

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppWorkQueuePostProcessFirewall.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppWorkQueuePostProcessFirewall.sp,v $ $Id: AppWorkQueuePostProcessFirewall.sp,v 1.14.14.1 2018/03/22 01:31:42 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppWorkQueuePostProcessFirewall <<<'

IF EXISTS (select * from sysobjects where name='AppWorkQueuePostProcessFirewall')
	drop procedure AppWorkQueuePostProcessFirewall
IF EXISTS (select * from GxQscripts where name='AppWorkQueuePostProcessFirewall')
	delete from GxQscripts where name = 'AppWorkQueuePostProcessFirewall'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWorkQueuePostProcessFirewall')
	delete from GXDBVersions where aliasname = 'AppWorkQueuePostProcessFirewall'
GO
print '... Creating Procedure: AppWorkQueuePostProcessFirewall'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppWorkQueuePostProcessFirewall
-- Input arguments
  @i_clientId integer = 0,
  @i_flags integer = 0
AS
  DECLARE @o_updateClients int
SET @o_updateClients = 0
SET NOCOUNT ON
DECLARE	@currentTime	 INTEGER
SET	@currentTime = dbo.GetUnixTime(GetUTCDate())
DECLARE @outTbl TABLE (clientId int, name nchar(255), net_hostName nchar(255), GUID nchar(255), type int)
DECLARE @mediaAgentTbl TABLE (clientId integer,maClientId integer,maClientName NVARCHAR(255),maClientHostName NVARCHAR(255),maClientGUID NVARCHAR(255))
DECLARE @mediaAgentClient INT = ISNULL((SELECT 1 FROM MMHost WHERE clientId = @i_clientId), 0)
DECLARE @proxyClient INT = ISNULL((SELECT isDMZ FROM App_FirewallOptions WHERE clientId = @i_clientId ),0)
IF @i_flags in (1,2) -- PUSH_ON_CS_MA	= 0, PUSH_ON_CLIENT = 1,PUSH_ON_ALL= 2
		INSERT INTO @outTbl
		SELECT C.id,C.name,C.net_hostname,C.GUID,0 FROM APP_CLIENT C WHERE C.id =  @i_clientId
IF @i_flags in (0,2)
IF @i_clientId <> 2 AND @mediaAgentClient = 0 AND @proxyClient = 0
BEGIN
	IF NOT EXISTS (SELECT 1 FROM App_FWTrivialConfig WHERE clientId = @i_clientId AND isTrivialConfig = 1) AND
		NOT EXISTS ( SELECT 1 FROM App_FWTrivialConfig FW INNER JOIN APP_ClientGroupAssoc CG ON FW.clientGroupId = CG.clientGroupId AND FW.clientGroupId > 0 AND CG.clientId = @i_clientId)
	BEGIN
		INSERT INTO @outTbl
			EXECUTE APPGetFWRestrictionFrom @i_clientId
		INSERT INTO @outTbl
			EXECUTE APPGetFWRestrictionTO @i_clientId
		END
	ELSE
	BEGIN
		INSERT INTO @mediaAgentTbl
			exec AppGetMediaAgentsForClient	@i_clientId
		INSERT INTO @outTbl
			SELECT maClientId,maClientName,maClientHostName,maClientGUID,0 FROM @mediaAgentTbl
		-- Add Commserv
		INSERT INTO @outTbl
		SELECT C.id,C.name,C.net_hostname,C.GUID,0 FROM APP_CLIENT C WHERE C.id =  2
		--Add proxy if present
		INSERT INTO @outTbl
		SELECT C.id,C.name,C.net_hostname,C.GUID,0 FROM APP_CLIENT C INNER JOIN App_FWTrivialConfig ON C.id = proxyClientIdCS AND proxyClientIdCS > 2 -- proxy has to be more than commserv client id
		INSERT INTO @outTbl
		SELECT C.id,C.name,C.net_hostname,C.GUID,0 FROM APP_CLIENT C INNER JOIN App_FWTrivialConfig ON C.id = proxyClientIdMA AND proxyClientIdMA > 2 AND NOT EXISTS (SELECT * FROM @outTbl WHERE clientId = C.id) -- proxy has to be more than commserv client id
	END
END
-- check if any VM in @outTbl then submit request to all Physical nodes
IF EXISTS( SELECT VMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId IN (SELECT clientId FROM @outTbl WHERE clientID <> 2)) --dont include cluster CS
BEGIN
	INSERT INTO @outTbl
	SELECT PMClientId, '', '', '', 0
	FROM APP_VMToPMMap WITH(NOLOCK)
	WHERE VMClientId IN (SELECT clientID FROM @outTbl WHERE clientID <> 2)
	DELETE @outTbl WHERE clientID IN (SELECT VMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId <> 2)
END
-- For virtual clients, push the config to all its physical except CS
IF @i_clientId <> 2
BEGIN
	IF EXISTS (SELECT * FROM APP_ClientProp WHERE componentNameId = @i_clientId AND attrName = 'Virtual Client' AND attrVal = '1')
	BEGIN
		INSERT INTO @outTbl
		SELECT PMClientId, C.name, C.net_hostname,C.GUID, 0
		FROM APP_VMToPMMap INNER JOIN APP_Client C ON VMClientId = @i_clientId AND PMClientId = C.id
	END
END
INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
	SELECT DISTINCT clientId, 5, '', @currentTime, 0, 0, 1, -1
	FROM @outTbl
SELECT COUNT(DISTINCT clientId) FROM @outTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppWorkQueuePostProcessFirewall')
	delete from GxQscripts where name = 'AppWorkQueuePostProcessFirewall'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWorkQueuePostProcessFirewall')
	delete from GXDBVersions where aliasname = 'AppWorkQueuePostProcessFirewall'
GO

insert into GXDBVersions values(2, 'AppWorkQueuePostProcessFirewall',  '00010014001400010000', 'AppWorkQueuePostProcessFirewall', '00010014001400010000')
GO

