

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppWorkQueueGetRequest.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppWorkQueueGetRequest.sp,v $ $Id: AppWorkQueueGetRequest.sp,v 1.17.80.27.6.1 2021/02/03 16:43:05 mnatarajan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppWorkQueueGetRequest')
BEGIN
	print '>>> Drop Stored Procedure: AppWorkQueueGetRequest <<<'
	drop procedure AppWorkQueueGetRequest
END
IF EXISTS (select * from GxQscripts where name='AppWorkQueueGetRequest')
	delete from GxQscripts where name = 'AppWorkQueueGetRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWorkQueueGetRequest')
	delete from GXDBVersions where aliasname = 'AppWorkQueueGetRequest'
GO
print '... Creating Procedure: AppWorkQueueGetRequest'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppWorkQueueGetRequest
-- Input arguments
  @i_timeInterval integer = 0,
  @i_retryCount integer = 1
AS
  DECLARE @o_workQueueId BIGINT
  DECLARE @o_clientId INTEGER
  DECLARE @o_remoteClient INTEGER
  DECLARE @o_workToken INTEGER
  DECLARE @o_lastUpdateTime INTEGER
  DECLARE @o_retryCount INTEGER
  DECLARE @o_flag INTEGER
  DECLARE @o_origCCId INTEGER
  DECLARE @o_workTokenParams NVARCHAR(MAX)
  DECLARE @o_createTime INTEGER
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @updateWorkQueueIDs		TABLE( tempWorkQueueId BIGINT PRIMARY KEY)
DECLARE	@currentTime			INTEGER
DECLARE	@MaxWorkQueueID			BIGINT
DECLARE @MaxRetryCountForNextUpdateTime INTEGER = ISNULL( (SELECT TOP 1 value FROM GXGlobalParam WHERE name = 'WQMaxRetryCountForNextUpdateTime' AND modified = 0),47)
DECLARE @MaxRetryCountForWQDeletion		INTEGER = ISNULL( (SELECT TOP 1 value FROM GXGlobalParam WHERE name = 'WQMaxRetryCountForPruning' AND modified = 0),500)
DECLARE @errorCode				INTEGER = 0
SET	@currentTime = dbo.GetUnixTime(GetUTCDate())
SET	@MaxWorkQueueID = (SELECT MAX(workQueueId) FROM APP_WorkQueueRequest WITH(NOLOCK))
-- Clear WORK_QUEUE_ITEM_IN_PROCESS flag if request did not clear that flag after 1 day of processing
-- (assuming something wrong happened during flag cleaning before)
UPDATE APP_WorkQueueRequest SET flag &= ~2 WHERE (flag & 2) = 2 AND lastUpdateTime > 0 AND (@currentTime - lastUpdateTime) > 86400
-- For active physical cluster node, change clientID to CS Client so that network call can succeed
IF EXISTS(SELECT 1 FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId=2)
BEGIN
	DECLARE @csActivePhysicalNode INT = 0
	SELECT @csActivePhysicalNode = CAST(attrVal AS INT) FROM App_ClientProp (NOLOCK) WHERE componentnameID =2 -- CS Client
	AND attrname='CS Active Physical Node' AND modified = 0
	IF @csActivePhysicalNode>0 AND @csActivePhysicalNode!=2 AND
		EXISTS(SELECT 1 FROM App_WorkQueueRequest WHERE Clientid = @csActivePhysicalNode)
	BEGIN
		UPDATE App_WorkQueueRequest
		SET clientID = 2, retryCount = 0, lastUpdateTime = 0
		WHERE Clientid = @csActivePhysicalNode
	END
END
-- Clear all request for clients with no packages (in case client was deconfigured),
-- GRC migrated clients and other temporary migrated clients
-- change to keep Name Change work token for client lower than 15
-- Performance changes for CPU Usage on DELETE Operation
IF OBJECT_ID('tempDb..#DelClients') IS NOT NULL
	DROP TABLE #DelClients
CREATE TABLE #DelClients (
	id	INT,		-- NO primary key / DISTINCT Insert Op faster even with deletion sort below
	specialClientFlags  INT
)
-- Performance changed to temp table for high memory grant for subquery implementation, leaving as a Hash Table
INSERT INTO #DelClients
	SELECT
		cl.id, cl.specialClientFlags
	FROM APP_Client cl WITH(NOLOCK)
		INNER JOIN APP_CommCell cc ON
			cl.csHostName = cc.aliasName
			AND cl.origCCId = cc.id		-- new index APP_Client_origCCId_id_idx
	WHERE cl.origCCId > 2 -- temporary migrated client
	UNION ALL
	SELECT
		cl.id, cl.specialClientFlags
	FROM APP_Client cl WITH(NOLOCK)
	WHERE
		(cl.specialClientFlags & 0x22) <> 0  -- package absent 0x2 and GRC migrated client 0x20, exclude name change work token	-- new index APP_Client_specialClientFlags_status_id_idx
	UNION ALL
	SELECT
		cl.id, cl.specialClientFlags
	FROM APP_Client cl WITH(NOLOCK)
		INNER JOIN APP_WorkQueueRequest  wqr WITH(NOLOCK) ON
			-- any work token except firewall supported from 10.0 (releaseId=15) and up
			cl.releaseId < 15
			AND cl.id = wqr.clientId
			AND wqr.workToken NOT IN (5, 34)
	-- 8.0 clients no longer supported by V11 - clause removed
IF OBJECT_ID('tempdb.dbo.#IDAPropModifiedWQ') IS NOT NULL
	DROP TABLE #IDAPropModifiedWQ
CREATE TABLE #IDAPropModifiedWQ
(
	workQueueId INT PRIMARY KEY
)
-- If there is Ida prop modified WQ token on a client whose special client flag = 2, then the client is being installed.
-- Wait until the client install is done and the flag is unset. Until then, do not consider this token.
IF EXISTS (SELECT 1 FROM APP_WorkQueueRequest (NOLOCK) WHERE workToken = 36 /*WORK_TOKEN_IDA_PROP_MODIFIED*/)
BEGIN
	INSERT INTO #IDAPropModifiedWQ
		SELECT workQueueId
		FROM APP_WorkQueueRequest WQ (NOLOCK)
			INNER JOIN APP_Client C (NOLOCK)
				ON WQ.clientId = C.id
				AND WQ.workToken = 36
				AND C.specialClientFlags & 2 <> 0
		UNION
		SELECT workQueueId			-- Defer processing this WQ token until a install client job is running. Else the reboot option (in this WQ) messes with install job.
		FROM APP_WorkQueueRequest WQ (NOLOCK)
			INNER JOIN JMQinetixUpdateStatus JM (NOLOCK)
				ON WQ.clientId = JM.clientId
				AND WQ.workToken = 36
			INNER JOIN JMAdminJobInfoTable RJ (NOLOCK)
				ON JM.jobId = RJ.jobId
				AND RJ.opType = 67				  -- Install client
END
IF OBJECT_ID('tempDb..#DelUnSupportedWQs') IS NOT NULL
	DROP TABLE #DelUnSupportedWQs
CREATE TABLE #DelUnSupportedWQs (
	WorkQueueID BIGINT
)
CREATE CLUSTERED INDEX DelUnSupportedWQs_WorkQueueId_Idx ON #DelUnSupportedWQs(WorkQueueID)
INSERT INTO #DelUnSupportedWQs
SELECT wqr.workQueueId FROM APP_WorkQueueRequest (NOLOCK) wqr
INNER JOIN #DelClients cl ON wqr.clientId = cl.id
LEFT OUTER JOIN #IDAPropModifiedWQ IPMWQ
	ON wqr.workQueueId = IPMWQ.workQueueId
WHERE
   workToken <> 29 -- workToken 29 is pushed only to DB and irrespective of deconfigured/pseudo clients, SCG refresh should happen.
   AND workToken <> 59 -- used to pull Web.see package from ServiceCommcell by MasterCommcell
   AND ((cl.specialClientFlags & 0x22) = 0 OR workToken <> 34)
   AND IPMWQ.workQueueId IS NULL
DECLARE @wqrDelCnt INT = @@ROWCOUNT
IF (@wqrDelCnt > 0)
BEGIN
	-- Delete clients identified in above table
	DELETE wqr
	FROM APP_WorkQueueRequest wqr INNER JOIN #DelUnSupportedWQs DelUnSupportedWQs
	ON wqr.workQueueID = DelUnSupportedWQs.workqueueID
END
if object_id('tempdb.dbo.#WorkQueueConsolidated') is not null
BEGIN
	DROP TABLE #WorkQueueConsolidated
END
Create table #WorkQueueConsolidated
(
	clientId INT,
	workToken INT,
	workTokenParams NVARCHAR(MAX),
	workQueueIdA BIGINT,
	lastUpdateTime INT,
	retryCountTotal INT,
	flagOR BIGINT
)
CREATE NONCLUSTERED INDEX WorkQueueConsolidated_clientId_workToken_Idx ON #WorkQueueConsolidated(clientId, workToken) INCLUDE (workTokenParams)
CREATE CLUSTERED INDEX WorkQueueConsolidated_workQueueIdA_Idx ON #WorkQueueConsolidated(workQueueIdA)
if object_id('tempdb.dbo.#WorkQueueShortList') is not null
	DROP TABLE #WorkQueueShortList
Create table #WorkQueueShortList
(
	clientId INT,
	workToken INT,
	workTokenParams NVARCHAR(MAX)
)
CREATE CLUSTERED INDEX WorkQueueShortList_Idx ON #WorkQueueShortList(clientId, workToken)
-- Performance create a short list of objects with minimal grouping operators - COUNT only
-- This slightly improves lite load queries about ~300ms while on scaling WQ tables with lots of data to be processed can ~20 seconds or more
INSERT INTO #WorkQueueShortList
	SELECT
		wqr.clientId,
		wqr.workToken,
		wqr.workTokenParams
	FROM APP_WorkQueueRequest wqr
	WHERE WQR.workQueueId <= @MaxWorkQueueID
	GROUP BY
		wqr.clientId,
		wqr.workToken,
		wqr.workTokenParams
	HAVING COUNT(1) > 1
-- Take MIN of lastUpdateTime. When we take min and new entries are added for same WQ (same client, work Token and work token params), lastUpdateTime of merged record comes as 0. And lastUpdateTime as 0 forces WQ to retry it again immediately.
-- Using the short list table we limit all the heavy lift processing for the other grouping operators decreasing overall elapse time for this query
Insert into #WorkQueueConsolidated(clientId, workToken, workTokenParams,workQueueIdA,lastUpdateTime, retryCountTotal, flagOR)
	SELECT
		wqr.clientId,
		wqr.workToken,
		wqr.workTokenParams,
		MAX(wqr.workQueueId) As workQueueId,
		MIN(wqr.lastUpdateTime) as lastUpdateTimeA,
		SUM(wqr.retryCount) as retryCountTotal,
		dbo.BitwiseOR(wqr.flag) as flagOR
	FROM APP_WorkQueueRequest wqr
		INNER JOIN #WorkQueueShortList sl ON
			sl.clientId = wqr.clientId
			AND sl.workToken = wqr.workToken
			AND sl.workTokenParams = wqr.workTokenParams
	WHERE
		WQR.workQueueId <= @MaxWorkQueueID
	GROUP BY
		wqr.clientId,
		wqr.workToken,
		wqr.workTokenParams
UPDATE Dups
SET workQueueIdA = APP_WorkQueueRequest.workQueueId
FROM #WorkQueueConsolidated Dups
INNER JOIN APP_WorkQueueRequest ON Dups.clientId = APP_WorkQueueRequest.clientId
AND Dups.workToken = APP_WorkQueueRequest.workToken
AND Dups.workTokenParams = APP_WorkQueueRequest.workTokenParams
AND (APP_WorkQueueRequest.flag&2)=2
-- Now clear duplicate requests if any but preserve flags (by OR) and retryCount (by sum) and lastUpdateTime
-- first update request with flags and retryCount from similar requests
UPDATE APP_WorkQueueRequest SET retryCount = A.retryCountTotal, flag = A.flagOR, lastUpdateTime = A.lastUpdateTime
FROM APP_WorkQueueRequest INNER JOIN #WorkQueueConsolidated A ON workQueueId = A.workQueueIdA
-- now delete duplicate requests
DELETE APP_WorkQueueRequest
FROM APP_WorkQueueRequest INNER JOIN
(
	SELECT DISTINCT W.workQueueId FROM APP_WorkQueueRequest W
	INNER JOIN #WorkQueueConsolidated A  ON W.clientId = A.clientId AND W.workToken = A.workToken AND W.workTokenParams = A.workTokenParams AND W.workQueueId != A.workQueueIdA
) DELETED
ON DELETED.workQueueId = APP_WorkQueueRequest.workQueueId
-- Also delete requests where retrycount exceeds MaxRetryCountForWQDeletion
IF EXISTS(SELECT 1 FROM APP_WorkQueueRequest
		where retryCount > @MaxRetryCountForWQDeletion)
BEGIN
	DELETE APP_WorkQueueRequest
	where retryCount > @MaxRetryCountForWQDeletion
END
-- Get current requests ID in temporary table to update their 'lastUpdateTime' and set 'In progress' flag
INSERT INTO @updateWorkQueueIDs (tempWorkQueueId)
SELECT workQueueId
FROM
(
	SELECT workQueueId, lastUpdateTime,flag, clientId, CASE WHEN retryCount > @MaxRetryCountForNextUpdateTime THEN @MaxRetryCountForNextUpdateTime ELSE retryCount END AS retryCount,
	CASE WHEN ((workToken = 51 AND retryCount<=5) OR workToken = 22) THEN 60 ELSE @i_timeInterval END AS timeInterval  --This condition for Token 51 or In case of 22 when we are trying to reset the Role and its for makeing first 5 retry in 10 min only, (0,1,3,6,10)
	from APP_WorkQueueRequest WITH (NOLOCK)
) WQ
WHERE (WQ.flag & 2) = 0 AND WQ.workQueueId <= @MaxWorkQueueID AND 							-- this request is not in process now and not inserted after we started this SP and
		((WQ.flag & 4) = 4 OR																-- this request must be executed forcefully or
		 (((@currentTime - WQ.lastUpdateTime) > (WQ.timeInterval * (WQ.retryCount + 1)) AND	-- lastupdateTime = 0 for new request or timeout passed for next retry and
				WQ.retryCount < @i_retryCount) OR											-- we didn't retryed max numbers of times (7 times is default) or
				-- these 2 subqueries are costly below - not sure how to correct
				EXISTS( SELECT CTC.ToClientId												-- this client became online after we tryed last time and
					FROM CCRClientToClient CTC WITH(NOLOCK)
					WHERE CTC.FromClientId = 2 AND CTC.ToClientId = WQ.clientID
					AND CTC.lastOnlineTime > CTC.lastOfflineTime
					AND CTC.lastOnlineTime > WQ.lastUpdateTime))
				AND
				NOT EXISTS( SELECT CTC.ToClientId											-- this client is not became offline after last time we tryed
					FROM CCRClientToClient CTC WITH(NOLOCK)
					WHERE CTC.FromClientId = 2 AND CTC.ToClientId = WQ.clientID
					AND CTC.lastOfflineTime > CTC.lastOnlineTime
					AND (@currentTime - CTC.lastOfflineTime) < (WQ.timeInterval * WQ.retryCount)))
-- For UploadFile token, Delete request IDs from temporary table if the web-server is not online
DELETE @updateWorkQueueIDs
WHERE tempWorkQueueId IN (SELECT workQueueId
						FROM APP_WorkQueueRequest WQ
						WHERE WQ.workToken = 10
						AND NOT EXISTS (SELECT CTC.ToClientId
									FROM CCRClientToClient CTC WITH(NOLOCK)
									WHERE CTC.FromClientId = 2
									AND CTC.ToClientId = CONVERT(INT, WQ.workTokenParams)
									AND CTC.lastOnlineTime > CTC.lastOfflineTime))
-- Do not consider the WQ token ids that are in Ida Prop modified table, yet.
DELETE T
FROM @updateWorkQueueIDs T
	INNER JOIN #IDAPropModifiedWQ IPMWQ
		ON T.tempWorkQueueId = IPMWQ.workQueueId
	-- Before updating workqueue table copy workqueues to tmep table
	if object_id('tempdb.dbo.#WorkQueueReturnData') is not null
	BEGIN
		DROP TABLE #WorkQueueReturnData
	END
	SELECT w.workQueueId, w.clientId, w.remoteClient, w.workToken, w.lastUpdateTime, w.retryCount, w.flag, c.origCCId, w.workTokenParams, w.createTime
	INTO #WorkQueueReturnData
	FROM APP_WorkQueueRequest w, APP_Client c WITH(NOLOCK)
	WHERE w.workQueueId IN (SELECT tempWorkQueueId FROM @updateWorkQueueIDs)
	AND w.clientId = c.id
	CREATE CLUSTERED INDEX WorkQueueReturnData_WorkQueueId_Idx ON #WorkQueueReturnData(workQueueId)
-- There could be lock timeout errors which may end up keeping WQ with flag 2 but not picked up by cpp. So this would keep them stuck forever in processing state
-- So having tran here and rolling it back in case there is error.
 BEGIN TRY
    BEGIN TRANSACTION
	-- Performance change to make only 1 pass over updating flag
	-- add flag = 2 - in process
	-- reset flag = 4 - force execution
	UPDATE APP_WorkQueueRequest
	SET lastUpdateTime = @currentTime,
	flag = (flag | 2) & (~4)
	WHERE workQueueId IN (SELECT tempWorkQueueId FROM @updateWorkQueueIDs)
    COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    ROLLBACK TRANSACTION
	SET @errorCode = 1
	-- trapping 1205 and rethrowing so that deadlock XML can be captured via Extended Events
	IF (ERROR_NUMBER()=1205)
	BEGIN
		THROW;
	END
END CATCH
IF @errorCode = 0
BEGIN
	-- @updateWorkQueueIDs table does not need DISTINCT clause on tempWorkQueueId columns since it is the Primary Key on table - already distinct
	SELECT w.workQueueId, w.clientId, w.remoteClient, w.workToken, w.lastUpdateTime, w.retryCount, w.flag, w.origCCId, w.workTokenParams, w.createTime
	FROM #WorkQueueReturnData w
	ORDER BY w.lastUpdateTime
END
if object_id('tempdb.dbo.#WorkQueueConsolidated') is not null
BEGIN
	DROP TABLE #WorkQueueConsolidated
END
if object_id('tempdb.dbo.#WorkQueueReturnData') is not null
BEGIN
	DROP TABLE #WorkQueueReturnData
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppWorkQueueGetRequest')
	delete from GxQscripts where name = 'AppWorkQueueGetRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWorkQueueGetRequest')
	delete from GXDBVersions where aliasname = 'AppWorkQueueGetRequest'
GO

insert into GXDBVersions values(2, 'AppWorkQueueGetRequest',  'v1.17.80.27.6.1', 'AppWorkQueueGetRequest', 'v1.17.80.27.6.1')
GO

