

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppWebEditSessionSet.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppWebEditSessionSet()
--  | Description:  Allows for Add/Edit for AppEdgeSession Table
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppWebEditSessionSet.sp,v $ $Id: AppWebEditSessionSet.sp,v 1.1.2.4 2018/03/27 08:01:41 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppWebEditSessionSet <<<'

IF EXISTS (select * from sysobjects where name='AppWebEditSessionSet')
	drop procedure AppWebEditSessionSet
IF EXISTS (select * from GxQscripts where name='AppWebEditSessionSet')
	delete from GxQscripts where name = 'AppWebEditSessionSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWebEditSessionSet')
	delete from GXDBVersions where aliasname = 'AppWebEditSessionSet'
GO
print '... Creating Procedure: AppWebEditSessionSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppWebEditSessionSet
  @i_machinekey NVARCHAR(300),
  @i_machineGuid VARCHAR(40),
  @i_flag INTEGER = 1,
  @o_errCode INTEGER		OUTPUT,
  @o_errString NVARCHAR(1024)	OUTPUT
AS
BEGIN TRY
	-- local variables
	DECLARE @nowTime		AS integer = dbo.GetUnixTime (GetUTCdate())
	DECLARE @l_flag			INT = 0
	DECLARE @l_machineGuid	NVARCHAR(40) = ''
	DECLARE @machineIP			AS VARCHAR(40) = LEFT(@i_machinekey, CHARINDEX('_', @i_machinekey) - 1)
	DECLARE @machineUserDetails AS NVARCHAR(255) = REPLACE(@i_machinekey, @machineIP+'_', '')
	-- Check any active machine for any other user is registered or not. If yes, simply deny processing request.
	IF EXISTS (SELECT TOP 1 * FROM App_WebEditSession WHERE (machineIP=@machineIP) AND (@machineUserDetails <> machineUser) AND flag=1)
	BEGIN
		SET @o_errCode = 1001
		SET @o_errString	=	'Machine with this ID is already in registered. Cannot register this machine for this user.'
		GOTO SCRIPT_EXIT
	END
	-- Get existing value, if there are any.
	SELECT  @l_flag = flag, @l_machineGuid=machineGUID FROM App_WebEditSession WHERE machineIP=@machineIP AND machineUser=@machineUserDetails
	IF ((@l_machineGuid IS NOT NULL) AND LEN(@l_machineGuid) > 0)
	BEGIN
		-- If machine with same GUID and FLAG is there, then simply return with details.
		IF (@i_flag = @l_flag AND  @l_machineGuid=@i_machineGuid)
			BEGIN
				SET @o_errCode = 0
				SET @o_errString	=	'Flag is already in the set in DB with the provided value. DB update Skipped'
			END
		ELSE
		BEGIN
			Update App_WebEditSession SET flag=@i_flag, modified=@nowTime, machineGUID=@i_machineGuid where machineIP=@machineIP AND machineUser=@machineUserDetails
			SET @o_errCode = 0
			SET @o_errString	= 'Request completed Successfully.'
			GOTO SCRIPT_EXIT
		END
	END
	ELSE
	BEGIN
			INSERT INTO App_WebEditSession(machineIP,machineUser,machineGUID,created,modified,flag)
										VALUES(@machineIP, @machineUserDetails, @i_machineGuid, @nowTime, @nowTime , @i_flag)
			-- Second Delete any older value for this machine .. means for the provided GUID that we might have in the DB
			DELETE FROM App_WebEditSession WHERE machineIP=@machineIP AND machineUser <> @machineUserDetails
			SET @o_errCode = 0
			SET @o_errString	=	'Request completed Successfully.'
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppWebEditSessionSet')
	delete from GxQscripts where name = 'AppWebEditSessionSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWebEditSessionSet')
	delete from GXDBVersions where aliasname = 'AppWebEditSessionSet'
GO

insert into GXDBVersions values(2, 'AppWebEditSessionSet',  '00010001000200040000', 'AppWebEditSessionSet', '00010001000200040000')
GO

