

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppWebEditSessionGet.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppWebEditSessionGet()
--  | Description:  Allows for GET for AppWebEditSessionGet Table
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppWebEditSessionGet.sp,v $ $Id: AppWebEditSessionGet.sp,v 1.1.2.4 2018/03/27 08:15:50 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppWebEditSessionGet <<<'

IF EXISTS (select * from sysobjects where name='AppWebEditSessionGet')
	drop procedure AppWebEditSessionGet
IF EXISTS (select * from GxQscripts where name='AppWebEditSessionGet')
	delete from GxQscripts where name = 'AppWebEditSessionGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWebEditSessionGet')
	delete from GXDBVersions where aliasname = 'AppWebEditSessionGet'
GO
print '... Creating Procedure: AppWebEditSessionGet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppWebEditSessionGet
  @i_machinekey NVARCHAR(300),
  @o_machineGuid VARCHAR(40) 	OUTPUT,
  @o_flag INTEGER  		OUTPUT,
  @o_errCode INTEGER			OUTPUT,
  @o_errString NVARCHAR(1024)	OUTPUT
AS
BEGIN TRY
	BEGIN
		DECLARE @machineIP			AS VARCHAR(40)		= LEFT(@i_machinekey, CHARINDEX('_', @i_machinekey) - 1)
		DECLARE @machineUserDetails AS NVARCHAR(255)	= REPLACE(@i_machinekey, @machineIP+'_', '')
		SELECT @o_machineGuid=machineGUID, @o_flag=flag  FROM App_WebEditSession WHERE machineIP=@machineIP AND machineUser=@machineUserDetails
		IF ((@o_machineGuid IS NOT NULL) AND LEN(@o_machineGuid) > 0)
		BEGIN
			SET @o_errCode = 0
			SET @o_errString	=	'Request completed Successfully.'
		END
		ELSE
		BEGIN
			SET @o_errCode = 1003
			SET @o_errString	=	'No Data to Return'
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errCode = ERROR_NUMBER()
    SET @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppWebEditSessionGet')
	delete from GxQscripts where name = 'AppWebEditSessionGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWebEditSessionGet')
	delete from GXDBVersions where aliasname = 'AppWebEditSessionGet'
GO

insert into GXDBVersions values(2, 'AppWebEditSessionGet',  '00010001000200040000', 'AppWebEditSessionGet', '00010001000200040000')
GO

