

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppWebEditPendingFileSet.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppWebEditPendingFileSet()
--  | Description:  Allows for Add/Edit for App_WebEditPendingFile Table
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppWebEditPendingFileSet.sp,v $ $Id: AppWebEditPendingFileSet.sp,v 1.1.2.5 2018/03/27 08:11:28 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppWebEditPendingFileSet <<<'

IF EXISTS (select * from sysobjects where name='AppWebEditPendingFileSet')
	drop procedure AppWebEditPendingFileSet
IF EXISTS (select * from GxQscripts where name='AppWebEditPendingFileSet')
	delete from GxQscripts where name = 'AppWebEditPendingFileSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWebEditPendingFileSet')
	delete from GXDBVersions where aliasname = 'AppWebEditPendingFileSet'
GO
print '... Creating Procedure: AppWebEditPendingFileSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppWebEditPendingFileSet
  @i_xmlText XML,
  @o_errCode INTEGER				OUTPUT,
  @o_errString NVARCHAR(1024)		OUTPUT
AS
BEGIN TRY
	-- local variables
	DECLARE		@nowTime				AS INTEGER			= dbo.GetUnixTime (GetUTCdate())
	DECLARE     @userId 				AS INTEGER       	= (SELECT ref.value('@userId', 'INT')FROM @i_xmlText.nodes('Api_EdgeWebEditFileInfo') R(ref))
	DECLARE		@fileID					AS VARCHAR(64)		= (SELECT ref.value('@fileGUID', 'VARCHAR(64)')FROM @i_xmlText.nodes('Api_EdgeWebEditFileInfo') R(ref))
    DECLARE		@filePathWithName		AS NVARCHAR(1024)	= (SELECT ref.value('@filePathWithName', 'NVARCHAR(1024)')FROM @i_xmlText.nodes('Api_EdgeWebEditFileInfo') R(ref))
	DECLARE		@shareId       			AS VARCHAR (64)		= ISNULL((SELECT ref.value('@shareId', 'VARCHAR (64)')FROM @i_xmlText.nodes('Api_EdgeWebEditFileInfo') R(ref)), '')
	DECLARE		@isPublicShare    		AS INTEGER			= ISNULL((SELECT ref.value('@isPublicShare', 'INT')FROM @i_xmlText.nodes('Api_EdgeWebEditFileInfo') R(ref)), 0)
	DECLARE		@isPasswordProtected    AS INTEGER			= ISNULL((SELECT ref.value('@isPasswordProtected', 'INT')FROM @i_xmlText.nodes('Api_EdgeWebEditFileInfo') R(ref)), 0)
    DECLARE		@passCode				AS VARCHAR(1024)	= ISNULL((SELECT ref.value('@passCode', 'VARCHAR(1024)')FROM @i_xmlText.nodes('Api_EdgeWebEditFileInfo') R(ref)), '')
	DECLARE		@flag      				AS INTEGER			= ISNULL((SELECT ref.value('@flag', 'INT')FROM @i_xmlText.nodes('Api_EdgeWebEditFileInfo') R(ref)), 0)
    -- Threshold time is 30 mins back. 30*60 = 1800 secs
	DECLARE @thresholdTime		AS INTEGER = dbo.GetUnixTime (GetUTCdate()) - 1800
	BEGIN
		IF ((@userId IS NOT NULL AND (@userId <> 0)) AND (@fileID IS NOT NULL AND LEN(@fileID) > 0))
			BEGIN
				MERGE App_WebEditPendingFile AS TGT
					USING (SELECT @userId AS UserID) AS SRC
						ON SRC.UserID=TGT.userId
					WHEN MATCHED THEN
						Update SET fileId=@fileID, shareId=@shareId, bPublicShare=@isPublicShare, bPasswordProtected=@isPasswordProtected, modified=@nowTime, fileName=@filePathWithName, passCode=@passCode
					WHEN NOT MATCHED THEN
						INSERT (userId, fileId, fileName, shareId, bPublicShare, bPasswordProtected, passCode, created, modified, flag)
												VALUES(@userId, @fileID, @filePathWithName, @shareId, @isPublicShare, @isPasswordProtected, @passCode, @nowTime, @nowTime , @flag);
				SET @o_errCode = 0
				SET @o_errString	=	'Data Processed Successfully.'
			END
		ELSE
			BEGIN
				SET @o_errCode = 2
				SET @o_errString	=	'Invalid Input to Stored Procedure. Please check input once.'
			END
        -- As a addon handling, cleanup any data older than 30 mins. will keep table clean
        DELETE FROM App_WebEditPendingFile WHERE modified < @thresholdTime
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errCode = ERROR_NUMBER()
    SET @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppWebEditPendingFileSet')
	delete from GxQscripts where name = 'AppWebEditPendingFileSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWebEditPendingFileSet')
	delete from GXDBVersions where aliasname = 'AppWebEditPendingFileSet'
GO

insert into GXDBVersions values(2, 'AppWebEditPendingFileSet',  '00010001000200050000', 'AppWebEditPendingFileSet', '00010001000200050000')
GO

