

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppWebEditPendingFileGet.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppWebEditPendingFileGet()
--  | Description:  Allows for Get for App_WebEditPendingFile Table
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppWebEditPendingFileGet.sp,v $ $Id: AppWebEditPendingFileGet.sp,v 1.1.2.5 2018/03/27 08:13:58 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppWebEditPendingFileGet <<<'

IF EXISTS (select * from sysobjects where name='AppWebEditPendingFileGet')
	drop procedure AppWebEditPendingFileGet
IF EXISTS (select * from GxQscripts where name='AppWebEditPendingFileGet')
	delete from GxQscripts where name = 'AppWebEditPendingFileGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWebEditPendingFileGet')
	delete from GXDBVersions where aliasname = 'AppWebEditPendingFileGet'
GO
print '... Creating Procedure: AppWebEditPendingFileGet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppWebEditPendingFileGet
  @i_userId INT,
  @xmlString XML					OUTPUT,
  @o_errCode INTEGER				OUTPUT,
  @o_errString NVARCHAR(1024)		OUTPUT
AS
BEGIN TRY
	-- local variables
	-- Threshold time is 30 mins back. 30*60 = 1800 secs
	DECLARE @thresholdTime		AS INTEGER = dbo.GetUnixTime (GetUTCdate()) - 1800
    DECLARE @flag               AS INTEGER = ISNULL((SELECT ref.value('@flag', 'INT')FROM @xmlString.nodes('Api_EdgeWebEditFileInfo') R(ref)), 0)
	BEGIN
		-- Select the Required Data For returning to Caller
		SET @xmlString = (SELECT userId AS '@userId', fileId AS '@fileGUID', fileName AS '@filePathWithName', shareId AS '@shareId',
								bPublicShare AS '@isPublicShare', bPasswordProtected AS '@isPasswordProtected', passCode AS '@passCode', flag AS '@flag'
								FROM App_WebEditPendingFile WITH(NOLOCK) WHERE userId=@i_userId AND modified >= @thresholdTime AND flag = @flag
							FOR XML PATH('Api_EdgeWebEditFileInfo'),TYPE)
		-- Now Cleanup any pending Edit option
		DELETE FROM App_WebEditPendingFile WHERE userId=@i_userId
		IF @xmlString IS NOT NULL
		BEGIN
			SET @o_errCode = 0
			SET @o_errString	= 'Pending File Data Added as Output and row updated for Read status.'
		END
		ELSE
		BEGIN
			SET @o_errCode = 1000
			SET @o_errString	= 'No Data to Return'
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppWebEditPendingFileGet')
	delete from GxQscripts where name = 'AppWebEditPendingFileGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWebEditPendingFileGet')
	delete from GXDBVersions where aliasname = 'AppWebEditPendingFileGet'
GO

insert into GXDBVersions values(2, 'AppWebEditPendingFileGet',  '00010001000200050000', 'AppWebEditPendingFileGet', '00010001000200050000')
GO

