

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppVirtualLabOperation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Prasanna Kumar TR
--	Date:   05/31/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppVirtualLabOperation.sp,v $ $Id: AppVirtualLabOperation.sp,v 1.1.2.1 2018/06/05 13:46:16 pktr Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppVirtualLabOperation <<<'

IF EXISTS (select * from sysobjects where name='AppVirtualLabOperation')
	drop procedure AppVirtualLabOperation
IF EXISTS (select * from GxQscripts where name='AppVirtualLabOperation')
	delete from GxQscripts where name = 'AppVirtualLabOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVirtualLabOperation')
	delete from GXDBVersions where aliasname = 'AppVirtualLabOperation'
GO
print '... Creating Procedure: AppVirtualLabOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppVirtualLabOperation
  @i_xmlText XML,
  @i_userId INT=0,
  @i_localId INT=0
AS
  DECLARE @o_ErrorCode integer = 0;
  DECLARE @o_ErrorString NVARCHAR(255);
SET NOCOUNT ON
BEGIN TRY
    DECLARE @labId   INT
    DECLARE @labOpType INT
	DECLARE @labName NVARCHAR(512)
	DECLARE @userName NVARCHAR(512)
	--sample xml : <Ida_ManageVMProvLabReq operationType="6"><lab><lab labId="9" labName="LabNewdemo5_modify"></lab></lab></Ida_ManageVMProvLabReq>
    SET @labId = ISNULL((SELECT @i_xmlText.value('Ida_ManageVMProvLabReq[1]/lab[1]/lab[1]/@labId', 'INT')),0)
    SET @labName = isnull((SELECT @i_xmlText.value('Ida_ManageVMProvLabReq[1]/lab[1]/lab[1]/@labName', 'NVARCHAR(512)')),'')
    SET @labOpType = (SELECT @i_xmlText.value('Ida_ManageVMProvLabReq[1]/@operationType', 'INT'))
	SET @labName = RTRIM(LTRIM(@labName))
	SET @userName = isnull((SELECT (CASE WHEN (len(isnull(name,'')) = 0) THEN login else name END) FROM UMUsers WHERE id = @i_userId),'')
	IF @labId <= 0 OR  NOT EXISTS(SELECT id FROM App_VirtualLab WHERE id = @labId and deleted=0)
	BEGIN
SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, (172 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
SET @o_ErrorCode = (172 | (CAST(POWER(2, 24) AS BIGINT) * 72))
		GOTO EXIT_ERROR
	END
	--VMLabOperationType_EDIT_LABNAME=6 - edit lab name
	IF ( @labOpType = 6)
	BEGIN
		IF len(@labName) = 0
		BEGIN
SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, (169 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
SET @o_ErrorCode = (169 | (CAST(POWER(2, 24) AS BIGINT) * 72))
			GOTO EXIT_ERROR
		END
		IF EXISTS(SELECT id FROM App_VirtualLab WHERE name = @labName and id != @labId and deleted=0)
		BEGIN
SET @o_ErrorCode = (171 | (CAST(POWER(2, 24) AS BIGINT) * 72))
        	SET @o_ErrorString = (select message from EvLocaleMsgs Where messageId=@o_ErrorCode  AND [localeId] = @i_localId)
			SET @o_ErrorString = replace(@o_errorstring,'^1%s',@labName)
			GOTO EXIT_ERROR
		END
		IF EXISTS(SELECT id FROM App_VirtualLab WHERE id = @labId and ownerId != @i_userId)
		BEGIN
SET @o_ErrorCode = (170 | (CAST(POWER(2, 24) AS BIGINT) * 72))
        	SET @o_ErrorString = (select message from EvLocaleMsgs Where messageId=@o_ErrorCode  AND [localeId] = @i_localId)
			SET @o_ErrorString = replace(@o_errorstring,'^1%s',@userName)
			GOTO EXIT_ERROR
		END
		ELSE
		BEGIN
			UPDATE App_VirtualLab
				SET
					 name = @labName,
					 modified = dbo.GetUnixTime (GetUTCdate())
				WHERE id = @labId
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_ErrorCode = ERROR_NUMBER()
    SET @o_ErrorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
END CATCH
EXIT_ERROR:
SELECT @o_ErrorCode as errorCode, @o_ErrorString as errorString
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppVirtualLabOperation')
	delete from GxQscripts where name = 'AppVirtualLabOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVirtualLabOperation')
	delete from GXDBVersions where aliasname = 'AppVirtualLabOperation'
GO

insert into GXDBVersions values(2, 'AppVirtualLabOperation',  '00010001000200010000', 'AppVirtualLabOperation', '00010001000200010000')
GO

