

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppVirtualLabDelete.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppVirtualLabDelete.sp,v $ $Id: AppVirtualLabDelete.sp,v 1.1.2.3 2018/03/27 08:14:58 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppVirtualLabDelete <<<'

IF EXISTS (select * from sysobjects where name='AppVirtualLabDelete')
	drop procedure AppVirtualLabDelete
IF EXISTS (select * from GxQscripts where name='AppVirtualLabDelete')
	delete from GxQscripts where name = 'AppVirtualLabDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVirtualLabDelete')
	delete from GXDBVersions where aliasname = 'AppVirtualLabDelete'
GO
print '... Creating Procedure: AppVirtualLabDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppVirtualLabDelete
  @i_userId INT,
  @i_localeId INT,
  @o_xmlText XML OUTPUT 
AS
-- added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
BEGIN TRY
DECLARE @labName nvarchar(1024)
DECLARE @userId   int
DECLARE @i_labId int
DECLARE @errorCode int  = 0
DECLARE @errorString nvarchar(1024) = 'Success'
SELECT @i_labId	= ref.value('lab[1]/@labId', 'int')
FROM @o_xmlText.nodes('/Ida_DeleteLabRequest') R(ref)
	IF NOT EXISTS ( select name from APP_VirtualLab  where id = @i_labId and deleted=0)
    BEGIN
            SET @errorCode = 1
            SET @errorString = 'Virtual Lab doesn''t exist'
            GOTO ERROR_EXIT
    END
	select @labName=name from APP_VirtualLab  where id = @i_labId
    Update APP_VirtualLab set deleted = dbo.GetUnixTime (GetUTCdate()), name = @labName +'_DELETED_'+CAST(dbo.GetUnixTime (GetUTCdate())as varchar) where id = @i_labId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
END CATCH
ERROR_EXIT:
SET @o_xmlText = ( SELECT
		(SELECT @i_labId as '@labId',
		       @labName as '@labName'
		FOR XML PATH('lab'),type) ,
		(SELECT @errorCode as '@errorCode',
		       @errorString as '@errorMessage'
		FOR XML PATH('resp'),type)
		 FOR XML PATH ('Ida_DeleteLabResponse')
	)
select @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppVirtualLabDelete')
	delete from GxQscripts where name = 'AppVirtualLabDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVirtualLabDelete')
	delete from GXDBVersions where aliasname = 'AppVirtualLabDelete'
GO

insert into GXDBVersions values(2, 'AppVirtualLabDelete',  '00010001000200030000', 'AppVirtualLabDelete', '00010001000200030000')
GO

