

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppVirtualLabCreate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppVirtualLabCreate.sp,v $ $Id: AppVirtualLabCreate.sp,v 1.1.2.5 2018/03/27 08:02:33 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppVirtualLabCreate <<<'

IF EXISTS (select * from sysobjects where name='AppVirtualLabCreate')
	drop procedure AppVirtualLabCreate
IF EXISTS (select * from GxQscripts where name='AppVirtualLabCreate')
	delete from GxQscripts where name = 'AppVirtualLabCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVirtualLabCreate')
	delete from GXDBVersions where aliasname = 'AppVirtualLabCreate'
GO
print '... Creating Procedure: AppVirtualLabCreate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppVirtualLabCreate
  @i_userId INT,
  @i_localeId INT,
  @o_xmlText XML OUTPUT 
AS
-- added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
BEGIN TRY
DECLARE @labName nvarchar(1024)
DECLARE @description nvarchar(1024)
DECLARE @expirationTime  datetime
DECLARE @userId   int
DECLARE @parentJobId int
DECLARE @switchName   nvarchar(256)
DECLARE @labId int
DECLARE @vmList xml
DECLARE @labPropList xml
DECLARE @labPolicyId int
DECLARE @newNetworkCreated int
DECLARE @errorCode int = 0
DECLARE @errorString nvarchar(1024) = 'Success'
DECLARE @createdTime int = dbo.GetUnixTime (GetUTCdate())
SELECT @labName = ref.value('lab[1]/@labName', 'nvarchar(1024)'),
       @description = ref.value('@description', 'nvarchar(1024)'),
	   @expirationTime = ref.value('expirationTime[1]/@time', 'int'),
	   @parentJobId  = ref.value('@parentJobId', 'int'),
	   @userId  = ref.value('@ownerId', 'int'),
	   @switchName = ref.value('@switchName', 'nvarchar(256)'),
	   @vmList = ref.query('vmList'),
	   @labPolicyId = ref.value('labPolicy[1]/@vmAllocPolicyId', 'int'),
	   @labPropList = ref.query('customLabPropList'),
	   @newNetworkCreated = ref.value('@newNetworkCreated', 'int')
FROM @o_xmlText.nodes('/Ida_CreateLabRequest') R(ref)
	IF EXISTS ( select name from APP_VirtualLab where name = @labName and ownerId =@i_userId)
	BEGIN
			SET @errorCode = 1
			SET @errorString = 'Virtual Lab with the given name already exists'
			GOTO ERROR_EXIT
	END
	INSERT INTO [dbo].[App_VirtualLab] (name, clientGroupId, description, vxml, ownerId,  created, modified, deleted, flags)
	VALUES (@labName, 0,@description, NULL,  @i_userId, @createdTime, 0,0,0)
	SET @labId = SCOPE_IDENTITY()
	INSERT INTO [dbo].[App_VirtualLabProp] values ( @labId, 'Virtual Lab Machine List', 1, cast(@vmList as nvarchar(max)),@createdTime,0)
	IF @labPropList.exist('*') = 1
		INSERT INTO [dbo].[App_VirtualLabProp] values ( @labId, 'Virtual Lab Custom Properties', 1, cast(@labPropList as nvarchar(max)),@createdTime,0)
	INSERT INTO [dbo].[App_VirtualLabProp] values ( @labId, 'Virtual Lab Parent Job Id', 1, @parentJobId,@createdTime,0)
	INSERT INTO [dbo].[App_VirtualLabProp] values ( @labId, 'Virtual Lab Private Switch Name', 1, @switchName ,@createdTime,0)
	INSERT INTO [dbo].[App_VirtualLabProp] values (	@labId, 'Virtual Lab Policy Id',1,@labPolicyId,@createdTime,0)
	INSERT INTO [dbo].[App_VirtualLabProp] values (	@labId, 'Virtual Lab New Network Created',1,@newNetworkCreated,@createdTime,0)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
END CATCH
ERROR_EXIT:
SET @o_xmlText = ( SELECT
		(SELECT @labId as '@labId',
		       @labName as '@labName'
		FOR XML PATH('lab'),type) ,
		(SELECT @errorCode as '@errorCode',
		       @errorString as '@errorMessage'
		FOR XML PATH('resp'),type)
		 FOR XML PATH ('Ida_CreateLabResponse')
		)
select @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppVirtualLabCreate')
	delete from GxQscripts where name = 'AppVirtualLabCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVirtualLabCreate')
	delete from GXDBVersions where aliasname = 'AppVirtualLabCreate'
GO

insert into GXDBVersions values(2, 'AppVirtualLabCreate',  '00010001000200050000', 'AppVirtualLabCreate', '00010001000200050000')
GO

