

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppVirtualAppOperation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppVirtualAppOperation.sp,v $ $Id: AppVirtualAppOperation.sp,v 1.1.2.10 2020/01/23 23:28:17 rpolimera Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppVirtualAppOperation"
--	|	This Procedure is used to handle the different request for VM Allocation Policy
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppVirtualAppOperation')
BEGIN
	print '>>> Drop Stored Procedure: AppVirtualAppOperation <<<'
	drop procedure AppVirtualAppOperation
END
IF EXISTS (select * from GxQscripts where name='AppVirtualAppOperation')
	delete from GxQscripts where name = 'AppVirtualAppOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVirtualAppOperation')
	delete from GXDBVersions where aliasname = 'AppVirtualAppOperation'
GO
print '... Creating Procedure: AppVirtualAppOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppVirtualAppOperation
-- Input arguments
  @i_uid INT,
  @i_xmlText XML
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
DECLARE @i_action 		int
DECLARE @i_vAppName 	varchar(256)
DECLARE @i_vAppDescription varchar(max)
DECLARE @i_vAppId 	INT
DECLARE @errorString	NVARCHAR(MAX)
DECLARE @errorCode		INT = 0
DECLARE @i_operationType	INT	= 0
declare @replicationID int
SET	@i_action = ISNULL (( SELECT ref.value('@action', 'int')
					FROM  @i_xmlText.nodes ('Api_VirtualAppReq') R(ref)), '')
SET	@i_vAppName = ISNULL (( SELECT ref.value('@vAppName', 'varchar(256)')
					FROM  @i_xmlText.nodes ('Api_VirtualAppReq/vApp/vAppEntity') R(ref)), '')
SET	@i_operationType = ISNULL (( SELECT ref.value('@operationType', 'INT')
					FROM  @i_xmlText.nodes ('Api_VirtualAppReq/vApp') R(ref)), 0)
SET	@i_vAppDescription = ISNULL (( SELECT ref.value('@description', 'nvarchar(max)')
				FROM  @i_xmlText.nodes ('Api_VirtualAppReq/vApp') R(ref)), '')
SET @i_vAppId =ISNULL (( SELECT ref.value('@vAppId', 'nvarchar(256)')
					FROM  @i_xmlText.nodes ('Api_VirtualAppReq/vApp/vAppEntity') R(ref)), '')
BEGIN TRY
declare @replicationType int =0
select @replicationType = isnull(@i_xmlText.value('(/Api_VirtualAppReq/vApp/@replicationType)[1]','int'),0)
--Create the virtual App
IF (@i_action = 0)
BEGIN
	IF EXISTS ( select name from APP_VirtualApp where name = @i_vAppName and ownerId =@i_uId)
	BEGIN
			SET @errorCode = 1
			SET @errorString = 'Virtual App with the given name already exists'
			GOTO ERROR_EXIT
	END
	INSERT INTO [dbo].[App_VirtualApp] (name, description, operationType, vxml, ownerId, created, modified, deleted, flags)
	VALUES (@i_vAppName, @i_vAppDescription, @i_operationType, @i_xmlText, @i_uid,   dbo.GetUnixTime (GetUTCdate()) , 0, 0,0)
	SET @i_vAppId = SCOPE_IDENTITY()
	SET @i_xmlText.modify('insert attribute vAppId {sql:variable("@i_vAppId")} as last into (/Api_VirtualAppReq/vApp/vAppEntity)[1]')
END
--Edit the virtual app
IF (@i_action = 1)
BEGIN
	IF NOT EXISTS ( select name from APP_VirtualApp where id = @i_vAppId)
	BEGIN
			SET @errorCode = 1
			SET @errorString = 'Virtual App doesn''t exist'
			GOTO ERROR_EXIT
	END
	SET @i_xmlText.modify('
            delete (/Api_VirtualAppReq/vApp/workflow)
            ');
	-- check if password is modified otherwise retain the original password
	if object_id('tempdb.dbo.#vmcreds') is not null drop table #vmcreds
	create table #vmcreds
	(
		seq int identity(1,1),
		replicationid int,
		uncPassword   nvarchar(max),
		vmPassword    nvarchar(max),
		updateUNCVal     int,
		updateUserVal	int,
	)
	insert into #vmcreds
	select  V.p.value('../@replicationId', 'int'),
			V.p.value('./UNCCredentials[1]/@password','nvarchar(max)'),
			V.p.value('./userImpersonation[1]/@password','nvarchar(max)'),
			1,
			1
	FROM APP_VirtualApp
	CROSS APPLY vxml.nodes('Api_VirtualAppReq/vApp/config/vmGroups/vmSequence/postScript') as V(p)
	WHERE id = @i_vAppId
	if exists ( select top 1 replicationid from #vmcreds )
	BEGIN
		if object_id('tempdb.dbo.#inputcreds') is not null drop table #inputcreds
		create table #inputcreds
		(
			replicationid int,
			uncPassword   nvarchar(max),
			vmPassword    nvarchar(max),
		)
		insert into #inputcreds
		select  V.p.value('../@replicationId', 'int') as replicationId,
				V.p.value('./UNCCredentials[1]/@password','nvarchar(max)') as UNCPassword,
				V.p.value('./userImpersonation[1]/@password','nvarchar(max)') as userPassword
				from
				@i_xmlText.nodes('Api_VirtualAppReq/vApp/config/vmGroups/vmSequence/postScript') as V(p)
		update VMC
		set updateUNCVal = case when I.uncPassword IS NULL then 1 else 0 end,
			updateUserVal = case when I.vmPassword IS NULL then 1 else 0 end
		from #vmcreds VMC
		inner join #inputcreds I
		on VMC.replicationid  =I.replicationid
		declare @replaceCount int
		select @replaceCount=count(*) from #vmcreds
		declare @uncPassword nvarchar(max)
		declare @userPassword nvarchar(max)
		declare @updateUNCVal int
		declare @updateUserVal int
		declare @index int =1
		while ( @index <=  @replaceCount )
		begin
			select @uncPassword = uncPassword, @userPassword = vmPassword , @replicationId = replicationId, @updateUNCVal =updateUNCval , @updateUserVal = updateUserVal
			from #vmcreds where seq = @index
			set @index = @index + 1
			if ( @updateUserVal  = 0 and @updateUNCVal = 0 ) continue
			if ( @updateUNCVal = 1 and @uncPassword is not null)
			begin
				set @i_xmlText.modify('insert attribute password {sql:variable("@uncPassword")} into (/Api_VirtualAppReq/vApp/config/vmGroups/vmSequence[@replicationId=sql:variable("@replicationId")]/postScript/UNCCredentials)[1]')
			end
			if ( @updateUserVal = 1 and @userPassword is not null)
			begin
				set @i_xmlText.modify('insert attribute password {sql:variable("@userPassword")} into (/Api_VirtualAppReq/vApp/config/vmGroups/vmSequence[@replicationId=sql:variable("@replicationId")]/postScript/userImpersonation)[1]')
			end
		end
	END
END
IF ( @i_action in ( 0,1) )
begin
	declare   @vmlist table
	(
		clientId int,
		replicationId int,
		vmguid nvarchar(256)
	)
	if ( @replicationType =3 and @i_operationType in ( 16, 256) )
	begin
		insert into @vmlist
		select ref.value('@clientId','int'),isnull(ref.value('@entityId', 'int'),0 ), NULL
		from @i_xmlText.nodes('Api_VirtualAppReq/vApp/clientList') R(ref)
		delete vapp
		from App_VirtualAppReplication  vapp
		where vappId = @i_vAppId and not exists (
		select 1 from  @vmlist VM
		where vapp.ReplicationId = vm.replicationId
		)
		delete from @vmlist where replicationId >0
		insert into App_VirtualAppReplication
		select distinct @i_vAppId, clientId,'','',0,'',0,0
		from @vmlist
		update VM
		set replicationID = vr.replicationId
		from @vmList VM
		inner join App_VirtualAppReplication vr
		on VM.clientId = vr.ClientId
		and vr.VappId = @i_vAppId
		update VM
		set vmguid = cp.attrVal
		from @vmlist VM
		inner join app_clientprop cp
		on VM.clientId = cp.componentNameId
		and cp.attrName ='Virtual Machine Instance UUID'
		and cp.modified =0
	end
	declare @clientId int
	declare @vmGUID nvarchar(256)
    declare tempclients cursor for
          select distinct clientId, vmGUID, replicationId from @vmlist
	open tempclients
        fetch next from tempclients into @clientId , @vmGUID, @replicationId
    WHILE @@FETCH_STATUS = 0
    begin
		set @i_xmlText.modify('insert (attribute entityId {sql:variable("@replicationId")}) into (/Api_VirtualAppReq/vApp/clientList[@clientId=sql:variable("@clientId")])[1]')
		set @i_xmlText.modify('insert (attribute replicationId {sql:variable("@replicationId")}) into (/Api_VirtualAppReq/vApp/config/vmGroups/vmSequence[vmInfo/@vmGUID=sql:variable("@vmGUID")])[1]')
        fetch next from tempclients into @clientId , @vmGUID, @replicationId
	end
    close  tempclients
    deallocate  tempclients
	update App_VirtualApp
	SET name=@i_vAppName, operationType = @i_operationType, description=@i_vAppDescription, vxml = @i_xmlText, modified = dbo.GetUnixTime (GetUTCdate())
	 WHERE id = @i_vAppId
END
--Delete virtual app
IF (@i_action = 2)
BEGIN
	declare @runningjobs int =0
	select @runningjobs = count(*) from App_VirtualAppJobStats vapp
	inner join JMAdminJobInfoTable JA
	on vapp.vappId = @i_vAppId
	and vapp.jobId = JA.jobId
	if ( isnull(@runningJobs,0) >0 )
	begin
		SET @errorCode = 2
		SET @errorString = 'The failover group can''t be deleted, as there are active jobs for this group'
		GOTO ERROR_EXIT
	end
	declare @failoverstatus  int
	declare @testfailoverstatus int
	select @failoverstatus = isnull(max(FailoverStatus),0), @testfailoverstatus = isnull(max(testfailoverstatus),0) from App_VirtualAppReplication where VappId = @i_vAppId
	and (failoverstatus not in (0,13) or testfailoverstatus not in (0) )
	if ( @failoverstatus > 0 )
	begin
		SET @errorCode = 3
		SET @errorString = 'The failover group can''t be deleted, as failover status is set for some VMs'
		GOTO ERROR_EXIT
	end
	if ( @testfailoverstatus >0 )
	begin
		SET @errorCode = 4
		SET @errorString = 'The failover group can''t be deleted, as test failover status is set for some VMs'
		GOTO ERROR_EXIT
	end
	IF NOT EXISTS ( select name from APP_VirtualApp  where id = @i_vAppId)
	BEGIN
			SET @errorCode = 1
			SET @errorString = 'Virtual App doesn''t exist'
			GOTO ERROR_EXIT
	END
	Update APP_VirtualApp set deleted = dbo.GetUnixTime (GetUTCdate()), name = @i_vAppName +'_DELETED_'+CAST(dbo.GetUnixTime (GetUTCdate())as varchar) where id = @i_vAppId
END
SET @errorCode =0
SET @errorString =''
SET @r_ReturnResult = (
		SELECT
		(SELECT @i_vAppId AS '@vAppId',
		        @i_vAppName AS '@vAppName'
		FOR XML PATH('entity'), TYPE),
		(SELECT @errorCode as '@errorCode',
		       @errorString as '@errorMessage'
		FOR XML PATH('resp'), TYPE)
		FOR XML path(''),
		ROOT('Api_VirtualAppResp')
		)
SELECT @r_ReturnResult;
return @errorCode
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
END CATCH
ERROR_EXIT:
SET @r_ReturnResult = (
		(SELECT @errorCode as '@errorCode',
		       @errorString as '@errorMessage'
		FOR XML PATH('resp'), ROOT('Api_VirtualAppResp')
		)
		)
SELECT @r_ReturnResult;
GO

IF EXISTS (select * from GxQscripts where name = 'AppVirtualAppOperation')
	delete from GxQscripts where name = 'AppVirtualAppOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVirtualAppOperation')
	delete from GXDBVersions where aliasname = 'AppVirtualAppOperation'
GO

insert into GXDBVersions values(2, 'AppVirtualAppOperation',  '00010001000200100000', 'AppVirtualAppOperation', '00010001000200100000')
GO

