

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppVirtualAppJobUpdate.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppVirtualAppJobUpdate.sp,v $ $Id: AppVirtualAppJobUpdate.sp,v 1.1.2.5 2019/06/13 21:51:08 pktr Exp $";
-- +-----------------------------------------------------------------------+
--	| 			Procedure : "AppVirtualAppJobUpdate"
--	|	This Procedure is used to get the Virtual app job details
-- +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppVirtualAppJobUpdate')
BEGIN
	print '>>> Drop Stored Procedure: AppVirtualAppJobUpdate <<<'
	drop procedure AppVirtualAppJobUpdate
END
IF EXISTS (select * from GxQscripts where name='AppVirtualAppJobUpdate')
	delete from GxQscripts where name = 'AppVirtualAppJobUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVirtualAppJobUpdate')
	delete from GXDBVersions where aliasname = 'AppVirtualAppJobUpdate'
GO
print '... Creating Procedure: AppVirtualAppJobUpdate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppVirtualAppJobUpdate
-- Input arguments
  @i_xmlText XML
AS
declare @errorCode int =0
declare @errorMessage nvarchar(max) ='Success'
IF object_id('tempdb.dbo.#jobList') IS NOT null DROP TABLE #jobList
CREATE TABLE #jobList
(
	jobId  int,
	replicationId int,
	clientId int,
	vappId int,
	phase int,
	status int,
	phaseName nvarchar(256),
	message nvarchar(max),
	startTime int,
	endTime  int,
	appTypeId int
)
declare @defaultvAppid int
select @defaultvAppId = id from App_VirtualApp where name = '_NO_NAME_'
BEGIN TRY
INSERT INTO #jobList (jobId, replicationId, clientId, vappId, phase, status, message, phaseName, appTypeId)
SELECT j.value('../@jobId', 'int'),
       ISNULL(j.value('../@replicationId', 'int'),0),
	   ISNULL(j.value('../client[1]/@clientId', 'int'),0),
	   case when isnull(j.value('../vapp[1]/@vAppId', 'int'),0) =0 then @defaultvAppid else j.value('../vapp[1]/@vAppId', 'int') end ,
	   j.value('@phase', 'int'),
	   j.value('@status', 'int'),
	   isnull(j.value('@message', 'nvarchar(max)'),''),
	   '',
           isnull(j.value('../@appTypeId', 'int'),106)
FROM @i_xmlText.nodes('/Api_VirtualAppJobUpdateReq/job/phase') J(j)
update j
set startTime  = case when status =2 then dbo.getunixtime(getutcdate()) else 0 end,
	endTime     = case when status !=2 then  dbo.getunixtime(getutcdate()) else 0 end
from #jobList j
Merge App_VirtualAppJobStats as Dest
USING #jobList J
ON Dest.jobId = J.jobId
AND Dest.phase = J.phase
AND Dest.replicationId = J.replicationId
AND Dest.clientId = J.clientId
AND Dest.appTypeId = J.appTypeId
WHEN MATCHED
	THEN UPDATE SET Dest.status = J.status, Dest.startTime = case when J.startTime =0 then Dest.startTime else J.startTime end, Dest.endTime = J.endTime, Dest.details = J.message
WHEN NOT MATCHED THEN
INSERT(jobid, commcellId, vappId,replicationId, clientId, phase, status, startTime, endTime, details, phaseName,failureReason, appTypeId)
Values(J.jobId, 2, J.vappId, J.replicationId, J.clientId, J.phase, J.status, J.startTime, J.endTime, message, phaseName,0, appTypeId);
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @errorCode = ERROR_NUMBER()
    SET @errorMessage  = ERROR_MESSAGE()
END CATCH
SET @i_xmlText = ( SELECT  @errorCode as '@errorCode', @errorMessage as '@errorMessage' FOR XML PATH('Api_GenericResponse'))
GO

IF EXISTS (select * from GxQscripts where name = 'AppVirtualAppJobUpdate')
	delete from GxQscripts where name = 'AppVirtualAppJobUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVirtualAppJobUpdate')
	delete from GXDBVersions where aliasname = 'AppVirtualAppJobUpdate'
GO

insert into GXDBVersions values(2, 'AppVirtualAppJobUpdate',  '00010001000200050000', 'AppVirtualAppJobUpdate', '00010001000200050000')
GO

