

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppViewCMCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppViewCMCredentials							|
--	|				View Credential Manager Records						|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppViewCMCredentials')
BEGIN
	print '>>> Drop Stored Procedure: AppViewCMCredentials <<<'
	drop procedure AppViewCMCredentials
END
IF EXISTS (select * from GxQscripts where name='AppViewCMCredentials')
	delete from GxQscripts where name = 'AppViewCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppViewCMCredentials')
	delete from GXDBVersions where aliasname = 'AppViewCMCredentials'
GO
print '... Creating Procedure: AppViewCMCredentials'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppViewCMCredentials
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @ixml XML
-----------------------------------------------------------
AS
  DECLARE @oxml XML
SET NOCOUNT ON
BEGIN TRY
	DECLARE @userId int = 0
	DECLARE @locale int = 0
	DECLARE @o_ErrorString   NVARCHAR(MAX) = ''
	DECLARE @o_ErrorCode     integer=0
	Declare @outputXml xml
	Declare @errXml xml
	DECLARE @propertyLevel INT = 30 --AllProperties
	DECLARE @credId int = 0
	DECLARE @credName nvarchar(256) = ''
	DECLARE @recordType int = 0
	DECLARE @flags int = 0
-----------------------------------------
-- Amazon/Azure cloud credential constants
-----------------------------------------
--	AMAZON = 13
--	AMAZON_IAM_ROLE = 14
--	AMAZON_STS_IAM_ROLE = 16
--	AMAZON_S3 = 102
--	MICROSOFT_AZURE_TYPE = 17
--	AZUREACCOUNT = 4
--	MICROSOFT_AZURE = 103
--	MICROSOFT_AZURE_VM_ROLE = 18
	IF OBJECT_ID('tempdb.dbo.#credIdsToSend') is not null drop table dbo.#credIdsToSend
	IF OBJECT_ID('tempdb.dbo.#credIdsfromSecurityList') IS NOT NULL DROP TABLE #credIdsfromSecurityList
	SELECT 	@userId = ISNULL(ref.value('(processinginstructioninfo/user/@userId)[1]', 'int'), 0),
			@locale = ISNULL(ref.value('(processinginstructioninfo/locale/@localeId)[1]', 'int'), 0),
			@propertyLevel = ISNULL(ref.value('@propertyLevel', 'int'), 0),
			@credId = ISNULL(ref.value('(credentialRecordInfo/credentialRecord/@credentialId)[1]', 'int'), 0),
			@credName = ISNULL(ref.value('(credentialRecordInfo/credentialRecord/@credentialName)[1]', 'nvarchar(256)'), ''),
			@recordType = ISNULL(ref.value('(credentialRecordInfo/@recordType)[1]', 'int'), 0),
			@flags = (case ref.value('(credentialRecordInfo/flags/@isWorkflowRecord)[1]', 'int')
when 1 then 1 else 0 end) |
					(case ref.value('(credentialRecordInfo/flags/@hasAzureKeyVaultAccess)[1]', 'int')
when 1 then 2 else 0 end) |
					(case ref.value('(credentialRecordInfo/flags/@hasAzureKeyVaultStorageAccess)[1]', 'int')
when 1 then 4 else 0 end) |
					(case ref.value('(credentialRecordInfo/flags/@hasAzureRSVAccess)[1]', 'int')
when 1 then 8 else 0 end)
	FROM @ixml.nodes('App_GetCredentialRecordInfoReq') R ( ref )
	create table #credIdsToSend
	(
		credentialId		integer PRIMARY KEY,
		ownerUserOrGroupId	integer,
		ownerIsUser			integer,
		credentialName		nvarchar(max),
		recordType			integer,
		userName		    nvarchar(max),
		credentialInfo		xml,
		description			nvarchar(max),
		flags				xml,
		created				integer,
		creatorXml            xml,
		securityXml         xml
	);
	CREATE TABLE #credIdsfromSecurityList (credId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId, 174, 218, '#credIdsfromSecurityList'
	IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL DROP TABLE dbo.#getMemberUserGroupsHelperOutputTbl
	create table #getMemberUserGroupsHelperOutputTbl
	(
		isUser int,
		userOrGroupId int
	);
	EXEC sec_getMemberUserGroupsHelper @userId
	INSERT INTO #credIdsfromSecurityList
	(credId)
	SELECT DISTINCT entityId1 FROM UMSecurityAssociations Sec
	INNER JOIN #getMemberUserGroupsHelperOutputTbl Tbl
	ON Sec.isUser = Tbl.isUSer AND Sec.userOrGroupId = Tbl.userOrGroupId
WHERE entityType1 = 174	AND isCreator = 1
	-- FILTER OUT CREDENTIALS CREATED FOR REGISTERED HEDVIG CLUSTERS BY SYSTEM TO PREVENT FROM USER UPDATING THESE CREDENTIALS
	DELETE creds
	FROM #credIdsfromSecurityList creds
JOIN APP_CredentialAssoc assoc (NOLOCK) ON assoc.entityType = 195 AND creds.credId = assoc.credentialId
	IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') is not null drop table dbo.#getMemberUserGroupsHelperOutputTbl
	INSERT INTO #credIdsToSend
	(credentialId, credentialName, recordType, userName, credentialInfo, description, flags, created, creatorXml, securityXml)
	SELECT
	credentialId, credentialName, recordType, userName, credentialInfo, description,
		(
SELECT	(case flags & 1 when 0 then 0 else 1 end) AS '@isWorkflowRecord',
(case flags & 2 when 0 then 0 else 1 end) AS '@hasAzureKeyVaultAccess',
(case flags & 4 when 0 then 0 else 1 end) AS '@hasAzureKeyVaultStorageAccess',
(case flags & 8 when 0 then 0 else 1 end) AS '@hasAzureRSVAccess'
			FOR XML PATh ('flags'), TYPE
		),
		created, NULL, NULL
	FROM APP_Credentials apc
	WHERE  -- Credentials that this user have permissions to view and use
	apc.credentialId IN (select distinct credId FROM #credIdsfromSecurityList)
	AND (@credId = 0 OR apc.credentialId=@credId)
	AND (@recordType = 0 OR apc.recordType=@recordType
	     OR (@recordType=13 AND apc.recordType IN(14,16,102))
	     OR (@recordType=17 AND apc.recordType IN(4,103,18)))
	AND (@credName = '' OR apc.credentialName = @credName)
	AND (@flags = 0 OR (apc.flags & @flags) >= @flags)
AND ((apc.flags & 16)= 0)
	IF @propertyLevel = 30
	BEGIN
		DECLARE @credentialId INT = 0
		DECLARE @securityXML xml = ''
		DECLARE @creatorXML xml = ''
		DECLARE @creatorUserId int = 0
		DECLARE @creatorUserGroupId int = 0
		DECLARE securityCredId CURSOR
		FOR SELECT credentialId FROM #credIdsToSend
		OPEN securityCredId
		FETCH securityCredId INTO @credentialId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @securityXML = NULL
			SET @creatorXML = NULL
			SET @creatorUserId  = 0
			SET @creatorUserGroupId = 0
EXEC sec_getSecurityForEntity @userId, @securityXML OUTPUT, 174, @credentialId
EXEC sec_getCreatorForEntity @creatorUserId OUTPUT, @creatorUserGroupId output, 0, 174, @credentialId
			IF @creatorUserId > 0
			BEGIN
				DECLARE @userName nvarchar(max) = (SELECT login FROM UMUSERS WHERE id=@creatorUserId)
SET @creatorXML = (SELECT @creatorUserId AS 'user/user/@userId', @userName AS 'user/user/@userName', 13 AS 'user/user/@_type_' FOR XML PATH('createAs'),TYPE)
			END
			ELSE IF @creatorUserGroupId > 0
			BEGIN
				DECLARE @userGroupName nvarchar(max) = (SELECT name FROM UMGroups WHERE id=@creatorUserGroupId)
SET @creatorXML = (SELECT @creatorUserGroupId AS 'userGroup/@userGroupId', @userGroupName AS 'userGroup/@userGroupName',15 AS 'userGroup/@_type_' FOR XML PATH('createAs'),TYPE)
			END
			UPDATE #credIdsToSend
			SET creatorXml=@creatorXML, securityXml=@securityXML
			WHERE credentialId=@credentialId
			FETCH securityCredId INTO @credentialId
		END
		CLOSE securityCredId
		DEALLOCATE securityCredId
		SET @outputXml = (
						SELECT
						recordType				AS '@recordType',
						description				AS '@description',
						created					AS '@createdTime',
						cast(flags as xml),
						credentialName			AS 'credentialRecord/@credentialName',
						credentialId			AS 'credentialRecord/@credentialId',
						userName				AS 'record/@userName',
						CAST(REPLACE(CAST(credentialInfo as nvarchar(max)), 'App_AdditionalCredInfo', 'additionalInformation') AS XML),
						securityXml				AS 'securityAssociations',
						cast(creatorXML as xml)
						FROM #credIdsToSend cids
						FOR XML PATH('credentialRecordInfo'), TYPE)
	END
	ELSE IF @propertyLevel = 20 /*App::ListPropertyLevels_ExtentedProperties*/
	BEGIN
		SET @outputXml = (
						SELECT
						recordType				AS '@recordType',
						description				AS '@description',
						credentialName			AS 'credentialRecord/@credentialName',
						credentialId			AS 'credentialRecord/@credentialId',
						cast(flags as xml),
						CAST(REPLACE(CAST(credentialInfo as nvarchar(max)), 'App_AdditionalCredInfo', 'additionalInformation') AS XML)
						FROM #credIdsToSend cids
						FOR XML PATH('credentialRecordInfo'), TYPE)
	END
	ELSE
	BEGIN
		SET @outputXml = (
						SELECT
						recordType				AS '@recordType',
						description				AS '@description',
						credentialName			AS 'credentialRecord/@credentialName',
						credentialId			AS 'credentialRecord/@credentialId'
						FROM #credIdsToSend cids
						FOR XML PATH('credentialRecordInfo'), TYPE)
	END
	SET @o_ErrorCode = 0
	SET @errXml =
    (
		SELECT @o_ErrorCode '@errorCode', @o_ErrorString '@errorMessage'
        FOR XML PATH ('error'),TYPE
    )
	SET @oxml =  (SELECT @outputXml,@errXml
 					FOR XML PATH('App_GetCredentialRecordResp'),TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_ErrorCode = ERROR_NUMBER()
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2722 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
		SET @oxml =
        (
            SELECT @o_ErrorCode '@errorCode', @o_ErrorString '@errorMessage'
            FOR XML PATH ('error'), ROOT('App_GetCredentialRecordResp')
        )
    --Close cursor
    IF ( CURSOR_STATUS('global', 'securityCredId') >= 0  /* cursor is open */
        OR CURSOR_STATUS('local', 'securityCredId') >= 0 )
    CLOSE securityCredId
    IF ( CURSOR_STATUS('global','securityCredId') = -1  /* cursor is closed */
        OR CURSOR_STATUS('local','securityCredId') = -1 )
    DEALLOCATE securityCredId
END CATCH
if OBJECT_ID('tempdb.dbo.#credIdsToSend') is not null drop table dbo.#credIdsToSend
SELECT @oxml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppViewCMCredentials')
	delete from GxQscripts where name = 'AppViewCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppViewCMCredentials')
	delete from GXDBVersions where aliasname = 'AppViewCMCredentials'
GO

insert into GXDBVersions values(2, 'AppViewCMCredentials',  '00000000000000000000', 'AppViewCMCredentials', '00000000000000000000')
GO

