

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppValidateRightsOnPlan.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppValidateRightsOnPlan.sp,v $ $Id: AppValidateRightsOnPlan.sp,v 1.1.2.3 2020/12/21 15:57:01 nshah Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppValidateRightsOnPlan')
BEGIN
	print '>>> Drop Stored Procedure: AppValidateRightsOnPlan <<<'
	drop procedure AppValidateRightsOnPlan
END
IF EXISTS (select * from GxQscripts where name='AppValidateRightsOnPlan')
	delete from GxQscripts where name = 'AppValidateRightsOnPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidateRightsOnPlan')
	delete from GXDBVersions where aliasname = 'AppValidateRightsOnPlan'
GO
print '... Creating Procedure: AppValidateRightsOnPlan'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppValidateRightsOnPlan
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_authCode VARCHAR(8),
  @i_PlanId VARCHAR(1024),
  @i_clientId INTEGER,
  @i_isCalledFromCPP INTEGER,
  @o_errorCode INTEGER			OUTPUT,
  @o_errorMsg NVARCHAR(MAX)	OUTPUT
AS
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
SET NOCOUNT ON
--Variable Declarations
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @o_errorCode	= 0
SET @o_errorMsg		= N''
BEGIN TRY
	DECLARE @companyId INT  = -1
	-- if userId is 0, then get userId from provided client Id
	-- Else just error out
	IF (@i_userId = 0)
	BEGIN
		IF (@i_authCode IS NOT NULL AND @i_authCode<>'')
		BEGIN
SET @companyId = (SELECT attrVal FROM APP_ClientProp WHERE attrname='Installation Company ID' AND componentNameId=@i_clientId AND modified=0)
		END
		ELSE IF (@i_clientId > 0)
		BEGIN
			-- Get user Id from Company Id saved in app_client Prop
SET @companyId = (SELECT attrVal FROM APP_ClientProp WHERE attrname='Installation Company ID' AND componentNameId=@i_clientId AND modified=0)
		END
		IF(@companyId = 0)
		BEGIN
SET @i_userId = ISNULL((SELECT TOP 1 id FROM UMUsers WHERE (flags & 0x040) <>0),0)
		END
	END
	IF (@i_userId>0) AND NOT EXISTS (SELECT 1 FROM UMUsers WHERE id=@i_userId)
	BEGIN
SET @o_errorCode = (1 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		SET @o_errorMsg = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1 | (CAST(POWER(2, 24) AS BIGINT) * 1)) AND [localeId] = @i_localeId)
		GOTO SCRIPT_EXIT
	END
	DECLARE @invalidPlans NVARCHAR(1024)
	IF OBJECT_ID('tempdb.dbo.#PlansList')	IS NOT NULL						DROP TABLE #PlansList
	CREATE TABLE #PlansList(planId INT NOT NULL)
	CREATE CLUSTERED INDEX PlansList_planId_idx ON #PlansList(planId)
	If (@companyId>0)
	BEGIN
		-- plans that user has rights to associate/deassociate
EXEC AppGetCompanyPlanList @companyId,159,'#PlansList'
		-- -- plans that user has rights to edit
EXEC AppGetCompanyPlanList @companyId,157,'#PlansList'
	END
	ELSE
	BEGIN
		-- plans that user has rights to associate/deassociate
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 157, '#PlansList'
		-- -- plans that user has rights to edit
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 159, '#PlansList'
	END
	-- If there is any plan in request for which user don't have rights, then error out
	IF EXISTS (SELECT 1 FROM dbo.SplitIDs(@i_PlanId) P
				LEFT OUTER JOIN #PlansList PL
				ON PL.planId=P._ID
			WHERE PL.planId IS NULL)
	BEGIN
		SELECT @invalidPlans = COALESCE(@invalidPlans+', ' ,'') + AP.name
			FROM dbo.SplitIDs(@i_PlanId) P
				INNER JOIN APP_Plan AP
					ON AP.id=P._ID
			LEFT OUTER JOIN #PlansList PL
				ON PL.planId=P._ID
			WHERE PL.planId IS NULL
		IF (@invalidPlans IS NULL OR @invalidPlans='')
		BEGIN
			SET @invalidPlans='Invalid PlanId'
		END
SET @o_errorCode = (4496 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @o_errorMsg = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
						WHERE messageId = @o_errorCode AND [localeId] = @i_localeId)
		--SET @o_errorMsg = REPLACE(@o_errorMsg, '^1%s', CAT_PLAN_ASSOCIATIONS_ADD_REMOVE_NAME)
		SET @o_errorMsg = REPLACE(@o_errorMsg, '^1%s', 'Use Plan')
		SET @o_errorMsg = REPLACE(@o_errorMsg, '^2%s', @invalidPlans)
		GOTO SCRIPT_EXIT
	END
	IF OBJECT_ID('tempdb.dbo.#PlansList')	IS NOT NULL						DROP TABLE #PlansList
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errorCode = ERROR_NUMBER()
	SET @o_errorMsg = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' + Convert(VARCHAR(5), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
SET @errorCode		= @o_errorCode
SET @errorString	= @o_errorMsg
IF (@i_isCalledFromCPP= 1)
BEGIN
	SELECT @errorCode, @errorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppValidateRightsOnPlan')
	delete from GxQscripts where name = 'AppValidateRightsOnPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidateRightsOnPlan')
	delete from GXDBVersions where aliasname = 'AppValidateRightsOnPlan'
GO

insert into GXDBVersions values(2, 'AppValidateRightsOnPlan',  '00010001000200030000', 'AppValidateRightsOnPlan', '00010001000200030000')
GO

