

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppValidatePlanTypeForSubclient.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppValidatePlanTypeForSubclient.sp,v $ $Id: AppValidatePlanTypeForSubclient.sp,v 1.1.4.4 2020/12/14 04:13:10 alakra Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppValidatePlanTypeForSubclient')
BEGIN
	print '>>> Drop Stored Procedure: AppValidatePlanTypeForSubclient <<<'
	drop procedure AppValidatePlanTypeForSubclient
END
IF EXISTS (select * from GxQscripts where name='AppValidatePlanTypeForSubclient')
	delete from GxQscripts where name = 'AppValidatePlanTypeForSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidatePlanTypeForSubclient')
	delete from GXDBVersions where aliasname = 'AppValidatePlanTypeForSubclient'
GO
print '... Creating Procedure: AppValidatePlanTypeForSubclient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppValidatePlanTypeForSubclient
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_subClientId INTEGER,
  @i_planId INTEGER,
  @i_planSubType INTEGER,
  @i_skipDCPlanCheck INTEGER,
  @o_planId INTEGER			OUTPUT,
  @o_planName NVARCHAR(1024)	OUTPUT,
  @o_planOwnerId INTEGER			OUTPUT,
  @o_mediaAgentId INTEGER			OUTPUT,
  @o_isMAHavePackages INTEGER			OUTPUT,
  @o_dcPlanId INTEGER			OUTPUT,
  @o_errCode INTEGER			OUTPUT,
  @o_errString NVARCHAR(1024)	OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @o_errCode = 0
SET @o_errString = 'Success'
-- Set default output values
SET @o_planId=0
SET @o_planName=''
SET @o_planOwnerId=0
SET @o_mediaAgentId=0
SET @o_isMAHavePackages=0
SET @o_dcPlanId=0
DECLARE @executionUnixTime  INT           = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
IF (@i_subClientId > 0) AND NOT EXISTS (SELECT 1 FROM App_Application WHERE id=@i_subClientId)
BEGIN
SET @o_errCode = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @i_localeId)
	SET @o_errString = REPLACE(@o_errString, '^1%s', 'Subclient Id')
END
IF (@i_planId > 0)
BEGIN
	SELECT @o_planId=id, @o_planName=name, @o_planOwnerId=ownerId FROM APP_Plan WHERE id=@i_planId
END
ELSE
BEGIN
	IF (@i_subClientId > 0)
	BEGIN
		-- Let's check if subclient already have server plan associated to it.
		SELECT @o_planId=AP.id, @o_planName=AP.name, @o_planOwnerId=AP.ownerId FROM APP_SubClientProp ASCP
						INNER JOIN App_Plan AP
							ON CAST(AP.id AS NVARCHAR(64))=ASCP.attrVal AND AP.subType=@i_planSubType
						INNER JOIN APP_Application AAP
							ON AAP.id=ASCP.componentNameId
WHERE ASCP.componentNameId=@i_subClientId AND ASCP.attrname='Associated Plan' AND ASCP.modified=0
	END
	ELSE
	BEGIN
		-- We have no route to support from here.
		-- Most possible case here is we are trying to Create Subclient wihtout server plan and with Intellisnap option enabled. Can't do much here
		SET @o_errCode = 5
		SET @o_errString = 'No Applicable Plan available can be fetched from subclient.'
		GOTO ERROR_EXIT
	END
END
-- At this time, we should have plan id available. If not, that means , there is no Server plan association
IF (@o_planId = 0)
BEGIN
	-- Since this is local error code, no need to localize
	SET @o_errCode = 5
	SET @o_errString = 'No Applicable Plan available'
	GOTO ERROR_EXIT
END
ELSE
BEGIN
	IF @i_skipDCPlanCheck = 0
	BEGIN
		-- Let's check if there is associated DC plan for the server plan
		SELECT @o_dcPlanId=AP.id FROM APP_PlanProp APP
				INNER JOIN App_Plan AP
ON CAST(AP.id AS NVARCHAR(64))=APP.attrVal AND APP.modified=0 AND AP.subtype=117506053
WHERE componentNameId=@o_planId AND APP.attrname='Default Data classification Plan'
	END
	-- If we have DC plan id, then no need to get MA client ID
	IF (@o_dcPlanId = 0)
	BEGIN
DECLARE @storagePolicyId   INT = dbo.AppPlanGetEntityValue(@o_planId, 'Storage policy',  default)
		DECLARE @count INT = 0
		-- Now get MA Client ID from this Storage Policy
		-- So, we will get MA with maximum packages installed here
SELECT	TOP 1 @o_mediaAgentId=DPool.ClientId, @count= ( SELECT COUNT(*) FROM simInstalledPackages WHERE simInstalledPackages.ClientId=DPool.ClientId AND simPackageID IN (55,263 ,1306, 1156) )
		FROM	ArchGroup AG WITH(READUNCOMMITTED),
				MMDataPath DPath WITH(READUNCOMMITTED),
				MMDrivePool DPool WITH(READUNCOMMITTED),
				App_Client AC  WITH(READUNCOMMITTED),
				simOperatingSystem SIM  WITH(READUNCOMMITTED)
		WHERE	AG.id = @storagePolicyId
				AND AG.defaultCopy = DPath.CopyId
				AND DPath.DrivePoolId = DPool.DrivePoolId
				AND AC.id=DPool.ClientId
				AND SIM.id=Ac.simOperatingSystemId AND SIM.Type IN ('Windows', 'Unix')
		ORDER BY 2 DESC
		-- Now for this MA, check if this one has all the required packages installed.
		IF @count = 2
		BEGIN
			SET @o_isMAHavePackages = 1
		END
		ELSE
		BEGIN
			SET @o_isMAHavePackages = 0
		END
	END
	ELSE
	BEGIN
		-- We don't need to honor anything with these values
		SET @o_mediaAgentId = 0
		SET @o_isMAHavePackages = 0
	END
END
RETURN
ERROR_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppValidatePlanTypeForSubclient')
	delete from GxQscripts where name = 'AppValidatePlanTypeForSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidatePlanTypeForSubclient')
	delete from GXDBVersions where aliasname = 'AppValidatePlanTypeForSubclient'
GO

insert into GXDBVersions values(2, 'AppValidatePlanTypeForSubclient',  '00010001000400040000', 'AppValidatePlanTypeForSubclient', '00010001000400040000')
GO

