

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppValidateMemberServers.sp] ---------- 

--  +==========================================================================================
--  | Stored Procedure: Validates the available members with the members passed in the request
--  +==========================================================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppValidateMemberServers')
BEGIN
	print '>>> Drop Stored Procedure: AppValidateMemberServers <<<'
	drop procedure AppValidateMemberServers
END
IF EXISTS (select * from GxQscripts where name='AppValidateMemberServers')
	delete from GxQscripts where name = 'AppValidateMemberServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidateMemberServers')
	delete from GXDBVersions where aliasname = 'AppValidateMemberServers'
GO
print '... Creating Procedure: AppValidateMemberServers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppValidateMemberServers
  @memberServers_xml XML
AS
    SET NOCOUNT ON
	DECLARE @availableServers_xml XML
	DECLARE @error XML
	DECLARE @errorCode int = 0
	DECLARE @errorMsg NVARCHAR(510) = 'Memberservers validated successfully.'
	DECLARE @invalidClients XML
	DECLARE @rowCount int
BEGIN TRY
	IF OBJECT_ID('tempdb.dbo.#memberServers') IS NOT NULL DROP TABLE #memberServers
	CREATE TABLE #memberServers (clientGroupId INT , clientGroupName nvarchar(510) , clientId INT, clientName nvarchar(510),entityType INT)
	INSERT INTO #memberServers
		SELECT ref.value('@clientGroupId', 'INT'), ref.value('@clientGroupName', 'NVARCHAR(510)'), ref.value('@clientId', 'INT'),ref.value('@clientName', 'NVARCHAR(510)'),ref.value('@_type_', 'INT')
		FROM @memberServers_xml.nodes('Api_ValidateMemberServersRequest/memberServers/memberServers/client') R(ref)
	SET @rowCount = @@ROWCOUNT
	IF(@rowCount = 0)
	BEGIN
		RAISERROR ('No member servers provided in the request.', 16, 1 )
	END
	DECLARE @vsaClientReq_XML XML = (SELECT
									ISNULL(ref.value('@vendor', 'INT'),0) AS '@vendor',
  									(SELECT ref.value('(appType/@applicationId)[1]', 'INT')  AS '@applicationId' FOR     XML PATH('appType'), TYPE),
									(SELECT ref.value('(user/@userId)[1]', 'INT')  AS '@userId' FOR     XML PATH('user'), TYPE),
									(SELECT ref.value('(packageInfo/@packageId)[1]', 'INT')  AS '@packageId' FOR   XML PATH('packageInfo'), TYPE)
								 FROM @memberServers_xml.nodes('Api_ValidateMemberServersRequest') R(ref)
								 FOR  XML PATH('Api_GetVSAClientsAndClientGroups'))
	EXEC AppGetVSAClientsAndClientGroups @vsaClientReq_XML,@availableServers_xml OUTPUT,0
	IF OBJECT_ID('tempdb.dbo.#availableServers') IS NOT NULL DROP TABLE #availableServers
	CREATE TABLE #availableServers (entityType INT, entityId INT)
	--clients
	INSERT INTO #availableServers
		SELECT 3, ref.value('@clientId', 'INT') FROM @availableServers_xml.nodes('Api_GetVSAClientsAndClientGroups/clients') R(ref)
	--clientgroups
	INSERT INTO #availableServers
		SELECT 28, ref.value('@clientGroupId', 'INT') FROM @availableServers_xml.nodes('Api_GetVSAClientsAndClientGroups/clientGroups') R(ref)
	--Autoscale related changes
	DECLARE @applicationId INT
	SELECT @applicationId = ref.value('(appType/@applicationId)[1]', 'INT')
		   FROM @memberServers_xml.nodes('Api_ValidateMemberServersRequest') R(ref)
	IF @applicationId = 106
	BEGIN
		--if client group used in autoscale hypervisors we need to ignore clientgroup from validation, as client group doesn't have any VSA client some time.
		DELETE ms
		FROM #memberServers ms
		INNER JOIN  App_VmAllocationPolicy VP WITH(NOLOCK)
		ON vxml.value('/policy[1]/@vmPolicyAppType','INT') = 2
		AND ms.entityType = 28
		AND ms.clientGroupId = vxml.value('/policy[1]/associatedClientGroup[1]/@clientGroupId','INT')
		LEFT OUTER JOIN #availableServers avs
		ON avs.entityType = ms.entityType
		AND avs.entityId = ms.clientGroupId
		WHERE avs.entityId IS NULL
		---raise an error after removing the autoscale enabled client group which doesn't have any valid VSA client
		--and memberServers list is empty.
		IF NOT EXISTS(SELECT 1 FROM #memberServers)
		BEGIN
           RAISERROR ('No member servers to validate after removing AutoScale client group.', 16, 1 )
		END
	END
	 SET @invalidClients =
			(SELECT ms.clientGroupId as '@clientGroupId',
					ms.clientGroupName as '@clientGroupName',
					ms.clientId as '@clientId',
					ms.clientName as '@clientName',
					ms.entityType as '@_type_'
			FROM #memberServers ms
			LEFT OUTER JOIN #availableServers avs ON ms.entityType = avs.entityType AND  (ms.clientGroupId  = avs.entityId OR ms.clientId  = avs.entityId)
			WHERE avs.entityId IS NULL
			FOR     XML PATH('client'), TYPE)
	IF (@invalidClients is not null)
	BEGIN
		 SET @errorCode = 99
		 SET @errorMsg = 'There is ' + @invalidClients.value('count(client)','nvarchar(30)') + ' client/clientgroups in the provided memberservers request.'
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode = ERROR_NUMBER()
        SET @errorMsg ='Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END  CATCH
	DECLARE @rv XML = (SELECT
							(SELECT
								@errorCode '@errorCode',
								@errorMsg '@errorMessage'
							FOR XML PATH('error'), TYPE
							),
							(SELECT
								@invalidClients
							FOR     XML PATH('invalidMemberServers'), TYPE
							)
						FOR  XML PATH('Api_ValidateMemberServersRespone'))
	SELECT @rv
    IF OBJECT_ID('tempdb.dbo.#availableServers') IS NOT NULL DROP TABLE #availableServers
	IF OBJECT_ID('tempdb.dbo.#memberServers') IS NOT NULL DROP TABLE #memberServers
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppValidateMemberServers')
	delete from GxQscripts where name = 'AppValidateMemberServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidateMemberServers')
	delete from GXDBVersions where aliasname = 'AppValidateMemberServers'
GO

insert into GXDBVersions values(2, 'AppValidateMemberServers',  '00000000000000000000', 'AppValidateMemberServers', '00000000000000000000')
GO

