

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppValidateIndexServerRole.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppValidateIndexServerRole
--  | Description:   Creates/ delete entries in  DM2Cloud table
--  |
--  |			create analytics servers cloud
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppValidateIndexServerRole.sp,v $ $Id: AppValidateIndexServerRole.sp,v 1.1.2.8 2020/08/24 15:15:51 sjohnson Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppValidateIndexServerRole')
BEGIN
	print '>>> Drop Stored Procedure: AppValidateIndexServerRole <<<'
	drop procedure AppValidateIndexServerRole
END
IF EXISTS (select * from GxQscripts where name='AppValidateIndexServerRole')
	delete from GxQscripts where name = 'AppValidateIndexServerRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidateIndexServerRole')
	delete from GXDBVersions where aliasname = 'AppValidateIndexServerRole'
GO
print '... Creating Procedure: AppValidateIndexServerRole'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppValidateIndexServerRole
  @i_userID INT,
  @i_inputXml XML,   
  @o_errorCode INT OUTPUT,
  @o_errorStr varchar(512) OUTPUT,
  @i_createMode INT = 0
AS
SET @o_errorCode = 0
SET @o_errorStr = 'Success'
DECLARE @opType INT = 0
DECLARE @roleId INT = 0
DECLARE @cloudId INT = 0
DECLARE @installTime int = dbo.GetUnixTime(GETDATE())
DECLARE @opEvMsgId          INT = 0
DECLARE @dataIsEvent        INT = 0
DECLARE @opMsgId            INT = 0
DECLARE @opId               INT = 0
DECLARE @paramMsgId         INT = 0
DECLARE @roleList			NVARCHAR(1024)
/*
<App_RoleOperation cloudId="7"><roles roleId="2" operationType="1" status="3" /></App_RoleOperation>
*/
SET @cloudId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
                              FROM @i_inputXml.nodes ('App_RoleOperation') R(ref)), 0)
IF @cloudId = 0 AND @i_createMode = 0
BEGIN
	SET @o_errorStr = 'Invalid cloudId'
	SET @o_errorCode = 12708 -- CLOUD_ID_INVALID
	GOTO errorexit
END
-- check validity of the client only for edit mode
If  @i_createMode = 0 ANd @cloudId > 0 AND NOT EXISTS (SELECT 1 FROM DM2CLOUD (NOLOCK) WHERE cloudId = @cloudId)
BEGIN
	SET @o_errorStr = 'Invalid cloudId. CloudId does not exists.'
	SET @o_errorCode = 12708 -- CLOUD_ID_INVALID
	GOTO errorexit
END
DECLARE @analyticsRolesTbl TABLE (t_roleId INT, t_opType INT, t_status INT)
INSERT INTO @analyticsRolesTbl
SELECT DISTINCT  ref.value('@roleId', 'INT') , ref.value('@operationType', 'INT'), ref.value('@status', 'INT')
FROM @i_inputXml.nodes ('App_RoleOperation/roles') R(ref)
IF NOT EXISTS (SELECT 1 FROM @analyticsRolesTbl)
BEGIN
	SET @o_errorStr = 'Invalid or empty roles.'
	SET @o_errorCode = 12751   -- ROLE_ID_INVALID
	GOTO errorexit
END
--check association before role deletion
IF EXISTS (SELECT 1 FROM @analyticsRolesTbl WHERE t_opType = 2 )
BEGIN
	DECLARE @roleIDList VARCHAR(255)
	SELECT @roleIDList = COALESCE(@roleIDList+',' ,'') + CAST (t_roleId AS VARCHAR(10)) FROM  @analyticsRolesTbl WHERE t_opType = 2
	DECLARE @indexServerClientId INT = ISNULL((SELECT TOP 1 pseudoClientId FROM DM2Cloud (nolock) WHERE cloudId = @cloudId),0)
	IF @indexServerClientId >0
		EXEC APPCheckIndexServerDelDependency @indexServerClientId, @roleIDList, 0, @o_errorCode OUTPUT, @o_errorStr OUTPUT
END
--For Edge role, NFS index role -- add operation -- WS /Index gateway package is required.
IF @i_createMode = 0 AND EXISTS (SELECT 1 FROM @analyticsRolesTbl WHERE t_roleId IN (7, 13) AND t_opType = 1)
BEGIN
	DECLARE @nodeClientTbl TABLE(t_nodeClientId INT, t_nodeClientName NVARCHAR(256))
	--get default node for CVSOLR and all nodes for Cluster SOLR
	INSERT INTO @nodeClientTbl (t_nodeClientId, t_nodeClientName)
	SELECT C.id, C.name
	FROM APP_Client C (NOLOCK)
	JOIN DM2SearchServerCoreInfo S (NOLOCK) ON C.id= S.clientId
WHERE S.cloudId = @cloudId AND ((S.coreRoles & 128 > 0
AND S.CloudType =1)
OR S.CloudType =5)
	IF NOT EXISTS (SELECT 1 FROM SimInstalledPackages S (NOLOCK)
					JOIN @nodeClientTbl T ON  S.clientId = T.t_nodeClientId
WHERE S.simpackageId IN (252, 1174,
263, 1156)
						)
	BEGIN
		SET @o_errorStr = 'Cannot add Edge Drive / NFS Index role. Error: Web Server OR Index Gateway package is not installed on the default node ['+ (SELECT TOP  1 t_nodeClientName FROM @nodeClientTbl)  +']'
		SET @o_errorCode = 10056 -- PACKAGE_NOT_FOUND
		GOTO errorexit
	END
END
--Check for supported roles for CvCloud
DECLARE @cloudType INT =0
SET @cloudType = ISNULL((SELECT TOP 1 cloudType FROM DM2Cloud (NOLOCK) WHERE cloudId = @cloudId),0)
IF @cloudType = 1 AND EXISTS (SELECT TOP 1 1 FROM @analyticsRolesTbl WHERE t_opType = 1)
BEGIN
	DECLARE @nodeOperation TABLE (t_OpType INT, t_clientId INT)
--AppAnalyticsCvCloudCheck.spb
--if cloud is already configured
IF @cloudId >0
BEGIN
	--get existing nodes
	INSERT INTO @nodeOperation (t_clientId, t_opType)
	SELECT clientId, 0
	FROM DM2SearchServerCoreInfo S (NOLOCK)
	LEFT JOIN @nodeOperation N ON S.clientId = N.t_clientId
WHERE S.cloudId =@cloudId AND S.cloudType = 1 AND N.t_clientId IS NULL
	--get existing roles
	INSERT INTO @analyticsRolesTbl (t_roleId, t_opType)
	SELECT roleId , 5  --ENABLED
	FROM DM2CloudCoreRole R (NOLOCK)
	LEFT JOIN @analyticsRolesTbl N ON R.roleId = N.t_roleId
	WHERE R.cloudId =@cloudId AND N.t_roleId IS NULL
END
IF (SELECT COUNT(*) FROM @nodeOperation) > 1
BEGIN
	DECLARE @roleNames    nvarchar(1024)= N''
	SELECT @roleNames = M.roleTypeName + COALESCE(', ' + @roleNames, '')
		FROM @analyticsRolesTbl R
		JOIN DM2CloudRoleMaster M ON R.t_roleId = M.roleId
WHERE (M.roleServerType & 4) = 0 AND R.t_opType IN (1,5)
	--Check for supported roles
	IF LEN(@roleNames) > 0
	BEGIN
		SET @o_errorStr = 'MultiNode index server is not supported for roles ['+ SUBSTRING(@roleNames, 1, LEN(@roleNames) - 1) +']'
		SET @o_errorCode = 12752 -- ROLE_OPERATION_FAILED
		GOTO errorexit
	END
END
END
errorexit:
--OUTPUT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppValidateIndexServerRole')
	delete from GxQscripts where name = 'AppValidateIndexServerRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidateIndexServerRole')
	delete from GXDBVersions where aliasname = 'AppValidateIndexServerRole'
GO

insert into GXDBVersions values(2, 'AppValidateIndexServerRole',  '00010001000200080000', 'AppValidateIndexServerRole', '00010001000200080000')
GO

