

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppValidateIndexServerNode.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppValidateIndexServerNode
--  | Description:   Creates/ delete entries in DM2SearchServerCodeInfo, DM2Cloud
--  |                and DM2CloudCoreRole tables
--  |
--  |			create solr servers cloud
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppValidateIndexServerNode.sp,v $ $Id: AppValidateIndexServerNode.sp,v 1.1.2.10.14.1 2021/05/18 05:01:04 pankajkumar Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppValidateIndexServerNode')
BEGIN
	print '>>> Drop Stored Procedure: AppValidateIndexServerNode <<<'
	drop procedure AppValidateIndexServerNode
END
IF EXISTS (select * from GxQscripts where name='AppValidateIndexServerNode')
	delete from GxQscripts where name = 'AppValidateIndexServerNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidateIndexServerNode')
	delete from GXDBVersions where aliasname = 'AppValidateIndexServerNode'
GO
print '... Creating Procedure: AppValidateIndexServerNode'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppValidateIndexServerNode
  @i_userID INT,
  @i_inputXml XML,   
  @i_cloudType INT,
  @o_errorCode INT OUTPUT,
  @o_errorStr varchar(512) OUTPUT,
  @i_createMode INT = 0,
  @i_createModeIndexServerPoolCloudId INT = 0
AS
SET @o_errorCode = 0
SET @o_errorStr = 'Success'
DECLARE @opType INT = 0
DECLARE @clientId INT = 0
DECLARE @cloudId INT = 0
DECLARE @indexServerPoolCloudId INT = 0
DECLARE @portNo INT = 0
DECLARE @commcellId INT = 2
DECLARE @status INT = 0
DECLARE @nodeProps NVARCHAR(2048)
DECLARE @clientName NVARCHAR(2048)
DECLARE @indexDir NVARCHAR(2048)
DECLARE @cloudDisplayName NVARCHAR(2048)
DECLARE @jvmMemory INT = 0
DECLARE @installTime int = dbo.GetUnixTime(GETDATE())
DECLARE @cloudName NVARCHAR(1024)
/*<App_NodeOperation cloudId="18">
      <nodes opType="1" status="3">
             <nodeClientEntity clientId="2" />
              <nodeMetaInfos name="analytics_datadirectory" value="C:\Program Files\CommVault\AEDataNew" />  <nodeMetaInfos name="analytics_jvmMaxMem" value="4098" />  <nodeMetaInfos name="analytics_startport" value="20000" />  <nodeMetaInfos name="analytics_stopport" value="20010" />
      </nodes>
 </App_NodeOperation>
*/
SET @opType = ISNULL (( SELECT TOP 1 ref.value('@opType', 'INT')
                              FROM @i_inputXml.nodes ('App_NodeOperation/nodes') R(ref)), 0)
SET @cloudId = ISNULL (( SELECT TOP 1 ref.value('@cloudId', 'INT')
                              FROM @i_inputXml.nodes ('App_NodeOperation') R(ref)), 0)
IF @i_cloudType = 6
BEGIN
	EXEC AppValidateHACClusterNode @i_userID,@i_inputXml, @i_cloudType,@o_errorCode OUTPUT,@o_errorStr OUTPUT
	GOTO errorexit
END
IF @cloudId = 0 AND @i_createMode = 0
BEGIN
		SET @o_errorStr = 'Invalid cloudId.'
		SET @o_errorCode = 12708 -- CLOUD_ID_INVALID
		GOTO errorexit
END
IF( @i_createMode = 0)
BEGIN
	-- check validity of the cloud
	If  @cloudId > 0 AND NOT EXISTS (SELECT 1 FROM DM2CLOUD (NOLOCK) WHERE cloudId = @cloudId)
	BEGIN
		SET @o_errorStr = 'Invalid cloudId. CloudId does not exists.'
		SET @o_errorCode = 12708 -- CLOUD_ID_INVALID
		GOTO errorexit
	END
	--populate pool
	select @indexServerPoolCloudId  = cloudId from DM2Cloud WITH (NOLOCK) WHERE CloudType = 9 AND pseudoClientId IN  (SELECT indexServerPoolClientId FROM DM2Cloud (NOLOCK) WHERE cloudId = @cloudId)
END
ELSE
BEGIN
	--When getting validated from IndexServer create mode, we will pass explicit PoolCloudId that we get in the input
	--
	SELECT @indexServerPoolCloudId  =  cloudId from DM2Cloud WITH (NOLOCK) WHERE CloudType = 9 AND pseudoClientId = @i_createModeIndexServerPoolCloudId
END
--get nodes
DECLARE @nodeOperation TABLE (t_OpType INT, t_clientId INT)
INSERT INTO @nodeOperation (t_OpType, t_clientId)
SELECT ref.value('@opType', 'INT'), ref.value('nodeClientEntity[1]/@clientId', 'INT')
FROM @i_inputXml.nodes ('App_NodeOperation/nodes') R(ref)
-- check validity of the client
IF NOT EXISTS (SELECT 1 FROM APP_Client (NOLOCK)  join  @nodeOperation ON id = t_clientId)
BEGIN
	SET @o_errorStr = 'Invalid clientId'
	SET @o_errorCode = 12742		--NODE_CLIENT_ID_INVALID
	GOTO errorexit
END
-- check if all nodes belong to same isp
IF @i_cloudType = 5
BEGIN
	IF EXISTS(SELECT t_clientId from @nodeOperation
				EXCEPT
SELECT ClientId FROM DM2SearchServerCoreInfo WHERE CloudType = 9 and CloudId = @indexServerPoolCloudId)
	BEGIN
		SET @o_errorStr = 'Clients doesnt belong to selected indexserverpool'
		SET @o_errorCode = 12742		--NODE_CLIENT_ID_INVALID --new error code
		GOTO errorexit
	END
	-- case when index server client are in non-configured state.
	--
IF EXISTS(SELECT t_clientId from @nodeOperation WHERE t_clientId IN (SELECT ClientId FROM DM2SearchServerCoreInfo WHERE CloudType = 9 and CloudId = @indexServerPoolCloudId AND status != 1))
	BEGIN
		SET @o_errorStr = 'Clients selected are not in configured state in indexserverpool'
		SET @o_errorCode = 12750		--NODE_CLIENT_ID_POOL_NOT_CONFIGURED
		GOTO errorexit
	END
END
-- check if nodes is not already configured
IF @i_cloudType = 9 AND @opType = 1 AND EXISTS (SELECT 1 FROM DM2SearchServerCoreInfo (NOLOCK) JOIN  @nodeOperation ON clientId = t_clientId AND cloudType IN (1,9) AND cloudId != @cloudId)
BEGIN
	SET @o_errorStr = 'Client already part of other index server/pool'
	SET @o_errorCode = 12742		--NODE_CLIENT_ID_INVALID --new error code
	GOTO errorexit
END
--Standalone node deletion is not allowed by default
IF @i_cloudType = 1 AND @opType = 2	--DELETE
BEGIN
	DECLARE @isNodeDeletionAllowed INT = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam (NOLOCK) WHERE name = 'AllowNodeDeletion' AND modified =0), 0)
	IF @isNodeDeletionAllowed = 0
	BEGIN
		SET @o_errorStr = 'Node deletion is not supported'
		SET @o_errorCode = 12744		--NODE_OPERATION_FAILED
		GOTO errorexit
	END
END
IF @i_cloudType = 1 AND @opType = 1	--ADD
BEGIN
	DECLARE @analyticsRolesTbl TABLE (t_roleId INT, t_opType INT, t_status INT)
	--Check for supported roles for CvCloud
--AppAnalyticsCvCloudCheck.spb
--if cloud is already configured
IF @cloudId >0
BEGIN
	--get existing nodes
	INSERT INTO @nodeOperation (t_clientId, t_opType)
	SELECT clientId, 0
	FROM DM2SearchServerCoreInfo S (NOLOCK)
	LEFT JOIN @nodeOperation N ON S.clientId = N.t_clientId
WHERE S.cloudId =@cloudId AND S.cloudType = 1 AND N.t_clientId IS NULL
	--get existing roles
	INSERT INTO @analyticsRolesTbl (t_roleId, t_opType)
	SELECT roleId , 5  --ENABLED
	FROM DM2CloudCoreRole R (NOLOCK)
	LEFT JOIN @analyticsRolesTbl N ON R.roleId = N.t_roleId
	WHERE R.cloudId =@cloudId AND N.t_roleId IS NULL
END
IF (SELECT COUNT(*) FROM @nodeOperation) > 1
BEGIN
	DECLARE @roleNames    nvarchar(1024)= N''
	SELECT @roleNames = M.roleTypeName + COALESCE(', ' + @roleNames, '')
		FROM @analyticsRolesTbl R
		JOIN DM2CloudRoleMaster M ON R.t_roleId = M.roleId
WHERE (M.roleServerType & 4) = 0 AND R.t_opType IN (1,5)
	--Check for supported roles
	IF LEN(@roleNames) > 0
	BEGIN
		SET @o_errorStr = 'MultiNode index server is not supported for roles ['+ SUBSTRING(@roleNames, 1, LEN(@roleNames) - 1) +']'
		SET @o_errorCode = 12752 -- ROLE_OPERATION_FAILED
		GOTO errorexit
	END
END
END
--Index directory modification is not allowed
IF @i_cloudType IN (1)
BEGIN
	DELETE @nodeOperation WHERE t_OpType != 3
	IF EXISTS (SELECT 1 FROM @nodeOperation)
	BEGIN
		DECLARE @nodeStatus INT = 0
		DECLARE @nodePropXml XML =''
		SELECT TOP 1 @nodePropXml = nodeProps , @nodeStatus = status
		FROM DM2SearchServerCoreInfo (NOLOCK) S
		JOIN @nodeOperation T ON S.clientId = T.t_clientId
WHERE cloudType = 1 AND S.cloudId = @cloudId AND ISNULL(nodeProps,'') <> ''
		IF @nodeStatus = 1
		BEGIN
			DECLARE @indexDirFromDB NVARCHAR(1024)
			--get index location from input request
			DECLARE @indexDirFromReq NVARCHAR(1024) =ISNULL (( SELECT ref1.value('@value', 'NVARCHAR(1024)')
                              FROM @i_inputXml.nodes ('App_NodeOperation/nodes/nodeMetaInfos') R(ref1)
							  WHERE ref1.value('@name', 'NVARCHAR(1024)') = 'INDEXLOCATION'), '')
			--get index location from DM2SearchServerCoreInfo DB
			DECLARE @nodePropsTbl TABLE (t_name NVARCHAR(256), t_value nvarchar(1024))
			INSERT INTO @nodePropsTbl
            SELECT  ref.value('@name', 'NVARCHAR(1024)'),ref.value('@value', 'NVARCHAR(1024)')
            FROM @nodePropXml.nodes ('NodeMetaProp/nodeMetaInfos') R(ref)
			SET @indexDirFromDB = ISNULL((SELECT  TOP 1 t_value FROM @nodePropsTbl WHERE t_name ='INDEXLOCATION'),'')
			--Compare index location from input request and DB
			IF LEN(@indexDirFromReq)> 0 AND LEN(@indexDirFromDB)>0 AND @indexDirFromReq != @indexDirFromDB
			BEGIN
				SET @o_errorStr = 'Index directory modification is not supported.'
				SET @o_errorCode = 12744		--NODE_OPERATION_FAILED
				GOTO errorexit
			END
		END
	END
END
errorexit:
return
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppValidateIndexServerNode')
	delete from GxQscripts where name = 'AppValidateIndexServerNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidateIndexServerNode')
	delete from GXDBVersions where aliasname = 'AppValidateIndexServerNode'
GO

insert into GXDBVersions values(2, 'AppValidateIndexServerNode',  'v1.1.2.10.14.1', 'AppValidateIndexServerNode', 'v1.1.2.10.14.1')
GO

