

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppValidateIndexServer.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppValidateIndexServer
--  | Description:   Creates/ delete entries in  DM2Cloud table
--  |
--  |			create analytics servers cloud
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppValidateIndexServer.sp,v $ $Id: AppValidateIndexServer.sp,v 1.1.2.15 2020/04/24 19:57:55 pankajkumar Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppValidateIndexServer')
BEGIN
	print '>>> Drop Stored Procedure: AppValidateIndexServer <<<'
	drop procedure AppValidateIndexServer
END
IF EXISTS (select * from GxQscripts where name='AppValidateIndexServer')
	delete from GxQscripts where name = 'AppValidateIndexServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidateIndexServer')
	delete from GXDBVersions where aliasname = 'AppValidateIndexServer'
GO
print '... Creating Procedure: AppValidateIndexServer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppValidateIndexServer
  @i_userID INT,
  @i_inputXml XML,   
  @i_cloudType INT,
  @o_pseudoClientId INT	OUTPUT,
  @o_errorCode INT OUTPUT,
  @o_errorStr varchar(512) OUTPUT,
  @i_validateCreateMode INT = 0,
  @i_localeId INT = 0
AS
SET @o_errorStr = 'Success'
DECLARE @cloudId INT
DECLARE @cloudName NVARCHAR(256) = N''
DECLARE @cloudDisplayName NVARCHAR(256) = N''
DECLARE @indexServerPoolId INT = 0
DECLARE @zookeeperCloudId INT = 0
DECLARE @nodeClientId TABLE (t_clientId INT)
DECLARE @clientId INT = 0
DECLARE @commcellId INT = 2
DECLARE @cloudProps NVARCHAR(512)
DECLARE @opType INT = 0
DECLARE @status INT = 0
declare @installTime int = dbo.GetUnixTime(GETDATE())
DECLARE @RegCode            NVARCHAR(64) = N''
DECLARE @DBRegCode          NVARCHAR(64) = N''
DECLARE @CsGuid             NVARCHAR(64) = N''
/*
<App_CloudInfo opType="1" type="4">  <cloudNodes opType="1">  <nodeClientEntity clientId="4" />
 <nodeMetaInfos name="INDEXLOCATION" value="C:\Program Files\CommVault\AEDataNew" />
  <nodeMetaInfos name="analytics_jvmMaxMem" value="4098" />
   <nodeMetaInfos name="PORTNO" value="20000" />
     <nodeMetaInfos name="analytics_stopport" value="20010" />
	   </cloudNodes>  <solrCloudInfo>  <roles roleId="2" operationType="1" />
	    </solrCloudInfo>  <cloudInfoEntity cloudName="firstCloud" cloudDisplayName="firstCloud" />
		 </App_CloudInfo>
*/
SET @opType = ISNULL (( SELECT ref.value('@opType', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo') R(ref)), 0)
SET @status = ISNULL (( SELECT ref.value('@status', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo') R(ref)), 3)  --pending
SET @cloudId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo/cloudInfoEntity') R(ref)), 0)
SET @cloudDisplayName = ISNULL (( SELECT ref.value('@cloudDisplayName', 'NVARCHAR(256)')
                            FROM @i_inputXml.nodes ('App_CloudInfo/cloudInfoEntity') R(ref)), N'')
SET @cloudName = ISNULL (( SELECT ref.value('@cloudName', 'NVARCHAR(1024)')
                            FROM @i_inputXml.nodes ('App_CloudInfo/cloudInfoEntity') R(ref)), N'')
SET @cloudProps =ISNULL((SELECT ref.value('@name', 'NVARCHAR(1024)') as '@name', ref.value('@value', 'NVARCHAR(2048)') AS '@value'
					FROM @i_inputXml.nodes ('App_CloudInfo/cloudMetaInfos') R(ref) FOR XML PATH('cloudMetaInfos'), ROOT('CloudMetaProp')) ,N'')
SET @indexServerPoolId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo/solrCloudInfo/cloudPoolInfo') R(ref)), 0)
SET @zookeeperCloudId = ISNULL (( SELECT ref.value('@clientGroupId', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo/solrCloudPoolInfo/zookerEntity') R(ref)), 0)
-- check validity of the operation type
If  @opType = 0 OR  @opType NOT IN (1, 2, 3) --modify, delete
BEGIN
	SET @o_errorStr = 'Invalid operation Type.'
	SET @o_errorCode = 12721 -- INVALID_OPERATION_TYPE
	GOTO errorexit
END
If @i_cloudType = 6  AND  @opType = 1 --ADD
BEGIN
	--get max node allowed to configured, by default = 5
	DECLARE @maxZKNodes INT= ISNULL((SELECT value FROM GXGlobalParam (NOLOCK) WHERE name ='MaxNumHACNodes' AND modified = 0), 5)
	DECLARE @inputZKNodes INT = ISNULL (( SELECT COUNT( ref.value('@clientId', 'INT'))
                              FROM @i_inputXml.nodes ('App_CloudInfo/cloudNodes/nodeClientEntity') R(ref)), 0)
	IF @inputZKNodes >0 AND (@inputZKNodes > @maxZKNodes OR @inputZKNodes % 2 = 0)
	BEGIN
		SET @o_errorStr = 'You must select an odd number of client nodes, with a maximum of ' + CAST (@maxZKNodes AS VARCHAR(10))
		SET @o_errorCode = 12792 -- HAC_CLUSTER_OPERATION_FAILED
		GOTO errorexit
	END
END
If @i_cloudType = 5  AND  @opType = 1 AND  (@indexServerPoolId = 0 OR NOT EXISTS (SELECT 1 FROM DM2Cloud (NOLOCK) WHERE pseudoClientId = @indexServerPoolId and cloudTYpe =9))
BEGIN
	SET @o_errorStr = 'Invalid Index Server Pool.'
	SET @o_errorCode = 12722 -- INVALID_SERVER_TYPE --new error no
	GOTO errorexit
END
If @i_cloudType = 9 AND  @opType = 1 AND  (@zookeeperCloudId = 0 OR NOT EXISTS (SELECT 1 FROM App_client (NOLOCK) WHERE Id = @zookeeperCloudId))
BEGIN
	SET @o_errorStr = 'Invalid Index Server Pool.'
	SET @o_errorCode =  12814  --ZK_CLOUD_ID_INVALID
	GOTO errorexit
END
IF @cloudId = 0 AND @opType IN (2, 3) --modify, delete
BEGIN
	SET @o_errorStr = 'Invalid cloudId.'
	SET @o_errorCode = 12708 -- CLOUD_ID_INVALID
	GOTO errorexit
END
-- check validity of the cloud name
If @opType = 1 AND @cloudDisplayName = N''
BEGIN
	SET @o_errorStr = 'Invalid cloud name.'
	SET @o_errorCode = 12707 -- CLOUD_DISPLAYNAME_INVALID
	GOTO errorexit
END
If @opType = 1 AND EXISTS (SELECT 1 FROM DM2Cloud (NOLOCK) WHERE displayName = @cloudDisplayName OR name = @cloudName)
BEGIN
	SET @o_errorStr = 'cloud name already exists.'
	SET @o_errorCode = 12704 -- CLOUD_NAME_ALREADY_EXISTS
	GOTO errorexit
END
If  @cloudId > 0
BEGIN
	IF @opType = 1 AND EXISTS (SELECT 1 FROM DM2Cloud (NOLOCK) WHERE (name = @cloudDisplayName OR displayName = @cloudDisplayName) AND cloudId != @cloudId)
	BEGIN
		SET @o_errorStr = 'cloud name already exists.'
		SET @o_errorCode = 12704 -- CLOUD_NAME_ALREADY_EXISTS
		GOTO errorexit
	END
	-- check validity of the client
	IF NOT EXISTS (SELECT 1 FROM DM2Cloud (NOLOCK) WHERE cloudId = @cloudId)
	BEGIN
		SET @o_errorStr = 'Invalid cloudId. CloudId does not exists.'
		SET @o_errorCode = 12708 -- CLOUD_ID_INVALID
		GOTO errorexit
	END
	--duplicate cloudname supplied
	--fetch pseudoclientId and validate.
	SELECT @o_pseudoClientId = pseudoClientId FROM DM2Cloud (NOLOCK) WHERE cloudId = @cloudId
	IF @o_pseudoClientId = 0 OR NOT EXISTS (SELECT 1 FROM APP_Client (NOLOCK) WHERE id = @o_pseudoClientId)
	BEGIN
		SET @o_errorStr = 'Invalid pseudoclient mapping to cloudId.'
		SET @o_errorCode = 12712 -- CLOUD_PSEUDOCLIENT_INVALID
		GOTO errorexit
	END
END
--fetch pseudoclient in create mode mapped to input cloud display name
-- this check is not required when request been passed only on validate mode
--
IF(@opType = 1 AND @i_validateCreateMode = 0)
BEGIN
	SET @o_pseudoClientId = ISNULL((SELECT id FROM APP_Client (nolock) WHERE NAME = @cloudDisplayName),0)
	IF(@o_pseudoClientId = 0)
	BEGIN
		SET @o_errorStr = 'Pseudoclient doesnt exists for current input cloud ' + @cloudDisplayName
		SET @o_errorCode = 12712 -- CLOUD_PSEUDOCLIENT_INVALID
		GOTO errorexit
	END
END
--in legacy mode, check if node is already configured
If @i_cloudType = 1 AND  @opType = 1
BEGIN
	INSERT INTO @nodeClientId
	SELECT DISTINCT ref.value('@clientId', 'INT')
    FROM @i_inputXml.nodes ('App_CloudInfo/cloudNodes/nodeClientEntity') R(ref)
	IF EXISTS (SELECT 1 FROM DM2SearchServerCoreInfo (NOLOCK) JOIN @nodeClientId ON clientId = t_clientId
AND cloudType IN (1, 5,9))
	BEGIN
		SET @o_errorStr = 'node client already exists.'
		SET @o_errorCode = 12746 -- NODE_CLIENT_ALREADY_EXISTS
		GOTO errorexit
	END
END
--check association before deletion of index server
IF @i_cloudType IN (1, 5) AND @opType = 2
BEGIN
	DECLARE @indexServerClientId INT = ISNULL((SELECT TOP 1 pseudoClientId FROM DM2Cloud (nolock) WHERE cloudId = @cloudId),0)
	IF @indexServerClientId > 0
		EXEC APPCheckIndexServerDelDependency @indexServerClientId,'', 0, @o_errorCode OUTPUT, @o_errorStr OUTPUT
END
-- During creation/modification of CvSolr index server, check if Webserver/index gateway package is installed on default node for Edge Role
IF @i_cloudType =  1 AND @opType IN (1,3)
BEGIN
	DECLARE @defaultNodeClientName NVARCHAR(256) =''
	SET  @defaultNodeClientName = ISNULL((SELECT TOP 1 C.name FROM APP_Client C (NOLOCK) JOIN  @nodeClientId T ON C.id = T.t_clientId),'')
	--get all roles
	DECLARE @analyticsRolesTbl TABLE (t_roleId INT, t_opType INT, t_status INT DEFAULT 0)
	INSERT INTO @analyticsRolesTbl (t_roleId, t_opType)
	SELECT DISTINCT ref.value('@roleId', 'INT'), ref.value('@operationType', 'INT')
	FROM @i_inputXml.nodes ('App_CloudInfo/solrCloudInfo/roles') R(ref)
	--get all nodes which are going to be added
	DECLARE @nodeOperation TABLE (t_OpType INT, t_clientId INT)
	INSERT INTO @nodeOperation (t_clientId)
	SELECT DISTINCT ref.value('nodeClientEntity[1]/@clientId', 'INT')
	FROM @i_inputXml.nodes ('App_CloudInfo/cloudNodes') R(ref)
	WHERE ref.value('@opType', 'INT') = 1
	--Check for supported roles for CvSolr
--AppAnalyticsCvCloudCheck.spb
--if cloud is already configured
IF @cloudId >0
BEGIN
	--get existing nodes
	INSERT INTO @nodeOperation (t_clientId, t_opType)
	SELECT clientId, 0
	FROM DM2SearchServerCoreInfo S (NOLOCK)
	LEFT JOIN @nodeOperation N ON S.clientId = N.t_clientId
WHERE S.cloudId =@cloudId AND S.cloudType = 1 AND N.t_clientId IS NULL
	--get existing roles
	INSERT INTO @analyticsRolesTbl (t_roleId, t_opType)
	SELECT roleId , 5  --ENABLED
	FROM DM2CloudCoreRole R (NOLOCK)
	LEFT JOIN @analyticsRolesTbl N ON R.roleId = N.t_roleId
	WHERE R.cloudId =@cloudId AND N.t_roleId IS NULL
END
IF (SELECT COUNT(*) FROM @nodeOperation) > 1
BEGIN
	DECLARE @roleNames    nvarchar(1024)= N''
	SELECT @roleNames = M.roleTypeName + COALESCE(', ' + @roleNames, '')
		FROM @analyticsRolesTbl R
		JOIN DM2CloudRoleMaster M ON R.t_roleId = M.roleId
WHERE (M.roleServerType & 4) = 0 AND R.t_opType IN (1,5)
	--Check for supported roles
	IF LEN(@roleNames) > 0
	BEGIN
		SET @o_errorStr = 'MultiNode index server is not supported for roles ['+ SUBSTRING(@roleNames, 1, LEN(@roleNames) - 1) +']'
		SET @o_errorCode = 12752 -- ROLE_OPERATION_FAILED
		GOTO errorexit
	END
END
	--for Edge & nfs index role
IF EXISTS (SELECT 1 FROM @analyticsRolesTbl WHERE t_roleId IN (7, 13) AND t_opType = 1)
	BEGIN
		--for add operation @nodeClientId table is already populated above
		--for modify operation, fetch only default node
		IF @opType = 3
		BEGIN
			DECLARE @defaultNodeClientId INT =0
			SELECT @defaultNodeClientId = C.id, @defaultNodeClientName = C.name
			FROM APP_Client C (NOLOCK)
			JOIN DM2SearchServerCoreInfo S (NOLOCK) ON C.id= S.clientId
WHERE S.cloudId = @cloudId AND S.coreRoles & 128 > 0 AND S.CloudType =1
			INSERT INTO @nodeClientId
			VALUES (@defaultNodeClientId)
		END
		--check if WS or Index gateway package is installed
		DELETE T
		FROM @nodeClientId T
LEFT JOIN SimInstalledPackages S (NOLOCK) ON T.t_clientId = S.clientId AND S.simpackageId IN (252, 1174, 263, 1156)
		WHERE  S.clientId IS NULL
		IF NOT EXISTS (SELECT 1 FROM @nodeClientId)
		BEGIN
			SET @o_errorStr = 'Cannot add Edge Drive / NFS Index role. Error: Web Server OR Index Gateway package is not installed on the default node ['+ @defaultNodeClientName +']'
			SET @o_errorCode = 10056 -- PACKAGE_NOT_FOUND
			GOTO errorexit
		END
	END
END
--Index directory modification is not allowed cluster cloud
IF @i_cloudType IN (5, 1) AND @opType = 3
BEGIN
		DECLARE @cloudStatus INT = ISNULL((SELECT status FROM DM2Cloud (NOLOCK) WHERE cloudId = @cloudId),0)
               --Check if cloud is already configured
		IF @cloudStatus = 1
		BEGIN
			DECLARE @indexDirFromDB NVARCHAR(1024)
                       --get index location from input request
			DECLARE @indexDirFromReq NVARCHAR(1024) =ISNULL (( SELECT ref1.value('@value', 'NVARCHAR(1024)')
                              FROM @i_inputXml.nodes ('App_CloudInfo/cloudMetaInfos') R(ref1)
							  WHERE ref1.value('@name', 'NVARCHAR(1024)') = 'INDEXLOCATION'), '')
			--get index location from DM2cloud DB
			DECLARE @clodMetaProp TABLE (t_name NVARCHAR(1024), t_value NVARCHAR(1024))
			INSERT INTO @clodMetaProp (t_name, t_value)
			EXEC APPGetDM2CloudMetaProp @CloudId , 'INDEXLOCATION'
			SET @indexDirFromDB = ISNULL((SELECT  TOP 1 t_value FROM @clodMetaProp WHERE t_name ='INDEXLOCATION'),'')
                         --Compare index directory from DB and input request
                         --error out if different
			IF (LEN(@indexDirFromReq)> 0 AND @indexDirFromReq != @indexDirFromDB) AND ((LEN(@indexDirFromDB)=0 AND @i_cloudType = 1) OR LEN(@indexDirFromDB)>0)
			BEGIN
				SET @o_errorStr = 'Index directory modification is not supported.'
				SET @o_errorCode = 12702 -- CLOUD_OPERATION_FAILED
				GOTO errorexit
			END
		END
END
errorexit:
return
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppValidateIndexServer')
	delete from GxQscripts where name = 'AppValidateIndexServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidateIndexServer')
	delete from GXDBVersions where aliasname = 'AppValidateIndexServer'
GO

insert into GXDBVersions values(2, 'AppValidateIndexServer',  '00010001000200150000', 'AppValidateIndexServer', '00010001000200150000')
GO

