

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppValidateHACClusterNode.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppValidateHACClusterNode
--  | Description:   Creates/ delete entries in DM2SearchServerCodeInfo, DM2Cloud
--  |
--  |			create solr servers cloud
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppValidateHACClusterNode.sp,v $ $Id: AppValidateHACClusterNode.sp,v 1.1.2.4 2020/08/24 15:17:12 sjohnson Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppValidateHACClusterNode')
BEGIN
	print '>>> Drop Stored Procedure: AppValidateHACClusterNode <<<'
	drop procedure AppValidateHACClusterNode
END
IF EXISTS (select * from GxQscripts where name='AppValidateHACClusterNode')
	delete from GxQscripts where name = 'AppValidateHACClusterNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidateHACClusterNode')
	delete from GXDBVersions where aliasname = 'AppValidateHACClusterNode'
GO
print '... Creating Procedure: AppValidateHACClusterNode'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppValidateHACClusterNode
  @i_userID INT,
  @i_inputXml XML,   
  @i_cloudType INT,
  @o_errorCode INT OUTPUT,
  @o_errorStr varchar(512) OUTPUT
AS
SET @o_errorCode = 0
SET @o_errorStr = 'Success'
DECLARE @opType INT = 0
DECLARE @clientId INT = 0
DECLARE @cloudId INT = 0
DECLARE @commcellId INT = 2
DECLARE @status INT = 0
DECLARE @nodeProps NVARCHAR(2048)
DECLARE @clientName NVARCHAR(2048)
DECLARE @indexDir NVARCHAR(2048)
DECLARE @cloudDisplayName NVARCHAR(2048)
DECLARE @jvmMemory INT = 0
DECLARE @installTime int = dbo.GetUnixTime(GETDATE())
DECLARE @cloudName NVARCHAR(1024)
/*<App_NodeOperation cloudId="18">
      <nodes opType="1" status="3">
             <nodeClientEntity clientId="2" />
              <nodeMetaInfos name="analytics_datadirectory" value="C:\Program Files\CommVault\AEDataNew" />  <nodeMetaInfos name="analytics_jvmMaxMem" value="4098" />  <nodeMetaInfos name="analytics_startport" value="20000" />  <nodeMetaInfos name="analytics_stopport" value="20010" />
      </nodes>
 </App_NodeOperation>
*/
SET @opType = ISNULL (( SELECT ref.value('@opType', 'INT')
                              FROM @i_inputXml.nodes ('App_NodeOperation') R(ref)), 0)
SET @cloudId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
                              FROM @i_inputXml.nodes ('App_NodeOperation') R(ref)), 0)
IF @cloudId = 0 AND @opType in (2,3)
BEGIN
		SET @o_errorStr = 'Invalid cloudId.'
		SET @o_errorCode = 12708 -- CLOUD_ID_INVALID
		GOTO errorexit
END
-- check validity of the cloud
If  @cloudId > 0 AND NOT EXISTS (SELECT 1 FROM DM2CLOUD (NOLOCK) WHERE cloudId = @cloudId)
BEGIN
	SET @o_errorStr = 'Invalid cloudId. CloudId does not exists.'
	SET @o_errorCode = 12708 -- CLOUD_ID_INVALID
	GOTO errorexit
END
--get nodes
DECLARE @nodeOperation TABLE (t_OpType INT, t_clientId INT)
INSERT INTO @nodeOperation (t_OpType, t_clientId)
SELECT ref.value('@opType', 'INT'), ref.value('nodeClientEntity[1]/@clientId', 'INT')
FROM @i_inputXml.nodes ('App_NodeOperation/nodes') R(ref)
-- check validity of the client for ADD or Modify
IF @opType in (1,2) AND NOT EXISTS (SELECT 1 FROM APP_Client (NOLOCK)  join  @nodeOperation ON id = t_clientId)
BEGIN
	SET @o_errorStr = 'Invalid clientId'
	SET @o_errorCode = 12742		--NODE_CLIENT_ID_INVALID
	GOTO errorexit
END
/*
-- case when index server client are in non-configured state.
--
IF EXISTS(SELECT t_clientId from @nodeOperation WHERE t_clientId IN (SELECT ClientId FROM DM2SearchServerCoreInfo WHERE CloudType = 9 and CloudId = @indexServerPoolCloudId AND status != 1))
BEGIN
	SET @o_errorStr = 'Clients selected are not in configured state in indexserverpool'
	SET @o_errorCode = 12750		--NODE_CLIENT_ID_POOL_NOT_CONFIGURED
	GOTO errorexit
END
*/
-- check if nodes is not already configured
IF @opType = 1 AND EXISTS (SELECT 1 FROM DM2SearchServerCoreInfo (NOLOCK) JOIN  @nodeOperation ON clientId = t_clientId AND cloudType = 6)
BEGIN
	SET @o_errorStr = 'Client already part of other HAC Cluster'
	SET @o_errorCode = 12742		--NODE_CLIENT_ID_INVALID --new error code
	GOTO errorexit
END
errorexit:
return
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppValidateHACClusterNode')
	delete from GxQscripts where name = 'AppValidateHACClusterNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppValidateHACClusterNode')
	delete from GXDBVersions where aliasname = 'AppValidateHACClusterNode'
GO

insert into GXDBVersions values(2, 'AppValidateHACClusterNode',  '00010001000200040000', 'AppValidateHACClusterNode', '00010001000200040000')
GO

