

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppVSAReplicationsGetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppVSAReplicationsGetInfo						|
--	|		 Procedure to get VSA replication information				|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppVSAReplicationsGetInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppVSAReplicationsGetInfo <<<'
	drop procedure AppVSAReplicationsGetInfo
END
IF EXISTS (select * from GxQscripts where name='AppVSAReplicationsGetInfo')
	delete from GxQscripts where name = 'AppVSAReplicationsGetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVSAReplicationsGetInfo')
	delete from GXDBVersions where aliasname = 'AppVSAReplicationsGetInfo'
GO
print '... Creating Procedure: AppVSAReplicationsGetInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppVSAReplicationsGetInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE	@o_xmlString			XML
	DECLARE @pos				INT = 0
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	IF object_id('tempdb.dbo.#repIds') IS NOT null DROP TABLE #repIds
	CREATE TABLE #repIds
	(
		repId int
	)
	-- READ THE XML
	DECLARE @replicationId			INT = ISNULL (( SELECT ref.value('@replicationId', 'INT')
													FROM @i_xmlString.nodes ('App_GetVSAReplicationReq/siteInfo') R(ref)), 0)
	DECLARE @replicationGuid		NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@replicationGuid', 'NVARCHAR(MAX)')
													FROM @i_xmlString.nodes ('App_GetVSAReplicationReq/siteInfo') R(ref)), '')
	DECLARE @sourceGuid				NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@sourceGuid', 'NVARCHAR(MAX)')
													FROM @i_xmlString.nodes ('App_GetVSAReplicationReq/siteInfo') R(ref)), '')
	DECLARE @destinationGuid		NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@destinationGuid', 'NVARCHAR(MAX)')
													FROM @i_xmlString.nodes ('App_GetVSAReplicationReq/siteInfo') R(ref)), '')
	DECLARE @taskId					INT = ISNULL (( SELECT ref.value('@taskId', 'INT')
													FROM @i_xmlString.nodes ('App_GetVSAReplicationReq/siteInfo/subTask') R(ref)), 0)
	DECLARE @subclientId			INT = ISNULL (( SELECT ref.value('@subclientId', 'INT')
													FROM @i_xmlString.nodes ('App_GetVSAReplicationReq/siteInfo/entity') R(ref)), 0)
	DECLARE @backupSetId			INT = ISNULL (( SELECT ref.value('@backupsetId', 'INT')
													FROM @i_xmlString.nodes ('App_GetVSAReplicationReq/siteInfo/entity') R(ref)), 0)
	DECLARE @instanceId				INT = ISNULL (( SELECT ref.value('@instanceId', 'INT')
													FROM @i_xmlString.nodes ('App_GetVSAReplicationReq/siteInfo/entity') R(ref)), 0)
	DECLARE @clientId				INT = ISNULL (( SELECT ref.value('@clientId', 'INT')
													FROM @i_xmlString.nodes ('App_GetVSAReplicationReq/siteInfo/entity') R(ref)), 0)
	DECLARE @inPropertyLevel		INT	= ISNULL (( SELECT ref.value('@propertyLevel', 'INT')
													FROM @i_xmlString.nodes ('App_GetVSAReplicationReq') R(ref)), 30) -- ListPropertyLevels_AllProperties
	DECLARE @vAppId					INT = ISNULL (( SELECT ref.value('@vAppId', 'INT')
													FROM @i_xmlString.nodes ('App_GetVSAReplicationReq/vApp') R(ref)), 0)
	DECLARE @userId					INT = ISNULL (( SELECT ref.value('@userId', 'INT')
													FROM @i_xmlString.nodes ('App_GetVSAReplicationReq/user') R(ref)), 0)
	DECLARE @skipSelectStatement    INT = ISNULL((SELECT  ref.value('@value', 'int')
	            FROM    @i_xmlString.nodes('App_GetVSAReplicationReq/processinginstructioninfo/attributes') R ( ref ) WHERE ref.value('@name', 'NVARCHAR(1024)') = 'skipSelectStatment'), 0)
	DECLARE @localeId 				INT = ISNULL (( SELECT ref.value('@localeId', 'INT')
													FROM @i_xmlString.nodes ('App_GetVSAReplicationReq/processinginstructioninfo/locale') R(ref)), 0)
	INSERT INTO #repIds
	SELECT  ref.value('@val','int')
			FROM @i_xmlString.nodes ('App_GetVSAReplicationReq/replicationId') R(ref)
	IF object_id('tempdb.dbo.#App_Application') IS NOT null DROP TABLE #App_Application
	CREATE TABLE #App_Application
	(
		id					integer,		-- PRIMARY KEY FOR THIS TABLE
		clientId			integer,
		appTypeId			integer,
		instance	   	    	integer,
		backupSet			integer,
		subclientStatus     integer,
		origCCId			integer,		-- for CommCell Migration Path
		subclientName		nvarchar(256),
		PRIMARY KEY (id)
	)
	--Have temp table for applicable appids and use it for JOIN
	-- For VSA v2 clients, replace parent client/hierarchy with child client/hierarchy.
	IF (@clientId> 0 OR @instanceId > 0 OR @backupSetId > 0 OR @subclientId > 0)
	BEGIN
		-- first insert all child subclients for parent subclients
		INSERT INTO #App_Application(id,clientId,appTypeId,instance,backupset,subclientStatus,origCCId,subclientName)
		SELECT DISTINCT CHILD.Id, CHILD.ClientId, CHILD.appTypeId, CHILD.instance, CHILD.backupset, CHILD.subclientStatus, CHILD.origCcId, CHILD.subclientName
		FROM App_Application PARENT (NOLOCK) INNER JOIN App_ClientProp (NOLOCK) ON App_ClientProp.ComponentnameId = PARENT.clientId
		AND App_ClientProp.attrName='IndexingV2_VSA' AND App_ClientProp.modified=0 AND App_ClientProp.attrVal=N'1' --CV_PROP_VSA_INDEXING_V2
		INNER JOIN APP_VMBackupSet (NOLOCK) ON PARENT.backupSet = APP_VMBackupSet.ParentBackupSetId
		INNER JOIN App_Application CHILD (NOLOCK) ON CHILD.backupSet = APP_VMBackupSet.ChildBackupSetId
		AND (CHILD.subclientstatus & (4|2))=0   --- We dont want deleted and uninstalled subclients _CV_STATUS_DELETED| CV_STATUS_UNINSTALLED
		AND (PARENT.backupSet = @backupSetId OR @backupSetId = 0)
		AND (PARENT.instance = @instanceId OR @instanceId = 0)
		AND (PARENT.clientId = @clientId OR @clientId = 0)
		AND (PARENT.Id = @subclientId or @subclientId = 0 )
		-- For parent backupsetId, get child backupsetId
		IF @backupSetId>0
		BEGIN
			SELECT @backupSetId = backupset FROM #App_Application (NOLOCK)
		END
	END
	-- if you dont find any child subclients, then expand given entities.
	IF NOT EXISTS(SELECT 1 FROM #App_Application)
	BEGIN
		INSERT INTO #App_Application(id,clientId,appTypeId,instance,backupset,subclientStatus,origCCId,subclientName)
		SELECT APP.Id, App.ClientId, APP.appTypeId, App.instance, App.backupset, App.subclientStatus, APP.origCCId, APP.subclientName FROM
		APP_Application APP WITH (NOLOCK) WHERE (APP.id = @subclientId or @subclientId = 0)
			AND (APP.backupSet = @backupSetId OR @backupSetId = 0)
			AND (APP.instance = @instanceId OR @instanceId = 0)
			AND (APP.clientId = @clientId OR @clientId = 0)
	END
	IF object_id('tempdb.dbo.#vsaInfoTable') IS NOT null DROP TABLE #vsaInfoTable
	CREATE TABLE #vsaInfoTable (replicationId INT, ccId INT, clId INT, clientName NVARCHAR(MAX), apId INT, appTypeName NVARCHAR(MAX), instId INT, instanceName NVARCHAR(MAX), bsId INT, bacupsetName NVARCHAR(MAX), subclientName NVARCHAR(MAX), taskId INT, subTaskId INT, subTaskName NVARCHAR(MAX), lastSyncedBkpJob INT, VMSyncedTillTime INTEGER, BkpJobsToSync NVARCHAR(MAX), ValidationFailCount INT, FailoverStatus INT, sla int, lastbackuptime int, status int, lastRestoretime int, subclientId int, sourceGUID nvarchar(126), sourceClientId int, vmToolsInstalled int, vmLastReplicationJobId INT, vmLastReplicationJobStatus INT, vmLastReplicationJobFailureReason NVARCHAR(MAX), isFailbackAllowed int, parentSubclientId int, parentInstanceId int, parentClientId int, parentBackupSetId INT, isIndexingV2 INT, repGroupId INT, repGroupName NVARCHAR(510), lastSyncedBkpJobServEndDate INT, RPOSecs INT, created int)
--
	IF object_id('tempdb.dbo.#vsaAdditionalInfo') IS NOT null DROP TABLE #vsaAdditionalInfo
	CREATE TABLE #vsaAdditionalInfo  ( replicationId INT, sourceVendorType int, dClientId int, dClientName nvarchar(max),  dInstId int, dInstanceName nvarchar(max), copyPrecedenceApplicable int, copyPrecedence int, destProxyClientId int, destProxyClientName nvarchar(256), policyId int, copyId int, subclientId int)
	IF @inPropertyLevel in ( 30,20) -- ListPropertyLevels_AllProperties
	BEGIN
		INSERT #vsaInfoTable
		SELECT DISTINCT VR.replicationId, APP.origCCId, APP.clientId, ISNULL(NULLIF(CL.displayName, ''), CL.name), APP.appTypeId, IDA.displayName, APP.instance, INS.name, backupsetId, BS.name, APP.subclientName, T.taskId, ST.subTaskId, ST.subTaskName, VR.lastSyncedBkpJob, VR.VMSyncedTillTime, VR.BkpJobsToSync, VR.ValidationFailCount, VR.FailoverStatus,-1 , VR.lastbackuptime, VR.status, VR.spare1, VR.subclientId, VR.sourceGuid, NULL, 0, 0, 0, '', 1,0,0,0,0,0,ISNULL(REP.id,0), ISNULL(REP.name,''), VR.VMSyncedTillTime, 24*3600, VR.created
		FROM APP_VSAReplication VR WITH (NOLOCK)
		INNER JOIN  TM_Task T WITH (NOLOCK) ON T.taskId = VR.taskId
			AND
			(
				T.taskId = @taskId OR @taskId = 0
			)
		LEFT OUTER JOIN TM_SubTask ST WITH (NOLOCK) ON ST.taskId = T.taskId
		JOIN #App_Application APP ON VR.subclientId = APP.Id -- Subclients are already expanded above
		JOIN APP_BackupSetName BS WITH (NOLOCK) ON BS.id = APP.backupSet
		JOIN APP_InstanceName INS WITH (NOLOCK) ON INS.id = APP.instance
		JOIN APP_iDAType IDA WITH (NOLOCK) ON IDA.type = APP.appTypeId
		JOIN APP_Client CL WITH (NOLOCK) ON CL.id = APP.clientId
		LEFT JOIN App_ReplicationGroupAssociation REPASSOC on T.taskId = REPASSOC.taskId
		LEFT JOIN App_ReplicationGroup REP on REP.id = REPASSOC.componentNameId
		WHERE
		(
			VR.replicationId = @replicationId OR @replicationId = 0
		)
		AND
		(
			VR.replicationGuid = @replicationGuid OR @replicationGuid = ''
		)
		AND
		(
			(
				VR.destinationGuid = @destinationGuid AND VR.sourceGuid = @sourceGuid
			)
			OR
			(
				VR.sourceGuid = @sourceGuid AND @destinationGuid = ''
			)
			OR
			(
				@destinationGuid = '' AND @sourceGuid = ''
			)
		)
		AND VR.flags != 1
        UPDATE LS
        set sourceClientId = prop.componentNameId
        FROM #vsaInfoTable LS
        inner join app_clientprop prop WITH (NOLOCK)
        on prop.attrName ='Virtual Machine Instance UUID'
        and prop.modified =0
        and prop.attrVal = LS.sourceGUID
		--TR: 200213-170  some VMs are getting replicated with BIOS GUID, so checking with VM instance UUID doesn't work, we are fetching VMCientID from the Backed up VM GUID of lastSynBackup
		UPDATE LS
        set sourceClientId = vmprop.VMclientId
        FROM #vsaInfoTable LS
        inner join app_vmprop vmprop WITH (NOLOCK)
        on vmprop.attrName ='vmGUID'
        and vmprop.attrVal = LS.sourceGUID
		and vmprop.jobId = LS.lastSyncedBkpJob
		and LS.sourceClientId is null
		update LS
		set sourceClientId = replprop.propertyValue
		FROM #vsaInfoTable LS
		inner join APP_VSAReplicationProp replprop WITH(NOLOCK)
		on LS.replicationId = replprop.replicationId
		and replprop.propertyTypeId = 2221 and replprop.modified =0
        UPDATE VSAOuter
        SET parentSubclientId = JMJobDataLink.parentAppid
        FROM #vsaInfoTable VSAOuter
		INNER JOIN
		(
			SELECT VSA.subclientId, MAX(JMJobDataLink.ParentJobId) AS parentJobId
			FROM #vsaInfoTable VSA INNER JOIN JMJobDataLink (NOLOCK) ON VSA.subclientId  = JMJobDataLink.childAppid
			AND linkType = 7 -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD
			INNER JOIN App_Application (NOLOCK) ON JMJobDataLink.parentAppid = App_Application.id
			AND (App_Application.subclientStatus & 6) = 0	-- subclient shldnt be deleted.
			GROUP BY VSA.subclientId
		) ParentJobs
		ON ParentJobs.subclientId = VSAOuter.subclientId
		INNER JOIN JMJobDataLink (NOLOCK) ON VSAOuter.subclientId  = JMJobDataLink.childAppid
			AND linkType = 7 -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD
			AND JMJobDataLink.parentJobID = ParentJobs.ParentJobId
		UPDATE VSA
		SET isIndexingV2 = 1
		FROM #vsaInfoTable VSA
		INNER JOIN APP_ClientProp A
		ON VSA.clId = A.componentNameId
		AND A.attrName='Indexingv2_vsa'
		AND A.attrVal='1'
		AND A.modified = 0
		update #vsaInfoTable
		set parentsubclientid = subclientid
		where isIndexingV2 =0
		update VSA
		set parentInstanceId = A.instance,
		    parentClientId = A.clientId,
		    parentBackupSetId = A.backupSet
		from #vsaInfoTable VSA
		inner join app_application A
		on VSA.parentSubclientId = A.id
	  IF ( @userId >0 )
	  BEGIN
		DECLARE @isUserAdmin int =0
		IF OBJECT_ID('tempdb.dbo.#idaListTemp') IS NOT NULL DROP TABLE #idaListTemp
		CREATE TABLE #idaListTemp
		(
			t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
		)
		EXECUTE sec_isUserAdmin   @i_userid = @userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
		IF ( @isUserAdmin !=1 )
		BEGIN
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#idaListTemp'
			-- insert all replicated vms from the vcenter if vcenter level access is given
			insert into #idaListTemp
			select vsa.sourceClientId,0,0,0,0
			from #vsaInfoTable vsa
			inner join #idaListTemp ida
			on vsa.clId = ida.t_clientId
			DELETE LS
            		FROM #vsaInfoTable LS
       		LEFT OUTER JOIN #idaListTemp ida
         	on LS.sourceClientId = ida.t_clientId
            where ida.t_clientId is NULL
		END
	  END
	  update VSA
	  set vmToolsinstalled =1
	  from #vsaInfoTAble VSA
	  inner join App_Clientprop vmprop
	  on VSA.sourceClientId = vmprop.componentNameid
	  and vmprop.attrname = 'Virtual Machine Tools Version'
	  and vmprop.modified = 0
	  and vmprop.attrval  not in ('Not installed','')
	  -- update the latest VM replication job and then VM completion status
	  UPDATE VSA
	  SET vmLastReplicationJobId = PROP.propertyValue
	  FROM #vsaInfoTable VSA
	  INNER JOIN APP_VSAReplicationProp PROP WITH (NOLOCK)
	  ON VSA.replicationId = PROP.replicationId
AND propertyTypeId = 2215
	  WHERE PROP.modified=0
	  update VSA
	  set vmLastReplicationJobStatus = CAST(ISNULL(vmprop.attrval, '0') AS INT)
	  from #vsaInfoTAble VSA
	  left outer join APP_VMPROP vmprop WITH (NOLOCK)
	  on VSA.sourceClientId = vmprop.vmclientId
	  and vmprop.jobid = vsa.vmLastReplicationJobId -- last replication job id
	  and vmprop.attrname = 'vmStatus'
	  and vsa.vmLastReplicationJobId > 0
	  update VSA
	  set vmLastReplicationJobFailureReason = vmprop.attrval
	  from #vsaInfoTAble VSA
	  left outer join APP_VMPROP vmprop WITH (NOLOCK)
	  on VSA.sourceClientId = vmprop.vmclientId
	  and vmprop.jobid = vsa.vmLastReplicationJobId -- last replication job id
	  and vmprop.attrname = 'vmFailureReason'
	  and vsa.vmLastReplicationJobId > 0
	  update VSA
	  set isFailbackAllowed =0
	  from #vsaInfoTAble VSA
	  inner join APP_SubClientProp scProp1
	  on VSA.subclientId = scProp1.componentNameId
	  and scProp1.attrName = 'Enable Snap Backups'
	  and scProp1.attrVal  ='1'
	  inner join APP_SubClientProp scProp2
	  on VSA.subclientId = scProp2.componentNameId
	  and scProp2.attrName = 'Snap Engine'
	  and scProp2.attrVal  != '58'
      IF  (@vAppid > 0)
      BEGIN
			IF object_id('tempdb.dbo.#vappTable') is not null
			DROP TABLE #vappTable
			CREATE TABLE #vappTable (
						  replicationId int
						)
            insert #vappTable
            select V.value('@replicationId', 'int')
            from app_virtualapp
			cross apply vxml.nodes('/Api_VirtualAppReq/vApp/config/vmGroups/vmSequence') A(V)
            where id = @vAppId
            DELETE LS
            FROM #vsaInfoTable LS
            LEFT OUTER JOIN #vappTable V
            on LS.replicationId = V.replicationId
            where V.replicationId is NULL
       END
	   -- UPDATE lastSyncedBkpJobServEndDate
		UPDATE vsa
		set lastSyncedBkpJobServEndDate = job.servEndDate, VMSyncedTillTime = job.servEndDate
	    FROM #vsaInfoTable vsa
		JOIN JMBkpStats job ON job.commCellId = 2 AND vsa.lastSyncedBkpJob = job.jobId
	   -- SLA -> 0 -> Missed SLA, 2 -> Met SLA, 3 -> Not applicable
		UPDATE vsa
		set RPOSecs = CAST(PP.attrVal as INT) * 60
	    FROM #vsaInfoTable vsa inner join APP_SubClientProp SP on vsa.parentSubclientId = SP.componentNameId
		inner join App_PlanProp PP on Sp.attrVal = PP.componentNameId
		and SP.attrName = 'Associated plan'
		and SP.modified = 0
and PP.attrName = 'RPO In Minutes'
		and PP.modified = 0
		UPDATE vsa
	    set sla = case when datediff(minute, dbo.getdatetime(vsa.lastSyncedBkpJobServEndDate), getutcdate()) <= ISNULL(RPOSecs/60,240) then 2
		       	  else 0
		     	 end
	    FROM #vsaInfoTable vsa
		where lastSyncedBkpJobServEndDate >0 and lastSyncedBkpJobServEndDate != @nowTime
		-- if newly created and rpo is not yet met, and rpo behind time is still valid, then set valid
		-- if sync status is sync disabled, then set sla "Not applicable"
	   update #vsaInfoTable
	   set sla = case when datediff(minute, dbo.getdatetime(created), getutcdate()) <= RPOSecs/60 then 3
					  when status = 6 then 3  -- VSAREP_DISABLED
					  else 0
			     end
	   where sla = -1
	   IF EXISTS ( select top 1 repId from #repIds )
	   BEGIN
			DELETE vsa
			FROM #vsaInfoTable vsa
			LEFT JOIN #repIds r
			on vsa.replicationId = r.repId
			WHERE r.repId is NULL
	   END
	-- FORM THE XML RESPONSE
		IF @inPropertyLevel = 20
		BEGIN
			INSERT INTO #vsaAdditionalInfo ( replicationId , sourceVendorType, subclientId)
			SELECT replicationId,
				   case when I.attrval in ('101') then 1
				        when I.attrval in ('102') then 2
						when I.attrval in ('301') then 4
						when I.attrval in ('401') then 5
						when I.attrval in ('402') then 7
						when I.attrval in ('1301') then 16
						when I.attrval in ('403') then 17
				   end,
				   vsa.parentSubclientId
 			FROM #vsaInfoTable vsa
			INNER JOIN APP_InstanceProp I
			ON vsa.parentInstanceId = I.componentNameId
			AND I.attrName = 'Virtual Server Instance Type'
			AND I.modified =0
			UPDATE VSA
			SET  dClientId = T.clientId,
			     dClientName = T.clientName,
				 dInstId = T.instanceId,
				 dInstanceName = T.instanceName,
				 copyPrecedenceApplicable = T.copyPrecedenceApplicable,
				 copyPrecedence = T.copyPrecedence,
				 destProxyClientId = T.destProxyClientId,
				 destProxyClientName = T.destProxyClientName,
				 policyId = T.policyId,
				 copyId = T.copyId
			FROM #vsaAdditionalInfo VSA
			INNER JOIN(
					SELECT vsa.replicationId,
							st.xmlValue.value('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/vCenterInstance/@clientId)[1]', 'int') as clientId,
							st.xmlValue.value('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/vCenterInstance/@clientName)[1]','NVARCHAR(MAX)') as clientName,
							st.xmlValue.value('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/vCenterInstance/@instanceId)[1]', 'int') as instanceId,
							st.xmlValue.value('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/vCenterInstance/@instanceName)[1]','NVARCHAR(MAX)') as instanceName,
						    st.xmlValue.value('(/TMMsg_JobOption/restoreOptions/browseOption/mediaOption/copyPrecedence/@copyPrecedenceApplicable)[1]' ,'int') as copyPrecedenceApplicable ,
						     ISNULL(st.xmlValue.value('(TMMsg_JobOption/restoreOptions/browseOption/mediaOption/copyPrecedence/@copyPrecedence)[1]' ,'int'),0) as copyPrecedence,
							st.xmlValue.value('(/TMMsg_JobOption/restoreOptions/destination/destClient/@clientId)[1]', 'int') as destProxyClientId,
							st.xmlValue.value('(/TMMsg_JobOption/restoreOptions/destination/destClient/@clientName)[1]', 'nvarchar(256)') as destProxyClientName,
							isnull(st.xmlValue.value('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/allocationPolicy/@vmAllocPolicyId)[1]','int'),0) as policyId,
							isnull(st.xmlValue.value('(/TMMsg_JobOption/restoreOptions/storagePolicy/@copyId)[1]','int'),0) as copyId
					FROM TM_SubTaskXMLOptions st
					INNER JOIN #vsaInfoTable vsa
					on st.subTaskId = vsa.subTaskId
				 ) T
			ON T.replicationId = vsa.replicationId
			update VSA
			set dClientId = c.id,
				dClientName = ISNULL(NULLIF(C.displayName, ''), C.name),
				dInstId = I.id,
				dInstanceName = I.name
			from #vsaAdditionalInfo VSA
			inner join App_VmAllocationPolicyprop prop
			on prop.componentNameId = VSA.policyId
			inner join app_client c
			on  attrName ='destinationHyperV' and prop.modified=0
			and c.id = prop.attrVal
			inner join app_application A
			on A.clientId  = c.id
and A.appTypeId = 106
			inner join APP_InstanceName I
			on I.id = A.instance
			and VSA.policyId >0
			update VSA
			set copyPrecedenceApplicable = case when copy =1 then 0 else 1 end,
				copyPrecedence = case when copy =1 then 0 else copy end
			FROM #vsaAdditionalInfo VSA
			INNER JOIN archGroupCopy CP
			on VSA.copyId = CP.id
			and VSA.copyId >0
			-- in some cases, live sync schedule is created with default copy and copy precdence is also set
			-- we are resetting the value in such case
			update VSA
			set  copyPrecedenceApplicable = case when G.defaultcopy = CP.id then 0 else 1 end ,
				 copyPrecedence = case when G.defaultcopy = CP.id then 0 else VSA.copyPrecedence end
			from #vsaAdditionalInfo VSA
			inner join app_application A
			on VSA.subclientId = A.id
			inner join archgroup G
			on A.dataarchgrpid = G.id
			inner join archGroupCopy CP
			on VSA.copyPrecedence = CP.copy
			and VSA.copyPrecedenceApplicable =1
			and G.id = CP.archGroupId
			and not exists ( select prop.componentnameid from app_subclientprop prop where prop.attrname ='Enable Snap Backups' and prop.componentnameid = A.id and prop.modified=0 and attrval='1')
			update VSA
			set destProxyClientId = c.id,
				destProxyClientName = ISNULL(NULLIF(C.displayName, ''), C.name)
			from #vsaAdditionalInfo VSA
			inner join App_VmAllocationPolicyprop prop
			on prop.componentNameId = VSA.policyId
			inner join app_client c
			on  attrName ='ProxyClientEntity' and prop.modified=0
			and c.id = prop.attrVal
			and VSA.policyId >0
		END
		UPDATE VSA
		SET Status = 0
		FROM #vsaInfoTable VSA
		LEFT JOIN APP_VSAReplicationProp
		ON VSA.replicationId = APP_VSAReplicationProp.replicationId
AND propertyTypeId = 2208
		WHERE VSA.status=1 AND VSA.lastRestoreTime=0
		AND (APP_VSAReplicationProp.propertyValue IS NULL  OR APP_VSAReplicationProp.propertyValue='0')
		-- store replication properties in prop table
		IF object_id('tempdb.dbo.#livesync_PropTable') is not null
			drop table #livesync_PropTable
		CREATE TABLE #livesync_PropTable(repId INT, propertyTypeId INT, propertyValue nvarchar(max))
		-- insert all the replication properties in temp table from app_vsareplicationprop table
		INSERT INTO #livesync_PropTable(repId, propertyTypeId, propertyValue)
		SELECT prop.replicationId, prop.propertyTypeId, prop.propertyValue FROM APP_VSAReplicationProp (NOLOCK) prop
		INNER JOIN #vsaInfoTable info ON info.replicationId = prop.replicationId
		-- store associated backup/restore/auxcopy job info in associatedJobsInfo table
		IF object_id('tempdb.dbo.#associatedJobsInfoTable') is not null
			drop table #associatedJobsInfoTable
		CREATE TABLE #associatedJobsInfoTable(replicationId INT, appId INT, jobType INT, jobId INT, runningJobState INT, completedJobStatus INT, errorCode INT, failureReason NVARCHAR(MAX))
		CREATE CLUSTERED INDEX associatedJobsInfoTable_replicationId_appId_jobType_Index ON #associatedJobsInfoTable ([replicationId], [appId], [jobType])
		DECLARE @jobTypeBackup INT = 4, @jobTypeRestore INT = 5, @jobTypeSnapBackup INT = 59, @jobTypeSnapBackupSiteReplication INT = 105, @jobTypeAuxCopy INT = 13, @jobTypeAuxCopy2 INT = 104
		-- FOR V2, QUERY JMBkpJobInfo TO GET THE CURRENT RUNNING BACKUP JOB INFO, INSERT JOB INFO INTO #associatedJobsInfoTable
		INSERT INTO #associatedJobsInfoTable
		(replicationId, appId, jobType, jobId, runningJobState, failureReason)
		SELECT jmbkji.replicationId, jmbkji.applicationId, ji.opType, jmbkji.jobId, ji.state, ji.failureReason
		FROM
		(
		   SELECT vsa.replicationId, bkji.jobId, bkji.applicationId,
				 ROW_NUMBER() OVER (PARTITION BY applicationId ORDER BY jobId DESC ) AS rowNumber
		   FROM JMBkpJobInfo bkji
		   JOIN #vsaInfoTable vsa ON vsa.isIndexingV2 = 1 AND bkji.applicationId = vsa.subclientId
		) jmbkji
		JOIN JMJobInfo ji ON jmbkji.rowNumber = 1 AND jmbkji.jobId = ji.jobId
		-- FOR V2, QUERY JMBkpStats TO GET THE LATEST COMPLETED BACKUP JOB INFO, INSERT JOB INFO INTO #associatedJobsInfoTable
		INSERT INTO #associatedJobsInfoTable
		(replicationId, appId, jobType, jobId, completedJobStatus, errorCode, failureReason)
		SELECT jmbkps.replicationId, jmbkps.appId, jmbkps.opType, jmbkps.jobId, jmbkps.status, jmbkps.failureErrorCode, jmbkps.failureReason
		FROM
		(
		   SELECT vsa.replicationId, bks.jobId, bks.appId, bks.opType, bks.status, bks.failureReason, bks.failureErrorCode,
				 ROW_NUMBER() OVER (PARTITION BY bks.appId ORDER BY servStartDate DESC ) AS rowNumber
		   FROM JMBkpStats bks
		   JOIN #vsaInfoTable vsa ON vsa.isIndexingV2 = 1 AND bks.opType IN (@jobTypeBackup, @jobTypeSnapBackup) AND bks.appId = vsa.subclientId
		   LEFT JOIN #associatedJobsInfoTable ajit ON vsa.replicationId = ajit.replicationId
		   WHERE ajit.jobId IS NULL
		) jmbkps
		WHERE jmbkps.rowNumber = 1
		-- FOR V1, QUERY JMBkpJobInfo TO GET THE CURRENT RUNNING BACKUP JOB INFO, INSERT JOB INFO INTO #associatedJobsInfoTable
		INSERT INTO #associatedJobsInfoTable
		(replicationId, appId, jobType, jobId, runningJobState, failureReason)
		SELECT jmbkji.replicationId, jmbkji.applicationId, ji.opType, jmbkji.jobId, ji.state, ji.failureReason
		FROM
		(
		   SELECT vsa.replicationId, vsa.sourceGuid, bkji.jobId, bkji.applicationId,
				 ROW_NUMBER() OVER (PARTITION BY applicationId ORDER BY bkji.jobId DESC ) AS rowNumber
		   FROM JMBkpJobInfo bkji
		   JOIN #vsaInfoTable vsa ON vsa.isIndexingV2 = 0 AND bkji.applicationId = vsa.subclientId
		   JOIN APP_VMProp vm ON vm.attrName = 'vmGUID' AND vm.attrVal = vsa.sourceGUID AND vm.jobId = bkji.jobId
		) jmbkji
		JOIN JMJobInfo ji ON jmbkji.rowNumber = 1 AND jmbkji.jobId = ji.jobId
		-- FOR V1, QUERY JMBkpStats TO GET THE LATEST COMPLETED BACKUP JOB INFO, INSERT JOB INFO INTO #associatedJobsInfoTable
		INSERT INTO #associatedJobsInfoTable
		(replicationId, appId, jobType, jobId, completedJobStatus, errorCode, failureReason)
		SELECT jmbkps.replicationId, jmbkps.appId, jmbkps.opType, jmbkps.jobId, jmbkps.status, jmbkps.failureErrorCode, jmbkps.failureReason
		FROM
		(
		   SELECT vsa.replicationId, vsa.sourceGuid, bks.jobId, bks.appId, bks.opType, bks.status, bks.failureReason, bks.failureErrorCode,
				 ROW_NUMBER() OVER (PARTITION BY bks.appId ORDER BY servStartDate DESC ) AS rowNumber
		   FROM JMBkpStats bks
		   JOIN #vsaInfoTable vsa ON vsa.isIndexingV2 = 0 AND bks.opType IN (@jobTypeBackup, @jobTypeSnapBackup) AND bks.appId = vsa.subclientId
		   JOIN APP_VMProp vm ON vm.attrName = 'vmGUID' AND vm.attrVal = vsa.sourceGUID AND vm.jobId = bks.jobId
		   LEFT JOIN #associatedJobsInfoTable ajit ON ajit.replicationId = vsa.replicationId
		   WHERE ajit.jobId IS NULL
		) jmbkps
		WHERE jmbkps.rowNumber = 1
		-- GET LATEST COMPLETED AND CURRENT RUNNING RESTORE JOBS INFO FROM JMRestoreStats, INSERT INTO #associatedJobsInfoTable
		INSERT INTO #associatedJobsInfoTable
		(replicationId, appId, jobType, jobId, runningJobState, completedJobStatus, errorCode, failureReason)
		(
			SELECT vsa.replicationId, vsa.subclientId, jmrs.opType, jmrs.jobId, null, jmrs.status, jmrs.failureErrorCode, jmrs.failureReason
			FROM #vsaInfoTable vsa
JOIN #livesync_PropTable live ON live.propertyTypeId = 2215 AND vsa.replicationId = live.repId
			JOIN JMRestoreStats jmrs ON CAST(live.propertyValue AS INT) = jmrs.jobId
		)
		UNION
		(
			SELECT vsa.replicationId, vsa.subclientId, ji.opType, ji.jobId, ji.state, null, null, ji.failureReason
			FROM #vsaInfoTable vsa
JOIN #livesync_PropTable live ON live.propertyTypeId = 2215 AND vsa.replicationId = live.repId
			JOIN JMRstJobInfo jmrji ON CAST(live.propertyValue AS INT) = jmrji.jobId
			JOIN JMJobInfo ji ON jmrji.jobId = ji.jobId
		)
		-- CREATE #auxCopyJobsInfo TABLE TO SAVE AUX COPY JOBS INFO
		IF object_id('tempdb.dbo.#auxCopyJobsInfo') is not null
			drop table #auxCopyJobsInfo
		CREATE TABLE #auxCopyJobsInfo (replicationId INT, subClientId INT, lastCopiedBackupJobId INT, backupJobEndTime INT, existJobsNotCopied INT)
		INSERT INTO #auxCopyJobsInfo
		SELECT DISTINCT vsa.replicationId, vsa.subclientId, CAST(prop.propertyValue AS INT) lastCopiedBackupJobId, bkp.servEndDate, 0
		FROM #vsaInfoTable vsa
		JOIN #vsaAdditionalInfo vsaadd ON vsaadd.copyPrecedenceApplicable = 1 AND vsa.replicationId = vsaadd.replicationId
JOIN APP_VSAReplicationProp prop ON prop.propertyTypeId = 2223 AND prop.replicationId = vsa.replicationId
		JOIN JMBkpStats bkp ON CAST(prop.propertyValue AS INT) = bkp.jobId
		-- FOR EACH SUBCLIENT, CHECK IF THERE ARE MORE BACKUP JOBS THAT HAVE NOT BEEN AUX COPIED SINCE THE LAST AUX COPY, AND UPDATE FIELD existJobsNotCopied IN #auxCopyJobsInfo
		UPDATE #auxCopyJobsInfo
		SET existJobsNotCopied = 1
		FROM #auxCopyJobsInfo a
		JOIN
		(
			SELECT MAX(bkstats.servEndDate) lastBackupTime, subClientId
			FROM #auxCopyJobsInfo aux
			JOIN JMBkpStats bkstats ON aux.subClientId = bkstats.appId
			WHERE bkstats.status in (1,3,14)
			GROUP BY aux.subClientId
		) s ON a.subClientId = s.subClientId
		WHERE backupJobEndTime < lastBackupTime
		-- FOR SUBCLIENTS THAT HAVE UN-AUX COPIED JOBS, CHECK IF THERE ARE RUNNING AUX COPY JOBS, AND INSERT THE JOB STATUS INTO #associatedJobsInfoTable
		INSERT INTO #associatedJobsInfoTable
		(replicationId, appId, jobType, jobId, runningJobState, completedJobStatus, errorCode, failureReason)
		SELECT DISTINCT aux.replicationId, aux.subClientId, running.opType, running.jobId, jinfo.state, null, null, jinfo.failureReason
		FROM #vsaInfoTable vsa
		JOIN #vsaAdditionalInfo vsaadd ON vsaadd.copyPrecedenceApplicable = 1 AND vsa.replicationId = vsaadd.replicationId
		JOIN #auxCopyJobsInfo aux ON aux.existJobsNotCopied = 1 AND vsa.replicationId = aux.replicationId
		JOIN JMJobDataStats stats on aux.lastCopiedBackupJobId = stats.jobId AND vsa.subclientId = stats.appId
		JOIN archGroupCopy agcopy on stats.archGrpId = agcopy.archGroupId and stats.archGrpCopyId = agcopy.id and vsaadd.copyPrecedence = agcopy.copy
		JOIN JMAdminJobInfoTable running ON running.opType in (@jobTypeAuxCopy, @jobTypeAuxCopy2) AND agcopy.archGroupId = running.archGrpID AND agcopy.id = running.archGrpCopyID
		JOIN JMJobInfo jinfo ON running.jobId = jinfo.jobId
		-- FOR SUBCLIENTS THAT ALL JOBS HAVE BEEN COPIED IN LAST AUX JOB, INSERT LAST AUX COPY JOP STATUS INTO #associatedJobsInfoTable
		INSERT INTO #associatedJobsInfoTable
		(replicationId, appId, jobType, jobId, runningJobState, completedJobStatus, errorCode, failureReason)
		SELECT a.replicationId, a.subClientId, a.opType, a.jobId, null, a.status, a.failureErrorCode, a.failureReason
		FROM
		(
			SELECT aux.replicationId, aux.subClientId, done.opType, done.jobId, done.status, done.failureErrorCode, done.failureReason,
				ROW_NUMBER() OVER (PARTITION BY vsa.replicationId ORDER BY done.servEnd DESC ) AS rowNumber
			FROM #vsaInfoTable vsa
			JOIN #vsaAdditionalInfo vsaadd ON vsaadd.copyPrecedenceApplicable = 1 AND vsa.replicationId = vsaadd.replicationId
			JOIN #auxCopyJobsInfo aux ON aux.existJobsNotCopied = 0 AND vsa.replicationId = aux.replicationId
			JOIN JMJobDataStats stats on aux.lastCopiedBackupJobId = stats.jobId AND vsa.subclientId = stats.appId
			JOIN archGroupCopy agcopy on stats.archGrpId = agcopy.archGroupId and stats.archGrpCopyId = agcopy.id and vsaadd.copyPrecedence = agcopy.copy
			JOIN JMAdminJobStatsTable done ON done.opType in (@jobTypeAuxCopy, @jobTypeAuxCopy2) AND agcopy.archGroupId = done.archGrpID AND agcopy.id = done.archGrpCopyID
		) a
		WHERE a.rowNumber = 1
		-- FOR SUBCLIENTS THAT HAVE UN-AUX COPIED JOBS, BUT NO RUNNING AUX JOBS AT THIS POINT, THEN INSERT AUX COPY JOB PENDING STATUS INTO #associatedJobsInfoTable
		INSERT INTO #associatedJobsInfoTable
		(replicationId, appId, jobType, jobId, runningJobState, completedJobStatus, errorCode, failureReason)
		SELECT aux.replicationId, aux.subClientId, @jobTypeAuxCopy2, null, null, null, null, 'Scheduled to run'
		FROM
		( SELECT * FROM #auxCopyJobsInfo aux WHERE aux.existJobsNotCopied = 1 ) aux
		LEFT JOIN #associatedJobsInfoTable asso ON asso.appId = aux.subClientId AND asso.jobType in (@jobTypeAuxCopy, @jobTypeAuxCopy2)
		WHERE jobId IS NULL
		SET @o_xmlString =
				(
					SELECT VR.replicationId '@replicationId', VR.replicationGuid '@replicationGuid', VR.sourceGuid '@sourceGuid', VR.sourceName '@sourceName', VR.spare1 '@spare1', VR.spare2 '@spare2', VR.spare3 '@spare3',
						VR.destinationGuid '@destinationGuid', VR.destinationName '@destinationName', VR.lastRestoreTime '@lastRestoreTime',
						VR.lastBackupTime '@lastBackupTime',
						ISNULL(vsADD.sourceVendorType, 0) '@SourceVendorType',
						ISNULL(vsAdd.copyPrecedenceApplicable, 0) '@copyPrecedenceApplicable',
						ISNULL(vsAdd.copyPrecedence,0) '@copyPrecedence',
						sla '@SLAStatus',
						isFailbackAllowed as '@isFailbackAllowed',
						isindexingv2 AS '@isIndexingV2', VSA.RPOSecs as '@RPOSecs', (CASE WHEN VSA.lastSyncedBkpJobServEndDate = 0 THEN 0 ELSE @nowTime - VSA.lastSyncedBkpJobServEndDate END) as '@RPOBehindSecs',
					(	SELECT CP.propertyValue
						FROM #livesync_PropTable CP WITH (NOLOCK)
						WHERE CP.repId = VR.replicationId
AND CP.propertyTypeId = 2203
					) '@DRVendorType',
					vmToolsinstalled '@vmToolsinstalled',
                    vmLastReplicationJobStatus '@vmLastReplicationJobStatus',
					vmLastReplicationJobFailureReason '@vmLastReplicationJobFailureReason',
					-- MR 213646 Sync status set to "In Sync" though the source is not replicated.
					VR.powerOn '@powerOn', VSA.status '@status', VR.flags '@flags', VR.options '@options', VR.lastSyncedBkpJob '@lastSyncedBkpJob', VSA.VMSyncedTillTime '@VMSyncedTillTime', VR.BkpJobsToSync '@BkpJobsToSync', VR.ValidationFailCount '@ValidationFailCount', VR.FailoverStatus '@FailoverStatus', backupsetId 'entity/@backupsetId', VR.subclientId 'entity/@subclientId', ccId 'entity/@commCellId',
					VSA.bacupsetName 'entity/@backupsetName', VSA.subclientName 'entity/@subclientName', VSA.instId 'entity/@instanceId', VSA.instanceName 'entity/@instanceName', VSA.apId 'entity/@applicationId', VSA.appTypeName 'entity/@appName',
					VSA.clId 'entity/@clientId', VSA.clientName 'entity/@clientName', VSA.taskId 'subTask/@taskId', VSA.subTaskId 'subTask/@subtaskId', VSA.subTaskName 'subTask/@subtaskName',
					vsADD.destProxyClientId 'destProxy/@clientId',
					vsADD.destProxyClientName 'destProxy/@clientName',
					VSA.parentSubclientId as 'parentSubclient/@subclientId', VSA.parentInstanceId as 'parentSubclient/@instanceId', VSA.parentClientId as 'parentSubclient/@clientId',
					-- Return parent VSA display name if parent is there. If display name isnt there then use client name. If parent entity isnt there then use VSA.clientName
					(SELECT ISNULL((SELECT ISNULL(NULLIF(CL.displayName, ''), CL.name) FROM App_Client CL WHERE ID = VSA.parentClientId), VSA.clientName))  'parentSubclient/@clientName',
					(	SELECT CAST(CP.propertyValue AS XML)
						FROM #livesync_PropTable CP WITH (NOLOCK)
						WHERE CP.repId = VR.replicationId
AND CP.propertyTypeId = 2201
						FOR XML PATH(''), TYPE
					),
					(	SELECT CAST(CP.propertyValue AS XML)
						FROM #livesync_PropTable CP WITH (NOLOCK)
						WHERE CP.repId = VR.replicationId
AND CP.propertyTypeId = 2202
						FOR XML PATH(''), TYPE
					),
					(	SELECT CP.propertyValue '@propertyValue', CP.propertyTypeId '@propertyId'
						FROM #livesync_PropTable CP WITH (NOLOCK)
						WHERE CP.repId = VR.replicationId
AND CP.propertyTypeId NOT IN  (2202, 2201, 2203)
						FOR XML PATH('VMReplInfoProperties'), TYPE
					),
					(
							SELECT vsADD.dClientId as '@clientId', vsADD.dClientName as '@clientName', vsAdd.dInstanceName as '@instanceName', vsAdd.dInstId as '@instanceId'
							FOR XML PATH('destinationInstance'), TYPE
					),
					(
							SELECT ISNULL(xmlValue.value('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/allocationPolicy/@vmAllocPolicyId)[1]','int') ,0) as '@vmAllocPolicyId',
								   ISNULL(xmlValue.value('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/allocationPolicy/@vmAllocPolicyName)[1]','nvarchar(1024)') ,0) as '@vmAllocPolicyName'
							FROM TM_SubTaskXMLOptions st
							WHERE st.subTaskId = VSA.subTaskId
							FOR XML PATH('replicationTarget'), TYPE
					),
					(
							SELECT VSA.repGroupId AS '@replicationGroupId', VSA.repGroupName AS '@replicationGroupName'
								FOR XML PATH('replicationGroup'), TYPE
					),
					(
						SELECT jobType as '@jobType', jobId as '@jobId', runningJobState as '@runningJobState', completedJobStatus as '@completedJobStatus', errorCode as '@errorCode', dbo.JMGetLocalizedMessageFunc(@localeId, failureReason) as '@failureReason'
						FROM #associatedJobsInfoTable ajit
						WHERE ajit.replicationId = VR.replicationId
						FOR XML PATH('associatedJobs'), TYPE
					)
					FROM APP_VSAReplication VR WITH (NOLOCK)
					JOIN #vsaInfoTable VSA ON VSA.replicationId = VR.replicationId
						LEFT JOIN #vsaAdditionalInfo vsADD on vsADD.replicationId = VSA.replicationId
					FOR XML PATH('siteInfo'),
					ROOT('App_GetVSAReplicationResp')
				)
	END
	ELSE IF @inPropertyLevel = 10 -- ListPropertyLevels_ListOnly
	BEGIN
		SET @o_xmlString =
				(
					SELECT vs.value('@replicationGuid', 'NVARCHAR(MAX)') '@replicationGuid', ad.value('@guid', 'NVARCHAR(MAX)') '@sourceGuid', VS.destinationGuid '@destinationGuid',
					ad.value('@name', 'NVARCHAR(MAX)') '@sourceName', ad.value('@newName', 'NVARCHAR(MAX)') '@destinationName', vs.lastSyncedBkpJob '@lastSyncedBkpJob', vs.VMSyncedTillTime '@VMSyncedTillTime', vs.BkpJobsToSync '@BkpJobsToSync', vs.ValidationFailCount '@ValidationFailCount', vs.FailoverStatus '@FailoverStatus', ST.taskId 'subTask/@taskId',
					ST.subTaskId 'subTask/@subtaskId', ST.subTaskName 'subTask/@subtaskName'
					FROM TM_SubTaskXMLOptions SO
					JOIN TM_SubTask ST (NOLOCK) ON ST.subTaskId = SO.subTaskId
					-- JOIN TM_AssocEntity AE (NOLOCK) ON AE.taskId = ST.taskId AND AE.backupsetId = @backupSetId Removing join since it isnt needed.
					CROSS APPLY SO.xmlValue.nodes('TMMsg_JobOption/restoreOptions/virtualServerRstOption') V(vs)
					CROSS APPLY	vs.nodes('./diskLevelVMRestoreOption/advancedRestoreOptions') A(ad)
					LEFT OUTER JOIN APP_VSAReplication VS (NOLOCK) ON VS.backupsetId = @backupSetId
						AND VS.replicationGuid = vs.value('@replicationGuid', 'NVARCHAR(MAX)')
						AND VS.sourceGuid = ad.value('@guid', 'NVARCHAR(MAX)')
						AND VS.flags != 1
					FOR XML PATH('siteInfo'),
					ROOT('App_GetVSAReplicationResp')
				)
	END
ERROR_EXIT:
	IF @errorCode <> 0
		SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
							FOR XML PATH('App_GenericResp'), TYPE)
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<App_GetVSAReplicationResp/>'
	IF @skipSelectStatement = 0
	BEGIN
		SELECT @o_xmlString as o_xmlString
	END
	ELSE
	BEGIN
		SET @i_xmlString=@o_xmlString
	END
	IF object_id('tempdb.dbo.#livesync_PropTable') is not null
		drop table #livesync_PropTable
	IF object_id('tempdb.dbo.#associatedJobsInfoTable') is not null
		drop table #associatedJobsInfoTable
	IF object_id('tempdb.dbo.#auxCopyJobsInfo') is not null
		drop table #auxCopyJobsInfo
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppVSAReplicationsGetInfo')
	delete from GxQscripts where name = 'AppVSAReplicationsGetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVSAReplicationsGetInfo')
	delete from GXDBVersions where aliasname = 'AppVSAReplicationsGetInfo'
GO

insert into GXDBVersions values(2, 'AppVSAReplicationsGetInfo',  '00000000000000000000', 'AppVSAReplicationsGetInfo', '00000000000000000000')
GO

