

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppVSAReplicationsDeleteOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppVSAReplicationsDeleteOptions				|
--	|Procedure for deleting a VSA replication montior and remove from task options|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppVSAReplicationsDeleteOptions')
BEGIN
	print '>>> Drop Stored Procedure: AppVSAReplicationsDeleteOptions <<<'
	drop procedure AppVSAReplicationsDeleteOptions
END
IF EXISTS (select * from GxQscripts where name='AppVSAReplicationsDeleteOptions')
	delete from GxQscripts where name = 'AppVSAReplicationsDeleteOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVSAReplicationsDeleteOptions')
	delete from GXDBVersions where aliasname = 'AppVSAReplicationsDeleteOptions'
GO
print '... Creating Procedure: AppVSAReplicationsDeleteOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppVSAReplicationsDeleteOptions
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @subTaskId		 INT
	DECLARE @taskXml		 XML
	DECLARE @repGroupId		 INT
	DECLARE @errorCode       INT = 0
	DECLARE @errorString     NVARCHAR(MAX) = 'Success'
	DECLARE @deleteRepGroup  INT = 0
	DECLARE @planId INT = -1, @planSubTYpe INT = -1, @subClientId INT = -1
	DECLARE @isInReplicationGroup INT = 0
	DECLARE @subClientXml 	 XML = NULL
	--set @i_xmlString = '<TMMsg_DROrchestrationOption initiatedfromMonitor="1" operationType="10"><replicationInfo><replicationId val="17"/><appType _type_="79" appTypeId="106"/></replicationInfo></TMMsg_DROrchestrationOption>'
	--set @i_xmlString = '<TMMsg_DROrchestrationOption initiatedfromMonitor="1" operationType="10"><replicationInfo replicationGroupId="8000"><appType _type_="79" appTypeId="106"/></replicationInfo></TMMsg_DROrchestrationOption>'
	select @repGroupId = @i_xmlString.value('(/TMMsg_DROrchestrationOption/replicationInfo/@replicationGroupId)[1]', 'INT')
	-- delete the task if replication group id is passed
	IF @repGroupId IS NOT NULL
		SET @deleteRepGroup = 1
	ELSE
	BEGIN
		IF object_id('tempdb.dbo.#ReplicationsToBeRemoved') IS NOT null DROP TABLE #ReplicationsToBeRemoved
		create table #ReplicationsToBeRemoved(
					id				int identity(1,1),
					repId			int,
					sourceGuid      nvarchar(max)
		)
		insert into #ReplicationsToBeRemoved(repId)
		select c.value('@val', 'int')
		FROM  @i_xmlString.nodes('/TMMsg_DROrchestrationOption/replicationInfo/replicationId') N(C)
		DECLARE @countToBeRemoved int = ( select count(*) from #ReplicationsToBeRemoved)
		IF @countToBeRemoved = 0
		BEGIN
			SET @errorCode = -1
			SET @errorString = 'Replication Id is missing in the input request'
			GOTO ERROR_EXIT
		END
		--update the source guid to be deleted
		update RP
		set RP.sourceGuid = VSR.sourceGuid,
			@subTaskId = st.subTaskId,
			@repGroupId = VSR.taskId
		from #ReplicationsToBeRemoved RP inner join APP_VSAReplication VSR on VSR.replicationId = RP.repId
		inner join tm_task T on VSR.taskId = T.taskId
		left join TM_SubTask st on T.taskId = st.taskId
		-- GET THE PLAN INFO THAT THE TASK IS ASSOCIATED WITH
		SELECT @planId = ISNULL(p.id, -1), @planSubType = ISNULL(p.subType, -1)
		FROM App_PlanProp pp
JOIN App_Plan p ON pp.attrName = 'Replication schedule policy' AND CAST(pp.attrVal AS INT) = @repGroupId AND pp.modified = 0 AND pp.componentNameId = p.id
		-- CHECK IF PLAN IS REPLICATION PLAN CREATED BY US
SET @isInReplicationGroup = (CASE WHEN @planSubType = 83918853 THEN 1 ELSE 0 END)
		IF @isInReplicationGroup = 0
		BEGIN
			DECLARE @existingCount INT
			select @existingCount = Cnt from (select taskId as TskId, count(*) as Cnt from APP_VSAReplication VSR group by taskId ) T where TskId =  @repGroupId
			IF @countToBeRemoved = @existingCount -- whole replication group should be removed
				SET @deleteRepGroup = 1
		END
		ELSE	-- IF PLAN IS REPLICATION PLAN, GET SUBCLIENT THAT IS ASSOCIATED WITH THE PLAN
		BEGIN
			SELECT @subClientId = componentNameId
FROM App_SubClientProp WHERE attrName = 'Associated Plan' AND cs_attrName = CHECKSUM(N'Associated Plan') AND modified = 0 AND CAST(attrVal AS INT) = @planId
			SELECT @subClientXml = CAST(REPLACE(scp.attrVal, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>', '')  AS XML)
			FROM App_SubCLientProp scp
WHERE scp.componentNameId = @subClientId AND scp.attrName = 'Virtual Server Dyanimc Content' AND scp.cs_attrName = CHECKSUM(N'Virtual Server Dyanimc Content') AND scp.modified = 0
		END
	END
	IF @deleteRepGroup = 1
	BEGIN
		DELETE from TM_Task where taskId = @repGroupId
		GOTO ERROR_EXIT
	END
	select @taskXml = cast ( replace(cast(o.xmlValue as nvarchar(max)),'<?xml version="1.0" encoding="UTF-8" standalone="no" ?>','')  as xml)
	from  TM_SubTaskXMLOptions o
	where o.subTaskId = @subTaskId
	DECLARE @i int =1
	While ( @i <= @countToBeRemoved)
	BEGIN
		DECLARE @sourceGuidToBeRemoved nvarchar(max) = ( select sourceGuid from #ReplicationsToBeRemoved where id = @i)
		-- IF PLAN IS A REPLICATION PLAN, WE NEED NOT ONLY REMOVE THIS VM FROM SubTaskXMLOptions, BUT ALSO FROM SUBCLIENT
		IF @isInReplicationGroup = 1
		BEGIN
			-- REMOVE VM FROM subClient
			SET @subClientXml.modify('delete (/VirtualServer_VMSubClientEntity/children/.[@name=sql:variable("@sourceGuidToBeRemoved")])')
		END
		set @taskXml.modify('delete (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions/.[@guid=sql:variable("@sourceGuidToBeRemoved")])')
		set @taskXml.modify('delete (/TMMsg_JobOption/vmBrowsePathNodes/.[@vmGUID=sql:variable("@sourceGuidToBeRemoved")])')
		set @sourceGuidToBeRemoved = '\'+ @sourceGuidToBeRemoved
		set @taskXml.modify('delete (/TMMsg_JobOption/restoreOptions/fileOption/sourceItem/.[@val=sql:variable("@sourceGuidToBeRemoved")])')
		set @i = @i +1
	END
	-- update the flags in the APP_VSAReplication and modify the task xml in one trasaction
	BEGIN TRAN
		UPDATE TM_SubTaskXMLOptions SET xmlValue=@taskXml WHERE subTaskId=@subTaskId
		UPDATE VSR SET VSR.flags = 1
		FROM APP_VSAReplication VSR INNER JOIN #ReplicationsToBeRemoved RP on VSR.replicationId = RP.repId
		IF @subClientXml IS NOT NULL
		BEGIN
			UPDATE App_SubCLientProp SET attrVal = CAST(@subClientXml AS NVARCHAR(MAX))
WHERE componentNameId = @subClientId AND attrName = 'Virtual Server Dyanimc Content' AND cs_attrName = CHECKSUM(N'Virtual Server Dyanimc Content') AND modified = 0
		END
		SELECT @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR
	ERROR:
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
	ERROR_EXIT:
	SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
						FOR XML PATH('App_GenericResp'), TYPE)
	SELECT @o_xmlString as o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppVSAReplicationsDeleteOptions')
	delete from GxQscripts where name = 'AppVSAReplicationsDeleteOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVSAReplicationsDeleteOptions')
	delete from GXDBVersions where aliasname = 'AppVSAReplicationsDeleteOptions'
GO

insert into GXDBVersions values(2, 'AppVSAReplicationsDeleteOptions',  '00000000000000000000', 'AppVSAReplicationsDeleteOptions', '00000000000000000000')
GO

