

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppVSAReplicationsDeleteInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppVSAReplicationsDeleteInfo					|
--	|			Procedure for deleting a VSA replication				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppVSAReplicationsDeleteInfo <<<'

IF EXISTS (select * from sysobjects where name='AppVSAReplicationsDeleteInfo')
	drop procedure AppVSAReplicationsDeleteInfo
IF EXISTS (select * from GxQscripts where name='AppVSAReplicationsDeleteInfo')
	delete from GxQscripts where name = 'AppVSAReplicationsDeleteInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVSAReplicationsDeleteInfo')
	delete from GXDBVersions where aliasname = 'AppVSAReplicationsDeleteInfo'
GO
print '... Creating Procedure: AppVSAReplicationsDeleteInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppVSAReplicationsDeleteInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	-- READ THE XML
	DECLARE @replicationGuid		NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@replicationGuid', 'NVARCHAR(MAX)')
													FROM @i_xmlString.nodes ('App_DeleteVSAReplicationReq/siteInfo') R(ref)), '')
	DECLARE @sourceGuid				NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@sourceGuid', 'NVARCHAR(MAX)')
													FROM @i_xmlString.nodes ('App_DeleteVSAReplicationReq/siteInfo') R(ref)), '')
	DECLARE @destinationGuid		NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@destinationGuid', 'NVARCHAR(MAX)')
													FROM @i_xmlString.nodes ('App_DeleteVSAReplicationReq/siteInfo') R(ref)), '')
	DECLARE @replicationId			INT = ISNULL (( SELECT ref.value('@replicationId', 'INT')
													FROM @i_xmlString.nodes ('App_DeleteVSAReplicationReq/siteInfo') R(ref)), 0)
	DECLARE @taskId					INT = ISNULL (( SELECT ref.value('@taskId', 'INT')
													FROM @i_xmlString.nodes ('App_DeleteVSAReplicationReq/siteInfo/subTask') R(ref)), 0)
	-- If VM is deleted from the schedule, Adminconsole passes the replicationId
	-- initialize the replication guid and taskid for this combination if it is not passed already
	IF @replicationId <> 0 AND @taskId = 0 AND @replicationGuid = ''
	BEGIN
		SELECT @taskId=taskId, @replicationGuid=replicationGuid
		FROM APP_VSAReplication WITH (NOLOCK)
		WHERE replicationId = @replicationId
	END
    -- If VM is deleted from the schedule, GUI passes the taskid and source vm guid
	-- initialize the replication guid for this combination if it is not passed already
	ELSE IF @taskId <> 0 AND @replicationId = 0 AND @replicationGuid = '' AND @sourceGuid <> ''
	BEGIN
		SELECT @replicationId=replicationId, @replicationGuid=replicationGuid
		FROM APP_VSAReplication WITH (NOLOCK)
		WHERE
			taskId = @taskId
			AND
			sourceGuid = @sourceGuid
	END
	IF @taskId = 0 OR @replicationId = 0
	BEGIN
		SELECT @taskId=taskId, @replicationId=replicationId
		FROM APP_VSAReplication WITH (NOLOCK)
		WHERE
		(
			replicationGuid = @replicationGuid
			OR
			@replicationGuid = ''
		)
		AND
		(
			sourceGuid = @sourceGuid
			AND
			destinationGuid = @destinationGuid
			OR
			(
				@destinationGuid = '' AND @sourceGuid = ''
			)
		)
	END
	IF @replicationGuid = ''
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Invalid replication info in delete request.'
		GOTO ERROR_EXIT
	END
	BEGIN TRAN
		UPDATE APP_VSAReplication SET flags =1
		WHERE replicationId = @replicationId
		SELECT @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR
ERROR:
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
ERROR_EXIT:
	SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
						FOR XML PATH('App_GenericResp'), TYPE)
	SELECT @o_xmlString as o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppVSAReplicationsDeleteInfo')
	delete from GxQscripts where name = 'AppVSAReplicationsDeleteInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVSAReplicationsDeleteInfo')
	delete from GXDBVersions where aliasname = 'AppVSAReplicationsDeleteInfo'
GO

insert into GXDBVersions values(2, 'AppVSAReplicationsDeleteInfo',  '00000000000000000000', 'AppVSAReplicationsDeleteInfo', '00000000000000000000')
GO

