

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppVSAReplicationSetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppVSAReplicationSetInfo.sp,v $ $Id: AppVSAReplicationSetInfo.sp,v 1.12.2.17 2019/01/29 10:43:14 cchaturvedi Exp $";
--	+===================================================================+
--	|  					  AppVSAReplicationSetInfo						|
--	| Procedure for create/update a APP_SiteReplication table			|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppVSAReplicationSetInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppVSAReplicationSetInfo <<<'
	drop procedure AppVSAReplicationSetInfo
END
IF EXISTS (select * from GxQscripts where name='AppVSAReplicationSetInfo')
	delete from GxQscripts where name = 'AppVSAReplicationSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVSAReplicationSetInfo')
	delete from GXDBVersions where aliasname = 'AppVSAReplicationSetInfo'
GO
print '... Creating Procedure: AppVSAReplicationSetInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppVSAReplicationSetInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = datediff(second, '01/01/1970', GETDATE())
	DECLARE @taskName			NVARCHAR(MAX) = ''
	DECLARE @siteInfoCount		INT = 0
    DECLARE @assocCount			INT = 0
	DECLARE @drive				NVARCHAR(MAX) = ''
	DECLARE @trackingId			NVARCHAR(MAX) = ''
	DECLARE @uuid				NVARCHAR(MAX) = ''
	DECLARE @componentVal		NVARCHAR(MAX) = ''
	DECLARE @sourceGuid			NVARCHAR(MAX) = ''
	DECLARE @destinationGuid	NVARCHAR(MAX) = ''
	DECLARE @x					INT = 1
	DECLARE @i					INT = 1
	DECLARE @infoXML			XML
	DECLARE @assocXML			XML
	DECLARE @vsvendorType		INT = 0
	IF object_id('tempdb.dbo.#replicationTable') IS NOT null DROP TABLE #replicationTable
CREATE TABLE #replicationTable	( replicationId INT, replicationGuid	VARCHAR(255), sourceGuid VARCHAR(255), sourceName NVARCHAR(MAX), destinationGuid VARCHAR(255), destinationName NVARCHAR(MAX),
							lastRestoreTime INT, lastBackupTime INT, backupsetId INT, subclientId INT, taskId INT, powerOn BIGINT, options NVARCHAR(MAX), spare1 NVARCHAR(MAX), spare2 NVARCHAR(MAX), spare3 NVARCHAR(MAX), flags INT, status INT, lastSyncedBkpJob INT, VMSyncedTillTime INT, BkpJobsToSync NVARCHAR(MAX), ValidationFailCount INT, FailoverStatus INT)
	-- READ THE XML
	DECLARE @replicationGuid		NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@replicationGuid', 'NVARCHAR(MAX)')
													FROM @i_xmlString.nodes ('App_SetVSAReplicationReq/siteInfo[1]') R(ref)), '')
	DECLARE @replicationId			INT = ISNULL (( SELECT ref.value('@replicationId', 'INT')
													FROM @i_xmlString.nodes ('App_SetVSAReplicationReq/siteInfo[1]') R(ref)), 0)
	DECLARE @taskId					INT = ISNULL (( SELECT ref.value('@taskId', 'INT')
													FROM @i_xmlString.nodes ('App_SetVSAReplicationReq/siteInfo[1]/subTask') R(ref)), 0)
	INSERT #replicationTable (replicationId, replicationGuid, sourceGuid, sourceName, destinationGuid, destinationName, lastRestoreTime, lastBackupTime, backupsetId, subclientId, taskId, powerOn, options, spare1, spare2, spare3, flags, status, lastSyncedBkpJob, VMSyncedTillTime, BkpJobsToSync, ValidationFailCount, FailoverStatus)
	SELECT	ISNULL((ref.value('@replicationId', 'INT')), 0),
			ref.value('@replicationGuid', 'VARCHAR(255)'),
			CASE WHEN ref.value('@sourceGuid', 'VARCHAR(255)') IS NULL OR ref.value('@sourceGuid', 'VARCHAR(255)') = '' THEN V.sourceGuid ELSE ref.value('@sourceGuid', 'VARCHAR(255)') END sourceGuid,
			CASE WHEN ref.value('@sourceName', 'NVARCHAR(MAX)') IS NULL OR ref.value('@sourceName', 'NVARCHAR(MAX)') = '' THEN V.sourceName ELSE ref.value('@sourceName', 'NVARCHAR(MAX)') END sourceName,
			ISNULL((ref.value('@destinationGuid', 'VARCHAR(255)')), V.destinationGuid),
			CASE WHEN ref.value('@destinationName', 'NVARCHAR(MAX)') IS NULL OR ref.value('@destinationName', 'NVARCHAR(MAX)') = '' THEN V.destinationName ELSE ref.value('@destinationName', 'NVARCHAR(MAX)') END destinationName,
			CASE WHEN ref.value('@lastRestoreTime', 'INT') IS NULL OR ref.value('@lastRestoreTime', 'INT') = 0 THEN V.lastRestoreTime ELSE CASE WHEN ref.value('@lastRestoreTime', 'INT') = 1 THEN 0 ELSE ref.value('@lastRestoreTime', 'INT') END END lastRestoreTime, --THIS IS LAST SYNC TIME (VALUE TAKEN FROM BACKUP JOB)
			CASE WHEN ref.value('@lastBackupTime', 'INT') IS NULL OR ref.value('@lastBackupTime', 'INT') = 0 THEN V.lastBackupTime ELSE ref.value('@lastBackupTime', 'INT') END lastBackupTime,
			CASE WHEN ref.value('entity[1]/@backupsetId', 'INT') IS NULL OR ref.value('entity[1]/@backupsetId', 'INT') = 0 THEN V.backupsetId ELSE ref.value('entity[1]/@backupsetId', 'INT') END backupsetId,
			CASE WHEN ref.value('entity[1]/@subclientId', 'INT') IS NULL OR ref.value('entity[1]/@subclientId', 'INT') = 0 THEN V.subclientId ELSE ref.value('entity[1]/@subclientId', 'INT') END subclientId,
			CASE WHEN ref.value('subTask[1]/@taskId', 'INT') IS NULL OR ref.value('subTask[1]/@taskId', 'INT') = 0 THEN V.taskId ELSE ref.value('subTask[1]/@taskId', 'INT') END taskId,
			ref.value('@powerOn', 'BIGINT'),
			ref.value('@options', 'VARCHAR(255)'),
			CASE WHEN ref.value('@spare1', 'VARCHAR(255)') IS NULL OR ref.value('@spare1', 'VARCHAR(255)') = '' THEN V.spare1 ELSE CASE WHEN ref.value('@spare1', 'VARCHAR(255)') = '1' THEN '' ELSE ref.value('@spare1', 'VARCHAR(255)') END END spare1, --USE THIS AS LAST REPLICATION TIME
			CASE WHEN ref.value('@spare2', 'VARCHAR(255)') IS NULL OR ref.value('@spare2', 'VARCHAR(255)') = '' THEN V.spare2 ELSE ref.value('@spare2', 'VARCHAR(255)') END spare2,
			CASE WHEN ref.value('@spare3', 'VARCHAR(255)') IS NULL OR ref.value('@spare3', 'VARCHAR(255)') = '' THEN V.spare3 ELSE ref.value('@spare3', 'VARCHAR(255)') END spare3,
			CASE WHEN ref.value('@flags', 'INT') IS NULL OR ref.value('@flags', 'INT') = 0 THEN V.flags ELSE ref.value('@flags', 'INT') END flags,
			CASE WHEN ref.value('@status', 'INT') IS NULL OR ref.value('@status', 'INT') = 0 THEN V.status ELSE ref.value('@status', 'INT') END status,
			CASE WHEN ref.value('@lastSyncedBkpJob', 'INT') IS NULL OR ref.value('@lastSyncedBkpJob', 'INT') = 0 THEN V.lastSyncedBkpJob ELSE ref.value('@lastSyncedBkpJob', 'INT') END lastSyncedBkpJob,
			CASE WHEN ref.value('@VMSyncedTillTime', 'INT') IS NULL OR ref.value('@VMSyncedTillTime', 'INT') = 0 THEN V.VMSyncedTillTime ELSE ref.value('@VMSyncedTillTime', 'INT') END VMSyncedTillTime,
			CASE WHEN ref.value('@BkpJobsToSync', 'NVARCHAR(MAX)') IS NULL OR ref.value('@BkpJobsToSync', 'NVARCHAR(MAX)') = '' THEN V.BkpJobsToSync ELSE ref.value('@BkpJobsToSync', 'NVARCHAR(MAX)') END BkpJobsToSync,
			CASE WHEN ref.value('@ValidationFailCount', 'INT') IS NULL OR ref.value('@ValidationFailCount', 'INT') < 0 THEN V.ValidationFailCount ELSE ref.value('@ValidationFailCount', 'INT') END ValidationFailCount,
			CASE WHEN ref.value('@FailoverStatus', 'INT') IS NULL OR ref.value('@FailoverStatus', 'INT') < 0 OR ref.value('@FailoverStatus', 'INT') > 999 THEN V.FailoverStatus ELSE ref.value('@FailoverStatus', 'INT') END FailoverStatus
			FROM @i_xmlString.nodes ('App_SetVSAReplicationReq/siteInfo') R(ref)
			LEFT OUTER JOIN APP_VSAReplication V (NOLOCK) ON ref.value('@replicationGuid', 'VARCHAR(255)') = V.replicationGuid
				AND
				(
					ref.value('@sourceGuid', 'VARCHAR(255)') = V.sourceGuid OR V.sourceGuid = '' OR ref.value('@sourceGuid', 'VARCHAR(255)') IS NULL
				)
				AND
				(
					ISNULL((ref.value('@replicationId', 'INT')), 0) = V.replicationId OR ( ISNULL((ref.value('@replicationId', 'INT')), 0) = 0 AND V.flags != 1)
				)
	BEGIN TRAN
		UPDATE APP_VSAReplication SET
		    APP_VSAReplication.sourceGuid = (CASE WHEN RT.sourceGuid IS NULL THEN VR.sourceGuid ELSE RT.sourceGuid END),
			APP_VSAReplication.destinationGuid = (CASE WHEN RT.destinationGuid IS NULL THEN VR.destinationGuid ELSE RT.destinationGuid END),
			APP_VSAReplication.destinationName = (CASE WHEN RT.destinationName IS NULL THEN VR.destinationName ELSE RT.destinationName END),
			APP_VSAReplication.lastRestoreTime = (CASE WHEN RT.lastRestoreTime IS NULL THEN VR.lastRestoreTime ELSE RT.lastRestoreTime END),
			APP_VSAReplication.lastBackupTime = (CASE WHEN RT.lastBackupTime IS NULL THEN VR.lastBackupTime ELSE RT.lastBackupTime END),
			APP_VSAReplication.powerOn = (CASE WHEN RT.powerOn IS NULL THEN VR.powerOn ELSE RT.powerOn END),
			APP_VSAReplication.options = (CASE WHEN RT.options IS NULL THEN VR.options ELSE RT.options END),
			APP_VSAReplication.flags = (CASE WHEN RT.flags IS NULL THEN VR.flags ELSE RT.flags END),
			APP_VSAReplication.spare1 = (CASE WHEN RT.spare1 IS NULL THEN VR.spare1 ELSE RT.spare1 END),
			APP_VSAReplication.spare2 = (CASE WHEN RT.spare2 IS NULL THEN VR.spare2 ELSE RT.spare2 END),
			APP_VSAReplication.spare3 = (CASE WHEN RT.spare3 IS NULL THEN VR.spare3 ELSE RT.spare3 END),
			APP_VSAReplication.modified = @nowTime,
			APP_VSAReplication.status = (CASE WHEN RT.status IS NULL THEN VR.status ELSE RT.status END),
			APP_VSAReplication.lastSyncedBkpJob =(CASE WHEN RT.lastSyncedBkpJob IS NULL THEN VR.lastSyncedBkpJob ELSE RT.lastSyncedBkpJob END),
			APP_VSAReplication.VMSyncedTillTime =(CASE WHEN RT.VMSyncedTillTime IS NULL THEN VR.VMSyncedTillTime ELSE RT.VMSyncedTillTime END),
			APP_VSAReplication.BkpJobsToSync = (CASE WHEN RT.BkpJobsToSync IS NULL THEN VR.BkpJobsToSync ELSE RT.BkpJobsToSync END),
			APP_VSAReplication.ValidationFailCount =(CASE WHEN RT.ValidationFailCount IS NULL THEN VR.ValidationFailCount ELSE RT.ValidationFailCount END),
			APP_VSAReplication.FailoverStatus =(CASE WHEN RT.FailoverStatus IS NULL THEN VR.FailoverStatus ELSE RT.FailoverStatus END)
		FROM APP_VSAReplication VR
			JOIN #replicationTable RT ON
			(
				RT.replicationGuid = VR.replicationGuid
				AND RT.sourceGuid = VR.sourceGuid
				AND (RT.destinationGuid = VR.destinationGuid OR RT.destinationName = VR.destinationName)
				AND (RT.replicationId = VR.replicationId OR (RT.replicationId = 0 AND VR.flags != 1))
			)
			OR (RT.replicationId = VR.replicationId)
		DELETE VSRepProp
		FROM   APP_VSAReplicationProp  VSRepProp
		INNER JOIN #replicationTable repTable
ON VSRepProp.propertyTypeId in (2204, 2212)
		AND VSRepProp.replicationId = repTable.replicationId
		WHERE repTable.FailOverStatus =  5 --  VSAREP_FAILBACK_COMPLETE
		SET @errorCode = @@ERROR
	SET @siteInfoCount = @i_xmlString.value('count(//.[@replicationGuid])', 'INT')
	WHILE (@x <= @siteInfoCount)
	BEGIN
		SET @i = 1
		SET @infoXML = @i_xmlString.query('(//.[@replicationGuid])[sql:variable("@x")]')
		SET @sourceGuid = ISNULL (( SELECT ref.value('@sourceGuid', 'NVARCHAR(MAX)')
									FROM @infoXML.nodes ('siteInfo') R(ref)), '')
		SET @destinationGuid = ISNULL (( SELECT ref.value('@destinationGuid', 'NVARCHAR(MAX)')
									FROM @infoXML.nodes ('siteInfo') R(ref)), '')
		SET @vsvendorType = ISNULL (( SELECT ref.value('@DRVendorType', 'INT')
									FROM @infoXML.nodes ('siteInfo') R(ref)), 0)
		DECLARE @l_replicationId INT = 	ISNULL ((SELECT VSA.replicationId FROM APP_VSAReplication VSA(NOLOCK)
						WHERE VSA.replicationGuid = @replicationGuid AND VSA.sourceGuid = @sourceGuid AND VSA.flags != 1
					AND VSA.destinationGuid = @destinationGuid), 0)
		--SET VSVendorType in App_VSAReplicationProp as property CV_REPLICATIONPROP_DR_HYPERVISOR
		IF (@vsvendorType > 0)
		BEGIN
			DELETE APP_VSAReplicationProp
				WHERE replicationId = @l_replicationId
AND propertyTypeId = 2203
			INSERT INTO APP_VSAReplicationProp ( replicationId, propertyTypeId, propertyValue, created, modified)
VALUES ( @l_replicationId, 2203, @vsvendorType, @nowTime, 0);
		END
		--GET TRACKING IDS
		SET @assocCount = @infoXML.value('count(//trackingIds/.[@trackingId])', 'INT')
		--REMOVE EXISTING TRACKING IDS
		IF (@assocCount > 0)
		BEGIN
			DELETE APP_VSAReplicationProp
			WHERE replicationId = @l_replicationId
AND propertyTypeId = 2201
		END
		-- ADD THE TRACKING IDS
		WHILE (@i <= @assocCount)
		BEGIN
			SET @assocXML = @infoXML.query('(//trackingIds/.[@trackingId])[sql:variable("@i")]')
			SET @componentVal = CONVERT(NVARCHAR(MAX), @assocXML)
			MERGE APP_VSAReplicationProp AS RP
			USING
			(
				SELECT VSA.replicationId, VSA.replicationGuid, VSA.sourceGuid, VSA.destinationGuid, VSA.taskId
				FROM APP_VSAReplication VSA
				WHERE VSA.replicationGuid = @replicationGuid
				AND VSA.sourceGuid = @sourceGuid
				AND VSA.destinationGuid = @destinationGuid
				AND VSA.flags != 1
) AS VR ON VR.replicationId = RP.replicationId AND RP.propertyTypeId = 2201
				AND RP.propertyValue = @componentVal
			WHEN NOT MATCHED THEN
			INSERT ( replicationId, propertyTypeId, propertyValue, created, modified)
VALUES ( VR.replicationId, 2201, @componentVal, @nowTime, 0);
NEXT_TRACKID:
			SET @i  = @i +1
		END
		--GET SNAP TRACKING IDS
		SET @i = 1
		SET @assocCount = @infoXML.value('count(//snapCBTIds/.[@trackingId])', 'INT')
		--REMOVE EXISTING SNAP TRACKING IDS
		IF (@assocCount > 0)
		BEGIN
			DELETE APP_VSAReplicationProp
			WHERE replicationId = @l_replicationId
AND propertyTypeId = 2202
		END
		-- ADD THE TRACKING IDS
		WHILE (@i <= @assocCount)
		BEGIN
			SET @assocXML = @infoXML.query('(//snapCBTIds/.[@trackingId])[sql:variable("@i")]')
			SET @componentVal = CONVERT(NVARCHAR(MAX), @assocXML)
			MERGE APP_VSAReplicationProp AS RP
			USING
			(
				SELECT VSA.replicationId, VSA.replicationGuid, VSA.sourceGuid, VSA.destinationGuid, VSA.taskId
				FROM APP_VSAReplication VSA
				WHERE VSA.replicationGuid = @replicationGuid
				AND VSA.sourceGuid = @sourceGuid
				AND VSA.destinationGuid = @destinationGuid
				AND VSA.flags != 1
) AS VR ON VR.replicationId = RP.replicationId AND RP.propertyTypeId = 2202
				AND RP.propertyValue = @componentVal
			WHEN NOT MATCHED THEN
			INSERT ( replicationId, propertyTypeId, propertyValue, created, modified)
VALUES ( VR.replicationId, 2202, @componentVal, @nowTime, 0);
NEXT_SNAP_TRACKID:
			SET @i  = @i +1
		END
	--Update/Insert all misc properties for every VM in App_VSAReplicationProp table
	DECLARE @TmpReplProp TABLE (replicationId INT, propertyId INT, propertyValue NVARCHAR(MAX))
	INSERT INTO @TmpReplProp
	SELECT
		@l_replicationId AS replicationId,
		 c.value('@propertyId', 'INT') AS propertyId,
		 c .value('@propertyValue', 'NVARCHAR(MAX)') AS propertyValue
	 FROM @infoXML.nodes('/siteInfo/VMReplInfoProperties') R(c)
    MERGE APP_VSAReplicationProp AS RP
	USING @TmpReplProp TRP
	ON RP.replicationId = TRP.replicationId
	AND RP.propertyTypeId = TRP.propertyId
	WHEN MATCHED
		THEN UPDATE SET RP.propertyValue = TRP.propertyValue
	WHEN NOT MATCHED THEN
		INSERT(replicationId, propertyTypeId, propertyValue, created, modified)
		VALUES(TRP.replicationId, TRP.propertyId, TRP.propertyValue, @nowtime, 0);
NEXT_SITE:
		SET @x  = @x +1
	END
ERROR:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ERROR_EXIT:
    SET @o_xmlString =
    (
		SELECT
			(SELECT
				@replicationId AS '@replicationId',
				@replicationGuid AS '@replicationGuid',
				@taskId AS '@taskId'
				FOR XML PATH('siteInfo'), TYPE
			),
			(SELECT @errorCode '@errorCode',
					@errorString '@errorMessage'
			FOR XML PATH ('resp'), TYPE
			)
		FOR XML PATH(''), ROOT('App_VSAReplicationResp')
    )
	SELECT @o_xmlString as o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppVSAReplicationSetInfo')
	delete from GxQscripts where name = 'AppVSAReplicationSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppVSAReplicationSetInfo')
	delete from GXDBVersions where aliasname = 'AppVSAReplicationSetInfo'
GO

insert into GXDBVersions values(2, 'AppVSAReplicationSetInfo',  '00010012000200170000', 'AppVSAReplicationSetInfo', '00010012000200170000')
GO

