

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUserLookupXML.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUserLookupXML.sp,v $ $Id: AppUserLookupXML.sp,v 1.1.2.4 2019/07/18 13:31:06 ygondi Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetUserBaseInfoXML"
--	|	This Procedure is used to get all properties of a client.
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUserLookupXML')
BEGIN
	print '>>> Drop Stored Procedure: AppUserLookupXML <<<'
	drop procedure AppUserLookupXML
END
IF EXISTS (select * from GxQscripts where name='AppUserLookupXML')
	delete from GxQscripts where name = 'AppUserLookupXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUserLookupXML')
	delete from GXDBVersions where aliasname = 'AppUserLookupXML'
GO
print '... Creating Procedure: AppUserLookupXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUserLookupXML
  @i_xml XML
AS
  DECLARE @o_xml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @userIds AS TABLE (id INT PRIMARY KEY)
DECLARE @reqUserId    INT         = (SELECT ref.value('@userId',   'INT')          FROM @i_xml.nodes ('App_UserLookupRequest') R(ref))
DECLARE @reqUserGUID  VARCHAR(64) = (SELECT ref.value('@userGUID', 'VARCHAR(64)')  FROM @i_xml.nodes ('App_UserLookupRequest') R(ref))
DECLARE @reqUserLogin NVARCHAR(64) = (SELECT ref.value('@userName', 'NVARCHAR(510)') FROM @i_xml.nodes ('App_UserLookupRequest') R(ref))
DECLARE @reqUserEmail NVARCHAR(64) = (SELECT ref.value('@email',    'NVARCHAR(510)') FROM @i_xml.nodes ('App_UserLookupRequest') R(ref))
IF @reqUserId IS NOT NULL
    INSERT INTO @userIds VALUES(@reqUserId)
ELSE IF @reqUserGUID IS NOT NULL
    INSERT INTO @userIds SELECT id FROM UMUsers WHERE userGuid = @reqUserGUID
ELSE IF @reqUserLogin IS NOT NULL
    INSERT INTO @userIds SELECT id FROM UMUsers WHERE [login] = @reqUserLogin
ELSE IF @reqUserEmail IS NOT NULL
    INSERT INTO @userIds SELECT id FROM UMUsers WHERE email = @reqUserEmail
SET @o_xml = ISNULL
(
    (SELECT
        (SELECT U.[description]    AS '@description',
                U.[name]           AS '@fullName',
                U.email            AS '@email',
                U.lastLogInTime    AS '@lastLogIntime',
                U.[enabled]        AS '@enableUser',
				P.[serviceType]	   AS '@serviceType',
ISNULL((SELECT attrVal FROM UMUsersProp WHERE attrName = 'Enforce Password Change' AND componentNameId = U.Id), 0) AS '@enforcePasswordChange',
                (
                   SELECT  U.id        AS '@userId',
                           U.userGuid  AS '@userGUID',
                           U.[login]   AS '@userName'
                   FOR XML PATH('userEntity'), TYPE
                ),
                (
                   SELECT  P.id            AS '@providerId',
                           P.domainName    AS '@providerDomainName'
                   FOR XML PATH('provider'), TYPE
                )
    FROM    UMUsers U INNER JOIN @userIds S ON S.id = U.id
	INNER JOIN   UMDSProviders P on P.id = U.umDSproviderId
	         FOR XML PATH('users'), TYPE)
    FOR XML PATH('App_UserLookupResponse'), TYPE), (CAST('<App_GenericResp errorCode="2" errorMessage="User not found"/>' AS XML))
)
SELECT @o_xml AS [o_xml]
GO

IF EXISTS (select * from GxQscripts where name = 'AppUserLookupXML')
	delete from GxQscripts where name = 'AppUserLookupXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUserLookupXML')
	delete from GXDBVersions where aliasname = 'AppUserLookupXML'
GO

insert into GXDBVersions values(2, 'AppUserLookupXML',  '00010001000200040000', 'AppUserLookupXML', '00010001000200040000')
GO

