

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpgrade_PseudoClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpgrade_PseudoClients.sp,v $ $Id: AppUpgrade_PseudoClients.sp,v 1.1.2.4 2018/03/27 08:17:15 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpgrade_PseudoClients <<<'

IF EXISTS (select * from sysobjects where name='AppUpgrade_PseudoClients')
	drop procedure AppUpgrade_PseudoClients
IF EXISTS (select * from GxQscripts where name='AppUpgrade_PseudoClients')
	delete from GxQscripts where name = 'AppUpgrade_PseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpgrade_PseudoClients')
	delete from GXDBVersions where aliasname = 'AppUpgrade_PseudoClients'
GO
print '... Creating Procedure: AppUpgrade_PseudoClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpgrade_PseudoClients
  @inClient integer
AS
  DECLARE @errCode integer = 0
  DECLARE @errString varchar(2048) = ''
SET  NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @CSRelId INT = ISNULL((select MAX(id) from simAllGalaxyRel), 0)
	DECLARE @CSRelStr VARCHAR(128)
	DECLARE @CSBuildStr VARCHAR(128)
	DECLARE @nowTime INT =	dbo.GetUnixTime (GetUTCdate())
	DECLARE @ClientProps TABLE (t_attrName VARCHAR(1024), t_attrVal VARCHAR(1024), t_attrType INT)
	IF object_id('tempdb.dbo.#pseudoClients') IS NOT Null
		DROP TABLE #pseudoClients
	CREATE TABLE #pseudoClients ([t_id] INT NOT NULL PRIMARY KEY)
	SELECT @CSRelStr = release, @CSBuildStr = buildNum FROM simAllGalaxyRel WHERE id = @CSRelId
	-- List of pseudo clients to be upgraded
	INSERT INTO #pseudoClients
		SELECT distinct C.id FROM
		APP_Client C JOIN
		APP_iDAName App
		ON C.id = App.clientId AND (C.id = @inClient OR @inClient = 0)
		WHERE C.releaseId < @CSRelId
		AND ( (App.appTypeId IN (13, 88) AND (C.status & 0x0080) = 0x0080 )
				--CV_STATUS_NAS refer to UpdateNASClientVersion.sql
				OR (C.status & 0x10000000 ) = 0x10000000  -- CV_STATUS_EDGE_DRIVE
				OR (C.status & 0x4000000) = 0x4000000 ) -- CV_STATUS_REFERENCE_COPY
	INSERT INTO @ClientProps VALUES ('Galaxy Build', 'BUILD' + @CSBuildStr, 1)
	INSERT INTO @ClientProps VALUES ('SP Version Info', @CSRelStr, 1)
	INSERT INTO @ClientProps VALUES ('Client Version', @CSRelStr + '(BUILD' + @CSBuildStr + ')', 1)
	--SELECT * FROM @ClientProps
	--SELECT * FROM #pseudoClients
	UPDATE APP_Client SET releaseId = @CSRelId WHERE id IN (select t_id from #pseudoClients)
	MERGE APP_ClientProp as DST
	USING (SELECT  t_id, t_attrName,t_attrType, t_attrVal FROM @ClientProps CROSS APPLY #pseudoClients) as SRC
	ON SRC.t_id = DST.componentNameId AND DST.attrName = SRC.t_attrName
	WHEN MATCHED THEN
		UPDATE SET attrVal = t_attrVal
	WHEN NOT MATCHED THEN
		INSERT  (componentNameId, attrName, attrType, attrVal, created, modified)
		VALUES( SRC.t_id, SRC.t_attrName,SRC.t_attrType, SRC.t_attrVal, @nowTime, 0);
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errCode = ERROR_NUMBER()
   	set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END	  CATCH
DROP TABLE #pseudoClients
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpgrade_PseudoClients')
	delete from GxQscripts where name = 'AppUpgrade_PseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpgrade_PseudoClients')
	delete from GXDBVersions where aliasname = 'AppUpgrade_PseudoClients'
GO

insert into GXDBVersions values(2, 'AppUpgrade_PseudoClients',  '00010001000200040000', 'AppUpgrade_PseudoClients', '00010001000200040000')
GO

