

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpgradeVirtualServerAgent.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpgradeVirtualServerAgent.sp,v $ $Id: AppUpgradeVirtualServerAgent.sp,v 1.3.88.2 2018/03/27 08:07:59 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppUpgradeVirtualServerAgent"
--	|	This Procedure is used to get all properties of a client.
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpgradeVirtualServerAgent <<<'

IF EXISTS (select * from sysobjects where name='AppUpgradeVirtualServerAgent')
	drop procedure AppUpgradeVirtualServerAgent
IF EXISTS (select * from GxQscripts where name='AppUpgradeVirtualServerAgent')
	delete from GxQscripts where name = 'AppUpgradeVirtualServerAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpgradeVirtualServerAgent')
	delete from GXDBVersions where aliasname = 'AppUpgradeVirtualServerAgent'
GO
print '... Creating Procedure: AppUpgradeVirtualServerAgent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpgradeVirtualServerAgent
  @clientId INTEGER
AS
DECLARE @vsInstances TABLE ( instanceId INTEGER)
DECLARE @vsMemberServers XML
DECLARE @instanceId INTEGER
DECLARE @prop NVARCHAR(MAX)
DECLARE @createTime INTEGER
DECLARE @instCursor CURSOR
DECLARE @subclients TABLE ( scId INTEGER)
DECLARE @subclientId INTEGER
DECLARE @scCursor CURSOR
DECLARE @vsProxy XML
DECLARE @proxyClientId INTEGER
-- SELECT ALL INSTANCES
INSERT INTO @vsInstances
SELECT DISTINCT instance from APP_Application WHERE clientId = @clientId and appTypeId = 106
-- UPDATE SELF CLIENT AS MEMBER SERVER ON ALL INSTANCES
SET @instCursor = CURSOR
FOR SELECT DISTINCT instanceId FROM @vsInstances
    OPEN @instCursor
     FETCH NEXT FROM @instCursor INTO @instanceId
        WHILE @@FETCH_STATUS = 0
        BEGIN
        	IF @instanceId = 0
				GOTO NEXTINSTANCE
			-- FOR EACH INSTANCE IN THE TEMP TABLE
			set @vsMemberServers = ( select (select C.id as '@clientId',
												C.name as '@clientName',
												C.net_hostname as '@hostName',
												3 AS '@_type_'
										FROM APP_Client C
										where C.id = @clientId
										FOR XML PATH('client'),TYPE)
								FOR XML PATH('memberServers'),ROOT('App_MemberServers'))
			SET @prop = N'<?xml version="1.0" encoding="UTF-16" standalone="no" ?>' + CONVERT(nvarchar(max),@vsMemberServers)
			SET @createTime = dbo.getunixtime(GETUTCDATE())
			IF NOT EXISTS(SELECT * from APP_InstanceProp WHERE componentNameId = @instanceId and attrName ='Vs Member Servers' and modified =0)
			BEGIN
						INSERT INTO APP_InstanceProp VALUES
						(@instanceId,'Vs Member Servers',1,@prop,@createTime,0,0)
			END
			INSERT INTO APP_InstanceProp VALUES
			(@instanceId,'Upgraded VS Instance',2,1,@createTime,0,0)
			INSERT INTO @subclients select id from APP_Application WHERE  instance = @instanceId
			-- FOR EACH SUBCLIENT
			SET @scCursor = CURSOR
			FOR SELECT DISTINCT scId FROM @subclients
				OPEN @scCursor
				 FETCH NEXT FROM @scCursor INTO @subclientId
					WHILE @@FETCH_STATUS = 0
					BEGIN
						-- DO FOR EACH SC OF THIS INSTANCE
						set @proxyClientId = ISNULL((select attrVal from APP_SubClientProp where componentNameId = @subclientId and attrName = 'Virtual Server Proxy Client' and modified =0),0)
						IF @proxyClientId = 0
							GOTO NEXTSC
						set @vsProxy = (select (select C.id as '@clientId',
										   C.name as '@clientName',
										  C.net_hostname as '@hostName',
										  3 AS '@_type_'
									FROM APP_Client C
									where C.id = @proxyClientId
									FOR XML PATH('client'),TYPE)
							FOR XML PATH('memberServers'),ROOT('App_MemberServers'))
						SET @prop = N'<?xml version="1.0" encoding="UTF-16" standalone="no" ?>' + CONVERT(nvarchar(max),@vsProxy)
						IF NOT EXISTS(SELECT * from APP_SubClientProp where componentNameId = @subclientId and attrName ='Virtual Server Proxy Client List' and modified =0)
						BEGIN
			 						insert into APP_SubClientProp values
									(@subclientId,'Virtual Server Proxy Client List',1,@prop,@createTime,0,0)
						END
						NEXTSC:
							FETCH NEXT FROM @scCursor INTO @subclientId
					END
			DEALLOCATE @scCursor
			--END SC OF THIS INSTANCE
		NEXTINSTANCE:
			FETCH NEXT FROM  @instCursor INTO @instanceId
		END
DEALLOCATE @instCursor
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpgradeVirtualServerAgent')
	delete from GxQscripts where name = 'AppUpgradeVirtualServerAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpgradeVirtualServerAgent')
	delete from GXDBVersions where aliasname = 'AppUpgradeVirtualServerAgent'
GO

insert into GXDBVersions values(2, 'AppUpgradeVirtualServerAgent',  '00010003008800020000', 'AppUpgradeVirtualServerAgent', '00010003008800020000')
GO

