

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpgradeRetentionProperties.sp] ---------- 

--------------------------------------------------------------------------------------------
--   AppUpgradeRetentionProperties - Add/Update properties in the App_SubClientProp Table   ---
-------------------------------------------------------------------------------------------
-- ----------------------------------------------------------------------
--
--           Copyright (c) 2009  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ------------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpgradeRetentionProperties.sp,v $ $Id: AppUpgradeRetentionProperties.sp,v 1.1.4.8 2019/09/20 10:01:09 kvinayak Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpgradeRetentionProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppUpgradeRetentionProperties <<<'
	drop procedure AppUpgradeRetentionProperties
END
IF EXISTS (select * from GxQscripts where name='AppUpgradeRetentionProperties')
	delete from GxQscripts where name = 'AppUpgradeRetentionProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpgradeRetentionProperties')
	delete from GXDBVersions where aliasname = 'AppUpgradeRetentionProperties'
GO
print '... Creating Procedure: AppUpgradeRetentionProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpgradeRetentionProperties
---------------------------------------
--   PARAMETERS   &   OUTPUTS       ---
---------------------------------------
  @i_xmlText XML
AS
DECLARE @o_xmlText XML
DECLARE @clientId INT
SET @clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
                                    FROM   @i_xmlText . nodes('App_UpgradeRetentionPropertiesReq/client') R ( ref )
                                ), 0)
BEGIN TRAN
DECLARE @lockResult INT
SET @lockResult = -99
IF NOT EXISTS(SELECT 1 FROM APP_Client WITH(NOLOCK) WHERE id = @clientId)
BEGIN
	SET @o_xmlText =	(SELECT
							(SELECT '1' AS '@errorCode',
									'Invalid client id' AS '@errorMessage'
							FOR XML PATH('genericerror'), TYPE)
						FOR XML PATH('App_UpgradeRetentionPropertiesResp'), TYPE )
	GOTO PROC_END
END
DECLARE @lockName NVARCHAR(64) = N'sp_AppUpgradeRetentionProperties'
EXEC @lockResult = sp_getapplock @Resource = @lockName, @LockMode = N'Exclusive', @LockTimeout = 2000
DECLARE @errMsg VARCHAR(128)
IF @lockResult < 0
BEGIN
    SET @errMsg = CASE @lockResult
                            WHEN -1 THEN 'SP lock: The lock request timed out.'
                            WHEN -2 THEN 'SP lock: The lock request was canceled.'
                            WHEN -3 THEN 'SP lock: The lock request was chosen as a deadlock victim.'
                            ELSE 'Parameter validation or other call error.'
                        END
    SET @o_xmlText =	(SELECT
							(SELECT @lockResult AS '@errorCode',
									@errMsg AS '@errorMessage'
							FOR XML PATH('genericerror'), TYPE)
						FOR XML PATH('App_UpgradeRetentionPropertiesResp'), TYPE )
	GOTO PROC_END
END
DECLARE @v2SubclientRetentionUpgrade NVARCHAR(128) = N'SubclientRetentionPropertiesUpgradedFromV1ToV2'
DECLARE @v2RetentionUpgrade NVARCHAR(128) = N'RetentionPropertiesUpgradedFromV1ToV2'
DECLARE @v2RetentionPropUpgrade INT = 0
SELECT
	@v2RetentionPropUpgrade = 1
FROM
	APP_ClientProp WITH(NOLOCK)
WHERE
	componentNameId = @clientId AND attrName = @v2RetentionUpgrade AND attrVal = '1' AND modified = 0
IF (@v2RetentionPropUpgrade = 1)
BEGIN
	SET @o_xmlText =	(SELECT
							(SELECT '0' AS '@errorCode',
									'Retention properties are already upgraded from v1 to v2.' AS '@errorMessage'
							FOR XML PATH('genericerror'), TYPE)
						FOR XML PATH('App_UpgradeRetentionPropertiesResp'), TYPE )
	GOTO PROC_END
END
	DECLARE @nowTime INT = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))
	IF OBJECT_ID('tempdb.dbo.#subclientRetention') IS NOT NULL
	DROP TABLE #subclientRetention
	CREATE TABLE #subclientRetention (
							appId INT PRIMARY KEY,
							enableOnePass INT NULL,
							deletedStubRetention INT NULL,
							deletedFileRetention INT NULL,
							keepVersions INT NULL,
							isDaysBasedRetention INT DEFAULT 0,
							storagePolicyDaysBasedRetention INT,
							isLaptop INT DEFAULT 0,
							dmDoNotCreateStub INT NULL,
							archiveExpirationDays INT DEFAULT -1,
							enableSnap INT NULL,
							archiveretentionMode INT NULL,
							backupRetentionMode INT NULL
	)
	INSERT #subclientRetention(appId)
	SELECT subclient.id FROM APP_Application subclient
	INNER JOIN APP_AppTypeGroupAssoc appType ON appType.appTypeId = subclient.appTypeId AND appType.appGroupId IN(22,34) AND appType.typeOfGroup = 0 --22:WinFS and 34:UnixFS
	WHERE subclient.clientId = @clientId
	------------------------------
	UPDATE T
		SET T.archiveretentionMode = CAST(attrVal AS INT)
	FROM #subclientRetention T
	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId
	WHERE prop.attrName = N'Is Archive Retention Mode Enabled' AND prop.modified = 0
	UPDATE T
		SET T.backupRetentionMode = CAST(attrVal AS INT)
	FROM #subclientRetention T
	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId
	WHERE prop.attrName = N'Is Backup Retention Mode Enabled' AND prop.modified = 0
	DELETE #subclientRetention
	WHERE archiveretentionMode IS NOT NULL OR backupRetentionMode IS NOT NULL
	------------------------------
	UPDATE T
		SET T.enableOnePass = (CASE prop.attrVal WHEN '1' THEN 1 ELSE 0 END)
	FROM #subclientRetention T
	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId
	WHERE prop.attrName = N'Is Turbo Subclient' AND prop.modified = 0
	UPDATE T
		SET T.deletedStubRetention = CAST(prop.attrVal AS INT)
	FROM #subclientRetention T
	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId
	WHERE prop.attrName = N'User deleted stubs expiration days' AND prop.modified = 0
	UPDATE T
		SET T.deletedFileRetention = CAST(prop.attrVal AS INT)
	FROM #subclientRetention T
	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId
	WHERE prop.attrName = N'Days to keep items past their expiration' AND prop.modified = 0
	UPDATE T
		SET T.keepVersions = CAST(prop.attrVal AS INT)
	FROM #subclientRetention T
	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId
	WHERE prop.attrName = N'Number of Synth Full Versions' AND prop.modified = 0
	UPDATE T
		SET T.isDaysBasedRetention = (CASE prop.attrVal WHEN '1' THEN 1 ELSE 0 END)
	FROM #subclientRetention T
	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId
	WHERE prop.attrName = N'Honor Archiver Agent Retention' AND prop.modified = 0
	UPDATE T
		SET T.isLaptop = (SELECT CASE (client.status & 4096) WHEN 4096 THEN 1 ELSE 0 END)
	FROM #subclientRetention T
	INNER JOIN APP_Application subclient ON subclient.id = T.appId
	INNER JOIN App_Client client ON client.id = subclient.clientid
	UPDATE T
		SET T.dmDoNotCreateStub = (CAST(attrVal AS INT) & 0x04)
	FROM #subclientRetention T
	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId
	WHERE prop.attrName = N'Data Migrator Rule Flag' AND prop.modified = 0
	UPDATE T
		SET T.archiveExpirationDays = CAST(attrVal AS INT)
	FROM #subclientRetention T
	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId
	WHERE prop.attrName = N'Archived expiration days' AND prop.modified = 0
	UPDATE T
		SET T.enableSnap = CAST(prop.attrVal AS INT)
	FROM #subclientRetention T
	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId
	WHERE prop.attrName = N'Enable Snap Backups' AND prop.modified = 0
	UPDATE T
		SET T.storagePolicyDaysBasedRetention = (SELECT CASE WHEN MIN(AAR.archiverRetDays) = -1 THEN -1 ELSE MAX(AAR.archiverRetDays) END AS MaxArchiverRetDays
										FROM archGroupCopy AGC WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK)
										WHERE AGC.archGroupId = subclient.dataArchGrpId
										AND      AGC.id = AAR.copyId
										AND      AGC.isSnapCopy = 0
										AND      AGC.type = 1)
	FROM #subclientRetention T
	INNER JOIN App_Application subclient ON subclient.id = T.appId
	UPDATE T
		SET T.modified = @nowTime
	FROM APP_SubClientProp T
	INNER JOIN #subclientRetention S ON S.appId = T.componentNameId
	AND T.attrName IN(N'Is Archive Retention Mode Enabled', N'Is Backup Retention Mode Enabled', N'Keep older Synth Full Versions' ) AND T.modified = 0
	INSERT APP_SubClientProp
	----------------Archiver-------------------------------
	SELECT appId, N'Is Archive Retention Mode Enabled', 2, (CASE enableOnePass WHEN 1 THEN N'1' ELSE N'0' END), @nowTime, 0, 0 FROM #subclientRetention
	UNION ALL
	---------------Archiver Retention----------------------
	SELECT appId, N'User deleted stubs expiration days', 7, N'-1', @nowTime, 0, 0  FROM #subclientRetention WHERE deletedStubRetention IS NULL
	UNION ALL
	--------------Deleted file retention-------------------
	SELECT appId, N'Days to keep items past their expiration', 7, N'0', @nowTime, 0, 0  FROM #subclientRetention WHERE deletedFileRetention IS NULL
	UNION ALL
	---------------Backup Mode-----------------------------
	SELECT appId, N'Is Backup Retention Mode Enabled', 2, N'0', @nowTime, 0, 0  FROM #subclientRetention
	---------------Archive retention days------------------
	UPDATE T
		SET T.modified = @nowTime
	FROM APP_SubClientProp T
	INNER JOIN #subclientRetention S ON S.appId = T.componentNameId
	WHERE S.dmDoNotCreateStub = 4
	AND T.attrName = N'User deleted stubs expiration days' AND T.modified = 0
	INSERT APP_SubClientProp
	SELECT appId, N'User deleted stubs expiration days', 7, archiveExpirationDays, @nowTime, 0, 0 FROM #subclientRetention WHERE dmDoNotCreateStub = 4
	---------------Backup Mode-----------------------------
	UPDATE T
		SET T.attrVal = N'1'
	FROM APP_SubClientProp T
	INNER JOIN #subclientRetention S ON S.appId = T.componentNameId
	WHERE ((S.enableOnePass = 1 AND S.isDaysBasedRetention = 0) OR ((S.enableOnePass = 0 OR S.enableOnePass IS NULL) AND (S.deletedFileRetention > 0 OR S.deletedFileRetention = -1 OR S.keepVersions > 0) AND (S.enableSnap IS NULL OR S.enableSnap = 0)))
		AND T.attrName = N'Is Backup Retention Mode Enabled' AND T.modified = 0
	----------------ESP/enableOnePass---------------------
	UPDATE T
		SET T.modified = @nowTime
	FROM APP_SubClientProp T
	INNER JOIN #subclientRetention S ON S.appId = T.componentNameId
	WHERE (S.deletedFileRetention = -1 OR S.deletedFileRetention > 0 OR S.keepVersions > 0) AND (S.enableSnap IS NULL OR S.enableSnap = 0)
		AND T.attrName = N'Is Turbo Subclient' AND T.modified = 0
	INSERT APP_SubClientProp
	SELECT appId, N'Is Turbo Subclient', 2, N'1', @nowTime, 0, 0 FROM #subclientRetention WHERE (deletedFileRetention = -1 OR deletedFileRetention > 0 OR keepVersions > 0) AND (enableSnap IS NULL OR enableSnap = 0)
	--------------Deleted file retention-------------------
	UPDATE T
		SET T.attrVal = N'730'
	FROM APP_SubClientProp T
	INNER JOIN #subclientRetention S ON S.appId = T.componentNameId
	WHERE (S.deletedFileRetention IS NULL AND (S.enableOnePass = 1 OR S.isLaptop = 1 ))
		AND T.attrName = N'Days to keep items past their expiration' AND T.modified = 0
	---------------Days based retention is ON---------------
	UPDATE T
		SET T.modified = @nowTime
	FROM APP_SubClientProp T
	INNER JOIN #subclientRetention S ON S.appId = T.componentNameId
	WHERE (S.enableOnePass = 1 AND S.isDaysBasedRetention = 1)
		AND T.attrName = N'User deleted stubs expiration days' AND T.modified = 0
	INSERT APP_SubClientProp
	SELECT appId, N'User deleted stubs expiration days', 7, storagePolicyDaysBasedRetention, @nowTime, 0, 0 FROM #subclientRetention WHERE enableOnePass = 1 AND isDaysBasedRetention = 1
	---------------Keep Versions----------------------------
	INSERT APP_SubClientProp
	SELECT appId, N'Number of Synth Full Versions', 7, N'0', @nowTime, 0, 0  FROM #subclientRetention WHERE keepVersions IS NULL
	INSERT APP_SubClientProp
	SELECT appId, N'Keep older Synth Full Versions', 7, N'2', @nowTime, 0, 0  FROM #subclientRetention
	-----------------------------------------------------------
	UPDATE T
		SET T.modified = @nowTime
	FROM APP_SubClientProp T
	INNER JOIN #subclientRetention S ON S.appId = T.componentNameId
	AND T.attrName = @v2SubclientRetentionUpgrade AND T.modified = 0
	INSERT APP_SubClientProp
	SELECT appId, @v2SubclientRetentionUpgrade, 7, N'1', @nowTime, 0, 0  FROM #subclientRetention
	------------------------------------------------------------
	IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @clientId AND attrName = @v2RetentionUpgrade AND modified = 0)
            UPDATE APP_ClientProp SET attrVal = N'1'
			WHERE componentNameId = @clientId AND attrName = @v2RetentionUpgrade AND modified = 0
		ELSE
			INSERT APP_ClientProp
			SELECT @clientId, @v2RetentionUpgrade, 2, N'1', @nowTime, 0, 0
	IF OBJECT_ID('tempdb.dbo.#subclientRetention') IS NOT NULL
		DROP TABLE #subclientRetention
	SET @o_xmlText =	(SELECT
							(SELECT '0' AS '@errorCode',
									'Successfully upgraded retention properties from v1 to v2.' AS '@errorMessage'
							FOR XML PATH('genericerror'), TYPE)
						FOR XML PATH('App_UpgradeRetentionPropertiesResp'), TYPE )
PROC_END:
IF @o_xmlText IS NULL
    SET @o_xmlText = '<App_UpgradeRetentionPropertiesResp/>'
IF @lockResult >= 0
BEGIN
	EXEC @lockResult = sp_releaseapplock @Resource = @lockName
	COMMIT TRAN
END
ELSE
BEGIN
	ROLLBACK TRAN
END
IF OBJECT_ID('tempdb.dbo.#tblAppUpgradeRetentionProperties') IS NOT NULL
	INSERT INTO #tblAppUpgradeRetentionProperties VALUES (@o_xmlText)
ELSE
	SELECT @o_xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpgradeRetentionProperties')
	delete from GxQscripts where name = 'AppUpgradeRetentionProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpgradeRetentionProperties')
	delete from GXDBVersions where aliasname = 'AppUpgradeRetentionProperties'
GO

insert into GXDBVersions values(2, 'AppUpgradeRetentionProperties',  '00010001000400080000', 'AppUpgradeRetentionProperties', '00010001000400080000')
GO

