

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateWildcardDIPs.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateWildcardDIPs')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateWildcardDIPs <<<'
	drop procedure AppUpdateWildcardDIPs
END
IF EXISTS (select * from GxQscripts where name='AppUpdateWildcardDIPs')
	delete from GxQscripts where name = 'AppUpdateWildcardDIPs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateWildcardDIPs')
	delete from GXDBVersions where aliasname = 'AppUpdateWildcardDIPs'
GO
print '... Creating Procedure: AppUpdateWildcardDIPs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateWildcardDIPs
/*
*	This SP updates entries in archPipelineFirewall table when some client/group properties are updated.
*/
  @i_params XML,
  @i_requestType INTEGER
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorMessage NVARCHAR(MAX)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	/* id from archPipeline table which gives us interface information */
	DECLARE @dipId INTEGER = 0
	/* Interface wildcard type. Non_Wildcard = 0, CIDR = 1, Wildcard = 2 */
	DECLARE @srcInterfaceType INTEGER = 0
	/* Interface wildcard type. Non_Wildcard = 0, CIDR = 1, Wildcard = 2 */
	DECLARE @dstInterfaceType INTEGER = 0
	DECLARE @srcClientId_APL INTEGER = 0
	DECLARE @dstClientId_APL INTEGER = 0
	DECLARE @srcClientGroupId_APL INTEGER = 0
	DECLARE @dstClientGroupId_APL INTEGER = 0
	DECLARE @clientGroupId INTEGER = 0
DECLARE @srcInterface VARCHAR (64)
DECLARE @dstInterface VARCHAR (64)
	DECLARE @isSrcInterface INTEGER
DECLARE @otherInterface NVARCHAR(255)
	DECLARE @otherInterfaceIsGroup INTEGER
	DECLARE @otherEnd INTEGER
	DECLARE @flags INTEGER
	SELECT @errorCode=0, @errorMessage=''
	DECLARE @createdTime INTEGER = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @modifiedTime INTEGER = dbo.GetUnixTime(GETUTCDATE())
	IF object_id('tempdb.dbo.#SrcClientInterfaceMap') IS NOT NULL
		DROP TABLE #SrcClientInterfaceMap
CREATE TABLE #SrcClientInterfaceMap (clientId INTEGER, interface NVARCHAR(255))
	CREATE CLUSTERED INDEX SrcClientInterfaceMap_clientId_Idx ON #SrcClientInterfaceMap(clientId)
	CREATE INDEX SrcClientInterfaceMap_interface_Idx ON #SrcClientInterfaceMap(interface)
	IF object_id('tempdb.dbo.#DstClientInterfaceMap') IS NOT NULL
		DROP TABLE #DstClientInterfaceMap
CREATE TABLE #DstClientInterfaceMap (clientId INTEGER, interface NVARCHAR(255))
	CREATE CLUSTERED INDEX DstClientInterfaceMap_clientId_Idx ON #DstClientInterfaceMap(clientId)
	CREATE INDEX DstClientInterfaceMap_interface_Idx ON #DstClientInterfaceMap(interface)
	IF object_id('tempdb.dbo.#clientTable') IS NOT NULL
		DROP TABLE #clientTable
	CREATE TABLE #clientTable (clientId INTEGER)
	CREATE CLUSTERED INDEX clientTable_clientId_Idx ON #clientTable(clientId)
	IF object_id('tempdb.dbo.#groupDipMapping') IS NOT NULL
		DROP TABLE #groupDipMapping
CREATE TABLE #groupDipMapping (isSrcGroup INTEGER, interface NVARCHAR(255), archPipelineId INTEGER, otherEnd INTEGER, otherInterface NVARCHAR(255), otherInterfaceIsGroup INTEGER, flags INTEGER)
	CREATE CLUSTERED INDEX groupDipMapping_archPipelineId_Idx ON #groupDipMapping(archPipelineId)
	IF object_id('tempdb.dbo.#DipMapping') IS NOT NULL
		DROP TABLE #DipMapping
CREATE TABLE #DipMapping (isSrc INTEGER, interface NVARCHAR(255), archPipelineId INTEGER, otherEnd INTEGER, otherInterface NVARCHAR(255), otherInterfaceIsGroup INTEGER, flags INTEGER)
	CREATE CLUSTERED INDEX DipMapping_archPipelineId_Idx ON #DipMapping(archPipelineId)
	IF object_id('tempdb.dbo.#pushClientList') IS NOT NULL
		DROP TABLE #pushClientList
	CREATE TABLE #pushClientList (clientId INTEGER)
	CREATE CLUSTERED INDEX pushClientList_clientId_Idx ON #pushClientList(clientId)
IF @i_requestType = 4
	BEGIN
		/* Add client to group */
		/*
		*	 ASSUMPTION : At a given time, the associations of a client group do not change till the complete execution of this SP
		*/
		SET @clientGroupId = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/clientGroupInfo[1]/clientGroup[1]/@clientGroupId', 'INTEGER')
		IF @clientGroupId IS NULL OR @clientGroupId <=0
		BEGIN
			SET @errorCode = 1
			SET @errorMessage = N'Invalid client group id ' + CAST(@i_params AS NVARCHAR(MAX))
			GOTO RETURN_FROM_HERE
		END
		INSERT INTO #clientTable
		SELECT clients.value('@clientId', 'INTEGER')
		FROM @i_params.nodes('App_WildcardDIPWorkqueueParams[1]/clientGroupInfo[1]/clients') AS Nodes(clients)
		INNER JOIN APP_Client C
		ON clients.value('@clientId', 'INTEGER') = C.id
		IF NOT EXISTS (SELECT 1 FROM #clientTable)
			GOTO RETURN_FROM_HERE
		INSERT INTO #groupDipMapping
		SELECT 1, srcInterface, id
				,CASE WHEN destClientId=0 THEN destGroupId ELSE destClientId END
				,destInterface
				,CASE WHEN destClientId=0 THEN 1 ELSE 0 END
				,flags
		FROM archPipeline
		WHERE srcGroupId=@clientGroupId AND isActive<>0
		UNION ALL
		SELECT 0, destInterface, id
				,CASE WHEN srcClientId=0 THEN srcGroupId ELSE srcClientId END
				,srcInterface
				,CASE WHEN srcClientId=0 THEN 1 ELSE 0 END
				,flags
		FROM archPipeline
		WHERE destGroupId=@clientGroupId AND isActive<>0
		IF NOT EXISTS (SELECT 1 FROM #groupDipMapping)
			GOTO RETURN_FROM_HERE
		DECLARE dips_to_process CURSOR
		FOR
		SELECT isSrcGroup, interface, archPipelineId, otherEnd, otherInterface, otherInterfaceIsGroup, flags
		FROM #groupDipMapping
		OPEN dips_to_process
		DECLARE @AplId INTEGER
		DECLARE @isSrcGroup INTEGER
		DECLARE @interfaceType INTEGER
		FETCH NEXT FROM dips_to_process INTO @isSrcGroup, @srcInterface, @AplId, @otherEnd, @otherInterface, @otherInterfaceIsGroup, @flags
		WHILE @@FETCH_STATUS = 0
		BEGIN
			TRUNCATE TABLE #SrcClientInterfaceMap
			TRUNCATE TABLE #DstClientInterfaceMap
			IF (@flags & 0x00000001) = (0x00000001)
				SET @srcInterfaceType = 1
			ELSE IF (@flags & 0x00000002) = (0x00000002)
				SET @srcInterfaceType = 2
			ELSE
				SET @srcInterfaceType = 0
			IF (@flags & 0x00000004) = (0x00000004)
				SET @dstInterfaceType = 1
			ELSE IF (@flags & 0x00000008) = (0x00000008)
				SET @dstInterfaceType = 2
			ELSE
				SET @dstInterfaceType = 0
			IF @isSrcGroup <> 0
			BEGIN
				/* If our client group is a source client group in archPipeline */
				/* This call will populate #SrcClientInterfaceMap*/
				EXEC AppProcessWildcardInterfaces 0, @clientGroupid, 0, 0, @srcInterfaceType, @srcInterface, 0, ''
				/* The above SP will process for all members in the group. We want to consider only new ones */
				DELETE Src
				FROM #SrcClientInterfaceMap Src
				WHERE Src.clientId NOT IN (SELECT CT.clientId FROM #clientTable CT)
				/* This call will populate #DstClientInterfaceMap*/
				IF @otherInterfaceIsGroup<>0
				BEGIN
					EXEC AppProcessWildcardInterfaces 0, 0, 0, @otherEnd, 0, '', @dstInterfaceType, @otherInterface
				END
				ELSE
				BEGIN
					EXEC AppProcessWildcardInterfaces 0, 0, @otherEnd, 0, 0, '', @dstInterfaceType, @otherInterface
				END
				INSERT INTO #pushClientList (clientId)
				SELECT clientId
				FROM #DstClientInterfaceMap
			END
			ELSE
			BEGIN
				/* If our client group is a destination client group in archPipeline */
				/* This call will populate #DstClientInterfaceMap */
				EXEC AppProcessWildcardInterfaces 0, 0, 0, @clientGroupId, 0, '', @dstInterfaceType, @srcInterface
				/* The above SP will process for all members in the group. We want to consider only new ones */
				DELETE Dst
				FROM #DstClientInterfaceMap Dst
				WHERE Dst.clientId NOT IN (SELECT CT.clientId FROM #clientTable CT)
				/* This call will populate #SrcClientInterfaceMap */
				IF @otherInterfaceIsGroup<>0
				BEGIN
					EXEC AppProcessWildcardInterfaces 0, @otherEnd, 0, 0, @srcInterfaceType, @otherInterface, 0, ''
				END
				ELSE
				BEGIN
					EXEC AppProcessWildcardInterfaces @otherEnd, 0, 0, 0, @srcInterfaceType, @otherInterface, 0, ''
				END
				INSERT INTO #pushClientList (clientId)
				SELECT clientId
				FROM #SrcClientInterfaceMap
			END
			/* Insert into ArchpipelineFirewall */
			/*
				Workqueue processing is not sequential and based on workqueue token insertion timings the processing might vary
				and we end up with duplicate entries in archPipelineFirewall table. So insert into the table only when the same entry
				doesn't exist.
				Example: When a client is added to a group, we add entries in App_ClientGroupAssocTrigger table.
						This App_ClientGroupAssocTrigger table is processed at a regular interval (5 minutes) to insert
						required worktokens.
						Within this interval, if we add a DIP for the client group, entries are added to archPipelineFirewall.
						Now at the end of this interval, another worktoken=54 is inserted resulting in duplicates.
			*/
			INSERT INTO archPipelineFirewall (srcClientId, destClientId, srcInterface, destInterface, created, modified, archPipelineId)
			SELECT Interfaces.srcClientId, Interfaces.dstClientId, Interfaces.srcInterface, Interfaces.dstInterface, @createdTime, 0, @AplId
			FROM
			(SELECT DISTINCT Src.clientId AS srcClientId ,Dst.clientId AS dstClientId, Src.interface AS srcInterface, Dst.interface AS dstInterface
			FROM #SrcClientInterfaceMap Src
			CROSS JOIN #DstClientInterfaceMap Dst ) Interfaces
			LEFT OUTER JOIN
			archPipelineFirewall APF
			ON APF.archPipelineId=@AplId AND APF.srcClientId=Interfaces.srcClientId AND APF.destClientId=Interfaces.dstClientId
				AND APF.srcInterface=Interfaces.srcInterface AND APF.destInterface=Interfaces.dstInterface
			WHERE APF.srcClientId IS NULL
			FETCH NEXT FROM dips_to_process INTO @isSrcGroup, @srcInterface, @AplId, @otherEnd, @otherInterface, @otherInterfaceIsGroup, @flags
		END
		CLOSE dips_to_process
		DEALLOCATE dips_to_process
		/* Insert Workqueue request to push network configuration */
		INSERT INTO APP_WorkQueueRequest (clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
SELECT clientId, -1, 5, '', @createdTime, 0, 0, 0
		FROM #pushClientList
		UNION ALL
SELECT clientId, -1, 5, '', @createdTime, 0, 0, 0
		FROM #clientTable
	END
ELSE IF @i_requestType = 5
	BEGIN
		/* Delete client from group */
		SET @clientGroupId = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/clientGroupInfo[1]/clientGroup[1]/@clientGroupId', 'INTEGER')
		IF @clientGroupId IS NULL OR @clientGroupId <=0
		BEGIN
			SET @errorCode = 1
			SET @errorMessage = N'Invalid client group id ' + CAST(@i_params AS NVARCHAR(MAX))
			GOTO RETURN_FROM_HERE
		END
		IF object_id('tempdb.dbo.#clientIdDipMapping') IS NOT NULL
			DROP TABLE #clientIdDipMapping
		CREATE TABLE #clientIdDipMapping (srcClientId INTEGER, dstClientId INTEGER, archPipelineId INTEGER)
		CREATE CLUSTERED INDEX clientIdDipMapping_srcClientId_dstClientId_Idx ON #clientIdDipMapping(srcClientId, dstClientId)
		INSERT INTO #clientIdDipMapping
		SELECT APLF.srcClientId, APLF.destClientId, APLF.archPipelineId
		FROM archPipelineFirewall APLF
		INNER JOIN archPipeline APL
		ON APLF.archPipelineId = APL.id AND APL.srcGroupId=@clientGroupId
		LEFT OUTER JOIN APP_ClientGroupAssoc ACGA
		ON APLF.srcClientId=ACGA.clientId AND ACGA.clientGroupId=@clientGroupId
		WHERE ACGA.clientId IS NULL
		UNION ALL
		SELECT APLF.srcClientId, APLF.destClientId, APLF.archPipelineId
		FROM archPipelineFirewall APLF
		INNER JOIN archPipeline APL
		ON APLF.archPipelineId = APL.id AND APL.destGroupId=@clientGroupId
		LEFT OUTER JOIN APP_ClientGroupAssoc ACGA
		ON APLF.destClientId=ACGA.clientId AND ACGA.clientGroupId=@clientGroupId
		WHERE ACGA.clientId IS NULL
		IF NOT EXISTS (SELECT 1 FROM #clientIdDipMapping)
			GOTO RETURN_FROM_HERE
		DELETE APLF
		FROM archPipelineFirewall APLF
		INNER JOIN #clientIdDipMapping MAP
		ON APLF.srcClientId=MAP.srcClientId AND APLF.destClientId=MAP.dstClientId AND APLF.archPipelineId=MAP.archPipelineId
		/* Add workqueue tokens for push network configuration for these clients */
		INSERT INTO APP_WorkQueueRequest (clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
SELECT srcClientId, -1, 5, '', @createdTime, 0, 0, 0
		FROM #clientIdDipMapping
		UNION ALL
SELECT dstClientId, -1, 5, '', @createdTime, 0, 0, 0
		FROM #clientIdDipMapping
		IF object_id('tempdb.dbo.#clientIdDipMapping') IS NOT NULL
			DROP TABLE #clientIdDipMapping
	END
ELSE IF @i_requestType = 6 OR @i_requestType = 7
	BEGIN
		/* Update Client IP/Hostname */
		/* Consider client ID from the xml */
		DECLARE @clientId INTEGER = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/clientUpdate[1]/@clientId', 'INTEGER')
		IF @clientId IS NULL OR @clientId<=0
		BEGIN
			SET @errorCode = 4
			SET @errorMessage = 'Invalid source client ID for request type :[' + CAST(@i_requestType AS VARCHAR(16)) + ']. Input params : [' + CAST(@i_params AS NVARCHAR(MAX)) + ']'
			GOTO RETURN_FROM_HERE
		END
		INSERT INTO #DipMapping (isSrc, interface, archPipelineId, otherEnd, otherInterface, otherInterfaceIsGroup, flags)
		SELECT 1, srcInterface, id,
				CASE WHEN destClientId=0 THEN destGroupId ELSE destClientId END,
				destInterface,
				CASE WHEN destClientId=0 THEN 1 ELSE 0 END,
				flags
		FROM archPipeline
		WHERE srcClientId=@clientId AND isActive<>0 AND flags<>0 -- For non-wildcard dips, i.e. flags=0, we don't have to reprocess everything.
		UNION ALL
		SELECT 0, destInterface, id,
				CASE WHEN srcClientId=0 THEN srcGroupId ELSE srcClientId END,
				srcInterface,
				CASE WHEN srcClientId=0 THEN 1 ELSE 0 END,
				flags
		FROM archPipeline
		WHERE destClientId=@clientId AND isActive<>0 AND flags<>0 -- For non-wildcard dips, i.e. flags=0, we don't have to reprocess everything.
		UNION ALL
		/* Pick up client's hostname when Group's interface is empty, pickup Group's interface when it is not empty (wildcard) */
		SELECT 1,
		    CASE WHEN APL.srcInterface=''  THEN APC.net_hostname ELSE APL.srcInterface END,
			APL.id,
			CASE WHEN APL.destClientId=0 THEN destGroupId ELSE destClientId END,
			APL.destInterface,
			CASE WHEN APL.destClientId=0 THEN 1 ELSE 0 END,
			APL.flags
		FROM archPipeline APL
		INNER JOIN APP_ClientGroupAssoc ACGA
		ON APL.srcGroupId=ACGA.clientGroupId
		INNER JOIN APP_Client APC
		ON APC.id = ACGA.clientId
		WHERE ACGA.clientId=@clientId AND APL.isActive<>0 AND APL.flags<>0 -- For non-wildcard dips, i.e. flags=0, we don't have to reprocess everything.
		UNION ALL
		/* Pick up client's hostname when Group's interface is empty, pickup Group's interface when it is not empty (wildcard) */
		SELECT 0,
		    CASE WHEN APL.destInterface='' THEN APC.net_hostname ELSE APL.destInterface END,
			APL.id,
			CASE WHEN APL.srcClientId=0 THEN srcGroupId ELSE srcClientId END,
			APL.srcInterface,
			CASE WHEN APL.srcClientId=0 THEN 1 ELSE 0 END,
			APL.flags
		FROM archPipeline APL
		INNER JOIN APP_ClientGroupAssoc ACGA
		ON APL.destGroupId=ACGA.clientGroupId
		INNER JOIN APP_Client APC
		ON APC.id = ACGA.clientId
		WHERE ACGA.clientId=@clientId AND APL.isActive<>0 AND APL.flags<>0 -- For non-wildcard dips, i.e. flags=0, we don't have to reprocess everything.
		/* Delete old entries */
		IF NOT EXISTS (SELECT 1 FROM #DipMapping)
			GOTO RETURN_FROM_HERE
		DELETE APLF
		FROM archPipelineFirewall APLF
		INNER JOIN #DipMapping MAP
		ON APLF.archPipelineId=MAP.archPipelineId AND ( APLF.srcClientId=@clientId OR APLF.destClientId=@clientId )
		/* Process new interface */
		/* A client can be part of multiple groups with dips defined. We need to reprocess for each of those dips */
		/* Utilizing cursors as the dataset is small in most of the usecases */
		DECLARE dips_to_process CURSOR
		FOR
		SELECT isSrc, interface, archPipelineId, otherEnd, otherInterface, otherInterfaceIsGroup, flags
		FROM #DipMapping
		OPEN dips_to_process
		FETCH NEXT FROM dips_to_process INTO @isSrcInterface, @srcInterface, @AplId, @otherEnd, @otherInterface, @otherInterfaceIsGroup, @flags
		WHILE @@FETCH_STATUS = 0
		BEGIN
			TRUNCATE TABLE #SrcClientInterfaceMap
			TRUNCATE TABLE #DstClientInterfaceMap
			IF (@flags & 0x00000001) = (0x00000001)
				SET @srcInterfaceType = 1
			ELSE IF (@flags & 0x00000002) = (0x00000002)
				SET @srcInterfaceType = 2
			ELSE
				SET @srcInterfaceType = 0
			IF (@flags & 0x00000004) = (0x00000004)
				SET @dstInterfaceType = 1
			ELSE IF (@flags & 0x00000008) = (0x00000008)
				SET @dstInterfaceType = 2
			ELSE
				SET @dstInterfaceType = 0
			IF @isSrcInterface <> 0
			BEGIN
				/* If our client is a source client/group in archPipeline */
				/* This call will populate #SrcClientInterfaceMap*/
				EXEC AppProcessWildcardInterfaces @clientId, 0, 0, 0, @srcInterfaceType, @srcInterface, 0, ''
				/* This call will populate #DstClientInterfaceMap*/
				IF @otherInterfaceIsGroup<>0
				BEGIN
					EXEC AppProcessWildcardInterfaces 0, 0, 0, @otherEnd, 0, '', @dstInterfaceType, @otherInterface
				END
				ELSE
				BEGIN
					EXEC AppProcessWildcardInterfaces 0, 0, @otherEnd, 0, 0, '', @dstInterfaceType, @otherInterface
				END
				INSERT INTO #pushClientList (clientId)
				SELECT clientId
				FROM #DstClientInterfaceMap
			END
			ELSE
			BEGIN
				/* If our client is a destination client/group in archPipeline */
				/* This call will populate #DstClientInterfaceMap */
				EXEC AppProcessWildcardInterfaces 0, 0, @clientId, 0, 0, '', @dstInterfaceType, @srcInterface
				/* This call will populate #SrcClientInterfaceMap */
				IF @otherInterfaceIsGroup<>0
				BEGIN
					EXEC AppProcessWildcardInterfaces 0, @otherEnd, 0, 0, @srcInterfaceType, @otherInterface, 0, ''
				END
				ELSE
				BEGIN
					EXEC AppProcessWildcardInterfaces @otherEnd, 0, 0, 0, @srcInterfaceType, @otherInterface, 0, ''
				END
				INSERT INTO #pushClientList (clientId)
				SELECT clientId
				FROM #SrcClientInterfaceMap
			END
			/* Insert into ArchpipelineFirewall */
			INSERT INTO archPipelineFirewall (srcClientId, destClientId, srcInterface, destInterface, created, modified, archPipelineId)
			SELECT DISTINCT Src.clientId,Dst.clientId, Src.interface, Dst.interface, @createdTime, @modifiedTime, @AplId
			FROM #SrcClientInterfaceMap Src
			CROSS JOIN #DstClientInterfaceMap Dst
			FETCH NEXT FROM dips_to_process INTO @isSrcInterface, @srcInterface, @AplId, @otherEnd, @otherInterface, @otherInterfaceIsGroup, @flags
		END
		CLOSE dips_to_process
		DEALLOCATE dips_to_process
		/* Insert workqueue token for push network configuration */
		INSERT INTO APP_WorkQueueRequest (clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
SELECT clientId, -1, 5, '', @createdTime, 0, 0, 0
		FROM #pushClientList
		UNION ALL
SELECT @clientId, -1, 5, '', @createdTime, 0, 0, 0
	END
ELSE IF @i_requestType = 8
	BEGIN
		/* Consider client ID from the xml */
		SET @clientId = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/clientUpdate[1]/@clientId', 'INTEGER')
		IF @clientId IS NULL OR @clientId<=0
		BEGIN
			SET @errorCode = 5
			SET @errorMessage = 'Invalid source client ID for request type :[' + CAST(@i_requestType AS VARCHAR(16)) + ']. Input params : [' + CAST(@i_params AS NVARCHAR(MAX)) + ']'
			GOTO RETURN_FROM_HERE
		END
		/* We need to push network configuration to the clients this client has DIPs with*/
		INSERT INTO #pushClientList
		SELECT destClientId
		FROM archPipelineFirewall
		WHERE srcClientId=@clientId
		UNION ALL
		SELECT srcClientId
		FROM archPipelineFirewall
		WHERE destClientId=@clientId
		/* Delete the routes */
		DELETE FROM archPipelineFirewall
		WHERE srcClientId=@clientId OR destClientId=@clientId
		/* Insert workqueue token for push network configuration */
		INSERT INTO APP_WorkQueueRequest (clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
SELECT clientId, -1, 5, '', @createdTime, 0, 0, 0
		FROM #pushClientList
	END
	ELSE
	BEGIN
		SET @errorCode = 3
		SET @errorMessage = 'Received unknown request type : ' + CAST(@i_requestType AS VARCHAR(16))
		GOTO RETURN_FROM_HERE
	END
	RETURN_FROM_HERE:
		IF object_id('tempdb.dbo.#SrcClientInterfaceMap') IS NOT NULL
			DROP TABLE #SrcClientInterfaceMap
		IF object_id('tempdb.dbo.#DstClientInterfaceMap') IS NOT NULL
			DROP TABLE #DstClientInterfaceMap
		IF object_id('tempdb.dbo.#clientTable') IS NOT NULL
			DROP TABLE #clientTable
		IF object_id('tempdb.dbo.#clientDipMapping') IS NOT NULL
			DROP TABLE #clientDipMapping
		IF object_id('tempdb.dbo.#pushClientList') IS NOT NULL
			DROP TABLE #pushClientList
		SELECT @errorCode, @errorMessage
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateWildcardDIPs')
	delete from GxQscripts where name = 'AppUpdateWildcardDIPs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateWildcardDIPs')
	delete from GXDBVersions where aliasname = 'AppUpdateWildcardDIPs'
GO

insert into GXDBVersions values(2, 'AppUpdateWildcardDIPs',  '00000000000000000000', 'AppUpdateWildcardDIPs', '00000000000000000000')
GO

