

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateVMSubclientAssociations.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateVMSubclientAssociations.sp,v $ $Id: AppUpdateVMSubclientAssociations.sp,v 1.1.2.4 2020/02/13 19:59:05 alakra Exp $";
-- 	+---------------------------------------------------------------------------------------+
--	| 			Procedure : "AppPopulateVMSubclientAssociations"
--	|	This Procedure is used to do intial processing of VM to subclient association
-- 	+---------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateVMSubclientAssociations')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateVMSubclientAssociations <<<'
	drop procedure AppUpdateVMSubclientAssociations
END
IF EXISTS (select * from GxQscripts where name='AppUpdateVMSubclientAssociations')
	delete from GxQscripts where name = 'AppUpdateVMSubclientAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateVMSubclientAssociations')
	delete from GXDBVersions where aliasname = 'AppUpdateVMSubclientAssociations'
GO
print '... Creating Procedure: AppUpdateVMSubclientAssociations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateVMSubclientAssociations
  @subclientId INT,
  @o_errCode INT OUTPUT,
  @o_errString VARCHAR(MAX) OUTPUT
AS
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
SET @o_errString = 'Success'
SET @o_errCode = 0
BEGIN TRY
	DECLARE @isAnyRegexPartofContent INT  = 0
	IF OBJECT_ID('tempdb.dbo.#vmInputTbl') IS NOT NULL DROP TABLE #vmInputTbl
	DECLARE @currentTime     INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @nSubclientId NVARCHAR(16) = CAST(@subclientId AS NVARCHAR(16))
	CREATE TABLE #vmInputTbl (id INT NOT NULL IDENTITY PRIMARY KEY, vmClientId INT, vmClientName NVARCHAR(MAX), vmGuid NVARCHAR(128), lastBackupSubclient INT, isBackedUpVM INT)
	-- Read XML from DB
	DECLARE @inputXml XML = (SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML)
							FROM APP_SubClientProp  ASCP
							WHERE ASCP.componentNameId=@subclientId
							AND ASCP.attrName='Virtual Server Dyanimc Content'
							AND modified=0 AND ASCP.cs_attrName=CHECKSUM(N'Virtual Server Dyanimc Content'))
	-- Read current contents from DB to table
	INSERT INTO #vmInputTbl
	SELECT ACp.componentNameId, T.c.query('.').value('(//./@displayName)[1]', 'nvarchar(1024)'), T.c.query('.').value('(//./@name)[1]', 'nvarchar(1024)'),
						ISNULL(CAST(ACPSUB.attrval AS INT), 0),
						(SELECT CASE WHEN ACP3.id IS NOT NULL THEN 1 ELSE 0 END)
						FROM @inputXml.nodes('/VirtualServer_VMSubClientEntity/children') AS T(c)
						INNER JOIN APP_ClientProp ACP
							ON ACP.attrName='Virtual Machine Instance UUID' AND ACP.attrVal=T.c.query('.').value('(//./@name)[1]', 'nvarchar(1024)') AND ACP.modified=0
						LEFT OUTER JOIN APP_ClientProp ACPSUB
ON ACPSUB.componentNameId=ACP.componentNameId AND ACPSUB.attrName='Last Backup Subclient' AND ACPSUB.modified=0
						LEFT OUTER JOIN APP_ClientProp ACP3
							ON ACP3.attrName='Last Backup JobID' AND ACP3.componentNameId=ACP.componentNameId AND ACP.modified=0
						WHERE T.c.query('.').value('(//./@type)[1]', 'nvarchar(1024)')='9'
	SET @isAnyRegexPartofContent = ISNULL((SELECT TOP 1 1 FROM @inputXml.nodes('/VirtualServer_VMSubClientEntity/children') AS T(c) WHERE T.c.query('.').value('(//./@type)[1]', 'nvarchar(1024)')<>'9'), 0)
	-- Insert for any VM client which doesn't have this property as content has been added
	INSERT INTO APP_ClientProp
	SELECT vmClientId, 'Last Backup Subclient', 7, @nSubclientId, @currentTime, 0,0
		FROM #vmInputTbl WHERE lastBackupSubclient=0
	--Update only for non-backed up VM
	UPDATE ACP
		SET ACP.attrVal=@nSubclientId
	FROM APP_ClientProp ACP
	INNER JOIN #vmInputTbl VI
		ON VI.vmClientId=ACP.componentNameId AND VI.isBackedUpVM=0
	WHERE ACP.attrName='Last Backup Subclient' AND ACP.attrVal<>@nSubclientId
	-- For backed up VM
	-- Insert 'Next Backup Subclient' for protected VM
	MERGE APP_ClientProp AS T1
	USING (
			SELECT vmClientId FROM #vmInputTbl WHERE isBackedUpVM=1
		) AS SOURCE
ON T1.componentNameId = SOURCE.vmClientId  AND T1.attrName='Next Backup Subclient' and T1.modified=0
	WHEN MATCHED AND T1.attrVal <> @nSubclientId THEN
		UPDATE SET T1.attrVal =@nSubclientId
	WHEN NOT MATCHED THEN
		INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(SOURCE.vmClientId,'Next Backup Subclient',7,@nSubclientId,@currentTime,0);
	-- For Non-protected VM's
	-- DELETE FROM APP_clientProp for VM which are not backed up
	--		and they don't have any regex present
	--		and current VM is not part of content anymore
	--		and "Last backup subclient" is the same as current subclient
	DELETE ACP
	FROM APP_ClientProp ACP
	LEFT OUTER JOIN APP_ClientProp ACP3
		ON ACP3.attrName='Last Backup JobID' AND ACP3.componentNameId=ACP.componentNameId AND ACP.modified=0
	LEFT OUTER JOIN #vmInputTbl VI
		ON VI.vmClientId=ACP.componentNameId
WHERE ACP3.id IS NULL AND VI.id IS NULL AND @isAnyRegexPartofContent=0 AND ACP.attrName='Last Backup Subclient' AND ACP.modified=0 AND ACP.attrVal=@nSubclientId
	-- For any VM's (protected or for which all jobs got aged)
	-- DELETE said property FROM APP_clientProp if VM is not part of content anymore
	--		and "Next Backup Subclient" is the same as current subclient in that property
	--		No point in keeping dangling entry.
	DELETE ACP
	FROM APP_ClientProp ACP
	LEFT OUTER JOIN #vmInputTbl VI
		ON VI.vmClientId=ACP.componentNameId
WHERE VI.id IS NULL AND ACP.attrName='Next Backup Subclient' AND ACP.modified=0 AND ACP.attrVal=@nSubclientId
END TRY
----=====================================================================
----==============  COME HERE IF THERE WAS A PROBLEM!     ===============
----=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errCode    = ERROR_NUMBER()
	SET @o_errString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
	SELECT @o_errCode, @o_errString
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateVMSubclientAssociations')
	delete from GxQscripts where name = 'AppUpdateVMSubclientAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateVMSubclientAssociations')
	delete from GXDBVersions where aliasname = 'AppUpdateVMSubclientAssociations'
GO

insert into GXDBVersions values(2, 'AppUpdateVMSubclientAssociations',  '00010001000200040000', 'AppUpdateVMSubclientAssociations', '00010001000200040000')
GO

