

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateUsersToMigrateToAD.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateUsersToMigrateToAD <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateUsersToMigrateToAD')
	drop procedure AppUpdateUsersToMigrateToAD
IF EXISTS (select * from GxQscripts where name='AppUpdateUsersToMigrateToAD')
	delete from GxQscripts where name = 'AppUpdateUsersToMigrateToAD'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateUsersToMigrateToAD')
	delete from GXDBVersions where aliasname = 'AppUpdateUsersToMigrateToAD'
GO
print '... Creating Procedure: AppUpdateUsersToMigrateToAD'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateUsersToMigrateToAD
  @inUsers XML
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString VARCHAR(MAX) = 'Success'
DECLARE @MigrateUserTBL TABLE (userEmail NVARCHAR(MAX), providerID INT, loginName NVARCHAR(MAX),name NVARCHAR(255) DEFAULT '', description NVARCHAR(MAX) DEFAULT '', userGuid  NVARCHAR(256)  DEFAULT '')
--Check for external group information. --here idleTime is used to populate
INSERT INTO @MigrateUserTBL(userEmail,loginName,providerID, name,description, userGuid )
SELECT R.ref.value('@email','NVARCHAR(MAX)'),S.usr.value('@userName','NVARCHAR(MAX)'),T.prv.value('@providerId','INT'),R.ref.value('@fullName','NVARCHAR(MAX)'), R.ref.value('@description','NVARCHAR(MAX)'),S.usr.value('@userGUID','NVARCHAR(MAX)')
FROM @inUsers.nodes('App_UpdateUserPropertiesRequest/users') R(ref)
	OUTER APPLY ref.nodes('userEntity') S(usr)
	OUTER APPLY ref.nodes('provider') T(prv)
BEGIN TRY
	MERGE UMUsers AS T
	USING (select DISTINCT userEmail, providerId, loginName,  name, description, userguid from @MigrateUserTBL) AS S
	ON (S.userEmail = T.email and S.providerId <> T.umDSproviderId and flags <>0 )
	WHEN MATCHED --BY TARGET AND S.providerId <> T.umDSproviderId
		THEN UPDATE SET T.umDSproviderId=S.providerId,T.description=S.description,T.login=S.loginName,T.password='2ALXqLLXNLLX0LLXcLLXxLL', T.userGuid=S.userguid;
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   SET @errorCode = ERROR_NUMBER()
   SET @errorString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateUsersToMigrateToAD')
	delete from GxQscripts where name = 'AppUpdateUsersToMigrateToAD'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateUsersToMigrateToAD')
	delete from GXDBVersions where aliasname = 'AppUpdateUsersToMigrateToAD'
GO

insert into GXDBVersions values(2, 'AppUpdateUsersToMigrateToAD',  '00000000000000000000', 'AppUpdateUsersToMigrateToAD', '00000000000000000000')
GO

