

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateTwoFactorAuthenticationDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppUpdateTwoFactorAuthenticationDetails			|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateTwoFactorAuthenticationDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateTwoFactorAuthenticationDetails <<<'
	drop procedure AppUpdateTwoFactorAuthenticationDetails
END
IF EXISTS (select * from GxQscripts where name='AppUpdateTwoFactorAuthenticationDetails')
	delete from GxQscripts where name = 'AppUpdateTwoFactorAuthenticationDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateTwoFactorAuthenticationDetails')
	delete from GXDBVersions where aliasname = 'AppUpdateTwoFactorAuthenticationDetails'
GO
print '... Creating Procedure: AppUpdateTwoFactorAuthenticationDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateTwoFactorAuthenticationDetails
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inProviderId INT,
  @inLocaleId INT,
  @inXml XML
-----------------------------------------------------------
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(MAX) = ''
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN TRY
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @tfaMode NVARCHAR(8)
DECLARE @userGroupsIncludedForTFA TABLE (id INT, name NVARCHAR(255))
	DECLARE @canManageProvider INT = 0
	DECLARE @tfaIsDisabled NVARCHAR(8) = '1'
	DECLARE @tfaIsNotDisabled NVARCHAR(8) = '0'
	-- security check
	IF(@inUserId > 0)
	BEGIN
DECLARE @entityType INT = (CASE WHEN @inProviderId = 0 then 1 ELSE 61 END)
EXEC sec_checkPermissionOnEntity @inUserId, 1, @canManageProvider OUTPUT, @entityType, @inProviderId
		IF @canManageProvider <> 1
		BEGIN
SET @errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ERROR_EXIT
		END
	END
	ELSE
	BEGIN
SET @errorCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO ERROR_EXIT
	END
	SET @tfaMode = @inXml.value('(/App_UpdateTwoFactorAuthenticationDetailsRequest/twoFactorAuthenticationInfo/@mode)[1]', 'NVARCHAR(8)')
	IF @tfaMode IS NULL
	BEGIN
SET @errorCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO ERROR_EXIT
	END
IF @tfaMode = '2'
	BEGIN
		INSERT INTO @userGroupsIncludedForTFA
SELECT T.c.query('.').value('(/userGroups/@userGroupId)[1]', 'INT'), T.c.query('.').value('(/userGroups/@userGroupName)[1]', 'NVARCHAR(255)')
		FROM   @inXml.nodes('/App_UpdateTwoFactorAuthenticationDetailsRequest/twoFactorAuthenticationInfo/userGroups') T(c)
	END
	IF @inProviderId = 0	-- if request is for commcell
	BEGIN
		-- update/insert property 'EnableTwoFactorAuthentication' in GxGlobalParam
IF EXISTS (SELECT 1 FROM GxGlobalParam WHERE name = 'EnableTwoFactorAuthentication' AND modified = 0)
		BEGIN
UPDATE GxGlobalParam SET value = @tfaMode WHERE name = 'EnableTwoFactorAuthentication' AND modified = 0
		END
		ELSE
		BEGIN
INSERT INTO GxGlobalParam VALUES ('EnableTwoFactorAuthentication', @tfaMode, @nowTime, 0)
		END
IF @tfaMode = '1'
		BEGIN
			DECLARE @tmpResultTable TABLE (errorCode INT, errorString NVARCHAR(MAX))
			DECLARE @userId INT = -1 -- not in use in SP AppSetTFAForUserGroups
			INSERT INTO @tmpResultTable
EXEC AppSetTFAForUserGroups 1, @inProviderId, @userId, @inLocaleId, 1
			SELECT TOP 1 @errorCode = errorCode, @errorString = errorString FROM @tmpResultTable
			IF @errorCode <> 0
			BEGIN
				GOTO ERROR_EXIT
			END
		END
	END
	ELSE		-- if request is for a company
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM UMDSProviders WHERE id = @inProviderId)
		BEGIN
SET @errorCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ERROR_EXIT
		END
		-- update/insert property 'EnableTwoFactorAuthentication' in App_CompanyProp
IF EXISTS (SELECT 1 FROM App_CompanyProp WHERE componentNameId = @inProviderId AND attrName = 'EnableTwoFactorAuthentication' AND modified = 0 AND cs_attrName = CHECKSUM('EnableTwoFactorAuthentication'))
		BEGIN
UPDATE App_CompanyProp SET attrVal = @tfaMode WHERE componentNameId = @inProviderId AND attrName = 'EnableTwoFactorAuthentication' AND modified = 0 AND cs_attrName = CHECKSUM('EnableTwoFactorAuthentication')
		END
		ELSE
		BEGIN
INSERT INTO App_CompanyProp VALUES (@inProviderId, 'EnableTwoFactorAuthentication', 7, @tfaMode, @nowTime, 0, 0)
		END
	END
	IF OBJECT_ID('tempdb.dbo.#TFASupportedADServiceTypesTempTable') IS NOT NULL
		DROP TABLE #TFASupportedADServiceTypesTempTable
	CREATE TABLE #TFASupportedADServiceTypesTempTable (serviceType INT)
	-- TFA support: AD, openldap, oracle ldap, apple ldap, jump cloud and Generic LDAP
	INSERT INTO #TFASupportedADServiceTypesTempTable
VALUES (2), (6), (8),
(9), (10), (14)
IF @tfaMode = '2'
	BEGIN
		-- disable TFA for local or AD user groups that are not in the listUserGroupsIncluded
		DELETE umgp FROM UMGroupsProp umgp
					INNER JOIN UMGroups umg
ON umgp.attrName = 'DisableTwoFactorAuthentication'
							   AND umgp.modified = 0
AND umgp.cs_attrName = CHECKSUM(N'DisableTwoFactorAuthentication')
							   AND umgp.attrVal = @tfaIsNotDisabled
							   AND umgp.componentNameId = umg.id
					INNER JOIN UMDSProviders umdsp
							ON (umg.umdsProviderId = @inProviderId OR (umdsp.serviceType IN (SELECT serviceType FROM #TFASupportedADServiceTypesTempTable) AND umdsp.ownerCompany = @inProviderId))
							   AND umdsp.id = umg.umdsProviderId
		WHERE umgp.componentNameId NOT IN (SELECT id FROM @userGroupsIncludedForTFA)
	END
ELSE IF @tfaMode = '1' AND @inProviderId <> 0
	BEGIN
		-- If its enabled at company level inherit the value at local user groups created by company user(umdsProviderId = companyId) as well as
		-- external user groups belonging to that company
		-- The property at usergroup level is DisableTwoFactor, so set it 0
		MERGE   UMGroupsProp AS TGT
		USING   (SELECT UMG.id FROM UMGroups UMG WITH(NOLOCK)
			    JOIN UMDSProviders UMP WITH(NOLOCK) ON UMG.umdsProviderId = UMP.id
			    WHERE UMP.serviceType IN (
SELECT 5
			        UNION
			        SELECT serviceType FROM #TFASupportedADServiceTypesTempTable)
			    AND (UMG.umdsProviderid = @inProviderId  OR UMP.ownerCompany = @inProviderId))
AS SRC ON TGT.componentNameId = SRC.id and TGT.attrName = 'DisableTwoFactorAuthentication' AND TGT.attrType = 7
		WHEN    MATCHED AND TGT.attrVal <> '0' THEN         UPDATE SET TGT.attrVal = '0'
		WHEN    NOT MATCHED THEN    INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(SRC.id, 'DisableTwoFactorAuthentication', 7, 0, @nowTime ,0);
	END
	-- update/insert property 'DisableTwoFactorAuthentication' in UMGroupsProp
	IF EXISTS (SELECT TOP 1 id FROM @userGroupsIncludedForTFA)	-- if user ids are provided in input xml
	BEGIN
		MERGE UMGroupsProp AS target
		USING (SELECT ugtfa.id FROM UMDSProviders umdsp
				INNER JOIN UMGroups umg ON (umdsp.id = @inProviderId OR umdsp.serviceType IN (SELECT serviceType FROM #TFASupportedADServiceTypesTempTable)) AND umdsp.id = umg.umdsProviderId
				INNER JOIN @userGroupsIncludedForTFA ugtfa ON umg.id = ugtfa.id
			   ) AS source
ON target.componentNameId = source.id AND target.attrName = 'DisableTwoFactorAuthentication' AND modified = 0
		WHEN MATCHED AND target.attrVal = @tfaIsDisabled THEN
			UPDATE SET attrVal = @tfaIsNotDisabled
		WHEN NOT MATCHED THEN
INSERT VALUES (source.id, 'DisableTwoFactorAuthentication', 7, @tfaIsNotDisabled, @nowTime, 0);
	END
--	ELSE
--	BEGIN	-- if user names are provided in input xml
--		MERGE UMGroupsProp AS target
--		USING (SELECT umg.id FROM @userGroupsIncludedForTFA ugtfa INNER JOIN UMGroups umg ON umg.umdsProviderId = @inProviderId AND ugtfa.name = umg.name) AS source
--		ON target.componentNameId = source.id AND target.attrName = 'DisableTwoFactorAuthentication' AND modified = 0
--		WHEN MATCHED AND target.attrVal = @tfaIsDisabled THEN
--			UPDATE SET attrVal = @tfaIsNotDisabled
--		WHEN NOT MATCHED THEN
--			INSERT VALUES (source.id, 'DisableTwoFactorAuthentication', 7, @tfaIsNotDisabled, @nowTime, 0);
--	END
ERROR_EXIT:
		SET @errorString = (SELECT Message FROM EvLocaleMsgs WHERE MessageId = @errorCode AND [localeId] = @inLocaleId)
		SET @outXml = (SELECT
							(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH('error'), TYPE),
							@outXml
							FOR XML PATH('App_UpdateTwoFactorAuthenticationDetailsResponse'), TYPE
					   )
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
    SET @outXml = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ('error'), ROOT('App_UpdateTwoFactorAuthenticationDetailsResponse'))
END CATCH
SELECT @outXml
IF OBJECT_ID('tempdb.dbo.#TFASupportedADServiceTypesTempTable') IS NOT NULL
	DROP TABLE #TFASupportedADServiceTypesTempTable
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateTwoFactorAuthenticationDetails')
	delete from GxQscripts where name = 'AppUpdateTwoFactorAuthenticationDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateTwoFactorAuthenticationDetails')
	delete from GXDBVersions where aliasname = 'AppUpdateTwoFactorAuthenticationDetails'
GO

insert into GXDBVersions values(2, 'AppUpdateTwoFactorAuthenticationDetails',  '00000000000000000000', 'AppUpdateTwoFactorAuthenticationDetails', '00000000000000000000')
GO

