

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateSystemMonitoringInfo.sp] ---------- 

--  +========================================================================+
--  | Stored Proc:  AppUpdateSystemMonitoringInfo()
--  |
--  | Description: CVD task updates Veem property and VSA volume info for clients to create a report on system statistics.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateSystemMonitoringInfo <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateSystemMonitoringInfo')
	drop procedure AppUpdateSystemMonitoringInfo
IF EXISTS (select * from GxQscripts where name='AppUpdateSystemMonitoringInfo')
	delete from GxQscripts where name = 'AppUpdateSystemMonitoringInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateSystemMonitoringInfo')
	delete from GXDBVersions where aliasname = 'AppUpdateSystemMonitoringInfo'
GO
print '... Creating Procedure: AppUpdateSystemMonitoringInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateSystemMonitoringInfo
  @inXML XML
AS
  DECLARE @outXML XML
DECLARE @errorCode INT
DECLARE @errorString nvarchar(max)
SET NOCOUNT ON
BEGIN TRY
DECLARE @rcnt INT
DECLARE @clientId INT=0
DECLARE @updateType INT = 0
SET @errorCode = 0
SET @errorString = ''
SET @clientId = ISNULL(@inXML.value('/App_UpdateSystemMonitoringInfo[1]/client[1]/@clientId','INT'),0)
SET @updateType = ISNULL (@inXML.value('/App_UpdateSystemMonitoringInfo[1]/@type','INT'),-1)
IF @clientId = 0 OR NOT EXISTS (SELECT id from App_client where id = @clientId)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Invalid client information.'
	GOTO END_SCRIPT
END
DECLARE @now INT = dbo.GetUnixTime(GetUTCDate())
IF @updateType IN (0,2) -- ALL OR VSA VOLUME INFO
BEGIN
	DECLARE @vsaVolumeInfo  nvarchar(max)
	SET @vsaVolumeInfo = CONVERT(nvarchar(MAX),@inXML.query('(/App_UpdateSystemMonitoringInfo/vsaVolumeInfo)[1]'))
	IF @vsaVolumeInfo <> ''
	BEGIN
UPDATE APP_CLIENTPROP SET attrval = @vsaVolumeInfo WHERE attrName = 'VSA Volume Info' and componentNameId = @clientId
		SET @rcnt  = @@ROWCOUNT
		IF (@rcnt = 0)
		BEGIN
			INSERT INTO APP_CLIENTPROP
Values( @clientId, 'VSA Volume Info', 1, @vsaVolumeInfo, @now, 0, 0)
		END
	END
END
IF @updateType IN (0,1) -- ALL OR VEEAM
BEGIN
	DECLARE @veeamInstalled	INT = 0
	SET @veeamInstalled = ISNULL (@inXML.value('/App_UpdateSystemMonitoringInfo[1]/@veeamInstalled','INT'), -1)
	IF  @veeamInstalled <> -1
	BEGIN
UPDATE APP_CLIENTPROP SET attrval = @veeamInstalled WHERE attrName = 'Veeam Configured' and componentNameId = @clientId
		Set @rcnt = @@ROWCOUNT
		IF (@rcnt = 0)
		BEGIN
			INSERT INTO APP_CLIENTPROP
Values( @clientId, 'Veeam Configured', 1, @veeamInstalled, @now, 0, 0)
		END
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Failed to update system monitoring info. ERROR_NUMBER: '+ cast(ERROR_NUMBER() as varchar(10))+' ERROR_LINE:
	'+cast(ERROR_LINE() as varchar(10))+' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), 'UNKNOWN')
END CATCH
END_SCRIPT:
	SET @outXML = (
						SELECT @errorCode as '@errorCode',
						@errorString as '@errorMessage'
						FOR XML PATH('App_GenericResp')
					)
	SELECT @outXML
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateSystemMonitoringInfo')
	delete from GxQscripts where name = 'AppUpdateSystemMonitoringInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateSystemMonitoringInfo')
	delete from GXDBVersions where aliasname = 'AppUpdateSystemMonitoringInfo'
GO

insert into GXDBVersions values(2, 'AppUpdateSystemMonitoringInfo',  '00000000000000000000', 'AppUpdateSystemMonitoringInfo', '00000000000000000000')
GO

