

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateSubClientSubStoreRelationship.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |                       SP: "AppUpdateSubClientSubStoreRelationship"                           |
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateSubClientSubStoreRelationship <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateSubClientSubStoreRelationship')
	drop procedure AppUpdateSubClientSubStoreRelationship
IF EXISTS (select * from GxQscripts where name='AppUpdateSubClientSubStoreRelationship')
	delete from GxQscripts where name = 'AppUpdateSubClientSubStoreRelationship'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateSubClientSubStoreRelationship')
	delete from GXDBVersions where aliasname = 'AppUpdateSubClientSubStoreRelationship'
GO
print '... Creating Procedure: AppUpdateSubClientSubStoreRelationship'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateSubClientSubStoreRelationship
  @i_xml XML
AS
  DECLARE @errorCode integer
  DECLARE @errorString varchar(255)
DECLARE @subClientId INT = 0
BEGIN
	SELECT @errorCode = 0, @errorString = ''
	SELECT @subClientId = TBL.stores.value('@subclientId', 'int') FROM @i_xml.nodes('//App_SubClientInfo/subClientEntity') AS TBL(stores)
	-- Make sure that the subclient exists before proceeding
	IF EXISTS (SELECT 1 FROM App_Application WITH (NOLOCK) WHERE id = @subClientId)
	BEGIN
		-- Update the stores that are assigned now
		UPDATE IdxSIDBSubStore
		SET DDBSubClientId = @subClientId
		WHERE
			SubStoreId IN (SELECT
					TBL.stores.value('@SubStoreId', 'int')
					FROM @i_xml.nodes('//App_SubClientInfo/fsSubClientProp/assignedDDBStores') AS TBL(stores))
		-- Update the stores that are made available now
		UPDATE IdxSIDBSubStore
		SET DDBSubClientId = 0
		WHERE
			SubStoreId IN (SELECT
			TBL.stores.value('@SubStoreId', 'int')
			FROM @i_xml.nodes('//App_SubClientInfo/fsSubClientProp/availableDDBStores') AS TBL(stores))
			AND DDBSubClientId <> 0
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid SubClientId was passed'
	END
	SELECT @errorCode, @errorString
END
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateSubClientSubStoreRelationship')
	delete from GxQscripts where name = 'AppUpdateSubClientSubStoreRelationship'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateSubClientSubStoreRelationship')
	delete from GXDBVersions where aliasname = 'AppUpdateSubClientSubStoreRelationship'
GO

insert into GXDBVersions values(2, 'AppUpdateSubClientSubStoreRelationship',  '00000000000000000000', 'AppUpdateSubClientSubStoreRelationship', '00000000000000000000')
GO

