

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateSubClientDerivedContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateSubClientDerivedContent.sp,v $ $Id: AppUpdateSubClientDerivedContent.sp,v 1.16.50.8 2020/06/22 05:03:05 shussain Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateSubClientDerivedContent')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateSubClientDerivedContent <<<'
	drop procedure AppUpdateSubClientDerivedContent
END
IF EXISTS (select * from GxQscripts where name='AppUpdateSubClientDerivedContent')
	delete from GxQscripts where name = 'AppUpdateSubClientDerivedContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateSubClientDerivedContent')
	delete from GXDBVersions where aliasname = 'AppUpdateSubClientDerivedContent'
GO
print '... Creating Procedure: AppUpdateSubClientDerivedContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateSubClientDerivedContent
  @subClientId INT,
  @operationType INT,
  @nvContent NVARCHAR(MAX)
AS
  DECLARE @errCode integer = 0
  DECLARE @errString varchar(MAX) = ''
BEGIN TRY
	DECLARE @nowTime		INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @attrName		NVARCHAR(MAX)
	DECLARE @attrVal		NVARCHAR(MAX)
	DECLARE @modified		INT = 0
	DECLARE @propertyType	INT = 0
	DECLARE @derivedSubclientPropType	INT = 0
	DECLARE @appTypeID		INT = 0
	DECLARE @mssqlSubClientType INT = 0
	DECLARE @existingContent NVARCHAR(MAX)
	DECLARE @cloudConnectorContentType NVARCHAR(50)
	DECLARE @inContent		XML
	DECLARE @subclientStatus	INT = 0
	DECLARE @InputContents TABLE(	attrName NVARCHAR(MAX),
									attrVal NVARCHAR(MAX))
	SET @inContent = @nvContent
	INSERT INTO @InputContents(attrName, attrVal)
		SELECT  ref.value('@attrName', 'NVARCHAR(MAX)'),
				ref.value('@attrVal', 'NVARCHAR(MAX)')
		FROM    @inContent.nodes('Content') R ( ref )
	--Identify ApptypeID & status of a given subClient
	SELECT @appTypeID = AP.appTypeId,
		@subclientStatus = AP.subclientStatus
	FROM APP_Application AP WITH (NOLOCK) WHERE id = @subClientId
	SET @mssqlSubClientType = (SELECT TOP 1 attrVal FROM APP_SubClientProp WITH (NOLOCK)
								WHERE componentNameId= @subClientId AND attrName = 'mssql subclient type' AND modified = 0
									AND cs_attrName = CHECKSUM(N'mssql subclient type'))
	-- For DNB subclient, SQL properties are not set by default.
	-- Consider setting the subclient type flag to '1' when following conditions meet.
	--	1. MSSQL Subclient
	--	2. DNB subclient.
	--	3. SQL Subclient Type is not found.
	--		Earlier query will set the value as 'NULL' when property not found.
	IF (@appTypeID = 81
			AND @subclientStatus & 32 = 32
			AND @mssqlSubClientType IS NULL)
	BEGIN
		SET @mssqlSubClientType = 1
	END
	SET @derivedSubclientPropType = (SELECT ISNULL((SELECT @inContent.value('(/Content/@derivedSubclientPropType)[1]','int')),0))
	--Identify Derived property type of the given subClient
IF @appTypeID = 81 AND @mssqlSubClientType = 1
		SET @propertyType = 118
ELSE IF @appTypeID = 81 AND @mssqlSubClientType = 2
		SET @propertyType = 119
ELSE IF @appTypeID = 5
		SET @propertyType = 116
ELSE IF @appTypeID = 53
		SET @propertyType = 112
ELSE IF @appTypeID = 59
OR @appTypeID = 77
		SET @propertyType = 102
ELSE IF @appTypeID = 104
		SET @propertyType = 120
ELSE IF @appTypeID = 125
		SET @propertyType = 122
ELSE IF @appTypeID = 33
OR @appTypeID = 11
OR @appTypeID = 33
OR @appTypeID = 34
OR @appTypeID = 42
OR @appTypeID = 43
OR @appTypeID = 13
OR @appTypeID = 1030
		SET @propertyType = 2
ELSE IF (@appTypeID = 17 OR @appTypeID = 18 OR @appTypeID = 17 OR @appTypeID = 19 OR @appTypeID = 20 OR @appTypeID = 19 OR @appTypeID = 21 OR @appTypeID = 29 OR @appTypeID = 38 OR @appTypeID = 36 OR @appTypeID = 63 OR @appTypeID = 64 OR @appTypeID = 74) AND ( @derivedSubclientPropType = 1 OR @derivedSubclientPropType = 2 )
		SET @propertyType = 124
ELSE IF @appTypeID = 134
		SET @propertyType = 134
	ELSE
		BEGIN
			SET @errCode = 1
			SET @errString = 'Unable to identify derived property type of subclient[' + CAST(@subClientId as NVARCHAR(MAX)) + ']'
			GOTO SKIP
		END
	--Property type specific code:MSSQL---------------------------------------------------------------------------------------------------------------
	IF @propertyType = 118 --PROPERTY_MSSQL_DB
	BEGIN
			IF @operationType = 1 -- OVERWRITE operation, logically delete all available contents of given subclient
			BEGIN
				UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrType = @propertyType AND modified = 0
				SET @modified = 1
			END
			--Iteriate through all input contents and perform ADD/OVERWRITE/DELETE operation
			DECLARE ContentCur	CURSOR FOR SELECT attrName, attrVal FROM @InputContents
			OPEN ContentCur
				FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				WHILE @@FETCH_STATUS = 0
				BEGIN
					SET @existingContent = (SELECT attrVal FROM APP_SubClientProp WITH (NOLOCK) where componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0)
					DECLARE @existingDatabaseID INT = 0
					DECLARE @existingDiscoverType INT = 0
					DECLARE @newDatabaseID INT = 0
					DECLARE @newDiscoverType INT = 0
					IF @operationType = 2 -- This is Add operation, get values of existing @content.
					BEGIN
						IF @existingContent <> ''
							SELECT
								@existingDatabaseID = CASE WHEN Id = 1 THEN Data ELSE @existingDatabaseID END,
								@existingDiscoverType = CASE WHEN Id = 2 THEN Data ELSE @existingDiscoverType END
								FROM SplitString(@existingContent,' ')
					END
					SELECT
						@newDatabaseID = CASE WHEN Id = 1 THEN Data ELSE @newDatabaseID END,
						@newDiscoverType = CASE WHEN Id = 2 THEN Data ELSE @newDiscoverType END
						FROM SplitString(@attrVal,' ')
IF @newDatabaseID = -99999
						SET @newDatabaseID = @existingDatabaseID
IF @newDiscoverType = -99999
						SET @newDiscoverType = @existingDiscoverType
					SET @attrVal = CAST(@newDatabaseID as NVARCHAR(MAX)) + ' ' + CAST(@newDiscoverType as NVARCHAR(MAX))
					IF @operationType = 1 OR @operationType = 2 -- 1:Overwrite operation, 2:Add operation, Add new content.
					BEGIN
						EXEC dbo.AppCheckIfContentExists @subClientId, @propertyType, @attrName, @errCode OUTPUT, @errString OUTPUT
						IF @errCode <> 0
						BEGIN
							CLOSE ContentCur
							DEALLOCATE ContentCur
							GOTO SKIP
						END
						UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
						INSERT app_subClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
						VALUES (@subClientId, @attrName, @propertyType, @attrVal, @nowTime, 0, 0)
						SET @modified = 1
					END
					IF @operationType = 3 -- 3:Delete operation, logically delete content
					BEGIN
						UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
						SET @modified = 1
					END
					FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				END--END ContentCur fetch loop
			CLOSE ContentCur
			DEALLOCATE ContentCur
			--Set last @content change value
			IF @modified = 1
			BEGIN
				UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = 'last content change' AND attrType = 10 AND modified = 0
				INSERT app_subClientProp (componentNameId, [attrName], [attrType],  [attrVal], created, modified, ccpId)
					VALUES (@subClientId, 'last content change', 10, @nowTime, @nowTime, 0, 0)
			END
	END -- End of PROPERTY_MSSQL_DB
	--------------------------------------------------------------------------------------------------------------------------------------------------
	--Property type specific code:MSSQL---------------------------------------------------------------------------------------------------------------
	IF @propertyType = 119 --PROPERTY_MSSQL_FFG
	BEGIN
			IF @operationType = 1 -- OVERWRITE operation, logically delete all available contents of given subclient
			BEGIN
				UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrType = @propertyType AND modified = 0
				SET @modified = 1
			END
			--Iteriate through all input contents and perform ADD/OVERWRITE/DELETE operation
			DECLARE ContentCur	CURSOR FOR SELECT attrName, attrVal FROM @InputContents
			OPEN ContentCur
				FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				WHILE @@FETCH_STATUS = 0
				BEGIN
					SET @existingContent = (SELECT attrVal FROM APP_SubClientProp WITH (NOLOCK) where componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0)
					DECLARE @existingFileID INT = 0
					DECLARE @existingFileGroupId INT = 0
					DECLARE @existingIsFile INT = 0
					DECLARE @existingFGDiscoverType INT = 0
					DECLARE @newFileID INT = 0
					DECLARE @newFileGroupId INT = 0
					DECLARE @newIsFile INT = 0
					DECLARE @newFGDiscoverType INT = 0
					IF @operationType = 2 -- This is Add operation, get values of existing @content.
					BEGIN
						IF @existingContent <> ''
						SELECT
							@existingFileID = CASE WHEN Id = 1 THEN Data ELSE @existingFileID END,
							@existingFileGroupId = CASE WHEN Id = 2 THEN Data ELSE @existingFileGroupId END,
							@existingIsFile = CASE WHEN Id = 3 THEN Data ELSE @existingIsFile END,
							@existingFGDiscoverType = CASE WHEN Id = 4 THEN Data ELSE @existingFGDiscoverType END
							FROM SplitString(@existingContent,' ')
					END
					SELECT
						@newFileID = CASE WHEN Id = 1 THEN Data ELSE @newFileID END,
						@newFileGroupId = CASE WHEN Id = 2 THEN Data ELSE @newFileGroupId END,
						@newIsFile = CASE WHEN Id = 3 THEN Data ELSE @newIsFile END,
						@newFGDiscoverType = CASE WHEN Id = 4 THEN Data ELSE @newFGDiscoverType END
						FROM SplitString(@attrVal,' ')
IF @newFileID = -99999
						SET @newFileID = @existingFileID
IF @newFileGroupId = -99999
						SET @newFileGroupId = @existingFileGroupId
IF @newIsFile = -99999
						SET @newIsFile = @existingIsFile
IF @newFGDiscoverType = -99999
						SET @newFGDiscoverType = @existingFGDiscoverType
					SET @attrVal = CAST(@newFileID as NVARCHAR(MAX)) + ' '
									+ CAST(@newFileGroupId as NVARCHAR(MAX)) + ' '
									+ CAST(@newIsFile as NVARCHAR(MAX)) + ' '
									+ CAST(@newFGDiscoverType as NVARCHAR(MAX)) + ' '
					IF @operationType = 1 OR @operationType = 2 -- 1:Overwrite operation, 2:Add operation, Add new content.
					BEGIN
						EXEC dbo.AppCheckIfContentExists @subClientId, @propertyType, @attrName, @errCode OUTPUT, @errString OUTPUT
						IF @errCode <> 0
						BEGIN
							CLOSE ContentCur
							DEALLOCATE ContentCur
							GOTO SKIP
						END
						UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
						INSERT app_subClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
						VALUES (@subClientId, @attrName, @propertyType, @attrVal, @nowTime, 0, 0)
						SET @modified = 1
					END
					IF @operationType = 3 -- 3:Delete operation, logically delete content
					BEGIN
						UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
						SET @modified = 1
					END
					FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				END--END ContentCur fetch loop
			CLOSE ContentCur
			DEALLOCATE ContentCur
			--Set last @content change value
			IF @modified = 1
			BEGIN
				UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = 'last content change' AND attrType = 10 AND modified = 0
				INSERT app_subClientProp (componentNameId, [attrName], [attrType],  [attrVal], created, modified, ccpId)
					VALUES (@subClientId, 'last content change', 10, @nowTime, @nowTime, 0, 0)
			END
	END -- End of PROPERTY_MSSQL_FFG
	--------------------------------------------------------------------------------------------------------------------------------------------------
	--Property type specific code:MSSQL---------------------------------------------------------------------------------------------------------------
	IF @propertyType = 116 --PROPERTY_SYBASE
	BEGIN
			IF @operationType = 1 -- OVERWRITE operation, logically delete all available contents of given subclient
			BEGIN
				UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrType = @propertyType AND modified = 0
				SET @modified = 1
			END
			--Iteriate through all input contents and perform ADD/OVERWRITE/DELETE operation
			DECLARE ContentCur	CURSOR FOR SELECT attrName, attrVal FROM @InputContents
			OPEN ContentCur
				FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				WHILE @@FETCH_STATUS = 0
				BEGIN
					SET @existingContent = (SELECT attrVal FROM APP_SubClientProp WITH (NOLOCK) where componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0)
					DECLARE @existingSybaseDatabaseId INT = 0
					DECLARE @existingDatabaseSize INT = 0
					DECLARE @existingCreationTime INT = 0
					DECLARE @existingOptions INT = 0
					DECLARE @existingOptions2 INT = 0
					DECLARE @existingSystemFlags INT = 0
					DECLARE @existingStatus INT = 0
					DECLARE @existingStatus2 INT = 0
					DECLARE @existingDbRecoveryOrder VARCHAR(MAX) = '0'
					DECLARE @existingOwner VARCHAR(MAX) = '0'
					DECLARE @newSybaseDatabaseId INT = 0
					DECLARE @newDatabaseSize INT = 0
					DECLARE @newCreationTime INT = 0
					DECLARE @newOptions INT = 0
					DECLARE @newOptions2 INT = 0
					DECLARE @newSystemFlags INT = 0
					DECLARE @newStatus INT = 0
					DECLARE @newStatus2 INT = 0
					DECLARE @newDbRecoveryOrder VARCHAR(MAX) = '0'
					DECLARE @newOwner VARCHAR(MAX) = '0'
					IF @operationType = 2 -- This is Add operation, get values of existing @content.
					BEGIN
						IF @existingContent <> ''
						SELECT
							@existingSybaseDatabaseId = CASE WHEN Id = 1 THEN Data ELSE @existingSybaseDatabaseId END,
							@existingDatabaseSize = CASE WHEN Id = 2 THEN Data ELSE @existingDatabaseSize END,
							@existingCreationTime = CASE WHEN Id = 3 THEN Data ELSE @existingCreationTime END,
							@existingOptions = CASE WHEN Id = 4 THEN Data ELSE @existingOptions END,
							@existingOptions2 = CASE WHEN Id = 5 THEN Data ELSE @existingOptions2 END,
							@existingSystemFlags = CASE WHEN Id = 6 THEN Data ELSE @existingSystemFlags END,
							@existingStatus = CASE WHEN Id = 7 THEN Data ELSE @existingStatus END,
							@existingStatus2 = CASE WHEN Id = 8 THEN Data ELSE @existingStatus2 END,
							@existingDbRecoveryOrder = CASE WHEN Id = 9 THEN Data ELSE @existingDbRecoveryOrder END,
							@existingOwner = CASE WHEN Id = 10 THEN Data ELSE @existingOwner END
							FROM SplitString(@existingContent,' ')
					END
					SELECT
						@newSybaseDatabaseId = CASE WHEN Id = 1 THEN Data ELSE @newSybaseDatabaseId END,
						@newDatabaseSize = CASE WHEN Id = 2 THEN Data ELSE @newDatabaseSize END,
						@newCreationTime = CASE WHEN Id = 3 THEN Data ELSE @newCreationTime END,
						@newOptions = CASE WHEN Id = 4 THEN Data ELSE @newOptions END,
						@newOptions2 = CASE WHEN Id = 5 THEN Data ELSE @newOptions2 END,
						@newSystemFlags = CASE WHEN Id = 6 THEN Data ELSE @newSystemFlags END,
						@newStatus = CASE WHEN Id = 7 THEN Data ELSE @newStatus END,
						@newStatus2 = CASE WHEN Id = 8 THEN Data ELSE @newStatus2 END,
						@newDbRecoveryOrder = CASE WHEN Id = 9 THEN Data ELSE @newDbRecoveryOrder END,
						@newOwner = CASE WHEN Id = 10 THEN Data ELSE @newOwner END
						FROM SplitString(@attrVal,' ')
IF @newSybaseDatabaseId = -99999
						SET @newSybaseDatabaseId = @existingSybaseDatabaseId
IF @newDatabaseSize = -99999
						SET @newDatabaseSize = @existingDatabaseSize
IF @newCreationTime = -99999
						SET @newCreationTime = @existingCreationTime
IF @newOptions = -99999
						SET @newOptions = @existingOptions
IF @newOptions2 = -99999
						SET @newOptions2 = @existingOptions2
IF @newSystemFlags = -99999
						SET @newSystemFlags = @existingSystemFlags
IF @newStatus = -99999
						SET @newStatus = @existingStatus
IF @newStatus2 = -99999
						SET @newStatus2 = @existingStatus2
					IF @newDbRecoveryOrder = '-99999'
						SET @newDbRecoveryOrder = @existingDbRecoveryOrder
					IF @newOwner = '-99999'
						SET @newOwner = @existingOwner
					SET @attrVal = CAST(@newSybaseDatabaseId as NVARCHAR(MAX)) + ' '
									+ CAST(@newDatabaseSize as NVARCHAR(MAX)) + ' '
									+ CAST(@newCreationTime as NVARCHAR(MAX)) + ' '
									+ CAST(@newOptions as NVARCHAR(MAX)) + ' '
									+ CAST(@newOptions2 as NVARCHAR(MAX)) + ' '
									+ CAST(@newSystemFlags as NVARCHAR(MAX)) + ' '
									+ CAST(@newStatus as NVARCHAR(MAX)) + ' '
									+ CAST(@newStatus2 as NVARCHAR(MAX)) + ' '
									+ @newDbRecoveryOrder + ' '
									+ @newOwner + ' '
					IF @operationType = 1 OR @operationType = 2 -- 1:Overwrite operation, 2:Add operation, Add new content.
					BEGIN
						EXEC dbo.AppCheckIfContentExists @subClientId, @propertyType, @attrName, @errCode OUTPUT, @errString OUTPUT
						IF @errCode <> 0
						BEGIN
							CLOSE ContentCur
							DEALLOCATE ContentCur
							GOTO SKIP
						END
						UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
						INSERT app_subClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
						VALUES (@subClientId, @attrName, @propertyType, @attrVal, @nowTime, 0, 0)
						SET @modified = 1
					END
					IF @operationType = 3 -- 3:Delete operation, logically delete content
					BEGIN
						UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
						SET @modified = 1
					END
					FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				END--END ContentCur fetch loop
			CLOSE ContentCur
			DEALLOCATE ContentCur
	END -- End of PROPERTY_SYBASE
	--------------------------------------------------------------------------------------------------------------------------------------
	--Property type specific code:ExchangeDB---------------------------------------------------------------------------------------------------------------
	IF @propertyType = 112 --PROPERTY_EXCHANGE_DB
	BEGIN
			IF @derivedSubclientPropType = 126 --PROPERTY_DAG_DBSERVER
			BEGIN
				IF @operationType = 4 -- CLEAR operation, remove servers of all exchange DBs
				BEGIN
					UPDATE APP_SubClientProp SET attrVal = ''
					WHERE componentNameId = @subClientId AND attrType = @derivedSubclientPropType AND modified = 0
					SET @modified = 1
				END
				IF @operationType = 1 -- OVERWRITE operation, logically delete all available contents of given subclient
				BEGIN
					UPDATE APP_SubClientProp SET modified = @nowTime WHERE componentNameId = @subClientId AND attrType = @derivedSubclientPropType AND modified = 0
					SET @modified = 1
				END
				--Iteriate through all input contents and perform ADD/OVERWRITE/DELETE operation
				DECLARE ContentCur	CURSOR FOR SELECT attrName, attrVal FROM @InputContents
				OPEN ContentCur
					FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
					WHILE @@FETCH_STATUS = 0
					BEGIN
						IF @operationType = 1  --delete existing entries on overwrite operation
						BEGIN
						DELETE APP_SubClientProp WHERE componentNameId = @subClientId AND attrType = @derivedSubclientPropType --PROPERTY_DAG_DBSERVER
						END
						IF @operationType = 1 OR @operationType = 2 -- 1:Overwrite operation, 2:Add operation, Add new content.
						BEGIN
							INSERT app_subClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
							VALUES (@subClientId, @attrName, @derivedSubclientPropType, @attrVal, @nowTime, 0, 0)
							SET @modified = 1
						END
						IF @operationType = 3 -- 3:Delete operation, logically delete content
						BEGIN
							UPDATE APP_SubClientProp SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @derivedSubclientPropType AND modified = 0
							SET @modified = 1
						END
						FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
					END--END ContentCur fetch loop
				CLOSE ContentCur
				DEALLOCATE ContentCur
			END
			ELSE
			BEGIN
				IF @operationType = 1 -- OVERWRITE operation, logically delete all available contents of given subclient
				BEGIN
					UPDATE APP_SubClientProp SET modified = @nowTime WHERE componentNameId = @subClientId AND attrType = @propertyType AND modified = 0
					SET @modified = 1
				END
				--Iteriate through all input contents and perform ADD/OVERWRITE/DELETE operation
				DECLARE ContentCur	CURSOR FOR SELECT attrName, attrVal FROM @InputContents
				OPEN ContentCur
					FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
					WHILE @@FETCH_STATUS = 0
					BEGIN
						IF @operationType = 1 OR @operationType = 2 -- 1:Overwrite operation, 2:Add operation, Add new content.
						BEGIN
							EXEC dbo.AppCheckIfContentExists @subClientId, @propertyType, @attrName, @errCode OUTPUT, @errString OUTPUT
							IF @errCode <> 0
							BEGIN
								CLOSE ContentCur
								DEALLOCATE ContentCur
								GOTO SKIP
							END
							UPDATE APP_SubClientProp SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
							INSERT app_subClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
							VALUES (@subClientId, @attrName, @propertyType, @attrVal, @nowTime, 0, 0)
							SET @modified = 1
						END
						IF @operationType = 3 -- 3:Delete operation, logically delete content
						BEGIN
							UPDATE APP_SubClientProp SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
							SET @modified = 1
						END
						FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
					END--END ContentCur fetch loop
				CLOSE ContentCur
				DEALLOCATE ContentCur
				--Set last @content change value
				IF @modified = 1
				BEGIN
					UPDATE APP_SubClientProp SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = 'last content change' AND attrType = 10 AND modified = 0
					INSERT app_subClientProp (componentNameId, [attrName], [attrType],  [attrVal], created, modified, ccpId)
						VALUES (@subClientId, 'last content change', 10, @nowTime, @nowTime, 0, 0)
				END
			END-- else of @derivedSubclientPropType = 126
	END -- End of PROPERTY_EXCHANGE_DB
	--------------------------------------------------------------------------------------------------------------------------------------------------
	--Property type specific code:LotusNotesDB---------------------------------------------------------------------------------------------------------------
	IF @propertyType = 102 --PROPERTY_LNOTES_DB
	BEGIN
			IF @operationType = 1 -- OVERWRITE operation, logically delete all available contents of given subclient
			BEGIN
				UPDATE APP_SubClientProp SET modified = @nowTime WHERE componentNameId = @subClientId AND attrType = @propertyType AND modified = 0
				SET @modified = 1
			END
			--Iteriate through all input contents and perform ADD/OVERWRITE/DELETE operation
			DECLARE ContentCur	CURSOR FOR SELECT attrName, attrVal FROM @InputContents
			OPEN ContentCur
				FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				WHILE @@FETCH_STATUS = 0
				BEGIN
					SET @existingContent = (SELECT attrVal FROM APP_SubClientProp WITH (NOLOCK) where componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0)
					DECLARE @existingdatabaseTitle NVARCHAR(MAX) = '0'
					DECLARE @existingdbiid VARCHAR(MAX) = '0'
					DECLARE @existingdbiid1 VARCHAR(MAX) = '0'
					DECLARE @existingdbiid2 VARCHAR(MAX) = '0'
					DECLARE @existingdbiid3 VARCHAR(MAX) = '0'
					DECLARE @existingdbiid4 VARCHAR(MAX) = '0'
					DECLARE @newdatabaseTitle NVARCHAR(MAX) = '0'
					DECLARE @newdbiid VARCHAR(MAX) = '0'
					DECLARE @newdbiid1 VARCHAR(MAX) = '0'
					DECLARE @newdbiid2 VARCHAR(MAX) = '0'
					DECLARE @newdbiid3 VARCHAR(MAX) = '0'
					DECLARE @newdbiid4 VARCHAR(MAX) = '0'
					IF @operationType = 2 -- This is Add operation, get values of existing @content.
					BEGIN
						IF @existingContent <> ''
						SELECT
							@existingdatabaseTitle = CASE WHEN Id = 1 THEN Data ELSE @existingdatabaseTitle END,
							@existingdbiid = CASE WHEN Id = 2 THEN Data ELSE @existingdbiid END
							FROM SplitString(@existingContent,' ')
						SELECT
							@existingdbiid1 = CASE WHEN Id = 1 THEN Data ELSE @existingdbiid1 END,
							@existingdbiid2 = CASE WHEN Id = 2 THEN Data ELSE @existingdbiid2 END,
							@existingdbiid3 = CASE WHEN Id = 3 THEN Data ELSE @existingdbiid3 END,
							@existingdbiid4 = CASE WHEN Id = 4 THEN Data ELSE @existingdbiid4 END
							FROM SplitString(@existingdbiid,':')
					END
					SELECT
							@newdatabaseTitle = CASE WHEN Id = 1 THEN Data ELSE @newdatabaseTitle END,
							@newdbiid = CASE WHEN Id = 2 THEN Data ELSE @newdbiid END
							FROM SplitString(@attrVal,' ')
					SELECT
							@newdbiid1 = CASE WHEN Id = 1 THEN Data ELSE @newdbiid1 END,
							@newdbiid2 = CASE WHEN Id = 2 THEN Data ELSE @newdbiid2 END,
							@newdbiid3 = CASE WHEN Id = 3 THEN Data ELSE @newdbiid3 END,
							@newdbiid4 = CASE WHEN Id = 4 THEN Data ELSE @newdbiid4 END
							FROM SplitString(@newdbiid,':')
					IF @newdatabaseTitle = '-99999'
						SET @newdatabaseTitle = @existingdatabaseTitle
IF @newdbiid1 = -99999
						SET @newdbiid1 = @existingdbiid1
IF @newdbiid2 = -99999
						SET @newdbiid2 = @existingdbiid2
IF @newdbiid3 = -99999
						SET @newdbiid3 = @existingdbiid3
IF @newdbiid4 = -99999
						SET @newdbiid4 = @existingdbiid4
					SET @attrVal = CAST(@newdatabaseTitle as NVARCHAR(MAX)) + ' '
									+ CAST(@newdbiid1 as NVARCHAR(MAX)) + ':'
									+ CAST(@newdbiid2 as NVARCHAR(MAX)) + ':'
									+ CAST(@newdbiid3 as NVARCHAR(MAX)) + ':'
									+ CAST(@newdbiid4 as NVARCHAR(MAX)) + ' nothing 0 0'
					IF @operationType = 1 OR @operationType = 2 -- 1:Overwrite operation, 2:Add operation, Add new content.
					BEGIN
						EXEC dbo.AppCheckIfContentExists @subClientId, @propertyType, @attrName, @errCode OUTPUT, @errString OUTPUT
						IF @errCode <> 0
						BEGIN
							CLOSE ContentCur
							DEALLOCATE ContentCur
							GOTO SKIP
						END
						UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
						INSERT app_subClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
						VALUES (@subClientId, @attrName, @propertyType, @attrVal, @nowTime, 0, 0)
						SET @modified = 1
					END
					IF @operationType = 3 -- 3:Delete operation, logically delete content
					BEGIN
						UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
						SET @modified = 1
					END
					FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				END--END ContentCur fetch loop
			CLOSE ContentCur
			DEALLOCATE ContentCur
			--Set last @content change value
			IF @modified = 1
			BEGIN
				UPDATE APP_SubClientProp SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = 'last content change' AND attrType = 10 AND modified = 0
				INSERT app_subClientProp (componentNameId, [attrName], [attrType],  [attrVal], created, modified, ccpId)
					VALUES (@subClientId, 'last content change', 10, @nowTime, @nowTime, 0, 0)
			END
	END -- End of PROPERTY_LNOTES_DB
	--------------------------------------------------------------------------------------------------------------------------------------------------
	--Property type specific code:PROPERTY_MYSQL---------------------------------------------------------------------------------------------------------------
	IF @propertyType = 120 --PROPERTY_MYSQL
	BEGIN
			IF @operationType = 1 -- OVERWRITE operation, logically delete all available contents of given subclient
			BEGIN
				UPDATE APP_SubClientProp SET modified = @nowTime WHERE componentNameId = @subClientId AND attrType = @propertyType AND modified = 0
			END
			--Iteriate through all input contents and perform ADD/OVERWRITE/DELETE operation
			DECLARE ContentCur	CURSOR FOR SELECT attrName, attrVal FROM @InputContents
			OPEN ContentCur
				FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				WHILE @@FETCH_STATUS = 0
				BEGIN
					IF @operationType = 2 --2:Add operation, skip content if it exists.
					BEGIN
						IF EXISTS (SELECT * FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0)
						BEGIN
							FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
							CONTINUE
						END
					END
					IF @operationType = 1 OR @operationType = 2 -- 1:Overwrite operation, 2:Add operation, Add new content.
					BEGIN
						INSERT APP_SubClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
						VALUES (@subClientId, @attrName, @propertyType, @attrVal, @nowTime, 0, 0)
					END
					IF @operationType = 3 -- 3:Delete operation, logically delete content
					BEGIN
						UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
					END
					FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				END--END ContentCur fetch loop
			CLOSE ContentCur
			DEALLOCATE ContentCur
	END -- End of PROPERTY_MYSQL
	--------------------------------------------------------------------------------------------------------------------------------------------------
	--Property type specific code:PROPERTY_POSTGRESQL---------------------------------------------------------------------------------------------------------------
	IF @propertyType = 122 --PROPERTY_POSTGRESQL
	BEGIN
			IF @operationType = 1 -- OVERWRITE operation, logically delete all available contents of given subclient
			BEGIN
				UPDATE APP_SubClientProp SET modified = @nowTime WHERE componentNameId = @subClientId AND attrType = @propertyType AND modified = 0
			END
			--Iteriate through all input contents and perform ADD/OVERWRITE/DELETE operation
			DECLARE ContentCur	CURSOR FOR SELECT attrName, attrVal FROM @InputContents
			OPEN ContentCur
				FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				WHILE @@FETCH_STATUS = 0
				BEGIN
					DECLARE @dbSize			VARCHAR(MAX) = '0'
					DECLARE @creationTime	VARCHAR(MAX) = '0'
					SELECT	@dbSize = CASE WHEN Id = 1 THEN Data ELSE @dbSize END,
							@creationTime = CASE WHEN Id = 2 THEN Data ELSE @creationTime END
							FROM SplitString(@attrVal,' ')
					SET @attrVal = @dbSize + ' ' + @creationTime
					IF @operationType = 2 --2:Add operation, skip content if it exists.
					BEGIN
						IF EXISTS (SELECT * FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0)
						BEGIN
							FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
							CONTINUE
						END
					END
					IF @operationType = 1 OR @operationType = 2 -- 1:Overwrite operation, 2:Add operation, Add new content.
					BEGIN
						EXEC dbo.AppCheckIfContentExists @subClientId, @propertyType, @attrName, @errCode OUTPUT, @errString OUTPUT
						IF @errCode <> 0
						BEGIN
							CLOSE ContentCur
							DEALLOCATE ContentCur
							GOTO SKIP
						END
						INSERT app_subClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
						VALUES (@subClientId, @attrName, @propertyType, @attrVal, @nowTime, 0, 0)
					END
					IF @operationType = 3 -- 3:Delete operation, logically delete content
					BEGIN
						UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
					END
					FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				END--END ContentCur fetch loop
			CLOSE ContentCur
			DEALLOCATE ContentCur
	END -- End of PROPERTY_POSTGRESQL
	--------------------------------------------------------------------------------------------------------------------------------------------------
	--Property type specific code:UNIX FS---------------------------------------------------------------------------------------------------------------
IF @propertyType = 124 AND @derivedSubclientPropType = 1 --PROPERTY_UNIX_SYMBOLIC_LINK
	BEGIN
		IF @operationType = 1 -- OVERWRITE operation, logically delete all available contents of given subclient
			BEGIN
				UPDATE APP_SubClientProp SET modified = @nowTime WHERE componentNameId = @subClientId AND attrType = @propertyType AND modified = 0
			END
			--Iteriate through all input contents and perform ADD/OVERWRITE/DELETE operation
			DECLARE ContentCur	CURSOR FOR SELECT attrName, attrVal FROM @InputContents
			OPEN ContentCur
				FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				WHILE @@FETCH_STATUS = 0
				BEGIN
					--attrVal of Symbolic link is stored in following format
					SET @attrVal = REPLACE(@attrVal, '+1', 0x15) --@attrVal + char(0x15) + @attrName
					IF @operationType = 2 --2:Add operation, skip content if it exists.
					BEGIN
						IF EXISTS (SELECT * FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0)
						BEGIN
							FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
							CONTINUE
						END
					END
					IF @operationType = 1 OR @operationType = 2 -- 1:Overwrite operation, 2:Add operation, Add new content.
					BEGIN
						EXEC dbo.AppCheckIfContentExists @subClientId, @propertyType, @attrName, @errCode OUTPUT, @errString OUTPUT
						IF @errCode <> 0
						BEGIN
							CLOSE ContentCur
							DEALLOCATE ContentCur
							GOTO SKIP
						END
						INSERT app_subClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
						VALUES (@subClientId, @attrName, @propertyType, @attrVal, @nowTime, 0, 0)
					END
					IF @operationType = 3 -- 3:Delete operation, logically delete content
					BEGIN
						UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
					END
					FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				END--END ContentCur fetch loop
			CLOSE ContentCur
			DEALLOCATE ContentCur
	END -- End of PROPERTY_UNIX_SYMBOLIC_LINK
IF @propertyType = 124 AND @derivedSubclientPropType = 2  --PROPERTY_UNIX_SYMBOLIC_LINK
	BEGIN
		UPDATE APP_SubClientProp SET modified = @nowTime WHERE componentNameId = @subClientId AND attrType = @propertyType AND modified = 0
	END
	--------------------------------------------------------------------------------------------------------------------------------------------------
	--Property type specific code:PROPERTY_CLOUDCONNECTOR_MAIL/MEDIA---------------------------------------------------------------------------------------------------------------
	IF @propertyType = 134 --PROPERTY_CLOUDCONNECTOR_MAIL/MEDIA
	BEGIN
			SET @cloudConnectorContentType = (	SELECT  ISNULL(ref.value('@attrType', 'NVARCHAR(50)') , '')
												FROM    @inContent.nodes('CC_Content') R ( ref ))
			IF @operationType = 1 -- OVERWRITE operation, logically delete all available contents of given subclient
			BEGIN
				IF @cloudConnectorContentType <> ''
				BEGIN
					UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime
					WHERE componentNameId = @subClientId AND attrType = @propertyType AND attrVal = @cloudConnectorContentType AND modified = 0
				END
				ELSE
				BEGIN
					SET @errCode 	= -1
					SET @errString 	= 'No Content Type set. Cannot proceed with Operation'
					GOTO SKIP
				END
			END
			--Iteriate through all input contents and perform ADD/OVERWRITE/DELETE operation
			DECLARE ContentCur	CURSOR FOR SELECT attrName, attrVal FROM @InputContents
			OPEN ContentCur
				FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				WHILE @@FETCH_STATUS = 0
				BEGIN
					IF @operationType = 2 --2:Add operation, skip content if it exists.
					BEGIN
						IF EXISTS (SELECT 1 FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0)
						BEGIN
							FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
							CONTINUE
						END
					END
					IF @operationType = 1 OR @operationType = 2 -- 1:Overwrite operation, 2:Add operation, Add new content.
					BEGIN
						INSERT APP_SubClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
						VALUES (@subClientId, @attrName, @propertyType, @attrVal, @nowTime, 0, 0)
					END
					IF @operationType = 3 -- 3:Delete operation, logically delete content
					BEGIN
						UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
					END
					FETCH NEXT FROM ContentCur INTO @attrName, @attrVal
				END--END ContentCur fetch loop
			CLOSE ContentCur
			DEALLOCATE ContentCur
			DELETE FROM APP_SubClientProp WHERE componentNameId = @subClientId and attrType = @propertyType AND modified <> 0
	END -- End of PROPERTY_CLOUDCONNECTOR_MAIL/MEDIA
	--------------------------------------------------------------------------------------------------------------------------------------------------
	--Property type specific code:FS---------------------------------------------------------------------------------------------------------------
	IF @propertyType = 2 --PROPERTY_BOOLEAN
	BEGIN
		SET @attrName = (SELECT attrName FROM @InputContents)
		SET @attrVal = (SELECT attrVal FROM @InputContents)
		IF @attrName = 'System State'
		BEGIN
			IF @attrVal = '1'
			BEGIN
				DECLARE @dupSubClientIdSystemState INT = 0
				DECLARE dupSystemStateCur CURSOR FOR (SELECT componentNameId FROM APP_SubClientProp WITH (NOLOCK) WHERE attrName = @attrName AND attrVal = 1 AND modified = 0 AND componentNameId <> @subClientId)
				OPEN dupSystemStateCur
					FETCH NEXT FROM dupSystemStateCur INTO @dupSubClientIdSystemState
					WHILE @@FETCH_STATUS = 0
					BEGIN
						IF (SELECT clientid FROM APP_Application WITH (NOLOCK) WHERE id = @dupSubClientIdSystemState) = (SELECT clientid FROM APP_Application WITH (NOLOCK) WHERE id = @subClientId)
						AND (SELECT backupSet FROM APP_Application WITH (NOLOCK) WHERE id = @dupSubClientIdSystemState) = (SELECT backupSet FROM APP_Application WITH (NOLOCK) WHERE id = @subClientId)
AND ((SELECT subclientStatus FROM APP_Application WITH (NOLOCK) WHERE id = @dupSubClientIdSystemState) & 0x00004) != 0x00004
						BEGIN
							DECLARE @dupSubClientNameSystemState VARCHAR(MAX) = (SELECT subclientName FROM APP_Application WHERE id = @dupSubClientIdSystemState)
							SET @errCode = 1
							SET @errString = 'Backup System State is enabled for subClient[' + CAST(@dupSubClientIdSystemState as NVARCHAR(MAX)) + '][' + @dupSubClientNameSystemState + '].Please disable Backup system state from subclient[' + CAST(@dupSubClientIdSystemState as NVARCHAR(MAX)) + '][' + @dupSubClientNameSystemState + '].'
							CLOSE dupSystemStateCur
							DEALLOCATE dupSystemStateCur
							GOTO SKIP
						END
						FETCH NEXT FROM dupSystemStateCur INTO @dupSubClientIdSystemState
					END--END dupSystemStateCur fetch loop
				CLOSE dupSystemStateCur
				DEALLOCATE dupSystemStateCur
				IF ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable Snap Backups' AND modified = 0), 0) != 0
				AND ((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId=@subclientId AND attrName = 'Use block level backup' AND modified = 0) <> 1 OR (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId=@subclientId AND attrName = 'Snap Engine' AND modified = 0) <> 1)
				BEGIN
					SET @errCode = 1
					SET @errString = 'System State Backups are not supported with SnapProtect subclients.'
					GOTO SKIP
				END
			END
			UPDATE APP_SubClientProp WITH (ROWLOCK) SET modified = @nowTime WHERE componentNameId = @subClientId AND attrName = @attrName AND attrType = @propertyType AND modified = 0
			INSERT App_SubClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
			VALUES (@subClientId, @attrName, @propertyType, @attrVal, @nowTime, 0, 0)
			--changes for supporting "System State on Full Backup Only" from cmdline
			IF @attrVal = '0'
			BEGIN
				--set "System State on Full Backup Only" to '0' for this subclient - mandatory
				IF EXISTS (SELECT * FROM APP_SubClientProp WITH (NOLOCK) WHERE attrName = 'System State on Full Backup Only' AND attrVal = '1' AND componentNameId = @subClientId AND modified = 0)
				BEGIN
					UPDATE APP_SubClientProp WITH (ROWLOCK)
					SET modified = @nowTime
					WHERE attrName = 'System State on Full Backup Only' AND attrVal = '1' AND componentNameId = @subClientId AND modified = 0
					INSERT INTO APP_SubClientProp(componentNameId, attrName,attrtype,attrVal, created, modified, ccpId)
					VALUES (@subClientId, 'System State on Full Backup Only',2,'0',@nowTime,0,0)
				END
			END
		END
		--changes for supporting "System State on Full Backup Only" from cmdline
		IF @attrName = 'System State on Full Backup Only'
		BEGIN
			--check if the value of 'System State' for this subclient is '1', if so then only honor this value
			IF EXISTS (SELECT * FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subClientId AND attrName = 'System State' AND attrVal = '1' AND modified = 0)
			BEGIN
				--verify with old value, if diffed then modify else leave as it is
				IF NOT EXISTS(SELECT * FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subClientId AND attrName = @attrname AND attrVal = @attrVal AND modified = 0)
				BEGIN
					UPDATE APP_SubClientProp WITH (ROWLOCK)
					SET modified = @nowTime
					WHERE attrName = @attrname AND componentNameId = @subClientId AND modified = 0
					INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					VALUES(@subClientId, @attrName, 2, @attrVal, @nowTime, 0, 0)
				END
			END
			--if 'System State' is '0' for this subclient, donot honor the new value. If new value is '0', leave it, if it is '1', throw an error
			ELSE
			BEGIN
				IF @attrVal = '1'
				BEGIN
					SET @errCode = 1
					SET @errString = 'System state is disabled for this subclient. So cannot set "System State on full backup"'
					GOTO SKIP
				END
			END
		END
	END
SKIP:
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   set @errCode = ERROR_NUMBER()
   set @errString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
SELECT @errCode, @errString
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateSubClientDerivedContent')
	delete from GxQscripts where name = 'AppUpdateSubClientDerivedContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateSubClientDerivedContent')
	delete from GXDBVersions where aliasname = 'AppUpdateSubClientDerivedContent'
GO

insert into GXDBVersions values(2, 'AppUpdateSubClientDerivedContent',  '00010016005000080000', 'AppUpdateSubClientDerivedContent', '00010016005000080000')
GO

