

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateStatusForSync.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateStatusForSync.sp,v $ $Id: AppUpdateStatusForSync.sp,v 1.5.70.3 2018/03/27 08:17:12 jiechen Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppUpdateStatusForSync						|
--	|			Procedure for JM to set status to start sync			|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateStatusForSync <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateStatusForSync')
	drop procedure AppUpdateStatusForSync
IF EXISTS (select * from GxQscripts where name='AppUpdateStatusForSync')
	delete from GxQscripts where name = 'AppUpdateStatusForSync'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateStatusForSync')
	delete from GXDBVersions where aliasname = 'AppUpdateStatusForSync'
GO
print '... Creating Procedure: AppUpdateStatusForSync'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateStatusForSync
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_subClientId INT,
  @i_bkpClientId INT,
  @i_jobId BIGINT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	UPDATE STAT
	SET syncStatus = 0,
	retryCount = 0
	FROM App_SyncCloudStats STAT
	INNER JOIN App_SyncCloudFolder SF ON STAT.syncWebFolderId = SF.syncWebFolderId
	WHERE STAT.sourceSubclientId = @i_subClientId
	AND STAT.destClientId <> @i_bkpClientId
	AND (STAT.syncWebFolderId IN (SELECT intData FROM JMMisc WHERE jobId = @i_jobId AND itemType = 20) /*JM_SYNC_JOB_WEB_FOLDER*/
OR (SF.flag & 0x10 = 0x10)) /*Edge drive*/
	-- This is for triggering sync on itself if the machine was down and it came back
	DECLARE @maxRetryCount INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='maximunNumberToRetryFailedSyncJobs'), 5)
	UPDATE App_SyncCloudStats
	SET syncStatus = 0,
	retryCount = 0
	WHERE destClientId = (SELECT DISTINCT clientId FROM APP_Application WHERE id = @i_subClientId)
		AND retryCount > @maxRetryCount
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateStatusForSync')
	delete from GxQscripts where name = 'AppUpdateStatusForSync'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateStatusForSync')
	delete from GXDBVersions where aliasname = 'AppUpdateStatusForSync'
GO

insert into GXDBVersions values(2, 'AppUpdateStatusForSync',  '00010005007000030000', 'AppUpdateStatusForSync', '00010005007000030000')
GO

