

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateStaticClientProperties.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateStaticClientProperties <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateStaticClientProperties')
	drop procedure AppUpdateStaticClientProperties
IF EXISTS (select * from GxQscripts where name='AppUpdateStaticClientProperties')
	delete from GxQscripts where name = 'AppUpdateStaticClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateStaticClientProperties')
	delete from GXDBVersions where aliasname = 'AppUpdateStaticClientProperties'
GO
print '... Creating Procedure: AppUpdateStaticClientProperties'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppUpdateStaticClientProperties
  @inClientId INTEGER
AS
DECLARE @nowTime integer = dbo.getUnixtime(GetUTCDate())
BEGIN
		BEGIN
			UPDATE APP_CLIENTPROP
				SET attrVal= (SELECT osName FROM ClientOSNameView where clientId = @inClientId)
				WHERE componentNameId = @inClientId
				and attrName = 'Operating System Name'
				and modified = 0
			IF @@ROWCOUNT = 0
			BEGIN
				INSERT INTO APP_CLIENTPROP
				SELECT clientId, 'Operating System Name',1, osName,@nowTime,0,0
				FROM ClientOSNameView
				where clientId = @inClientId
			END
			DECLARE @hwName varchar(255)
			SET @hwName = ISNULL((
									SELECT
	                                     CASE
	                                           WHEN q.hwPos IS NOT NULL AND q.hwPos > 0 THEN SUBSTRING(q.osInfo, q.osInfoLen - q.hwPos + 1, hwPos + 1)
	                                           ELSE q.osName
	                                     END as cHwName
										FROM
										(
											SELECT
												os.name osName,
												cp.attrVal osInfo,
												LEN(cp.attrVal) osInfoLen,
												(CHARINDEX('-:', REVERSE(cp.attrVal))-1) hwPos
												FROM APP_Client c WITH (NOLOCK)
												LEFT OUTER JOIN simOperatingSystem os WITH (NOLOCK) ON
													os.id = c.simOperatingSystemId
												INNER JOIN APP_ClientProp cp WITH (NOLOCK) ON
													cp.componentNameId = c.id and
													cp.componentNameId = @inClientId
													AND cp.attrname = N'Sim OS Info'
													AND cp.modified = 0
										) q
								),'')
			IF @hwName <> ''
			BEGIN
				UPDATE APP_CLIENTPROP
					SET attrVal= @hwName
					WHERE componentNameId = @inClientId
					and attrName = 'Hardware Info'
					and modified = 0
				IF @@ROWCOUNT = 0
				BEGIN
					INSERT INTO APP_CLIENTPROP
					VALUES(@inClientId,'Hardware Info',1,@hwName,@nowTime,0,0)
				END
			END
		END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateStaticClientProperties')
	delete from GxQscripts where name = 'AppUpdateStaticClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateStaticClientProperties')
	delete from GXDBVersions where aliasname = 'AppUpdateStaticClientProperties'
GO

insert into GXDBVersions values(2, 'AppUpdateStaticClientProperties',  '00000000000000000000', 'AppUpdateStaticClientProperties', '00000000000000000000')
GO

