

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateSmartTopologyRoutesForClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Id: AppUpdateSmartTopologyRoutesForClient.sp
--
--  +===================================================================================+
--  |   Procedure:  AppUpdateSmartTopologyRoutesForClient
--  |
--  | Description:  This procedure is used to update smart topology routes for the client
--  |
--  |       Input:  clientId
--  |
--  |      Output:  xxxxxxxxxxxxxxxx
-- 	|
--  |      Return:  xxxxxxxxxxxxxxxx
--  |
--  |   Revision	Author					Description
--  |   ---------  	-------					--------------------------------
--  |   1.1        	kmokshagundam   		Initial Edit
--  +===================================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateSmartTopologyRoutesForClient <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateSmartTopologyRoutesForClient')
	drop procedure AppUpdateSmartTopologyRoutesForClient
IF EXISTS (select * from GxQscripts where name='AppUpdateSmartTopologyRoutesForClient')
	delete from GxQscripts where name = 'AppUpdateSmartTopologyRoutesForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateSmartTopologyRoutesForClient')
	delete from GXDBVersions where aliasname = 'AppUpdateSmartTopologyRoutesForClient'
GO
print '... Creating Procedure: AppUpdateSmartTopologyRoutesForClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppUpdateSmartTopologyRoutesForClient
  @clientId int
AS
DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
DECLARE @previous TABLE( clientId INT )
DECLARE @current TABLE( clientId INT )
DECLARE @clientsToPushFW TABLE ( clientId INT)
IF object_id('tempdb.dbo.#maList') IS NOT NULL
	DROP TABLE #maList
CREATE TABLE #maList
(
	clientId integer,
	maClientId integer,
	maClientName NVARCHAR(255),
	maClientHostName NVARCHAR(255),
	maClientGUID NVARCHAR(255)
)
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON
	INSERT INTO @previous
	SELECT clientId FROM APP_SmartTopologyClientAssoc WHERE forClientId = @clientId
	--Delete existing routes for this client in the smart topologies
	DELETE FROM APP_SmartTopologyClientAssoc WHERE forClientId = @clientId OR clientId = @clientId
	INSERT INTO #maList EXECUTE AppGetMediaAgentsForClient @clientId -- Get media-agents the client can ever reach
	INSERT INTO APP_SmartTopologyClientAssoc
	SELECT ClientTopology.topologyId,
	CASE
		WHEN restrictionType = 1 THEN CASE fwGroupType WHEN 2 THEN maClientId ELSE clientId END
		WHEN restrictionType = 0 THEN CASE fwGroupType WHEN 2 THEN clientId ELSE maClientId END
	END clientId,
	CASE
		WHEN restrictionType = 1 THEN CASE fwGroupType WHEN 2 THEN clientId ELSE maClientId END
		WHEN restrictionType = 0 THEN CASE fwGroupType WHEN 2 THEN maClientId ELSE clientId END
	END forClientId,
	CASE
		WHEN topologyType = 2 THEN restrictionType
		ELSE 0
		END restrictionType
	FROM
	(
	SELECT topologyId FROM APP_FirewallTopologyAssoc WHERE groupId < 0
	INTERSECT
	SELECT topologyId FROM APP_FirewallTopologyAssoc WHERE groupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId = @clientID)
	) ClientTopology -- All smart topologies the client is part of
	INNER JOIN APP_FirewallTopology AllTopology
	ON AllTopology.topologyId =ClientTopology.topologyId
	CROSS APPLY
	(SELECT aft1.fwGroupType,aft1.groupId FROM APP_FirewallTopologyAssoc aft1 WHERE aft1.topologyId =ClientTopology.topologyid AND aft1.groupId IN (-2,-3)) Groups -- Add routes to the table only when groupId is My Media Agents(-2) or My CommServe and Media Agents(-3)
	INNER JOIN (SELECT clientId, maClientId FROM #maList) MediaAgent ON Mediaagent.clientid= @clientID
	CROSS APPLY (SELECT 1 restrictionType UNION SELECT 0 restrictionType) RestrictionTable
	UNION
	SELECT ClientTopology.topologyId,
	CASE
		WHEN restrictionType = 1 THEN CASE fwGroupType WHEN 2 THEN csClientId ELSE clientId END
		WHEN restrictionType = 0 THEN CASE fwGroupType WHEN 2 THEN clientId ELSE csClientId END
	END clientId,
	CASE
		WHEN restrictionType = 1 THEN CASE fwGroupType WHEN 2 THEN clientId ELSE csClientId END
		WHEN restrictionType = 0 THEN CASE fwGroupType WHEN 2 THEN csClientId ELSE clientId END
	END forClientId,
	CASE
		WHEN topologyType = 2 THEN restrictionType
		ELSE 0
		END restrictionType
	FROM
	(
	SELECT topologyId FROM APP_FirewallTopologyAssoc WHERE groupId < 0
	INTERSECT
	SELECT topologyId FROM APP_FirewallTopologyAssoc WHERE groupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId = @clientID)
	) ClientTopology -- All smart topologies the client is part of
	INNER JOIN APP_FirewallTopology AllTopology
	ON AllTopology.topologyId =ClientTopology.topologyId
	CROSS APPLY
	(SELECT aft1.fwGroupType,aft1.groupId FROM APP_FirewallTopologyAssoc aft1 WHERE aft1.topologyId =ClientTopology.topologyid AND groupId IN (-1,-3)) Groups -- Add routes to the table only when groupId is My CommServe(-1) or My CommServe and Media Agents(-3)
	INNER JOIN (SELECT @clientId clientId, 2 csClientId /* 2 is CommServe ID */) CommServe ON CommServe.clientid= @clientID
	CROSS APPLY (SELECT 1 restrictionType UNION SELECT 0 restrictionType) RestrictionTable
	INSERT INTO @current
	SELECT clientId FROM APP_SmartTopologyClientAssoc WHERE forClientId = @clientId
	INSERT INTO @clientsToPushFW
	SELECT clientId FROM @previous
	EXCEPT
	SELECT clientId FROM @current
	INSERT INTO @clientsToPushFW
	SELECT clientId FROM @current
	EXCEPT
	SELECT clientId FROM @previous
	IF EXISTS(SELECT * FROM @clientsToPushFW)--Push to this client only when any routes changed
		INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
		VALUES (@clientId,-1,5,'',@currentTime,0,0,0)
	--Push to all the disassociated and newly associated MAs
	INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
	SELECT DISTINCT clientId,-1,5,'',@currentTime,0,0,0 FROM @clientsToPushFW
	IF object_id('tempdb.dbo.#maList') IS NOT NULL
		DROP TABLE #maList
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateSmartTopologyRoutesForClient')
	delete from GxQscripts where name = 'AppUpdateSmartTopologyRoutesForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateSmartTopologyRoutesForClient')
	delete from GXDBVersions where aliasname = 'AppUpdateSmartTopologyRoutesForClient'
GO

insert into GXDBVersions values(2, 'AppUpdateSmartTopologyRoutesForClient',  '00000000000000000000', 'AppUpdateSmartTopologyRoutesForClient', '00000000000000000000')
GO

