

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateSchedulePolicyAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateSchedulePolicyAssociation.sp,v $ $Id: AppUpdateSchedulePolicyAssociation.sp,v 1.1.2.1 2020/06/09 04:12:03 alakra Exp $";
-- =================================================================================
-- Author:		Arvind Lakra
-- Create date: 05/29/2020
-- Description:	Add/remove schedule policy association to subclient or backupset
-- =================================================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateSchedulePolicyAssociation')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateSchedulePolicyAssociation <<<'
	drop procedure AppUpdateSchedulePolicyAssociation
END
IF EXISTS (select * from GxQscripts where name='AppUpdateSchedulePolicyAssociation')
	delete from GxQscripts where name = 'AppUpdateSchedulePolicyAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateSchedulePolicyAssociation')
	delete from GXDBVersions where aliasname = 'AppUpdateSchedulePolicyAssociation'
GO
print '... Creating Procedure: AppUpdateSchedulePolicyAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateSchedulePolicyAssociation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_entityId INTEGER,
  @i_entityType INTEGER,
  @i_taskId INTEGER = 0,
  @i_isDeleteAssociation INTEGER = 0,
  @i_localeId INTEGER = 0,
  @o_errorCode INTEGER OUTPUT,
  @o_errorString NVARCHAR(MAX) OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
	SET NOCOUNT ON
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
	DECLARE @i_clientGroupId	INTEGER = 0
	DECLARE @i_clientId			INTEGER = 0
	DECLARE @i_InstanceId		INTEGER = 0
	DECLARE @i_appTypeId		INTEGER = 0
	DECLARE @i_archGroupCopyId	INTEGER = 0
	DECLARE @i_assocType		INTEGER = 0
	DECLARE @i_backupSetId		INTEGER = 0
	DECLARE @i_subclientId		INTEGER = 0
	SET @errorCode = 0
	SET @errorString = N''
		DECLARE @now		INT = dbo.GetUnixTime(GETDATE())
		DECLARE @policyId	INT = 0
IF (@i_entityType = 7)
		BEGIN
			SELECT @i_subclientId = id, @i_backupSetId=backupSet, @i_InstanceId=instance, @i_appTypeId=appTypeId, @i_clientId=clientId FROM APP_Application WHERE id = @i_entityId
SET @i_assocType = 7
		END
ELSE IF (@i_entityType = 6)
		BEGIN
			SELECT @i_subclientId = 0, @i_backupSetId=backupSet, @i_InstanceId=instance, @i_appTypeId=appTypeId, @i_clientId=clientId FROM APP_Application WHERE backupSet = @i_entityId
SET @i_assocType = 6
		END
IF ((@i_subclientId = 0) AND (@i_entityType = 7)) OR
((@i_backupSetId = 0) AND (@i_entityType = 6)) OR
			(NOT EXISTS (SELECT 1 FROM TM_Task WHERE taskId=@i_taskId))
		BEGIN
			-- Error Out as we don't have valid backupset or subclient
SET @errorCode = (7 | (CAST(POWER(2, 24) AS BIGINT) * 4))  -- Invalid combination of arguments.
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (7 | (CAST(POWER(2, 24) AS BIGINT) * 4)) and localeid = @i_localeId)
			GOTO SCRIPT_EXIT
		END
		IF (@i_isDeleteAssociation = 0)
		BEGIN
			INSERT INTO TM_AssocEntity	(assocType,			taskId,			flags,		created,		exclude,
										 clientGroupId,		clientId,		apptypeId,	instanceId,		backupsetId,
										 subclientId,		policyId,		copyId,		srmReportSet,	srmReportType,
										 trackingPolicyId,	MediaAgentId,	agentlessPolicyId, workflowId, sidbStoreId,
										 libraryId, logMonitoringPolicyId
										 )
			values						(@i_assocType,		@i_taskId,		0,			@now,		0,
										 @i_clientGroupId,	@i_clientId,	@i_appTypeId,	@i_InstanceId,	@i_backupSetId,
										 @i_subclientId,	@policyId,		@i_archGroupCopyId,			0,				0,
										 0,					0,				0,			0,				0,
										 0,					0
										 )
		END
		ELSE
		BEGIN
			DELETE FROM TM_AssocEntity
				WHERE assocType =  @i_assocType AND taskId = @i_taskId
					AND (
((subclientId = @i_subclientId) AND (@i_entityType = 7))
							OR
((backupsetId = @i_backupSetId) AND (@i_entityType = 6))
						)
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
			SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
SCRIPT_EXIT:
	SET @o_errorCode  = @errorCode
	SET @o_errorString  = @errorString
SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateSchedulePolicyAssociation')
	delete from GxQscripts where name = 'AppUpdateSchedulePolicyAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateSchedulePolicyAssociation')
	delete from GXDBVersions where aliasname = 'AppUpdateSchedulePolicyAssociation'
GO

insert into GXDBVersions values(2, 'AppUpdateSchedulePolicyAssociation',  '00010001000200010000', 'AppUpdateSchedulePolicyAssociation', '00010001000200010000')
GO

