

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdatePlanAssocEntities.sp] ---------- 

--  +=============================================================================================+
--  |                       Name: AppUpdatePlanAssocEntities()
--  | Description: Flips currUserId of entities associated to the plan with newUserId
--  |
--  |       Input: currUserId, newUserId, planId
--  |      Output: errorCode
--  |      Author: sravanan
--  +=============================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdatePlanAssocEntities')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdatePlanAssocEntities <<<'
	drop procedure AppUpdatePlanAssocEntities
END
IF EXISTS (select * from GxQscripts where name='AppUpdatePlanAssocEntities')
	delete from GxQscripts where name = 'AppUpdatePlanAssocEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdatePlanAssocEntities')
	delete from GXDBVersions where aliasname = 'AppUpdatePlanAssocEntities'
GO
print '... Creating Procedure: AppUpdatePlanAssocEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdatePlanAssocEntities
  @currUserId INT,
  @newUserId INT,
  @planId INT
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(MAX)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @replicationSchedulePolicyId INT = ISNULL((SELECT CONVERT(INT,attrVal) FROM App_PlanProp WITH(NOLOCK) WHERE
componentNameId = @planId AND attrName = 'Replication schedule policy' AND modified = 0 ),0)
	DECLARE @schedulePolicyId INT = ISNULL((SELECT CONVERT(INT,attrVal) FROM App_PlanProp WITH(NOLOCK) WHERE
componentNameId = @planId AND attrName = 'Schedule policy' AND modified = 0 ),0)
	DECLARE @storagePolicyId INT = ISNULL((SELECT CONVERT(INT,attrVal) FROM App_PlanProp WITH(NOLOCK) WHERE
componentNameId = @planId AND attrName = 'Storage policy' AND modified = 0 ),0)
	-- Flip userId of replication schedule policy
	IF @replicationSchedulePolicyId <> 0
	BEGIN
EXEC sec_setCreatorForEntity @currUserId, 0, '', @errorCode, @errorString, 69, @replicationSchedulePolicyId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, @newUserId
		IF(@errorCode <> 0)
		BEGIN
			GOTO PROC_EXIT
		END
	END
	-- Flip userId of schedule policy
	IF @schedulePolicyId <> 0
	BEGIN
EXEC sec_setCreatorForEntity @currUserId, 0, '', @errorCode, @errorString, 35, @schedulePolicyId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, @newUserId
		IF(@errorCode <> 0)
		BEGIN
			GOTO PROC_EXIT
		END
	END
	-- Flip userId of storage policy
	IF @storagePolicyId <> 0
	BEGIN
EXEC sec_setCreatorForEntity @currUserId, 0, '', @errorCode, @errorString, 17, @storagePolicyId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, @newUserId
		IF(@errorCode <> 0)
		BEGIN
			GOTO PROC_EXIT
		END
	END
	-- Flip userId of plan owner
		-- 1. Update ownerId of plan
	UPDATE App_Plan SET ownerId = @newUserId WHERE id = @planId AND ownerId = @currUserId
	-- 2. Update permissions
	IF @planId <> 0
	BEGIN
EXEC sec_setCreatorForEntity @currUserId, 0, '', @errorCode, @errorString, 158, @planId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, @newUserId
		IF(@errorCode <> 0)
		BEGIN
			GOTO PROC_EXIT
		END
	END
END
PROC_EXIT:
	SELECT @errorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdatePlanAssocEntities')
	delete from GxQscripts where name = 'AppUpdatePlanAssocEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdatePlanAssocEntities')
	delete from GXDBVersions where aliasname = 'AppUpdatePlanAssocEntities'
GO

insert into GXDBVersions values(2, 'AppUpdatePlanAssocEntities',  '00000000000000000000', 'AppUpdatePlanAssocEntities', '00000000000000000000')
GO

