

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdatePlanAccessTimeRuleAssoc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--		Copyright (c) CommVault Systems
--		All Rights Reserved
--
--		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--		The copyright notice above does not evidence any
--		actual or intended publication of such source code.
--
--
-- ----------------------------------------------------------------------*/
-- ----------------------------------------------------------------------
--
--		Stored proc: AppUpdatePlanAccessTimeRuleAssoc
--		Description: When access time rule is enabled for a archival plan, this stored procedure
--					 updates all the associated subclients and clients accordingly.
--					 1. For Unix subclients, it sets "Use native snapshot" property.
--					 2. For windows subclients, it sets "Track access file time" at FS level and submits a WQ to update the client registry
--						(Also to reboot the machine based on user choice).
--					 3. For NAS(CIFS) subclients, it sets "Preserve file access time" property.
--		Inputs: planSubclientId and rebootRequired
--		Outputs: errorCode and errorString
--		Author: jswaminathan
--
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdatePlanAccessTimeRuleAssoc')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdatePlanAccessTimeRuleAssoc <<<'
	drop procedure AppUpdatePlanAccessTimeRuleAssoc
END
IF EXISTS (select * from GxQscripts where name='AppUpdatePlanAccessTimeRuleAssoc')
	delete from GxQscripts where name = 'AppUpdatePlanAccessTimeRuleAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdatePlanAccessTimeRuleAssoc')
	delete from GXDBVersions where aliasname = 'AppUpdatePlanAccessTimeRuleAssoc'
GO
print '... Creating Procedure: AppUpdatePlanAccessTimeRuleAssoc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdatePlanAccessTimeRuleAssoc
  @i_planSubclientId INT,
  @i_rebootRequired INT
AS
SET NOCOUNT ON
-- Outputs:
  DECLARE @o_errorCode INT = 0
  DECLARE @o_errorString VARCHAR(1024) = ''
DECLARE @_planSubclientIdStr VARCHAR(10) = CAST(@i_planSubclientId AS VARCHAR(10))
DECLARE @_nowTime INT = dbo.getUnixTime(GETUTCDATE())
DECLARE @_scpType VARCHAR(5) = '0'
-- Using nvarchar variables so that when querying Subclient Properties table, we can use cs_attrname column for better index usage and faster query performance.
DECLARE @_useSnapshotProp NVARCHAR(1024) = N'Use LVM/cxbf snapshot to preserve file access time'			/*'Use LVM/cxbf snapshot to preserve file access time'*/
DECLARE @_useLocalArchivalRulesProp NVARCHAR(1024) = N'Use Local Archival Rules'							/*'Use Local Archival Rules'*/
DECLARE @_associatedSCPProp NVARCHAR(1024) = N'Associated subclient Policy'									/*'Associated subclient Policy'*/
DECLARE @_preserveFileAccessTimeProp NVARCHAR(1024) = N'Preserve File Access Times'
BEGIN TRY
	SELECT @_scpType = attrVal
	FROM APP_BackupsetProp (NOLOCK)
	WHERE
		componentNameId = (SELECT backupset FROM APP_Application (NOLOCK) WHERE id = @i_planSubclientId)
AND attrName = 'Associated subclient Policy Ida Type'			-- 'Associated subclient Policy Ida Type'
		AND modified = 0
	IF OBJECT_ID ('tempdb.dbo.#UpdateAccessTimeRuleAssoc_SCList') IS NOT NULL
		DROP TABLE #UpdateAccessTimeRuleAssoc_SCList
	CREATE TABLE #UpdateAccessTimeRuleAssoc_SCList
	(
		scId INT PRIMARY KEY
	)
	IF @_scpType = '3'				-- Unix SCP.
	BEGIN
		INSERT INTO #UpdateAccessTimeRuleAssoc_SCList
			SELECT DISTINCT SP1.componentNameId
			FROM APP_SubclientProp SP1
				INNER JOIN APP_Application A
					ON SP1.componentNameId = A.id
				INNER JOIN APP_Client C
					ON A.clientID = C.id
				INNER JOIN SimOperatingSystem OS
					ON C.simOperatingSystemId = OS.id
					AND OS.type = 'Unix'			-- Get only the subclients that belongs to a physical Unix machine. Ignore NAS!!!
				LEFT OUTER JOIN APP_SubclientProp SP2
					ON SP2.componentNameID = SP1.componentNameId
					AND SP2.attrName = @_useSnapshotProp									-- 'Use LVM/cxbf snapshot to preserve file access time'
					AND SP2.cs_attrName = CHECKSUM(@_useSnapshotProp)
					AND SP2.attrVal = '1'
					AND SP2.modified = 0
				LEFT OUTER JOIN APP_SubclientProp SP3
					ON SP1.componentNameId = SP3.componentNameID
					AND SP3.attrName = @_useLocalArchivalRulesProp							-- 'Use Local Archival Rules'
					AND SP3.cs_attrName = CHECKSUM(@_useLocalArchivalRulesProp)
					AND SP3.attrVal = '1'
					AND SP3.modified = 0
			WHERE
				SP1.attrName = @_associatedSCPProp											-- 'Associated subclient Policy'
				AND SP1.cs_attrName = CHECKSUM(@_associatedSCPProp)
				AND SP1.attrVal = @_planSubclientIdStr
				AND SP1.modified = 0
				AND SP2.componentNameID IS NULL					-- Update only those subclients that do not have this property as 1.
				AND SP3.componentNameId IS NULL					-- If subclient is using local archival rules, then we do not need to update them.
		IF NOT EXISTS (SELECT 1 FROM APP_SubclientProp (NOLOCK) WHERE componentNameId = @i_planSubclientId AND attrName = @_useSnapshotProp AND cs_attrName = CHECKSUM(@_useSnapshotProp) AND attrVal = '1' AND modified = 0)
			INSERT INTO #UpdateAccessTimeRuleAssoc_SCList		-- Include the subclient policy's subclient too. Update the property there also.
				VALUES (@i_planSubclientId)
		-- Age the old property for these subclients.
		UPDATE APP_SubclientProp
		SET modified = @_nowTime
		FROM #UpdateAccessTimeRuleAssoc_SCList
		WHERE
			componentNameID = scId
			AND attrName = @_useSnapshotProp								-- 'Use LVM/cxbf snapshot to preserve file access time'
			AND cs_attrName = CHECKSUM(@_useSnapshotProp)
			AND modified = 0
		-- Insert the new values.
		INSERT INTO APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT scId,
					@_useSnapshotProp,										-- 'Use LVM/cxbf snapshot to preserve file access time'
					2,
					'1',
					@_nowTime,
					0
			FROM #UpdateAccessTimeRuleAssoc_SCList
				LEFT OUTER JOIN APP_SubclientProp SCP
					ON SCP.componentNameId = scId
					AND SCP.attrName = @_useSnapshotProp					-- 'Use LVM/cxbf snapshot to preserve file access time'
					AND SCP.cs_attrName = CHECKSUM(@_useSnapshotProp)
					AND SCP.attrVal = '1'
					AND SCP.modified = 0
			WHERE
				SCP.componentNameID IS NULL
	END
	ELSE IF @_scpType = '2'			-- Windows SCP.
	BEGIN
		-- Windows clients.
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#UpdateAccessTimeRuleAssoc_ClientList') IS NOT NULL
				DROP TABLE #UpdateAccessTimeRuleAssoc_ClientList
			CREATE TABLE #UpdateAccessTimeRuleAssoc_ClientList
			(
				appIdaNameId INT PRIMARY KEY
			)
			INSERT INTO #UpdateAccessTimeRuleAssoc_ClientList
				SELECT DISTINCT I.id
				FROM APP_SubclientProp SP1
					INNER JOIN APP_Application A
						ON SP1.componentNameId = A.id
					INNER JOIN APP_Client C
						ON A.clientID = C.id
					INNER JOIN SimOperatingSystem OS
						ON C.simOperatingSystemId = OS.id
						AND OS.type = 'Windows'			-- Get only the subclients that belongs to a physical Windows machine. Ignore NAS!!!
					INNER JOIN APP_IdaName I
						ON I.clientId = A.clientId
						AND I.appTypeId = A.appTypeId
					LEFT OUTER JOIN APP_IdaProp IProp
						ON IProp.componentNameId = I.id
						AND IProp.attrName = 'Enable Access Time Collection'
						AND IProp.attrVal = '1'
						AND IProp.modified = 0
					LEFT OUTER JOIN APP_SubclientProp SP3
						ON SP1.componentNameId = SP3.componentNameID
						AND SP3.attrName = @_useLocalArchivalRulesProp							-- 'Use Local Archival Rules'
						AND SP3.cs_attrName = CHECKSUM(@_useLocalArchivalRulesProp)
						AND SP3.attrVal = '1'
						AND SP3.modified = 0
				WHERE
					SP1.attrName = @_associatedSCPProp											-- 'Associated subclient Policy'
					AND SP1.cs_attrName = CHECKSUM(@_associatedSCPProp)
					AND SP1.attrVal = @_planSubclientIdStr
					AND SP1.modified = 0
					AND IProp.componentNameId IS NULL						-- Update those agents which already does not have this enabled.
					AND SP3.componentNameId IS NULL							-- If subclient is using local archival rules, then we do not need to update them.
			-- Age the old property.
			UPDATE APP_IdaProp
			SET modified = @_nowTime
			FROM #UpdateAccessTimeRuleAssoc_ClientList
			WHERE
				componentNameID = appIdaNameID
				AND attrName = 'Enable Access Time Collection'
				AND modified = 0
			-- Insert the new values.
			INSERT INTO App_IdaProp (componentNameId, attrName, attrType, attrVal, created, modified)
				SELECT appIdaNameID,
					  'Enable Access Time Collection',
					  2,
					  '1',
					  @_nowTime,
					  0
				FROM #UpdateAccessTimeRuleAssoc_ClientList
					LEFT OUTER JOIN App_IdaProp IProp
						ON IProp.componentNameId = appIdaNameID
						AND IProp.attrName = 'Enable Access Time Collection'
						AND IProp.attrVal = '1'
						AND IProp.modified = 0
				WHERE
					IProp.componentNameID IS NULL
			-- For rebooting and updating the Windows registry key, submit a WQ for all associated clients.
			DECLARE @wqXML XML = (
									SELECT '1' AS '@isAccessTimeCollected',
											@i_rebootRequired AS '@isRebootPermitted'
									FOR XML PATH ('App_IDAAccessTimeCollecionChanged')
								 )
			DECLARE @wqParam VARCHAR(MAX) = CONVERT(VARCHAR(MAX), @wqXML)
			INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
				SELECT DISTINCT clientId,
								36,							-- WORK_TOKEN_IDA_PROP_MODIFIED
								@wqParam,
								@_nowTime,
								0,
								0,
								0,
								-1
				FROM App_idaName
					INNER JOIN #UpdateAccessTimeRuleAssoc_ClientList
						ON id = appIdaNameId
		END
		-- NAS(CIFS) clients.
		BEGIN
			INSERT INTO #UpdateAccessTimeRuleAssoc_SCList
				SELECT DISTINCT SP1.componentNameId
				FROM APP_SubclientProp SP1
					INNER JOIN APP_Application A
						ON SP1.componentNameId = A.id
					INNER JOIN APP_Client C
						ON A.clientID = C.id
					INNER JOIN SimOperatingSystem OS
						ON C.simOperatingSystemId = OS.id
						AND OS.subType = 'NAS'					-- Get only the subclients that belongs to a NAS(CIFS) client.
					LEFT OUTER JOIN APP_SubclientProp SP2
						ON SP2.componentNameID = SP1.componentNameId
						AND SP2.attrName = @_preserveFileAccessTimeProp						-- 'Preserve file access times'
						AND SP2.cs_attrName = CHECKSUM(@_preserveFileAccessTimeProp)
						AND SP2.attrVal = '1'
						AND SP2.modified = 0
					LEFT OUTER JOIN APP_SubclientProp SP3
						ON SP1.componentNameId = SP3.componentNameID
						AND SP3.attrName = @_useLocalArchivalRulesProp						-- 'Use Local Archival Rules'
						AND SP3.cs_attrName = CHECKSUM(@_useLocalArchivalRulesProp)
						AND SP3.attrVal = '1'
						AND SP3.modified = 0
				WHERE
					SP1.attrName = @_associatedSCPProp										-- 'Associated subclient Policy'
					AND SP1.cs_attrName = CHECKSUM(@_associatedSCPProp)
					AND SP1.attrVal = @_planSubclientIdStr
					AND SP1.modified = 0
					AND SP2.componentNameID IS NULL					-- Update only those subclients that do not have this property as 1.
					AND SP3.componentNameId IS NULL					-- If subclient is using local archival rules, then we do not need to update them.
			-- Age the old property for these subclients.
			UPDATE APP_SubclientProp
			SET modified = @_nowTime
			FROM #UpdateAccessTimeRuleAssoc_SCList
			WHERE
				componentNameID = scId
				AND attrName = @_preserveFileAccessTimeProp								-- 'Preserve file access times'
				AND cs_attrName = CHECKSUM(@_preserveFileAccessTimeProp)
				AND modified = 0
			-- Insert the new values.
			INSERT INTO APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				SELECT scId,
						@_preserveFileAccessTimeProp,									-- 'Preserve file access times'
						2,
						'1',
						@_nowTime,
						0
				FROM #UpdateAccessTimeRuleAssoc_SCList
					LEFT OUTER JOIN APP_SubclientProp SCP
						ON SCP.componentNameId = scId
						AND SCP.attrName = @_preserveFileAccessTimeProp					-- 'Preserve file access times'
						AND SCP.cs_attrName = CHECKSUM(@_preserveFileAccessTimeProp)
						AND SCP.attrVal = '1'
						AND SCP.modified = 0
				WHERE
					SCP.componentNameID IS NULL
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = ERROR_NUMBER()
	SET @o_errorString = ERROR_MESSAGE()
END CATCH
SELECT @o_errorCode, @o_errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdatePlanAccessTimeRuleAssoc')
	delete from GxQscripts where name = 'AppUpdatePlanAccessTimeRuleAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdatePlanAccessTimeRuleAssoc')
	delete from GXDBVersions where aliasname = 'AppUpdatePlanAccessTimeRuleAssoc'
GO

insert into GXDBVersions values(2, 'AppUpdatePlanAccessTimeRuleAssoc',  '00000000000000000000', 'AppUpdatePlanAccessTimeRuleAssoc', '00000000000000000000')
GO

