

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateOneDriveV1AzureProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--		  Author: Mahesh Kasana
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppUpdateOneDriveV1AzureProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateOneDriveV1AzureProperties <<<'
	drop procedure AppUpdateOneDriveV1AzureProperties
END
IF EXISTS (select * from GxQscripts where name='AppUpdateOneDriveV1AzureProperties')
	delete from GxQscripts where name = 'AppUpdateOneDriveV1AzureProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateOneDriveV1AzureProperties')
	delete from GXDBVersions where aliasname = 'AppUpdateOneDriveV1AzureProperties'
GO
print '... Creating Procedure: AppUpdateOneDriveV1AzureProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppUpdateOneDriveV1AzureProperties
  @i_xmlString XML
AS
BEGIN
SET NOCOUNT ON
	DECLARE @o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime            DATETIME = GETDATE()
	DECLARE @nowUtcTime         DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix         INT = DATEDIFF(second, '01/01/1970', @nowUtcTime)
	DECLARE @nowTimeUnix        INT = DATEDIFF(second, '01/01/1970', @nowTime)
	DECLARE @i_instanceId INT = 0
	DECLARE @i_appType		INT = 0
	DECLARE @i_clientId NVARCHAR(1024) = NULL
	DECLARE @clientSecret NVARCHAR(MAX) = NULL
	DECLARE @clientId NVARCHAR(1024) = NULL
	DECLARE @tenantId NVARCHAR(1024) = NULL
	SELECT @i_clientId = ISNULL(ref.value('instanceProperties[1]/instance[1]/@clientId','INT'),0),
		   @i_instanceId  = ISNULL(ref.value('instanceProperties[1]/instance[1]/@instanceId','INT'),0),
		   @i_appType  = ISNULL(ref.value('instanceProperties[1]/instance[1]/@applicationId','INT'),0),
		   @clientSecret = ISNULL(ref.value('instanceProperties[1]/cloudAppsInstance[1]/oneDriveInstance[1]/@clientSecret','NVARCHAR(1024)'),''),
		   @clientId = ISNULL(ref.value('instanceProperties[1]/cloudAppsInstance[1]/oneDriveInstance[1]/@clientId','NVARCHAR(1024)'),''),
		   @tenantId = ISNULL(ref.value('instanceProperties[1]/cloudAppsInstance[1]/oneDriveInstance[1]/@tenant','NVARCHAR(1024)'),'')
	FROM @i_xmlString.nodes ('App_UpdateInstancePropertiesRequest') R(ref)
	IF @i_instanceId <=0 OR @i_clientId<=0 OR @i_appType <=0
	BEGIN
		SET @errorCode = 100
		SET @errorString =
		CASE
			WHEN @i_instanceId <= 0 THEN 'ERROR : Invalid Instance Id'
			WHEN @i_clientId <= 0 THEN 'ERROR : Invalid Client Id'
			WHEN @i_appType <= 0 THEN 'ERROR : Invalid AppType'
		END
		GOTO ERROR_EXIT
	END
	IF NOT EXISTS (SELECT TOP 1 * FROM App_Application (NOLOCK) WHERE instance = @i_instanceId and clientId = @i_clientId and appTypeId = @i_appType)
	BEGIN
		SET @errorCode = 200
		SET @errorString = 'ERROR : Instance doesnt present, Invalied Id Passed'
		GOTO  ERROR_EXIT
	END
	IF EXISTS(SELECT TOP 1 * FROM APP_InstanceProp (NOLOCK) WHERE componentNameId = @i_instanceId AND attrName = 'OneDrive Secret Key' AND modified = 0 AND attrType = 1)
		UPDATE APP_InstanceProp SET attrVal =  @clientSecret WHERE componentNameId = @i_instanceId AND attrName = 'OneDrive Secret Key' AND modified = 0 AND attrType = 1
	ELSE
		INSERT INTO APP_InstanceProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES (@i_instanceId,'OneDrive Secret Key',1,@clientSecret,@nowTimeUnix,0,0)
	IF EXISTS(SELECT TOP 1 * FROM APP_InstanceProp (NOLOCK) WHERE componentNameId = @i_instanceId AND attrName = 'Enterprise App client Id' AND modified = 0 AND attrType = 1)
		UPDATE APP_InstanceProp SET attrVal =  @clientId WHERE componentNameId = @i_instanceId AND attrName = 'Enterprise App client Id' AND modified = 0 AND attrType = 1
	ELSE
		INSERT INTO APP_InstanceProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES (@i_instanceId,'Enterprise App client Id',1,@clientId,@nowTimeUnix,0,0)
	IF LEN(@tenantId) > 0
	BEGIN
		IF EXISTS(SELECT TOP 1 * FROM APP_InstanceProp (NOLOCK) WHERE componentNameId = @i_instanceId AND attrName = 'OneDrive Tenant' AND modified = 0 AND attrType = 1)
			UPDATE APP_InstanceProp SET attrVal =  @tenantId WHERE componentNameId = @i_instanceId AND attrName = 'OneDrive Tenant' AND modified = 0 AND attrType = 1
		ELSE
			INSERT INTO APP_InstanceProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES (@i_instanceId,'OneDrive Tenant',1,@tenantId,@nowTimeUnix,0,0)
	END
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
ERROR_EXIT:
	IF @o_xmlString IS NULL
	SET @o_xmlString =
	(
		SELECT
		(SELECT @errorCode '@errorCode',
				@errorString '@errorMessage'
				FOR XML PATH ('resp'),TYPE
				)
			FOR XML PATH(''),ROOT('App_OneDriveInstance')
	)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateOneDriveV1AzureProperties')
	delete from GxQscripts where name = 'AppUpdateOneDriveV1AzureProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateOneDriveV1AzureProperties')
	delete from GXDBVersions where aliasname = 'AppUpdateOneDriveV1AzureProperties'
GO

insert into GXDBVersions values(2, 'AppUpdateOneDriveV1AzureProperties',  '00000000000000000000', 'AppUpdateOneDriveV1AzureProperties', '00000000000000000000')
GO

