

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateMonitoringPolicyProperty.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc. All rights reserved.
-- -----------------------------------------------------------------------------------------------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateMonitoringPolicyProperty.sp,v $ $Id: AppUpdateMonitoringPolicyProperty.sp,v 1.1.2.1 2019/03/21 15:33:20 anarde Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateMonitoringPolicyProperty')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateMonitoringPolicyProperty <<<'
	drop procedure AppUpdateMonitoringPolicyProperty
END
IF EXISTS (select * from GxQscripts where name='AppUpdateMonitoringPolicyProperty')
	delete from GxQscripts where name = 'AppUpdateMonitoringPolicyProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateMonitoringPolicyProperty')
	delete from GXDBVersions where aliasname = 'AppUpdateMonitoringPolicyProperty'
GO
print '... Creating Procedure: AppUpdateMonitoringPolicyProperty'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateMonitoringPolicyProperty
  @inXML XML
AS
  DECLARE @o_xmlMsg XML;
DECLARE @errorCode INT = 0
DECLARE @errorMessage VARCHAR(MAX) = 'Success'
DECLARE @nowTime INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @policyId INT = ISNULL(@inXML.value('(/LogMonitoring_UpdateMonitoringPolicyPropertyRequest/monitoringPolicyEntity/@policyId)[1]','INT'), 0)
IF OBJECT_ID('tempdb.dbo.#LMProperties') IS NOT NULL
    DROP TABLE #LMProperties
CREATE TABLE #LMProperties (id INT,
							propName NVARCHAR(1024),
							propValue NVARCHAR(MAX),
							dataType INT)
INSERT #LMProperties(id, propName, propValue, dataType)
SELECT  @policyId,
		ref.value('@name','NVARCHAR(1024)'),
		ref.value('@value','NVARCHAR(MAX)'),
		ref.value('@dataType','int')
FROM
	@inXML.nodes('/LogMonitoring_UpdateMonitoringPolicyPropertyRequest/monitoringPolicyProperties') R ( ref )
IF NOT EXISTS(SELECT 1 FROM APP_MonitoringPolicy WHERE monitorPolicyId = @policyId)
BEGIN
	SET @errorCode = 1
	SET @errorMessage = 'Invalid monitoring policy id [' + CAST(@policyId AS VARCHAR(16)) + ']'
	GOTO ERROR_EXIT
END
IF EXISTS(SELECT 1 FROM #LMProperties WHERE dataType IS NULL)
BEGIN
	SET @errorCode = 2
	SET @errorMessage = 'Data type is missing for property.'
	GOTO ERROR_EXIT
END
BEGIN TRY
	MERGE APP_MonitoringPolicyProp T
	USING #LMProperties AS S
	ON T.monitorPolicyId = S.id AND T.attrName = S.propName
	WHEN MATCHED THEN UPDATE SET T.attrVal = S.propValue, T.modified = @nowTime
	WHEN NOT MATCHED THEN INSERT VALUES(S.id, 2, S.propName, S.dataType, S.propValue, @nowTime, @nowTime);
END TRY
BEGIN CATCH
    Set @errorCode = ERROR_NUMBER()
    SET @errorMessage = ERROR_MESSAGE()
END CATCH
ERROR_EXIT:
SET @o_xmlMsg = (SELECT
						@errorCode AS '@errorString',
						@errorMessage AS '@errorCode'
				FOR XML PATH('errors'),ROOT('LogMonitoring_UpdateMonitoringPolicyPropertyResponse'))
SELECT @o_xmlMsg
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateMonitoringPolicyProperty')
	delete from GxQscripts where name = 'AppUpdateMonitoringPolicyProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateMonitoringPolicyProperty')
	delete from GXDBVersions where aliasname = 'AppUpdateMonitoringPolicyProperty'
GO

insert into GXDBVersions values(2, 'AppUpdateMonitoringPolicyProperty',  '00010001000200010000', 'AppUpdateMonitoringPolicyProperty', '00010001000200010000')
GO

