

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateMobilePolicyProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateMobilePolicyProp.sp,v $ $Id: AppUpdateMobilePolicyProp.sp,v 1.1.2.5 2020/12/17 08:29:16 jswaminathan Exp $";
--	+===================================================================+
--	|  					  AppUpdateMobilePolicyProp							|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppUpdateMobilePolicyProp')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateMobilePolicyProp <<<'
	drop procedure AppUpdateMobilePolicyProp
END
IF EXISTS (select * from GxQscripts where name='AppUpdateMobilePolicyProp')
	delete from GxQscripts where name = 'AppUpdateMobilePolicyProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateMobilePolicyProp')
	delete from GXDBVersions where aliasname = 'AppUpdateMobilePolicyProp'
GO
print '... Creating Procedure: AppUpdateMobilePolicyProp'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppUpdateMobilePolicyProp
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inLocaleId INT,
  @inXml XML
-----------------------------------------------------------
AS
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	-- Read the XML
	DECLARE @policyId			INT
DECLARE @policyName			NVARCHAR(255)
DECLARE @description		NVARCHAR(2048)
	SELECT
		@policyId = ISNULL(( ref.value('@policyId', 'INT')), 0),
		@policyName = ISNULL(( ref.value('@policyName', 'NVARCHAR(255)')), ''),
		@description = ISNULL(( ref.value('@description', 'NVARCHAR(2048)')), '')
	FROM @inXml.nodes ('Api_UpdateMobilePolicyPropertiesRequest/policy') R(ref)
	BEGIN TRY
	IF NOT EXISTS (SELECT 1 FROM App_MobilePolicy WITH (NOLOCK) WHERE mobilePolicyId = @policyId)
	BEGIN
SET @errorCode = (3127 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
	END
	IF OBJECT_ID('tempdb.dbo.#policyProp') IS NOT NULL
	    DROP TABLE #policyProp
	CREATE TABLE #policyProp
	(
		propName		NVARCHAR(MAX),
		propValue		NVARCHAR(MAX),
	)
	-- Read the XML
	INSERT INTO #policyProp
	SELECT
			ISNULL((ref.value('@name', 'NVARCHAR(MAX)')), ''),
			ISNULL((ref.value('@value', 'NVARCHAR(MAX)')), '')
	FROM
	@inXml.nodes('/Api_UpdateMobilePolicyPropertiesRequest/policy/properties/nameValues') doc(ref)
	BEGIN TRAN
	-- CHECK IF USER HAS AN ABILITY / PERMISSION TO UPDATE THE POLICY
	DECLARE @userHasCapability INT = 0
	IF @userHasCapability <> 1
	BEGIN
SET @errorCode = (3106 | (CAST(POWER(2, 24) AS BIGINT) * 35))/*use the same message as it is generic*/
		SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
        GOTO ERROR
    END
	-- UPDATE APP_MobilePolicy TABLE
	UPDATE APP_MobilePolicy
		SET mobilePolicyName = @policyName, description = @description
	WHERE mobilePolicyId = @policyId
	-- IF EXIST THEN UPDATE ELSE INSERT
	MERGE App_MobilePolicyProp AS TARGET
	USING (SELECT propName, propValue FROM #policyProp) AS
		SOURCE (propName, propValue)
		ON (TARGET.componentId = @policyId AND TARGET.attrName = SOURCE.propName)
	WHEN MATCHED THEN
		UPDATE SET TARGET.stringVal = SOURCE.propValue, TARGET.modified = @nowTime
	WHEN NOT MATCHED BY TARGET THEN
		INSERT(componentId, attrName, dataType, longVal, stringVal, created, modified)
VALUES(@policyId, SOURCE.propName, 1, 0, SOURCE.propValue, @nowTime, 0);
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	END CATCH
ERROR:
	IF @errorCode <> 0
	BEGIN
		ROLLBACK TRAN
		IF @errorString = ''
		BEGIN
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, 1, 0, 2)
		END
	END
	ELSE
		COMMIT TRAN
ERROR_EXIT:
		SET @outXml = (SELECT
							(CASE WHEN @errorCode <> 0 THEN
								(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
									FOR XML PATH('error'), TYPE)
							END)
						FOR XML PATH('Api_MobilePolicyResponse'), TYPE)
	SELECT @outXml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateMobilePolicyProp')
	delete from GxQscripts where name = 'AppUpdateMobilePolicyProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateMobilePolicyProp')
	delete from GXDBVersions where aliasname = 'AppUpdateMobilePolicyProp'
GO

insert into GXDBVersions values(2, 'AppUpdateMobilePolicyProp',  '00010001000200050000', 'AppUpdateMobilePolicyProp', '00010001000200050000')
GO

