

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateMailboxUsages.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2013  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateMailboxUsages.sp,v $ $Id: AppUpdateMailboxUsages.sp,v 1.9.12.2 2017/02/10 21:16:17 sjohnson Exp $";
-- =========================================================
-- Author: Jatin Sanghvi
-- Description: Update the user mailbox usage
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateMailboxUsages <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateMailboxUsages')
	drop procedure AppUpdateMailboxUsages
IF EXISTS (select * from GxQscripts where name='AppUpdateMailboxUsages')
	delete from GxQscripts where name = 'AppUpdateMailboxUsages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateMailboxUsages')
	delete from GXDBVersions where aliasname = 'AppUpdateMailboxUsages'
GO
print '... Creating Procedure: AppUpdateMailboxUsages'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateMailboxUsages
  @xmlText XML
AS
SET NOCOUNT ON;
--
BEGIN TRY
	--
	-- if @inAppdId = -1, we will update all subclient records
	DECLARE @inAppId int;
	SELECT @inAppId = N.value('@appId', 'int') FROM @xmlText.nodes ('App_MailboxUsages') AS T(N);
	DECLARE @inType int;
	SELECT @inType = N.value('@type', 'int') FROM @xmlText.nodes ('App_MailboxUsages') AS T(N);
	--
	SELECT
	N.value('@userGuid', 'varchar(max)') AS newUserGuid,
	N.value('@spaceConsumed', 'bigint') AS newSpaceConsumed,
	N.value('@globalQuotaLimitMB', 'bigint') AS newGlobalQuotaLimitMB,
	(CASE WHEN M.appId IS NULL THEN 0 ELSE 1 END) AS keyExists
	INTO #tempUserTable
	FROM @xmlText.nodes ('App_MailboxUsages/usageData') AS T(N)
	LEFT JOIN APP_MailboxUsages AS M WITH (TABLOCKX)
	ON M.userGuid = T.N.value('@userGuid', 'varchar(max)') AND M.appId = @inAppId;
	--
	-- the type can be one of the following:
	-- Absolute_Local = 0, update local space consumption
	-- Absolute_Global = 1, update global space consumption
	-- Absolute_Local_Global = 2, update both local and global space consumption
	-- Differential_Local = 10, add to local space consumption
	-- Differential_Global = 11, add to global space consumption
	-- Differential_Local_Global = 12, add to both local and global space consumption
	-- Fresh_Local = 20, clear and then update local space consumption
	-- Fresh_Global = 21, clear an then update global space consumption
	-- Fresh_Local_Global = 22, clear and then update both local and global space consumption
	--
	-- clear local or global space consumptions data before inserting/updating the table.
	IF @inType IN (20, 21, 22)
	BEGIN
		IF @inType IN (20, 22)
			UPDATE APP_MailboxUsages SET localSpaceConsumed = NULL
			WHERE (appId = @inAppId OR @inAppId = -1) AND localSpaceConsumed IS NOT NULL;
		--
		IF @inType IN (21, 22)
			UPDATE APP_MailboxUsages SET globalSpaceConsumed = NULL, globalQuotaLimitMB = NULL
			WHERE (appId = @inAppId OR @inAppId = -1) AND globalSpaceConsumed IS NOT NULL;
		--
		SET @inType = @inType - 20;
	END
	--
	-- input xml contains absolute mailbox usage values. insert/update them into table.
	-- do not modify last update time unless the request type is Absolute_Local (i.e. 0)
	-- and mailbox is currently part of the subclient's content
	IF @inType IN (0, 1, 2)
	BEGIN
		UPDATE APP_MailboxUsages
		SET
		localSpaceConsumed = CASE WHEN @inType IN (0, 2) THEN T.newSpaceConsumed ELSE localSpaceConsumed END,
		globalSpaceConsumed = CASE WHEN @inType IN (1, 2) THEN T.newSpaceConsumed ELSE globalSpaceConsumed END,
		globalQuotaLimitMB = CASE WHEN @inType IN (1, 2) THEN T.newGlobalQuotaLimitMB ELSE globalQuotaLimitMB END
		FROM #tempUserTable T
		WHERE userGuid = T.newUserGuid AND ((T.keyExists = 1 AND appId = @inAppId) OR @inAppId = -1);
		--
		INSERT INTO APP_MailboxUsages (userGuid, appId, localSpaceConsumed, globalSpaceConsumed, globalQuotaLimitMB)
		SELECT T.newUserGuid, @inAppId,
		CASE WHEN @inType IN (0, 2) THEN T.newSpaceConsumed ELSE NULL END,
		CASE WHEN @inType IN (1, 2) THEN T.newSpaceConsumed ELSE NULL END,
		CASE WHEN @inType IN (1, 2) THEN T.newGlobalQuotaLimitMB ELSE NULL END
		FROM #tempUserTable T
		WHERE T.keyExists = 0 AND @inAppId <> -1;
		--
		UPDATE APP_MailboxUsages SET lastUpdateTime = CURRENT_TIMESTAMP
		FROM #tempUserTable T, APP_SubClientProp S
		WHERE @inType = 0 AND @inAppId <> -1 AND appId = @inAppId
		AND userGuid = T.newUserGuid AND T.keyExists = 1
		AND S.componentNameId = @inAppId AND S.attrType = 111 AND S.modified = 0
		AND userGuid = SUBSTRING(S.attrVal, CHARINDEX(' {', attrVal) + 1, 38);
	END
	--
	-- input xml contains differences. update them into table.
	-- do not update null values.
	ELSE IF @inType IN (10, 11, 12)
	BEGIN
		UPDATE APP_MailboxUsages
		SET
		localSpaceConsumed = CASE WHEN @inType IN (10, 12) THEN localSpaceConsumed + T.newSpaceConsumed ELSE localSpaceConsumed END,
		globalSpaceConsumed = CASE WHEN @inType IN (11, 12) THEN globalSpaceConsumed + T.newSpaceConsumed ELSE globalSpaceConsumed END
		FROM #tempUserTable T
		WHERE userGuid = T.newUserGuid AND ((T.keyExists = 1 AND appId = @inAppId) OR @inAppId = -1);
	END
	--
	-- replace negative space consumed values, if any with zeros
	UPDATE APP_MailboxUsages SET localSpaceConsumed = 0
	WHERE (appId = @inAppId OR @inAppId = -1) AND localSpaceConsumed < 0;
	--
	UPDATE APP_MailboxUsages SET globalSpaceConsumed = 0
	WHERE (appId = @inAppId OR @inAppId = -1) AND globalSpaceConsumed < 0;
	--
	-- return success response
	SET @xmlText = (SELECT 0 AS '@errorCode', NULL AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE);
	SELECT @xmlText;
	--
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	--
	-- return error response
	SET @xmlText = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE);
	SELECT @xmlText;
END CATCH
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateMailboxUsages')
	delete from GxQscripts where name = 'AppUpdateMailboxUsages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateMailboxUsages')
	delete from GXDBVersions where aliasname = 'AppUpdateMailboxUsages'
GO

insert into GXDBVersions values(2, 'AppUpdateMailboxUsages',  '00010009001200020000', 'AppUpdateMailboxUsages', '00010009001200020000')
GO

