

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateIndexMigrationForJob.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppUpdateIndexMigrationForJob')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateIndexMigrationForJob <<<'
	drop procedure AppUpdateIndexMigrationForJob
END
IF EXISTS (select * from GxQscripts where name='AppUpdateIndexMigrationForJob')
	delete from GxQscripts where name = 'AppUpdateIndexMigrationForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateIndexMigrationForJob')
	delete from GXDBVersions where aliasname = 'AppUpdateIndexMigrationForJob'
GO
print '... Creating Procedure: AppUpdateIndexMigrationForJob'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppUpdateIndexMigrationForJob
  @xmlText XML
AS
DECLARE @jobId BIGINT = @xmlText.value('(/Indexing_UpdateIndexMigrationForJobReq/@jobId)[1]', 'BIGINT')
DECLARE @isCleanUp INT = @xmlText.value('(/Indexing_UpdateIndexMigrationForJobReq/@isCleanUp)[1]', 'INT')
DECLARE @backupSetGuid NVARCHAR(36) = @xmlText.value('(/Indexing_UpdateIndexMigrationForJobReq/migration/@backupSetGuid)[1]', 'NVARCHAR(36)')
DECLARE @databaseGuid NVARCHAR(36) = @xmlText.value('(/Indexing_UpdateIndexMigrationForJobReq/migration/@databaseGuid)[1]', 'NVARCHAR(36)')
DECLARE @currentServerName NVARCHAR(MAX) = @xmlText.value('(/Indexing_UpdateIndexMigrationForJobReq/migration/@currentServerName)[1]', 'NVARCHAR(MAX)')
DECLARE @newServerName NVARCHAR(MAX) = @xmlText.value('(/Indexing_UpdateIndexMigrationForJobReq/migration/@newServerName)[1]', 'NVARCHAR(MAX)')
DECLARE @fromClientId INT = (SELECT TOP 1 id FROM APP_Client WITH(NOLOCK) WHERE name = @currentServerName)
DECLARE @toClientId INT = (SELECT TOP 1 id FROM APP_Client WITH(NOLOCK) WHERE name = @newServerName)
DECLARE @dbId INT = (
    SELECT TOP 1 DB.id
    FROM App_IndexDBInfo DB WITH(NOLOCK)
    WHERE DB.dbName = @databaseGuid AND DB.backupSetGuid = @backupSetGuid
)
IF @dbId IS NOT NULL
BEGIN
    IF EXISTS (SELECT 1 FROM IdxServerMigrations WITH(NOLOCK) WHERE jobId = @jobId AND indexId = @dbId AND endTime = -1 AND isMigrated = 2)
        UPDATE IdxServerMigrations
        SET endTime = dbo.GetUnixTime(GETUTCDATE()), isMigrated = CASE @isCleanUp WHEN 0 THEN 1 ELSE 0 END
        WHERE jobId = @jobId AND indexId = @dbId
    ELSE IF @isCleanUp = 0
        INSERT INTO IdxServerMigrations(indexId, fromClientId, toClientId, isMigrated, jobId, startTime, endTime)
            VALUES (@dbId, @fromClientId, @toClientId, 2, @jobId, dbo.GetUnixTime(GETUTCDATE()), -1)
END
DECLARE @outXml XML = '<Common_Ack errorCode="0"/>'
select @outXml
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateIndexMigrationForJob')
	delete from GxQscripts where name = 'AppUpdateIndexMigrationForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateIndexMigrationForJob')
	delete from GXDBVersions where aliasname = 'AppUpdateIndexMigrationForJob'
GO

insert into GXDBVersions values(2, 'AppUpdateIndexMigrationForJob',  '00000000000000000000', 'AppUpdateIndexMigrationForJob', '00000000000000000000')
GO

