

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateIndexDBTransactionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--   AppUpdateIndexDBTransactionInfo
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateIndexDBTransactionInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateIndexDBTransactionInfo <<<'
	drop procedure AppUpdateIndexDBTransactionInfo
END
IF EXISTS (select * from GxQscripts where name='AppUpdateIndexDBTransactionInfo')
	delete from GxQscripts where name = 'AppUpdateIndexDBTransactionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateIndexDBTransactionInfo')
	delete from GXDBVersions where aliasname = 'AppUpdateIndexDBTransactionInfo'
GO
print '... Creating Procedure: AppUpdateIndexDBTransactionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateIndexDBTransactionInfo
  @inXML XML
AS
  DECLARE @outXML XML
DECLARE @dbTbl TABLE (dbName varchar(128), backupSetGUID uniqueidentifier, committedTransactionId BIGINT)
BEGIN
	INSERT INTO @dbTbl
	SELECT	req.value('@dbName','varchar(128)'),
			req.value('@backupSetGUID','uniqueidentifier'),
			req.value('@committedTransactionId','bigint')
	FROM @inXML.nodes('App_UpdateIndexDBTransactionInfo/indexDbInfoList') AS T(req)
	INSERT INTO App_IndexDBInfo (backupSetGUID, dbName, type, idxDbEngineType, backupSetId, currentIdxServer, isPrimary)
	SELECT DISTINCT REQ.backupSetGUID, REQ.dbName, APP.appTypeId, 1, BS.id, 0, 1 FROM @dbTbl REQ
	JOIN APP_BackupSetName BS WITH (NOLOCK) ON REQ.backupSetGUID = BS.GUID
	JOIN APP_Application APP WITH (NOLOCK) ON BS.id = APP.backupSet
	LEFT JOIN App_IndexDBInfo IDX (UPDLOCK) ON REQ.backupSetGUID = IDX.backupSetGUID AND REQ.dbName = IDX.dbName
	WHERE IDX.dbName IS NULL
	UPDATE App_IndexDBInfo
	SET committedTransactionId = QDB.committedTransactionId,
flags = CASE WHEN QDB.backupsetGUID <> QDB.dbName THEN flags | 4 ELSE flags END
	FROM App_IndexDBInfo IDB, @dbTbl QDB
	WHERE IDB.backupSetGUID = QDB.backupsetGUID AND IDB.dbName = QDB.dbName AND IDB.isPrimary = 1
	--Making sure the udpate is what we wanted
	SET @outXML = ISNULL((SELECT IDB.dbname AS '@dbName', IDB.backupSetGUID as '@backupSetGUID', IDB.committedTransactionId as '@committedTransactionId'
	FROM App_IndexDBInfo AS IDB
	JOIN @dbTbl QDB ON IDB.backupSetGUID = QDB.backupsetGUID AND IDB.dbName = QDB.dbName
	WHERE IDB.isPrimary = 1
	FOR XML PATH('indexDbInfoList'), ROOT('App_GetIndexDBInfo')),'<App_GetIndexDBInfo/>')
END
SELECT @outXML
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateIndexDBTransactionInfo')
	delete from GxQscripts where name = 'AppUpdateIndexDBTransactionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateIndexDBTransactionInfo')
	delete from GXDBVersions where aliasname = 'AppUpdateIndexDBTransactionInfo'
GO

insert into GXDBVersions values(2, 'AppUpdateIndexDBTransactionInfo',  '00000000000000000000', 'AppUpdateIndexDBTransactionInfo', '00000000000000000000')
GO

