

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateFirewallTopology.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateFirewallTopology')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateFirewallTopology <<<'
	drop procedure AppUpdateFirewallTopology
END
IF EXISTS (select * from GxQscripts where name='AppUpdateFirewallTopology')
	delete from GxQscripts where name = 'AppUpdateFirewallTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateFirewallTopology')
	delete from GXDBVersions where aliasname = 'AppUpdateFirewallTopology'
GO
print '... Creating Procedure: AppUpdateFirewallTopology'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateFirewallTopology
  @topologyXML XML
AS
  DECLARE @o_exist INT
  DECLARE @o_duplicateGroups INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @topologyId INT = @topologyXML.value('(/App_UpdateFirewallTopologyReq/firewallTopology/topologyEntity/@topologyId)[1]', 'int')
DECLARE @topologyName nvarchar(256) = ISNULL(@topologyXML.value('(/App_UpdateFirewallTopologyReq/firewallTopology/topologyEntity/@topologyName)[1]', 'nvarchar(256)'), '')
DECLARE @description nvarchar(max) = ISNULL(@topologyXML.value('(/App_UpdateFirewallTopologyReq/firewallTopology/@description)[1]', 'nvarchar(max)'), '')
DECLARE @topologyType INT = @topologyXML.value('(/App_UpdateFirewallTopologyReq/firewallTopology/@topologyType)[1]', 'int')
DECLARE @oldTopologyType INT = 0
DECLARE @oldExtendedProperties XML = ''
DECLARE	@created	INT = 0
DECLARE @modified	INT = DATEDIFF(SECOND, '1970-1-1',CURRENT_TIMESTAMP)
DECLARE @extendedProperties XML = ISNULL(@topologyXML.value('(/App_UpdateFirewallTopologyReq/firewallTopology/@extendedProperties)[1]','nvarchar(max)'),N'<App_TopologyExtendedProperties displayType="0" encryptTraffic="0" connectionProtocol ="2" numberOfStreams="1"/>')
DECLARE @clientGroupId INT = 0
DECLARE @fwGroupType INT = 0
DECLARE @firewallGroups NWTopoGroupInfoTableType
DECLARE @oldFirewallGroups NWTopoGroupInfoTableType
DECLARE @exist INT = 0
DECLARE @oldExternal INT = 0
DECLARE @external INT = 0
DECLARE @oldWildCardOption INT = 0
DECLARE @duplicateGroups INT = 0
DECLARE @isSmartTopology	BIT	=	ISNULL(@topologyXML.value('(/App_UpdateFirewallTopologyReq/firewallTopology/@isSmartTopology)[1]', 'bit'), 0)
DECLARE @flag	INT	= 0
DECLARE @useWildCardProxy INT = ISNULL(@topologyXML.value('(/App_UpdateFirewallTopologyReq/firewallTopology/@useWildcardProxy)[1]', 'int'), 0)
DECLARE @prevTranCount INT = 0
BEGIN
SELECT @flag = @flag | 1 WHERE @isSmartTopology = 1
	-- Dont reset FWTOPOLOGY_CSFAILOVER_MASK flag on updation. Have it same as before.
SELECT @flag = @flag | 2 from APP_FirewallTopology
WHERE topologyId = @topologyId and (flag&2)>0
	INSERT INTO @firewallGroups (clientGroupId, fwGroupType, fwConfig)
	SELECT CASE
			WHEN T.c.value('(clientGroup/@clientGroupId)[1]', 'int') IS NULL OR  T.c.value('(clientGroup/@clientGroupId)[1]', 'int') = -32000 THEN dbo.GetSmartTopologyMnemonicID(T.c.value('(clientGroup/@clientGroupName)[1]', 'NVARCHAR(255)'))
			ELSE T.c.value('(clientGroup/@clientGroupId)[1]', 'int') END
			, T.c.value('(@fwGroupType)[1]', 'int')
			, T.c.query('options')
	FROM @topologyXML.nodes('/App_UpdateFirewallTopologyReq/firewallTopology/firewallGroups') T(c)
	IF @topologyType IN (2,3)
	BEGIN
		SET @duplicateGroups = (
									SELECT COUNT(1)
									FROM APP_FirewallTopology AFT
									WHERE NOT EXISTS
									(
										(
											SELECT groupId
											FROM APP_FirewallTopologyAssoc AFTA
											WHERE AFTA.topologyId = AFT.topologyId AND (AFTA.fwGroupType IN (1,2))
										)
										EXCEPT
										(
											SELECT clientGroupId
											FROM @firewallGroups FG
											WHERE FG.fwGroupType IN (1,2)
										)
									) AND AFT.topologyId <> @topologyId
							 )
	END
	IF @topologyType in (1,4)
	BEGIN
		SET @duplicateGroups = (
									SELECT COUNT(1)
									FROM APP_FirewallTopology AFT
									WHERE AFT.topologyType IN (2,3) AND NOT EXISTS(
																					(
																						SELECT groupId
																						FROM APP_FirewallTopologyAssoc AFTA
																						WHERE AFTA.topologyId = AFT.topologyId
																					)
																					EXCEPT
																					(
																						SELECT clientGroupId
																						FROM @firewallGroups FG
																						WHERE FG.fwGroupType IN (1,2)
																					)
																			) AND AFT.topologyId <> @topologyId
								)
	END
	IF @duplicateGroups = 0
	BEGIN
			SET @duplicateGroups = (
										SELECT COUNT(1)
										FROM APP_FirewallTopology AFT
										WHERE AFT.topologyType = @topologyType AND NOT EXISTS(
																					(
																						SELECT groupId
																						FROM APP_FirewallTopologyAssoc AFTA
																						WHERE AFTA.topologyId = AFT.topologyId
																					)
																					EXCEPT
																					(
																						SELECT clientGroupId FROM @firewallGroups
																					)
																				) AND AFT.topologyId <> @topologyId
									)
	END
	IF @duplicateGroups = 0
	BEGIN
		SELECT @oldTopologyType = topologyType, @oldExtendedProperties = extendedProperties
		FROM APP_FirewallTopology
		WHERE topologyId = @topologyId
		-- Note : Topology can be created from multiple end points : Commcell console, Command center, qsdk.
		-- All properties might not be set from all ends. So when a topology has to be updated, if the given xml does not contain required options, use the existing DB values
		DECLARE @oldEncryptTraffic INTEGER
		DECLARE @oldConnectionProtocol INTEGER
		DECLARE @oldNumberOfStreams INTEGER
		SELECT @oldEncryptTraffic = Props.col.value('@encryptTraffic', 'INTEGER')
				, @oldConnectionProtocol = Props.col.value('@connectionProtocol', 'INTEGER')
				, @oldNumberOfStreams = Props.col.value('@numberOfStreams', 'INTEGER')
		FROM @oldExtendedProperties.nodes('App_TopologyExtendedProperties') Props(col)
		DECLARE @newEncryptTraffic INTEGER
		DECLARE @newConnectionProtocol INTEGER
		DECLARE @newNumberOfStreams INTEGER
		SELECT @newEncryptTraffic = Props.col.value('@encryptTraffic', 'INTEGER')
				, @newConnectionProtocol = Props.col.value('@connectionProtocol', 'INTEGER')
				, @newNumberOfStreams = Props.col.value('@numberOfStreams', 'INTEGER')
		FROM @extendedProperties.nodes('App_TopologyExtendedProperties') Props(col)
		IF @newConnectionProtocol IS NULL AND @oldConnectionProtocol IS NOT NULL
		BEGIN
			SET @extendedProperties.modify('insert attribute connectionProtocol {sql:variable("@oldConnectionProtocol")} into (App_TopologyExtendedProperties[1])')
		END
		IF @newNumberOfStreams IS NULL AND @oldNumberOfStreams IS NOT NULL
		BEGIN
			SET @extendedProperties.modify('insert attribute numberOfStreams {sql:variable("@oldNumberOfStreams")} into (App_TopologyExtendedProperties[1])')
		END
		IF @newEncryptTraffic IS NULL AND @oldEncryptTraffic IS NOT NULL
		BEGIN
			SET @extendedProperties.modify('insert attribute encryptTraffic {sql:variable("@oldEncryptTraffic")} into (App_TopologyExtendedProperties[1])')
		END
		-- If encryptTraffic is set, ensure we set the connectionProtocol to https
		IF @newEncryptTraffic = 1
SET @extendedProperties.modify('replace value of (/App_TopologyExtendedProperties/@connectionProtocol)[1] with "1"')
		ELSE IF @newConnectionProtocol IS NULL AND @oldConnectionProtocol IS NULL
SET @extendedProperties.modify('replace value of (/App_TopologyExtendedProperties/@connectionProtocol)[1] with "2"')
		ELSE IF @newConnectionProtocol IS NULL AND @oldConnectionProtocol IS NOT NULL
			SET @extendedProperties.modify('replace value of (/App_TopologyExtendedProperties/@connectionProtocol)[1] with sql:variable("@oldConnectionProtocol")')
		BEGIN TRY
			SET @prevTranCount = @@TRANCOUNT
			IF @prevTranCount > 0 -- We have an active transaction. SAVE TRANSACTION so that the transaction can be rolled back in case of an exception.
				SAVE TRANSACTION TRAN_UPDATE_FWTOPO
			ELSE -- No transaction was started before calling this SP. BEGIN TRANSACTION so that the transaction can be rolled back in case of an exception.
				BEGIN TRANSACTION TRAN_UPDATE_FWTOPO
			UPDATE APP_FirewallTopology
			SET topologyName = @topologyName, description = @description, modified = @modified, topologyType = @topologyType, extendedProperties = @extendedProperties, flag = @flag
			WHERE topologyId = @topologyId
			IF @prevTranCount = 0 -- COMMIT the transaction we started.
				COMMIT TRANSACTION TRAN_UPDATE_FWTOPO
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			ROLLBACK TRANSACTION TRAN_UPDATE_FWTOPO
			IF ERROR_NUMBER() = 2627
				SET @exist = 1
			ELSE
				THROW;
		END CATCH
		IF @exist = 0
		BEGIN
			INSERT INTO @oldFirewallGroups (clientGroupId, fwGroupType, fwConfig) -- Todo
			SELECT groupId, fwGroupType, ''
			FROM APP_FirewallTopologyAssoc
			WHERE topologyId = @topologyId
			IF @oldTopologyType = 1
			BEGIN
				SELECT @oldExternal = clientGroupId
				FROM @oldFirewallGroups
				WHERE fwGroupType = 2
				SET @oldWildCardOption = ISNULL((SELECT extendedProperties.value('(/App_FirewallExtendedProperties/@useWildcardProxy)[1]','int')
				FROM App_FirewallOptions WHERE clientGroupId = @oldExternal),0)
			END
			/*
			IF @oldTopologyType != @topologyType OR
				 EXISTS (SELECT clientGroupId, fwGroupType FROM @firewallGroups
								EXCEPT SELECT clientGroupId, fwGroupType FROM @oldFirewallGroups)
				OR (@topologyType = 1 AND @oldWildCardOption != @useWildCardProxy)
				-- It is difficult to add checks to identify if any property changed. So ensure that updateTopology can function correctly when there is no change.
			*/
			BEGIN
				DELETE FROM APP_FirewallTopologyAssoc
				WHERE topologyId = @topologyId
				INSERT INTO APP_FirewallTopologyAssoc(topologyId, groupId, fwGroupType)
				SELECT @topologyId, clientGroupId, fwGroupType
				FROM @firewallGroups
				EXEC updateTopology @topologyId, @oldFirewallGroups, @firewallGroups, @oldTopologyType, @topologyType, @oldWildCardOption, @useWildCardProxy, @oldExtendedProperties, @extendedProperties
			END
		END
	END
	SELECT @exist, @duplicateGroups
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateFirewallTopology')
	delete from GxQscripts where name = 'AppUpdateFirewallTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateFirewallTopology')
	delete from GXDBVersions where aliasname = 'AppUpdateFirewallTopology'
GO

insert into GXDBVersions values(2, 'AppUpdateFirewallTopology',  '00000000000000000000', 'AppUpdateFirewallTopology', '00000000000000000000')
GO

