

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateFileSystemUsageAfterSplit.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2014  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateFileSystemUsageAfterSplit.sp,v $ $Id: AppUpdateFileSystemUsageAfterSplit.sp,v 1.1.2.1 2020/02/13 18:57:54 sbhukar Exp $";
-- =========================================================
-- Author: Jatin Sanghvi
-- Description: Update the file-system backupset usage
-- =========================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateFileSystemUsageAfterSplit')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateFileSystemUsageAfterSplit <<<'
	drop procedure AppUpdateFileSystemUsageAfterSplit
END
IF EXISTS (select * from GxQscripts where name='AppUpdateFileSystemUsageAfterSplit')
	delete from GxQscripts where name = 'AppUpdateFileSystemUsageAfterSplit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateFileSystemUsageAfterSplit')
	delete from GXDBVersions where aliasname = 'AppUpdateFileSystemUsageAfterSplit'
GO
print '... Creating Procedure: AppUpdateFileSystemUsageAfterSplit'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateFileSystemUsageAfterSplit
  @xmlText XML OUTPUT
AS
SET NOCOUNT ON;
DECLARE @trancount INT = 0
--
BEGIN TRY
IF @@TRANCOUNT = 0
BEGIN
	BEGIN TRANSACTION
	SET @trancount = 1
END
	IF object_id('tempdb.dbo.#tempFSUsageDetails')     IS NOT NULL DROP TABLE #tempFSUsageDetails
	CREATE TABLE #tempFSUsageDetails (appGuid VARCHAR(36), spaceConsumed BIGINT, ClientId INT, appId INT)
	DECLARE @currentTime INT = dbo.GetUnixTime(GetUTCDate())
	INSERT INTO #tempFSUsageDetails
	SELECT
		ISNULL(ref.value('@backupSetGuid', 'VARCHAR(36)'), 0),
		ISNULL(ref.value('@spaceConsumed', 'BIGINT'), 0),
		0,0
	FROM @xmlText.nodes('App_UpdateUsageAfterBackupsetSplit/fsUsage') R(ref)
	UPDATE T SET T.ClientId = App.clientId, T.appId = App.id
	FROM #tempFSUsageDetails T
	JOIN APP_Application App WITH(NOLOCK) ON App.GUID = T.appGuid
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	SELECT appId, N'Application Size', 14, CAST(spaceConsumed AS nvarchar(max)), @currentTime, 0, 0  FROM #tempFSUsageDetails
	DELETE BP FROM
	APP_BackupSetProp BP
	JOIN APP_Application App WITH(NOLOCK) ON App.Backupset = BP.componentNameId
	JOIN #tempFSUsageDetails tmp ON tmp.appId = App.Id
	WHERE BP.attrName = 'Application Size'
	IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = 'DoFSQuotaCheck' AND value = '1' AND modified = 0)
	BEGIN
		IF OBJECT_ID(N'tempdb..#userList', N'U') IS NOT NULL DROP TABLE #userList;
		CREATE TABLE #userList(userId int PRIMARY KEY);
		INSERT INTO #userList(userId)
		SELECT CO.userId
		FROM #tempFSUsageDetails T
		CROSS APPLY
		sec_getClientOwnersWithParam(T.ClientId, 0, 0) CO
		join UMUsers U WITH(NOLOCK) ON CO.userId = U.id
		UPDATE UP SET UP.attrVal = '1', modified = @currentTime
		FROM UMUsersProp UP
		JOIN #userList U ON U.userId = UP.componentNameId
WHERE UP.attrName  = 'ReComputeQuota' AND cs_attrName = CHECKSUM(N'ReComputeQuota')
IF EXISTS(SELECT * FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'ReComputeQuota')
UPDATE GXGlobalParam SET value = 1 WHERE name = 'ReComputeQuota'
		ELSE
INSERT INTO GxGlobalParam VALUES ('ReComputeQuota', 1, @currentTime, 0)
	END
	SELECT @xmlText = (SELECT 0 AS N'@errorCode', NULL AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
IF @trancount=1
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF @trancount=1
		ROLLBACK TRANSACTION
	-- return error response
	SET @xmlText = (SELECT ERROR_STATE() AS N'@errorCode', ERROR_MESSAGE() AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
	DECLARE @errMsg Nvarchar(4000) = ERROR_MESSAGE()
	RAISERROR(@errMsg, 16, 1);
END CATCH
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateFileSystemUsageAfterSplit')
	delete from GxQscripts where name = 'AppUpdateFileSystemUsageAfterSplit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateFileSystemUsageAfterSplit')
	delete from GXDBVersions where aliasname = 'AppUpdateFileSystemUsageAfterSplit'
GO

insert into GXDBVersions values(2, 'AppUpdateFileSystemUsageAfterSplit',  '00010001000200010000', 'AppUpdateFileSystemUsageAfterSplit', '00010001000200010000')
GO

