

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateFileSystemUsage2.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2014  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateFileSystemUsage2.sp,v $ $Id: AppUpdateFileSystemUsage2.sp,v 1.5.12.13 2020/10/28 23:27:35 mmansano Exp $";
-- =========================================================
-- Author: Jatin Sanghvi
-- Description: Update the file-system backupset usage
-- =========================================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppUpdateFileSystemUsage2')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateFileSystemUsage2 <<<'
	drop procedure AppUpdateFileSystemUsage2
END
IF EXISTS (select * from GxQscripts where name='AppUpdateFileSystemUsage2')
	delete from GxQscripts where name = 'AppUpdateFileSystemUsage2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateFileSystemUsage2')
	delete from GXDBVersions where aliasname = 'AppUpdateFileSystemUsage2'
GO
print '... Creating Procedure: AppUpdateFileSystemUsage2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppUpdateFileSystemUsage2
  @xmlText XML OUTPUT
AS
SET NOCOUNT ON;
DECLARE @trancount INT = 0
--
BEGIN TRY
IF @@TRANCOUNT = 0
BEGIN
	BEGIN TRANSACTION
	SET @trancount = 1
END
	DECLARE @currentTime INT = dbo.GetUnixTime(GetUTCDate())
	DECLARE @inType INT = ISNULL(@xmlText.value('(/App_FSBackupSetUsage/@type)[1]', 'INT'), 0)
	DECLARE @guid VARCHAR(36) = @xmlText.value('(/App_FSBackupSetUsage/@backupSetGuid)[1]', 'VARCHAR(36)')
	DECLARE @inSpaceConsumed BIGINT = ISNULL(@xmlText.value('(/App_FSBackupSetUsage/@spaceConsumed)[1]', 'BIGINT'), 0)
	-- Get index playback stats from incoming xml
	DECLARE @jobId BIGINT = ISNULL(@xmlText.value('(/App_FSBackupSetUsage/indexStats/@jobId)[1]', 'BIGINT'), -1)
	DECLARE @appId INT = 0
	DECLARE @bsId INT = ISNULL((SELECT ID FROM APP_BackupSetName WITH(NOLOCK) WHERE GUID = @guid), 0)
	IF(@bsId = 0)
		SELECT @appId = ISNULL(ID, 0), @bsId = ISNULL(backupset, 0) FROM App_Application WITH(NOLOCK) WHERE GUID = @guid
	IF(@bsId = 0 AND @appId = 0)
		RAISERROR(N'No such Index exists.', 16, 1);
	DECLARE @clientId INT = (SELECT TOP 1 A.clientId FROM APP_Application A WITH(NOLOCK) WHERE A.backupSet = @bsId)
	--get list of users for this client
	IF OBJECT_ID(N'tempdb..#userPropIdList', N'U') IS NOT NULL DROP TABLE #userPropIdList;
	CREATE TABLE #userPropIdList(userPropId int PRIMARY KEY);
	INSERT INTO #userPropIdList(userPropId)
	SELECT Prop.id
	FROM sec_getClientOwnersWithParam(@clientId, 0, 0) CO
	JOIN UMUsers U WITH(NOLOCK) ON CO.userId = U.id
JOIN UMUsersProp Prop WITH(NOLOCK) ON Prop.componentNameId = U.id and Prop.attrName = 'FSQuotaUsage' AND Prop.cs_attrName = CHECKSUM(N'FSQuotaUsage') AND Prop.modified = 0
WHERE U.flags & 0x001 <> 0 AND U.flags & 0x004 = 0 AND U.enabled <> 0
	DECLARE @oldQuotaUsage BIGINT = 0
	DECLARE @deltaUsage BIGINT = @inSpaceConsumed
	--We need to take UPDLOCK or XLock on APP_BackupSetProp as no other thread should be able to read the value until we update the delta change in UMUsersProp.
	DECLARE @id INT = 0
	IF(@appId <> 0)
	BEGIN
		SELECT @id = id FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @appId AND attrName = N'Application Size' AND modified = 0 AND cs_attrName = CHECKSUM(N'Application Size')
		IF @id > 0
			SELECT @oldQuotaUsage = CAST(attrVal AS BIGINT) FROM APP_SubClientProp WITH(UPDLOCK) WHERE id = @id
	END
	ELSE
	BEGIN
		SELECT @id = id FROM APP_BackupSetProp WITH(NOLOCK) WHERE componentNameId = @bsId AND attrName = N'Application Size' AND modified = 0
		IF @id > 0
			SELECT @oldQuotaUsage = CAST(attrVal AS BIGINT) FROM APP_BackupSetProp WITH(UPDLOCK) WHERE id = @id
	END
	IF @inType = 0 --Absolute
		SET @deltaUsage = @inSpaceConsumed - @oldQuotaUsage
	DECLARE @newQuotaUsage BIGINT = @oldQuotaUsage + @deltaUsage
	IF(@newQuotaUsage < 0) SET @newQuotaUsage = 0
	-- Only update row if quota usage changed OR it is a new entry
	IF @id = 0
	BEGIN
		IF(@appId <> 0)
		BEGIN
			INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@appId, N'Application Size', 14, CAST(@newQuotaUsage AS nvarchar(max)), @currentTime, 0, 0)
		END
		ELSE
		BEGIN
			INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@bsId, N'Application Size', 14, CAST(@newQuotaUsage AS nvarchar(max)), @currentTime, 0, 0)
		END
	END
	ELSE IF (@id > 0 AND @newQuotaUsage <> @oldQuotaUsage)
	BEGIN
		IF(@appId <> 0)
			UPDATE APP_SubClientProp SET attrVal = CAST(@newQuotaUsage AS nvarchar(max)) WHERE id = @id
		ELSE
			UPDATE APP_BackupSetProp SET attrVal = CAST(@newQuotaUsage AS nvarchar(max)) WHERE id = @id
	END
	--Update the Quota usage for each user
	UPDATE UMUsersProp SET attrVal =
	CASE WHEN (CAST(attrVal AS bigint) + @deltaUsage) < 0 THEN N'0'
	ELSE (CAST((CAST(attrVal AS bigint) + @deltaUsage) AS NVARCHAR(MAX))) END
	FROM #userPropIdList tmp WHERE Id = tmp.userPropId
	SELECT @xmlText = (SELECT 0 AS N'@errorCode', NULL AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
IF @trancount=1
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF @trancount=1
		ROLLBACK TRANSACTION
	-- return error response
	SET @xmlText = (SELECT ERROR_STATE() AS N'@errorCode', ERROR_MESSAGE() AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
	DECLARE @errMsg Nvarchar(4000) = ERROR_MESSAGE()
	RAISERROR(@errMsg, 16, 1);
END CATCH
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateFileSystemUsage2')
	delete from GxQscripts where name = 'AppUpdateFileSystemUsage2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateFileSystemUsage2')
	delete from GXDBVersions where aliasname = 'AppUpdateFileSystemUsage2'
GO

insert into GXDBVersions values(2, 'AppUpdateFileSystemUsage2',  '00010005001200130000', 'AppUpdateFileSystemUsage2', '00010005001200130000')
GO

