

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateFileSystemUsage.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2014  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateFileSystemUsage.sp,v $ $Id: AppUpdateFileSystemUsage.sp,v 1.5.12.4 2018/06/19 16:56:18 sbhukar Exp $";
-- =========================================================
-- Author: Jatin Sanghvi
-- Description: Update the file-system subclient usage
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateFileSystemUsage <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateFileSystemUsage')
	drop procedure AppUpdateFileSystemUsage
IF EXISTS (select * from GxQscripts where name='AppUpdateFileSystemUsage')
	delete from GxQscripts where name = 'AppUpdateFileSystemUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateFileSystemUsage')
	delete from GXDBVersions where aliasname = 'AppUpdateFileSystemUsage'
GO
print '... Creating Procedure: AppUpdateFileSystemUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateFileSystemUsage
  @xmlText xml
AS
SET NOCOUNT ON;
--
	--
	-- read the update-type, application-id and space-consumed values from input xml
	DECLARE @inType int;
	SELECT @inType = N.value(N'@type', N'int') FROM @xmlText.nodes (N'App_FSSubclientUsage') AS T(N);
	DECLARE @inAppId int;
	SELECT @inAppId = N.value(N'@appId', N'int') FROM @xmlText.nodes (N'App_FSSubclientUsage') AS T(N);
	DECLARE @inSpaceConsumed bigint;
	SELECT @inSpaceConsumed = N.value(N'@spaceConsumed', N'bigint') FROM @xmlText.nodes (N'App_FSSubclientUsage') AS T(N);
	--
	IF NOT EXISTS (SELECT * FROM APP_Application WITH (NOLOCK) WHERE id = @inAppId)
	BEGIN
		SELECT 1 AS N'@errorCode', N'No such subclient exists.' AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE;
		RETURN
	END
	SET @xmlText = (SELECT @inType AS '@updateType',
			@inAppId AS '@appId',
			@inSpaceConsumed AS '@spaceConsumed',
			NULL AS '@backupSetGuid',
			0 AS '@deltaUsage',
			1 AS '@checkQuotaLimit'
	FOR XML PATH('App_FSQuotaUsage'), TYPE)
	IF OBJECT_ID(N'tempdb..#usageDataXML', N'U') IS NOT NULL DROP TABLE #usageDataXML;
	CREATE TABLE #usageDataXML(usage xml);
	EXEC CheckAndUpdateQuotaLimit @xmlText
	-- return response
	SELECT usage FROM #usageDataXML
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateFileSystemUsage')
	delete from GxQscripts where name = 'AppUpdateFileSystemUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateFileSystemUsage')
	delete from GXDBVersions where aliasname = 'AppUpdateFileSystemUsage'
GO

insert into GXDBVersions values(2, 'AppUpdateFileSystemUsage',  '00010005001200040000', 'AppUpdateFileSystemUsage', '00010005001200040000')
GO

